/*
 * Decompiled with CFR 0.152.
 */
package com.creativenorth.base;

import java.util.Calendar;
import java.util.Date;

public class Timekeeper {
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long WEEK = 604800000L;
    public static Timekeeper me;
    private long milliseconds_in_life = 0L;

    public Timekeeper() {
        me = this;
    }

    public final void setTime(long _time) {
        this.milliseconds_in_life = _time;
    }

    public final void advanceMilliseconds(long _milliseconds) {
        this.milliseconds_in_life += _milliseconds;
    }

    public final void advanceSeconds(long _seconds) {
        this.milliseconds_in_life += _seconds * 1000L;
    }

    public final void advanceMinutes(long _minutes) {
        this.milliseconds_in_life += _minutes * 60000L;
    }

    public final void advanceHours(long _hours) {
        this.milliseconds_in_life += _hours * 3600000L;
    }

    public final void advanceDays(long _days) {
        this.milliseconds_in_life += _days * 86400000L;
    }

    public final void advanceWeeks(long _weeks) {
        this.milliseconds_in_life += _weeks * 604800000L;
    }

    public final long getMillisecondsInLife() {
        return this.milliseconds_in_life;
    }

    public final long getSecondsInLife() {
        return this.milliseconds_in_life / 1000L;
    }

    public final long getMinutesInLife() {
        return this.getSecondsInLife() / 60L;
    }

    public final long getHoursInLife() {
        return this.getMinutesInLife() / 60L;
    }

    public final long getDaysInLife() {
        return this.getHoursInLife() / 24L;
    }

    public final long getWeeksInLife() {
        return this.getDaysInLife() / 7L;
    }

    public final int getMillisecondOfSecond() {
        return (int)(this.getMillisecondsInLife() % 1000L);
    }

    public final int getSecondOfMinute() {
        return (int)(this.getSecondsInLife() % 60L);
    }

    public final int getMinuteOfHour() {
        return (int)(this.getMinutesInLife() % 60L);
    }

    public final int getHourOfDay() {
        return (int)(this.getHoursInLife() % 24L);
    }

    public final int getDayOfWeek() {
        return (int)(this.getDaysInLife() % 7L);
    }

    public final boolean isDaytime() {
        int day = this.getHourOfDay();
        return day >= 7 && day < 18;
    }

    public final boolean isNighttime() {
        return !this.isDaytime();
    }

    public final int getWeeks() {
        return (int)this.getWeeksInLife();
    }

    public int getYYMMDD() {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date(this.milliseconds_in_life));
        return c.get(1) % 100 * 10000 + (c.get(2) + 1) * 100 + c.get(5);
    }

    public int getHHMMSS() {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date(this.milliseconds_in_life));
        return c.get(11) * 10000 + c.get(12) * 100 + c.get(13);
    }

    public String getDatetimestamp() {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date(this.milliseconds_in_life));
        return c.get(1) + "-" + this.pad(c.get(2) + 1, 2) + "-" + this.pad(c.get(5), 2) + "T" + this.pad(c.get(11), 2) + ":" + this.pad(c.get(12), 2) + ":" + this.pad(c.get(13), 2) + "." + this.pad(c.get(14), 3) + "Z";
    }

    private String pad(int _val, int _amt) {
        int numsize = ("" + _val).length();
        if (numsize >= _amt) {
            return "" + _val;
        }
        String ret = "";
        for (int i = 0; i < _amt - numsize; ++i) {
            ret = ret + '0';
        }
        return ret + _val;
    }
}

