/*
 * Decompiled with CFR 0.152.
 */
package schoolfriends.graphics;

import com.creativenorth.dev.Log;
import com.creativenorth.graphics.CNGraphics;
import com.creativenorth.graphics.CNImage;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import schoolfriends.Data;
import schoolfriends.graphics.Engine;
import schoolfriends.loading.LoadingRequirement;

public class Render {
    public static final int TILE_SHIFT = 3;
    public static final int WALL_HEIGHT = 100;
    public static int g_iCentreX;
    public static int g_iCentreY;
    public static int g_iDrawX;
    public static int g_iDrawY;
    public static int g_iDrawW;
    public static int g_iDrawH;
    public static int g_iWallLeftX;
    public static int g_iWallLeftY;
    public static int g_iWallCentreX;
    public static int g_iWallCentreY;
    public static int g_iWallRightX;
    public static int g_iWallRightY;
    public static Vector depth_stack;
    public static Vector generated_image_sets;
    private static final int[] trans;

    public static final void setDrawCoords(Data.Room room, int draw_x, int draw_y, int draw_w, int draw_h) {
        g_iDrawX = draw_x;
        g_iDrawY = draw_y;
        g_iDrawW = draw_w;
        g_iDrawH = draw_h;
        g_iCentreX = draw_x + draw_w / 2;
        g_iCentreY = draw_y + draw_h / 2;
        g_iWallLeftX = Render.tileToWorldX(0, 0);
        g_iWallLeftY = Render.tileToWorldY(0, 0);
        g_iWallCentreX = Render.tileToWorldX(room.floor[0].length - 1, 0) + Data.tile_w_half;
        g_iWallCentreY = Render.tileToWorldY(room.floor[0].length - 1, 0) - Data.tile_h_half;
        g_iWallRightX = Render.tileToWorldX(room.floor[0].length, room.floor.length);
        g_iWallRightY = Render.tileToWorldY(room.floor[0].length, room.floor.length);
    }

    public static final void updateDepthSort(Data.Room room) {
        int j;
        if (depth_stack != null) {
            depth_stack.removeAllElements();
        } else {
            depth_stack = new Vector();
        }
        System.gc();
        if (room == null) {
            return;
        }
        if (room.walls != null) {
            for (j = room.walls.length - 1; j >= 0; --j) {
                Render.InsertSorted(room.walls[j]);
            }
        }
        if (room.objs != null) {
            for (j = room.objs.length - 1; j >= 0; --j) {
                if (room.objs[j].hidden) continue;
                Render.InsertSorted(room.objs[j]);
            }
        }
        Render.InsertSorted(Data.player);
    }

    public static final void Resort(Data.DepthSortable item) {
        item.depth = item instanceof Data.PlacedObject ? item.y + ((Data.PlacedObject)item).depth_fix : Render.tileToWorldY(item.x, item.y) - Data.tile_h * 2;
        if (depth_stack == null) {
            return;
        }
        int index = depth_stack.indexOf(item);
        if (index < 0) {
            return;
        }
        if (index > 0 && ((Data.DepthSortable)Render.depth_stack.elementAt((int)(index - 1))).depth > item.depth) {
            depth_stack.removeElementAt(index);
            --index;
            while (index > 0) {
                if (((Data.DepthSortable)Render.depth_stack.elementAt((int)(index - 1))).depth <= item.depth) {
                    depth_stack.insertElementAt(item, index);
                    return;
                }
                --index;
            }
            depth_stack.insertElementAt(item, 0);
            return;
        }
        if (index < depth_stack.size() - 1 && ((Data.DepthSortable)Render.depth_stack.elementAt((int)(index + 1))).depth < item.depth) {
            depth_stack.removeElementAt(index);
            while (index < depth_stack.size() - 1) {
                if (((Data.DepthSortable)Render.depth_stack.elementAt((int)(index + 1))).depth >= item.depth) {
                    depth_stack.insertElementAt(item, index + 1);
                    return;
                }
                ++index;
            }
            depth_stack.addElement(item);
            return;
        }
    }

    private static final void InsertSorted(Data.DepthSortable item) {
        item.depth = item instanceof Data.PlacedObject ? item.y + ((Data.PlacedObject)item).depth_fix : Render.tileToWorldY(item.x, item.y) - Data.tile_h * 2;
        int i = depth_stack.size();
        while (i-- > 0) {
            if (((Data.DepthSortable)Render.depth_stack.elementAt((int)i)).depth >= item.depth) continue;
            depth_stack.insertElementAt(item, i + 1);
            return;
        }
        depth_stack.insertElementAt(item, 0);
    }

    public static final int tileToScreenX(int x, int y) {
        return g_iCentreX + (x + y) * Data.tile_w_half - Engine.g_iCameraX;
    }

    public static final int tileToScreenY(int x, int y) {
        return g_iCentreY + (y - x) * Data.tile_h_half - Engine.g_iCameraY;
    }

    public static final int tileToWorldX(int x, int y) {
        return (x + y) * Data.tile_w_half;
    }

    public static final int tileToWorldY(int x, int y) {
        return (y - x) * Data.tile_h_half;
    }

    public static final int worldToTileX(int x, int y) {
        int r;
        return (r >> 5) - ((r = (x << 5) / Data.tile_w - (y << 5) / Data.tile_h) > 0 ? 0 : 1);
    }

    public static final int worldToTileY(int x, int y) {
        int r;
        return (r >> 5) - ((r = (x << 5) / Data.tile_w + (y << 5) / Data.tile_h) > 0 ? 0 : 1);
    }

    public static final int worldToScreenX(int x, int y) {
        return g_iCentreX + x - Engine.g_iCameraX;
    }

    public static final int worldToScreenY(int x, int y) {
        return g_iCentreY + y - Engine.g_iCameraY;
    }

    public static final int isoToScreenX(int x, int y) {
        return g_iCentreX + ((x + y) * Data.tile_w_half >> 3) - Engine.g_iCameraX;
    }

    public static final int isoToScreenY(int x, int y) {
        return g_iCentreY + ((y - x) * Data.tile_h_half >> 3) - Engine.g_iCameraY;
    }

    public static final void paintRoom(CNGraphics g, Data.Room room) {
        if (room == null) {
            return;
        }
        g.setColor(472683);
        g.clear();
        Render.paintFloor(g, room);
        if (depth_stack != null) {
            Enumeration en = depth_stack.elements();
            long time = System.currentTimeMillis();
            while (en.hasMoreElements()) {
                Data.DepthSortable d = (Data.DepthSortable)en.nextElement();
                if (d instanceof Data.Wall) {
                    try {
                        Data.Wall w = (Data.Wall)d;
                        Render.paintTile(g, w.tile, w.x, w.y, 0);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!(d instanceof Data.PlacedObject)) continue;
                Data.PlacedObject o = (Data.PlacedObject)d;
                try {
                    if (o.anim && Data.animations != null && (time < o.anim_duration || o.anim_duration == 0L)) {
                        CNImage img;
                        if (o.anim_frame < 0 || o.anim_frame >= Data.animations.length || (img = Data.animations[o.anim_frame]) == null) continue;
                        int draw_x = Render.worldToScreenX(o.x, o.y) - img.getWidth() / 2;
                        int draw_y = Render.worldToScreenY(o.x, o.y);
                        draw_y = o.type ? (draw_y -= img.getHeight()) : (draw_y -= img.getHeight() / 2);
                        g.drawImage(img, draw_x, draw_y + 4 - o.z, 0);
                        Engine.g_bRepaint = true;
                        continue;
                    }
                    o.anim = false;
                    if (!o.type) {
                        if (o.gfx >= 0 && o.gfx < Data.mobjs.length) {
                            Render.paintObject(g, Data.mobjs[o.gfx], o.x, o.y, o.z, o.left);
                            continue;
                        }
                        Log.addError("Invalid mobj: " + o.gfx + " / " + (Data.mobjs.length - 1));
                        continue;
                    }
                    if (o.gfx >= 0 && o.gfx < Data.mchrs.length) {
                        Render.paintCharacter(g, o, Render.worldToScreenX(o.x, o.y), Render.worldToScreenY(o.x, o.y));
                        continue;
                    }
                    Log.addError("Invalid character: " + o.gfx + " / " + (Data.mchrs.length - 1));
                }
                catch (Exception e) {
                    Log.addExeption("Placed Object gfx = " + o.gfx, e);
                }
            }
        }
    }

    public static final void paintCharacter(CNGraphics g, Data.PlacedObject o, int draw_x, int draw_y) {
        try {
            g.drawImage(Data.shadow, draw_x, draw_y, 3);
        }
        catch (Exception ex) {
            // empty catch block
        }
        int anim = Math.abs(o.chr_anim) % Data.frames.length;
        LoadingRequirement.VerifyAnimation(anim);
        int frame = Math.abs(o.frame) % Data.frames[anim].length;
        Data.MasterCharacter mchr = Data.mchrs[o.gfx];
        Data.Tile t = null;
        try {
            long mem;
            if (mchr.frames == null) {
                mchr.frames = new Data.Tile[Data.frames.length][];
            }
            if (mchr.frames[anim] == null) {
                mchr.frames[anim] = new Data.Tile[Data.frames[anim].length];
            }
            if (mchr.frames[anim][frame] == null && (mem = Runtime.getRuntime().freeMemory()) > 1000L) {
                mchr.frames[anim][frame] = new Data.Tile();
                Render.rasterSprite(null, anim, frame, mchr.partsets, mchr.palindices, mchr.frames[anim][frame], o.gfx);
            }
            if ((t = mchr.frames[anim][frame]) != null) {
                if (g != null) {
                    g.m_graphics.drawRegion(t.img.getImage(), 0, 0, t.img.getImage().getWidth(), t.img.getImage().getHeight(), o.left ? 0 : 2, draw_x + (o.left ? t.hotspot_x : -t.img.getImage().getWidth() - t.hotspot_x), draw_y + t.hotspot_y, 0);
                }
                return;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (!Render.paintSprite(g, anim, frame, mchr.partsets, mchr.palindices, draw_x, draw_y, o.left)) {
            // empty if block
        }
    }

    public static final boolean paintSprite(CNGraphics g, int anim, int frame, int[] setindex, int[] colindex, int x, int y, boolean hflip) {
        try {
            LoadingRequirement.VerifyAnimation(anim);
            Data.Frame f = Data.frames[anim][frame];
            for (int i = 0; i < f.elements.length; ++i) {
                Render.paintElement(g, f.elements[i], setindex, colindex, x, y, !hflip);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static final boolean paintElement(CNGraphics g, Data.FrameElement fe, int[] setindex, int[] colindex, int x, int y, boolean hflip) {
        int partlist = 0;
        int set = 0;
        try {
            int flags = fe.flags;
            if (hflip) {
                x -= fe.x;
                flags ^= 1;
            } else {
                x += fe.x;
            }
            y += fe.y;
            partlist = fe.partlist;
            if (partlist < setindex.length) {
                set = setindex[partlist];
            }
            if (Data.partlists[partlist][set][fe.part] == null) {
                return false;
            }
            String path = Data.partlists[partlist][set][fe.part].img.getPath();
            Enumeration en = generated_image_sets.elements();
            while (en.hasMoreElements()) {
                Data.GeneratedImageSet gis = (Data.GeneratedImageSet)en.nextElement();
                if (gis.getOriginalPath() != path) continue;
                int j = 16;
                while (j-- > 0) {
                    Data.GeneratedImage gi = gis.getGeneratedImage(j);
                    if (gi == null || !gi.isThisPalette(colindex)) continue;
                    Image img = gi.getImage();
                    if (g == null || img == null) continue;
                    g.m_graphics.drawRegion(img, 0, 0, img.getWidth(), img.getHeight(), trans[flags], x, y, 3);
                    return true;
                }
            }
            Data.GeneratedImage gi = null;
            try {
                gi = new Data.GeneratedImage(Data.partlists[partlist][set][fe.part].img.getPath(), colindex);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            Image img = gi.getImage();
            if (g != null && img != null) {
                g.m_graphics.drawRegion(img, 0, 0, img.getWidth(), img.getHeight(), trans[flags], x, y, 3);
                return true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    public static final void resetRasters() {
        if (Data.mchrs != null) {
            int mchr = Data.mchrs.length;
            while (mchr-- > 0) {
                if (Data.mchrs[mchr] == null || Data.mchrs[mchr].frames == null) continue;
                int anim = Data.mchrs[mchr].frames.length;
                while (anim-- > 0) {
                    if (Data.mchrs[mchr].frames[anim] == null) continue;
                    int frame = Data.mchrs[mchr].frames[anim].length;
                    while (frame-- > 0) {
                        Data.mchrs[mchr].frames[anim][frame] = null;
                    }
                }
            }
        }
    }

    public static final void rasterSprite(CNGraphics screen_g, int anim, int frame, int[] setindex, int[] colindex, Data.Tile out, int gfx) {
        LoadingRequirement.VerifyAnimation(anim);
        Data.Frame f = Data.frames[anim][frame];
        int minx = 9999;
        int maxx = -9999;
        int miny = 9999;
        int maxy = -9999;
        Data.FrameElement fe = null;
        CNImage img = null;
        for (int loop = f.elements.length - 1; loop >= 0; --loop) {
            int set = 0;
            try {
                int t;
                fe = f.elements[loop];
                if (fe.partlist < setindex.length) {
                    set = setindex[fe.partlist];
                }
                if (Data.partlists[fe.partlist][set][fe.part] == null) continue;
                img = Data.partlists[fe.partlist][set][fe.part].img;
                if ((fe.flags & 4) == 0) {
                    t = fe.x - img.getWidth() / 2;
                    if (t < minx) {
                        minx = t;
                    }
                    if ((t = fe.x + img.getWidth() / 2) > maxx) {
                        maxx = t;
                    }
                    if ((t = fe.y - img.getHeight() / 2) < miny) {
                        miny = t;
                    }
                    if ((t = fe.y + img.getHeight() / 2) <= maxy) continue;
                    maxy = t;
                    continue;
                }
                t = fe.x - img.getHeight() / 2;
                if (t < minx) {
                    minx = t;
                }
                if ((t = fe.x + img.getHeight() / 2) > maxx) {
                    maxx = t;
                }
                if ((t = fe.y - img.getWidth() / 2) < miny) {
                    miny = t;
                }
                if ((t = fe.y + img.getWidth() / 2) <= maxy) continue;
                maxy = t;
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        int width = maxx - minx + 1;
        int height = maxy - miny + 1;
        Image temp = Image.createImage((int)width, (int)height);
        Graphics g = temp.getGraphics();
        int transp_col = 6636321;
        g.setColor(transp_col);
        g.fillRect(0, 0, width, height);
        transp_col = g.getDisplayColor(transp_col);
        int m = f.elements.length;
        CNGraphics cng = new CNGraphics();
        cng.setGraphics(g);
        for (int i = 0; i < m; ++i) {
            try {
                fe = f.elements[i];
                Render.paintElement(cng, fe, setindex, colindex, -minx, -miny, false);
                continue;
            }
            catch (Exception ex) {
                Log.addExeption("Error rastering sprite", ex);
            }
        }
        int[] rgb = new int[width * height];
        temp.getRGB(rgb, 0, width, 0, 0, width, height);
        for (int i = rgb.length - 1; i >= 0; --i) {
            if ((rgb[i] & 0xFFFFFF) != transp_col) continue;
            rgb[i] = 0;
        }
        temp = Image.createRGBImage((int[])rgb, (int)width, (int)height, (boolean)true);
        rgb = null;
        out.img = new CNImage(temp);
        out.hotspot_x = minx;
        out.hotspot_y = miny;
    }

    private static final void paintFloor(CNGraphics g, Data.Room room) {
        int max = Data.tiles.length;
        int y = room.floor.length;
        while (y-- > 0) {
            int[] row = room.floor[y];
            int x = row.length;
            while (x-- > 0) {
                try {
                    int tile = row[x];
                    if (tile == 0 || tile >= max) continue;
                    if (tile < 0) {
                        tile = -tile;
                    }
                    Render.paintTile(g, tile, x, y, 0);
                }
                catch (Exception e) {}
            }
        }
    }

    public static final void paintTile(CNGraphics g, int t, int x, int y, int z) {
        if (t < 0 || t > Data.tiles.length) {
            return;
        }
        try {
            CNImage img = Data.tiles[t - 1].img;
            g.resetClip();
            int draw_x = Render.tileToScreenX(x, y) + Data.tile_w_half - img.getImage().getWidth() / 2 - Data.tiles[t - 1].hotspot_x;
            int draw_y = Render.tileToScreenY(x, y) - img.getImage().getHeight() / 2 - Data.tiles[t - 1].hotspot_y - z;
            if (draw_x + img.getImage().getWidth() > g.getClipX() || draw_x < g.getClipX() + g.getClipWidth() || draw_y + img.getImage().getHeight() > g.getClipY() || draw_y < g.getClipY() + g.getClipHeight()) {
                g.drawImage(img, draw_x, draw_y, 0);
            }
        }
        catch (Exception ex) {
            Log.addExeption("PaintTile " + t, ex);
        }
    }

    private static final void rasterShadow(CNGraphics g, Data.Room room, boolean wall) {
        int const_x = Render.worldToScreenX(0, 0) - g_iDrawX;
        int const_y = Render.worldToScreenY(0, 0) - g_iDrawY;
        for (int i = 0; i < room.shadowPoints.size(); ++i) {
            Data.CNPoly tmpPoly = (Data.CNPoly)room.shadowPoints.elementAt(i);
            if (tmpPoly.m_wall != wall) continue;
            Data.CNPoint[] tmpPoints = tmpPoly.getPoints();
            int[] x = new int[3];
            int[] y = new int[3];
            for (int j = 0; j < 3; ++j) {
                x[j] = tmpPoints[j].X + const_x;
                y[j] = tmpPoints[j].Y + const_y;
            }
            Data.CNColour m_colour = room.colours[tmpPoly.colourIndex];
            g.m_graphics.setColor(m_colour.r, m_colour.g, m_colour.b);
            g.m_graphics.fillTriangle(x[0], y[0], x[1], y[1], x[2], y[2]);
        }
    }

    public static final void paintObject(CNGraphics g, int t, int x, int y, int z, boolean left) {
        if (t < 1 || t > Data.tiles.length) {
            return;
        }
        try {
            LoadingRequirement.VerifyTile(t);
            CNImage img = Data.tiles[t - 1].img;
            Image image = img.getImage();
            int draw_x = Render.worldToScreenX(x, y) + Data.tile_w_half - image.getWidth() / 2 - Data.tiles[t - 1].hotspot_x;
            int draw_y = Render.worldToScreenY(x, y) - image.getHeight() / 2 - Data.tiles[t - 1].hotspot_y - z;
            if (draw_x + img.getWidth() > g.getClipX() || draw_x < g.getClipX() + g.getClipWidth() || draw_y + img.getHeight() > g.getClipY() || draw_y < g.getClipY() + g.getClipHeight()) {
                g.m_graphics.drawRegion(image, 0, 0, image.getWidth(), image.getHeight(), left ? 2 : 0, draw_x, draw_y, 0);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    static {
        g_iDrawX = 0;
        g_iDrawY = 0;
        g_iDrawW = 1;
        g_iDrawH = 1;
        generated_image_sets = new Vector();
        trans = new int[]{0, 2, 1, 3, 5, 7, 4, 6};
    }
}

