/*
 * Decompiled with CFR 0.152.
 */
package fi.tamk.tiko.gameprogramming.Slumber.levels;

import fi.tamk.tiko.gameprogramming.Slumber.ui.Slumber;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.lcdui.game.TiledLayer;

public class level1
extends GameCanvas
implements Runnable,
CommandListener {
    private Graphics g = this.getGraphics();
    private Slumber game;
    private double time;
    private boolean gameIsOn;
    private int resourcesReceived = 3;
    private int selectedCharacter;
    private Command backCommand;
    private Sprite character;
    private LayerManager layerManager;
    private TiledLayer floor;
    private TiledLayer walls;
    private TiledLayer tilesOver;
    private TiledLayer rock1;
    private TiledLayer rock2;
    private TiledLayer rock3;
    private TiledLayer ppads;
    private TiledLayer resetPad;
    private Sprite torch;
    private Sprite gate;
    private Sprite gate2;
    private Sprite gateSide;
    private Sprite torch2;
    private Sprite objective;
    private Image tileset;
    private static final int TILE_LENGTH = 24;
    private static int characterSpeedX = 0;
    private static int characterSpeedY = 0;
    private int torchCounter = 1;
    private int gateCounter = 0;
    private int gate2Counter = 0;
    private int gateSideCounter = 1;
    private boolean gateCounterDirection;
    private boolean gateSideCounterDirection;
    private boolean gate2CounterDirection;
    private int dTileX;
    private int dTileY;
    private int UP = 3;
    private int DOWN = 4;
    private int LEFT = 2;
    private int RIGHT = 1;
    private boolean moving = false;
    private int EMPTY = 0;
    private int FIRST_TILE = 1;
    private int firstRockCol = 21;
    private int firstRockRow = 10;
    private int secondRockCol = 14;
    private int secondRockRow = 16;
    private int thirdRockCol = 13;
    private int thirdRockRow = 4;
    private int originalFirstRockCol = 21;
    private int originalFirstRockRow = 10;
    private int originalSecondRockCol = 14;
    private int originalSecondRockRow = 16;
    private int originalThirdRockCol = 13;
    private int originalThirdRockRow = 4;
    private boolean ppad1IsActive = false;
    private boolean ppad2IsActive = false;
    private boolean ppad3IsActive = false;
    private boolean threePadsActive = false;
    private boolean finalPad1;
    private boolean finalPad2;
    private boolean finalPad3;
    private int windowX;
    private int windowY;

    public level1(boolean suppressKeyEvents, Slumber game, int x) {
        super(suppressKeyEvents);
        this.selectedCharacter = x;
        this.backCommand = new Command("Back", 2, 1);
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
        this.addCharacter();
        try {
            this.initializeGraphics();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.paintObjects(this.g);
        this.game = game;
        this.gameIsOn = true;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void initializeGraphics() throws IOException {
        try {
            this.tileset = Image.createImage((String)"/tilesetti.png");
        }
        catch (Exception e) {
            System.out.println("Tileset problem");
        }
        this.floor = this.getMap("/level_tutorial/tutorial_floor.smp", this.tileset);
        this.walls = this.getMap("//level_tutorial/tutorial_walls.smp", this.tileset);
        this.tilesOver = this.getMap("/level_tutorial/tutorial_tilesover.smp", this.tileset);
        this.rock1 = new TiledLayer(26, 21, Image.createImage((String)"/rock.png"), 24, 24);
        this.rock1.setCell(this.firstRockCol, this.firstRockRow, this.FIRST_TILE);
        this.rock2 = new TiledLayer(26, 21, Image.createImage((String)"/rock.png"), 24, 24);
        this.rock2.setCell(this.secondRockCol, this.secondRockRow, this.FIRST_TILE);
        this.rock3 = new TiledLayer(26, 21, Image.createImage((String)"/rock.png"), 24, 24);
        this.rock3.setCell(this.thirdRockCol, this.thirdRockRow, this.FIRST_TILE);
        this.ppads = new TiledLayer(26, 21, Image.createImage((String)"/brown ppad.png"), 24, 24);
        this.ppads.setCell(21, 5, this.FIRST_TILE);
        this.ppads.setCell(15, 16, this.FIRST_TILE);
        this.ppads.setCell(11, 10, this.FIRST_TILE);
        this.ppads.setCell(2, 17, this.FIRST_TILE);
        this.ppads.setCell(4, 17, this.FIRST_TILE);
        this.ppads.setCell(6, 17, this.FIRST_TILE);
        this.resetPad = new TiledLayer(26, 21, Image.createImage((String)"/resetpad.png"), 24, 24);
        this.resetPad.setCell(22, 17, 1);
        this.resetPad.setCell(23, 17, 2);
        this.resetPad.setCell(22, 18, 5);
        this.resetPad.setCell(23, 18, 6);
        this.resetPad.setCell(16, 10, 1);
        this.resetPad.setCell(17, 10, 2);
        this.resetPad.setCell(16, 11, 5);
        this.resetPad.setCell(17, 11, 6);
        this.torch = new Sprite(Image.createImage((String)"/torch.png"), 24, 24);
        this.torch2 = new Sprite(Image.createImage((String)"/torch.png"), 24, 24);
        this.gate = new Sprite(Image.createImage((String)"/gate.png"), 48, 48);
        this.gate2 = new Sprite(Image.createImage((String)"/gate.png"), 48, 48);
        this.gateSide = new Sprite(Image.createImage((String)"/gate2.png"), 24, 96);
        this.objective = new Sprite(Image.createImage((String)"/pappa.png"), 63, 63);
        this.layerManager = new LayerManager();
        this.layerManager.append((Layer)this.torch);
        this.layerManager.append((Layer)this.torch2);
        this.layerManager.append((Layer)this.tilesOver);
        this.layerManager.append((Layer)this.character);
        this.layerManager.append((Layer)this.objective);
        this.character.setVisible(true);
        this.character.setPosition(504, 384);
        this.windowX = 504 - this.getWidth() / 2;
        this.windowY = 384 - this.getHeight() / 2;
        this.character.defineReferencePixel(this.character.getWidth() / 2, this.character.getHeight() / 2);
        this.objective.setPosition(96, 144);
        this.objective.setVisible(true);
        this.torch.setPosition(264, 168);
        this.torch.setVisible(true);
        this.torch2.setPosition(384, 168);
        this.torch2.setVisible(true);
        this.gate.setPosition(312, 168);
        this.gate.setVisible(true);
        this.gate2.setPosition(120, 264);
        this.gate2.setVisible(true);
        this.gateSide.setPosition(432, 240);
        this.gateSide.setVisible(true);
        this.layerManager.append((Layer)this.rock1);
        this.layerManager.append((Layer)this.rock2);
        this.layerManager.append((Layer)this.rock3);
        this.layerManager.append((Layer)this.ppads);
        this.layerManager.append((Layer)this.resetPad);
        this.layerManager.append((Layer)this.gate);
        this.layerManager.append((Layer)this.gate2);
        this.layerManager.append((Layer)this.gateSide);
        this.layerManager.append((Layer)this.walls);
        this.layerManager.append((Layer)this.floor);
        this.layerManager.setViewWindow(this.windowX, this.windowY, this.getWidth(), this.getHeight());
    }

    protected void paintObjects(Graphics g) {
        this.flushGraphics();
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.layerManager.paint(g, 0, 0);
    }

    public void pointerPressed(int x, int y) {
        if (!this.moving) {
            if (x < this.getWidth() / 3 && y > this.getHeight() / 3 && y < this.getHeight() - this.getHeight() / 3) {
                characterSpeedX = 24;
                this.moveToon(this.LEFT);
            }
            if (x > this.getWidth() - this.getWidth() / 3 && y > this.getHeight() / 3 && y < this.getHeight() - this.getHeight() / 3) {
                characterSpeedX = 24;
                this.moveToon(this.RIGHT);
            }
            if (x > this.getWidth() / 3 && x < this.getWidth() - this.getWidth() / 3 && y < this.getHeight() / 3) {
                characterSpeedY = 24;
                this.moveToon(this.DOWN);
            }
            if (x > this.getWidth() / 3 && x < this.getWidth() - this.getWidth() / 3 && y > this.getHeight() - this.getHeight() / 3) {
                characterSpeedY = 24;
                this.moveToon(this.UP);
            }
        }
    }

    public void moveToon(int direction) {
        int counter;
        boolean isTileSolid;
        this.moving = true;
        if (direction == this.RIGHT) {
            this.character.setTransform(2);
            this.dTileX = this.character.getRefPixelX() / 24;
            this.dTileY = this.character.getRefPixelY() / 24;
            this.dTileX += 2;
            isTileSolid = this.isSolid(this.dTileX, this.dTileY);
            this.checkCollision(direction);
            System.out.println(isTileSolid);
            if (!isTileSolid) {
                counter = 0;
                while (counter < characterSpeedX) {
                    this.character.move(1, 0);
                    this.character.nextFrame();
                    ++counter;
                    this.layerManager.setViewWindow(this.character.getRefPixelX() - this.getWidth() / 2, this.character.getRefPixelY() - this.getHeight() / 2, this.getWidth(), this.getHeight());
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (direction == this.LEFT) {
            this.character.setTransform(0);
            this.dTileX = this.character.getRefPixelX() / 24;
            this.dTileY = this.character.getRefPixelY() / 24;
            --this.dTileX;
            isTileSolid = this.isSolid(this.dTileX, this.dTileY);
            this.checkCollision(direction);
            System.out.println(isTileSolid);
            if (!isTileSolid) {
                counter = 0;
                while (counter < characterSpeedX) {
                    this.character.move(-1, 0);
                    this.character.nextFrame();
                    ++counter;
                    this.layerManager.setViewWindow(this.character.getRefPixelX() - this.getWidth() / 2, this.character.getRefPixelY() - this.getHeight() / 2, this.getWidth(), this.getHeight());
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (direction == this.UP) {
            this.dTileX = this.character.getRefPixelX() / 24;
            this.dTileY = this.character.getRefPixelY() / 24;
            this.dTileY += 2;
            isTileSolid = this.isSolid(this.dTileX, this.dTileY);
            this.checkCollision(direction);
            System.out.println(isTileSolid);
            if (!isTileSolid) {
                counter = 0;
                while (counter < characterSpeedY) {
                    this.character.move(0, 1);
                    this.character.nextFrame();
                    ++counter;
                    this.layerManager.setViewWindow(this.character.getRefPixelX() - this.getWidth() / 2, this.character.getRefPixelY() - this.getHeight() / 2, this.getWidth(), this.getHeight());
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (direction == this.DOWN) {
            this.dTileX = this.character.getRefPixelX() / 24;
            this.dTileY = this.character.getRefPixelY() / 24;
            --this.dTileY;
            isTileSolid = this.isSolid(this.dTileX, this.dTileY);
            this.checkCollision(direction);
            System.out.println(isTileSolid);
            if (!isTileSolid) {
                counter = 0;
                while (counter < characterSpeedY) {
                    this.character.move(0, -1);
                    this.character.nextFrame();
                    ++counter;
                    this.layerManager.setViewWindow(this.character.getRefPixelX() - this.getWidth() / 2, this.character.getRefPixelY() - this.getHeight() / 2, this.getWidth(), this.getHeight());
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        characterSpeedX = 0;
        characterSpeedY = 0;
        this.dTileX = 0;
        this.dTileY = 0;
        this.moving = false;
    }

    public void pointerReleased(int x, int y) {
    }

    public void pointerDragged(int x, int y) {
    }

    public void run() {
        while (this.gameIsOn) {
            this.paintObjects(this.g);
            this.torchCounter = this.torchCounter == 4 ? 0 : ++this.torchCounter;
            this.torch.setFrame(this.torchCounter);
            this.torch2.setFrame(this.torchCounter);
            this.openSecondDoor();
            if (this.gateCounterDirection) {
                if (this.gateCounter < 9) {
                    ++this.gateCounter;
                }
            } else if (!this.gateCounterDirection && this.gateCounter > 0) {
                --this.gateCounter;
            }
            this.openFirstDoor();
            if (this.gateSideCounterDirection) {
                if (this.gateSideCounter < 4) {
                    ++this.gateSideCounter;
                }
            } else if (!this.gateSideCounterDirection && this.gateSideCounter > 1) {
                --this.gateSideCounter;
            }
            this.openThirdDoor();
            if (this.gate2CounterDirection) {
                if (this.gate2Counter < 9) {
                    ++this.gate2Counter;
                }
            } else if (!this.gate2CounterDirection && this.gate2Counter > 0) {
                --this.gate2Counter;
            }
            this.gate2.setFrame(this.gate2Counter);
            this.gate.setFrame(this.gateCounter);
            this.torch.setFrame(this.torchCounter);
            this.gateSide.setFrame(this.gateSideCounter);
            this.ppad1IsActive = this.isOnPpad(21, 5, this.rock1);
            this.ppad2IsActive = this.isOnPpad(11, 10, this.rock2);
            if (!this.ppad2IsActive) {
                this.ppad2IsActive = this.isOnPpad(11, 10, this.rock3);
            }
            if (!this.ppad2IsActive) {
                this.ppad2IsActive = this.isOnPpad(11, 10, this.rock1);
            }
            this.ppad3IsActive = this.isOnPpad(15, 16, this.rock2);
            if (!this.ppad3IsActive) {
                this.ppad3IsActive = this.isOnPpad(15, 16, this.rock3);
            }
            if (!this.ppad3IsActive) {
                this.ppad3IsActive = this.isOnPpad(15, 16, this.rock1);
            }
            this.finalPad1 = this.rockOnPad1(2, 17);
            this.finalPad2 = this.rockOnPad2(4, 17);
            this.finalPad3 = this.rockOnPad3(6, 17);
            this.threePadsActive = this.allOnPads();
            this.isOnResetPad();
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                System.out.println("Something went wrong");
            }
        }
    }

    public void addCharacter() {
        switch (this.selectedCharacter) {
            case 1: {
                try {
                    this.character = new Sprite(Image.createImage((String)"/girl_animationtest.png"), 35, 41);
                    break;
                }
                catch (Exception e) {
                    System.out.println("Error reading IMG");
                }
            }
            case 5: {
                try {
                    this.character = new Sprite(Image.createImage((String)"/herosprite copy.png"), 41, 43);
                    break;
                }
                catch (Exception e) {
                    System.out.println("Error reading image");
                }
            }
        }
    }

    public TiledLayer getMap(String fpath, Image ftiles) {
        TiledLayer tMap = null;
        try {
            InputStream is = this.getClass().getResourceAsStream(fpath);
            DataInputStream ds = new DataInputStream(is);
            try {
                ds.skipBytes(8);
                int mW = ds.readByte();
                int mH = ds.readByte();
                byte tW = ds.readByte();
                byte tH = ds.readByte();
                tMap = new TiledLayer(mW, mH, ftiles, (int)tW, (int)tH);
                int rCtr = 0;
                while (rCtr < mH) {
                    int cCtr = 0;
                    while (cCtr < mW) {
                        byte nB = ds.readByte();
                        if (nB > 0) {
                            tMap.setCell(cCtr, rCtr, nB + 1);
                        }
                        ++cCtr;
                    }
                    ++rCtr;
                }
            }
            catch (Exception ex) {
                tMap = null;
                System.err.println("map loading error1 : " + ex.getMessage());
            }
            ds.close();
            ds = null;
            is = null;
        }
        catch (Exception ex) {
            tMap = null;
            System.err.println("map loading error2 : " + ex.getMessage());
        }
        return tMap;
    }

    public boolean isSolid(int dX, int dY) {
        boolean isSolid = false;
        System.out.println(this.walls.getCell(dX, dY));
        isSolid = this.walls.getCell(dX, dY) != this.EMPTY;
        if (this.gateSideCounter < 3 && dX == 18) {
            isSolid = true;
        }
        if (this.gateCounter < 9 && (dX == 13 || dX == 14) && dY == 8) {
            isSolid = true;
        }
        if (this.gate2Counter < 9 && (dX == 5 || dX == 6) && dY == 12) {
            isSolid = true;
        }
        return isSolid;
    }

    public boolean isOnPpad(int x, int y, TiledLayer layer) {
        boolean ppad_active = false;
        ppad_active = layer.getCell(x, y) != this.EMPTY;
        return ppad_active;
    }

    public boolean allOnPads() {
        boolean allActive = false;
        allActive = this.finalPad1 && this.finalPad2 && this.finalPad3;
        return allActive;
    }

    private void checkCollision(int direction) {
        if (this.rock1.getCell(this.dTileX, this.dTileY) != this.EMPTY || this.rock1.getCell(this.dTileX, this.dTileY + 1) != this.EMPTY || this.rock1.getCell(this.dTileX, this.dTileY) != this.EMPTY) {
            this.rock1.setCell(this.firstRockCol, this.firstRockRow, this.EMPTY);
            switch (direction) {
                case 1: {
                    if (this.isSolid(this.dTileX + 1, this.dTileY)) break;
                    ++this.firstRockCol;
                    break;
                }
                case 2: {
                    if (this.isSolid(this.dTileX + -1, this.dTileY)) break;
                    --this.firstRockCol;
                    break;
                }
                case 3: {
                    if (this.isSolid(this.dTileX, this.dTileY + 1)) break;
                    ++this.firstRockRow;
                    break;
                }
                case 4: {
                    if (this.isSolid(this.dTileX, this.dTileY - 1)) break;
                    --this.firstRockRow;
                }
            }
            this.rock1.setCell(this.firstRockCol, this.firstRockRow, this.FIRST_TILE);
        }
        if (this.rock2.getCell(this.dTileX, this.dTileY) != this.EMPTY || this.rock2.getCell(this.dTileX, this.dTileY + 1) != this.EMPTY || this.rock2.getCell(this.dTileX, this.dTileY) != this.EMPTY) {
            System.out.println("Collided with rock");
            this.rock2.setCell(this.secondRockCol, this.secondRockRow, this.EMPTY);
            switch (direction) {
                case 1: {
                    if (this.isSolid(this.dTileX + 1, this.dTileY)) break;
                    ++this.secondRockCol;
                    break;
                }
                case 2: {
                    if (this.isSolid(this.dTileX + -1, this.dTileY)) break;
                    --this.secondRockCol;
                    break;
                }
                case 3: {
                    if (this.isSolid(this.dTileX, this.dTileY + 1)) break;
                    ++this.secondRockRow;
                    break;
                }
                case 4: {
                    if (this.isSolid(this.dTileX, this.dTileY - 1)) break;
                    --this.secondRockRow;
                }
            }
            this.rock2.setCell(this.secondRockCol, this.secondRockRow, this.FIRST_TILE);
        }
        if (this.rock3.getCell(this.dTileX, this.dTileY) != this.EMPTY || this.rock3.getCell(this.dTileX, this.dTileY + 1) != this.EMPTY || this.rock3.getCell(this.dTileX, this.dTileY) != this.EMPTY) {
            System.out.println("Collided with rock");
            this.rock3.setCell(this.thirdRockCol, this.thirdRockRow, this.EMPTY);
            switch (direction) {
                case 1: {
                    if (this.isSolid(this.dTileX + 1, this.dTileY)) break;
                    ++this.thirdRockCol;
                    break;
                }
                case 2: {
                    if (this.isSolid(this.dTileX + -1, this.dTileY)) break;
                    --this.thirdRockCol;
                    break;
                }
                case 3: {
                    if (this.isSolid(this.dTileX, this.dTileY + 1)) break;
                    ++this.thirdRockRow;
                    break;
                }
                case 4: {
                    if (this.isSolid(this.dTileX, this.dTileY - 1)) break;
                    --this.thirdRockRow;
                }
            }
            this.rock3.setCell(this.thirdRockCol, this.thirdRockRow, this.FIRST_TILE);
        }
        if (this.character.collidesWith(this.objective, true)) {
            this.game.endOfLevel(this.resourcesReceived);
            this.gameIsOn = false;
        }
    }

    private void openFirstDoor() {
        this.gateSideCounterDirection = this.ppad1IsActive || this.ppad3IsActive;
    }

    private void openSecondDoor() {
        this.gateCounterDirection = this.ppad2IsActive;
    }

    private void openThirdDoor() {
        this.gate2CounterDirection = this.threePadsActive;
    }

    private boolean rockOnPad1(int x, int y) {
        boolean pad1Active = false;
        if (this.rock1.getCell(x, y) != this.EMPTY) {
            pad1Active = true;
        } else if (this.rock2.getCell(x, y) != this.EMPTY) {
            pad1Active = true;
        } else if (this.rock3.getCell(x, y) != this.EMPTY) {
            pad1Active = true;
        }
        return pad1Active;
    }

    private boolean rockOnPad2(int x, int y) {
        boolean pad2Active = false;
        if (this.rock1.getCell(x, y) != this.EMPTY) {
            pad2Active = true;
        } else if (this.rock2.getCell(x, y) != this.EMPTY) {
            pad2Active = true;
        } else if (this.rock3.getCell(x, y) != this.EMPTY) {
            pad2Active = true;
        }
        return pad2Active;
    }

    private boolean rockOnPad3(int x, int y) {
        boolean pad3Active = false;
        if (this.rock1.getCell(x, y) != this.EMPTY) {
            pad3Active = true;
        } else if (this.rock2.getCell(x, y) != this.EMPTY) {
            pad3Active = true;
        } else if (this.rock3.getCell(x, y) != this.EMPTY) {
            pad3Active = true;
        }
        return pad3Active;
    }

    private void isOnResetPad() {
        if (this.resetPad.getCell(this.dTileX, this.dTileY) != this.EMPTY) {
            this.resetLevel();
            this.resetPad.setCell(22, 17, 3);
            this.resetPad.setCell(23, 17, 4);
            this.resetPad.setCell(22, 18, 7);
            this.resetPad.setCell(23, 18, 8);
            this.resetPad.setCell(16, 10, 3);
            this.resetPad.setCell(17, 10, 4);
            this.resetPad.setCell(16, 11, 7);
            this.resetPad.setCell(17, 11, 8);
        } else {
            this.resetPad.setCell(22, 17, 1);
            this.resetPad.setCell(23, 17, 2);
            this.resetPad.setCell(22, 18, 5);
            this.resetPad.setCell(23, 18, 6);
            this.resetPad.setCell(16, 10, 1);
            this.resetPad.setCell(17, 10, 2);
            this.resetPad.setCell(16, 11, 5);
            this.resetPad.setCell(17, 11, 6);
        }
    }

    private void resetLevel() {
        System.out.println("Reset level");
        this.rock1.setCell(this.firstRockCol, this.firstRockRow, this.EMPTY);
        this.rock2.setCell(this.secondRockCol, this.secondRockRow, this.EMPTY);
        this.rock3.setCell(this.thirdRockCol, this.thirdRockRow, this.EMPTY);
        this.firstRockCol = this.originalFirstRockCol;
        this.firstRockRow = this.originalFirstRockRow;
        this.secondRockCol = this.originalSecondRockCol;
        this.secondRockRow = this.originalSecondRockRow;
        this.thirdRockCol = this.originalThirdRockCol;
        this.thirdRockRow = this.originalThirdRockRow;
        this.rock1.setCell(this.firstRockCol, this.firstRockRow, this.FIRST_TILE);
        this.rock2.setCell(this.secondRockCol, this.secondRockRow, this.FIRST_TILE);
        this.rock3.setCell(this.thirdRockCol, this.thirdRockRow, this.FIRST_TILE);
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.backCommand) {
            this.game.save();
            this.game.endOfLevel(0);
        }
    }
}

