/*
 * Decompiled with CFR 0.152.
 */
package fi.tamk.tiko.gameprogramming.Slumber.levels;

import fi.tamk.tiko.gameprogramming.Slumber.ui.Slumber;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.lcdui.game.TiledLayer;

public class level2
extends GameCanvas
implements Runnable,
CommandListener {
    private Graphics g;
    private int width;
    private Slumber game;
    private boolean gameIsOn;
    private int resourcesReceived = 3;
    private int selectedCharacter;
    private Command backCommand;
    private Sprite character;
    private LayerManager layerManager;
    private TiledLayer floor;
    private TiledLayer walls;
    private TiledLayer tilesOver;
    private TiledLayer ppad1;
    private TiledLayer ppad2;
    private TiledLayer ppad3;
    private Sprite torch;
    private Sprite torch2;
    private Sprite gate;
    private Sprite objective;
    private Image tileset;
    private static final int TILE_LENGTH = 24;
    private static int characterSpeedX = 0;
    private static int characterSpeedY = 0;
    private int torchCounter = 1;
    private int gateCounter = 0;
    private boolean gateCounterDirection;
    private int dTileX;
    private int dTileY;
    private int UP = 3;
    private int DOWN = 4;
    private int LEFT = 2;
    private int RIGHT = 1;
    private int EMPTY = 0;
    private int NOT_ACTIVE = 1;
    private int ACTIVE = 2;
    private int TORCH_NOT_ON = 5;
    private boolean ppad1IsActive = false;
    private boolean ppad2IsActive = false;
    private boolean ppad3IsActive = false;
    private boolean torch1On = false;
    private boolean torch2On = false;
    private boolean torch3On = false;
    private boolean allTorchesOn = false;
    private int ppad1XTile = 11;
    private int ppad1YTile = 4;
    private int ppad2XTile = 13;
    private int ppad2YTile = 4;
    private int ppad3XTile = 15;
    private int ppad3YTile = 4;
    private int howManyTorches = 3;
    private int[] randoms = new int[this.howManyTorches];
    private Sprite[] torches = new Sprite[this.howManyTorches];
    private boolean moving = false;

    public level2(boolean suppressKeyEvents, Slumber game, int x) {
        super(suppressKeyEvents);
        this.g = this.getGraphics();
        this.width = this.getWidth() / 2;
        this.selectedCharacter = x;
        this.randomTorches();
        this.addCharacter();
        this.backCommand = new Command("Back", 2, 1);
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
        try {
            this.initializeGraphics();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.paintObjects(this.g);
        this.game = game;
        this.gameIsOn = true;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void initializeGraphics() throws IOException {
        try {
            this.tileset = Image.createImage((String)"/tileset3.png");
        }
        catch (Exception e) {
            System.out.println("Tileset problem");
        }
        this.floor = this.getMap("/level_2/2LevelFloor.smp", this.tileset);
        this.walls = this.getMap("/level_2/2LevelWalls.smp", this.tileset);
        this.tilesOver = this.getMap("/level_2/2LevelTileOver.smp", this.tileset);
        this.ppad1 = new TiledLayer(30, 25, Image.createImage((String)"/brown ppad.png"), 24, 24);
        this.ppad1.setCell(11, 4, this.NOT_ACTIVE);
        this.ppad2 = new TiledLayer(30, 25, Image.createImage((String)"/brown ppad.png"), 24, 24);
        this.ppad2.setCell(13, 4, this.NOT_ACTIVE);
        this.ppad3 = new TiledLayer(30, 25, Image.createImage((String)"/brown ppad.png"), 24, 24);
        this.ppad3.setCell(15, 4, this.NOT_ACTIVE);
        this.torch = new Sprite(Image.createImage((String)"/torch.png"), 24, 24);
        this.torch2 = new Sprite(Image.createImage((String)"/torch.png"), 24, 24);
        int i = 0;
        while (i < this.howManyTorches) {
            this.torches[i] = new Sprite(Image.createImage((String)"/torch.png"), 24, 24);
            ++i;
        }
        this.gate = new Sprite(Image.createImage((String)"/gate.png"), 48, 48);
        this.objective = new Sprite(Image.createImage((String)"/pappa.png"), 63, 63);
        this.layerManager = new LayerManager();
        this.layerManager.append((Layer)this.torch);
        this.layerManager.append((Layer)this.torch2);
        i = 0;
        while (i < this.howManyTorches) {
            this.layerManager.append((Layer)this.torches[i]);
            ++i;
        }
        this.layerManager.append((Layer)this.tilesOver);
        this.layerManager.append((Layer)this.character);
        this.layerManager.append((Layer)this.objective);
        this.character.setVisible(true);
        this.character.setPosition(120, 288);
        this.character.defineReferencePixel(this.character.getWidth() / 2, this.character.getHeight() / 2);
        this.objective.setPosition(96, 72);
        this.objective.setVisible(true);
        this.torch.setPosition(72, 168);
        this.torch.setVisible(true);
        this.torch2.setPosition(144, 168);
        this.torch2.setVisible(true);
        int position = 11;
        int i2 = 0;
        while (i2 < this.howManyTorches) {
            this.torches[i2].setPosition(position * 24, 24);
            this.torches[i2].setVisible(true);
            this.torches[i2].setFrame(this.TORCH_NOT_ON);
            position += 2;
            ++i2;
        }
        this.gate.setPosition(96, 168);
        this.gate.setVisible(true);
        this.layerManager.append((Layer)this.ppad1);
        this.layerManager.append((Layer)this.ppad2);
        this.layerManager.append((Layer)this.ppad3);
        this.layerManager.append((Layer)this.gate);
        this.layerManager.append((Layer)this.walls);
        this.layerManager.append((Layer)this.floor);
        this.layerManager.setViewWindow(this.character.getRefPixelX() - this.getWidth() / 2, this.character.getRefPixelY() - this.getHeight() / 2, this.getWidth(), this.getHeight());
    }

    protected void paintObjects(Graphics g) {
        this.flushGraphics();
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(255, 255, 255);
        this.layerManager.paint(g, 0, 0);
    }

    public void pointerPressed(int x, int y) {
        if (!this.moving) {
            if (x < this.getWidth() / 3 && y > this.getHeight() / 3 && y < this.getHeight() - this.getHeight() / 3) {
                characterSpeedX = 24;
                this.moveToon(this.LEFT);
            }
            if (x > this.getWidth() - this.getWidth() / 3 && y > this.getHeight() / 3 && y < this.getHeight() - this.getHeight() / 3) {
                characterSpeedX = 24;
                this.moveToon(this.RIGHT);
            }
            if (x > this.getWidth() / 3 && x < this.getWidth() - this.getWidth() / 3 && y < this.getHeight() / 3) {
                characterSpeedY = 24;
                this.moveToon(this.DOWN);
            }
            if (x > this.getWidth() / 3 && x < this.getWidth() - this.getWidth() / 3 && y > this.getHeight() - this.getHeight() / 3) {
                characterSpeedY = 24;
                this.moveToon(this.UP);
            }
        }
    }

    public void moveToon(int direction) {
        int counter;
        boolean isTileSolid;
        this.checkCollision(direction);
        this.moving = true;
        if (direction == this.RIGHT) {
            this.character.setTransform(2);
            this.dTileX = this.character.getRefPixelX() / 24;
            this.dTileY = this.character.getRefPixelY() / 24;
            this.dTileX += 2;
            isTileSolid = this.isSolid(this.dTileX, this.dTileY);
            this.isOnPpad(this.dTileX, this.dTileY);
            this.isOnPpad(this.dTileX, this.dTileY);
            this.isOnPpad(this.dTileX, this.dTileY);
            System.out.println(isTileSolid);
            if (!isTileSolid) {
                counter = 0;
                while (counter < characterSpeedX) {
                    this.character.move(1, 0);
                    this.character.nextFrame();
                    ++counter;
                    this.layerManager.setViewWindow(this.character.getRefPixelX() - this.getWidth() / 2, this.character.getRefPixelY() - this.getHeight() / 2, this.getWidth(), this.getHeight());
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (direction == this.LEFT) {
            this.character.setTransform(0);
            this.dTileX = this.character.getRefPixelX() / 24;
            this.dTileY = this.character.getRefPixelY() / 24;
            --this.dTileX;
            isTileSolid = this.isSolid(this.dTileX, this.dTileY);
            this.isOnPpad(this.dTileX, this.dTileY);
            this.isOnPpad(this.dTileX, this.dTileY);
            this.isOnPpad(this.dTileX, this.dTileY);
            System.out.println(isTileSolid);
            if (!isTileSolid) {
                counter = 0;
                while (counter < characterSpeedX) {
                    this.character.move(-1, 0);
                    this.character.nextFrame();
                    ++counter;
                    this.layerManager.setViewWindow(this.character.getRefPixelX() - this.getWidth() / 2, this.character.getRefPixelY() - this.getHeight() / 2, this.getWidth(), this.getHeight());
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (direction == this.UP) {
            this.dTileX = this.character.getRefPixelX() / 24;
            this.dTileY = this.character.getRefPixelY() / 24;
            this.dTileY += 2;
            isTileSolid = this.isSolid(this.dTileX, this.dTileY);
            this.isOnPpad(this.dTileX, this.dTileY);
            this.isOnPpad(this.dTileX, this.dTileY);
            this.isOnPpad(this.dTileX, this.dTileY);
            System.out.println(isTileSolid);
            if (!isTileSolid) {
                counter = 0;
                while (counter < characterSpeedY) {
                    this.character.move(0, 1);
                    this.character.nextFrame();
                    ++counter;
                    this.layerManager.setViewWindow(this.character.getRefPixelX() - this.getWidth() / 2, this.character.getRefPixelY() - this.getHeight() / 2, this.getWidth(), this.getHeight());
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (direction == this.DOWN) {
            this.dTileX = this.character.getRefPixelX() / 24;
            this.dTileY = this.character.getRefPixelY() / 24;
            --this.dTileY;
            isTileSolid = this.isSolid(this.dTileX, this.dTileY);
            this.isOnPpad(this.dTileX, this.dTileY);
            this.isOnPpad(this.dTileX, this.dTileY);
            this.isOnPpad(this.dTileX, this.dTileY);
            System.out.println(isTileSolid);
            if (!isTileSolid) {
                counter = 0;
                while (counter < characterSpeedY) {
                    this.character.move(0, -1);
                    this.character.nextFrame();
                    ++counter;
                    this.layerManager.setViewWindow(this.character.getRefPixelX() - this.getWidth() / 2, this.character.getRefPixelY() - this.getHeight() / 2, this.getWidth(), this.getHeight());
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        characterSpeedX = 0;
        characterSpeedY = 0;
        this.dTileX = 0;
        this.dTileY = 0;
        this.moving = false;
    }

    public void pointerReleased(int x, int y) {
    }

    public void pointerDragged(int x, int y) {
    }

    public void run() {
        while (this.gameIsOn) {
            this.paintObjects(this.g);
            this.torchCounter = this.torchCounter == 4 ? 0 : ++this.torchCounter;
            this.torch.setFrame(this.torchCounter);
            this.torch2.setFrame(this.torchCounter);
            if (this.ppad1IsActive) {
                this.torches[0].setFrame(this.torchCounter);
                this.torches[1].setFrame(this.torchCounter);
            } else {
                this.torches[0].setFrame(this.TORCH_NOT_ON);
                this.torches[1].setFrame(this.TORCH_NOT_ON);
            }
            if (this.ppad2IsActive) {
                this.torches[1].setFrame(this.torchCounter);
                this.torches[2].setFrame(this.torchCounter);
            } else {
                this.torches[1].setFrame(this.TORCH_NOT_ON);
                this.torches[2].setFrame(this.TORCH_NOT_ON);
            }
            if (this.ppad3IsActive) {
                this.torches[0].setFrame(this.torchCounter);
                this.torches[1].setFrame(this.torchCounter);
            } else {
                this.torches[0].setFrame(this.TORCH_NOT_ON);
                this.torches[1].setFrame(this.TORCH_NOT_ON);
            }
            this.openFirstDoor();
            if (this.gateCounterDirection) {
                if (this.gateCounter < 9) {
                    ++this.gateCounter;
                }
            } else if (!this.gateCounterDirection && this.gateCounter > 0) {
                --this.gateCounter;
            }
            this.gate.setFrame(this.gateCounter);
            this.areTorchesOn();
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                System.out.println("Something went wrong");
            }
        }
    }

    public void addCharacter() {
        switch (this.selectedCharacter) {
            case 1: {
                try {
                    this.character = new Sprite(Image.createImage((String)"/girl_animationtest.png"), 35, 41);
                    break;
                }
                catch (Exception e) {
                    System.out.println("Error reading IMG");
                }
            }
            case 5: {
                try {
                    this.character = new Sprite(Image.createImage((String)"/herosprite copy.png"), 41, 43);
                    break;
                }
                catch (Exception e) {
                    System.out.println("Error reading image");
                }
            }
        }
    }

    public TiledLayer getMap(String fpath, Image ftiles) {
        TiledLayer tMap = null;
        try {
            InputStream is = this.getClass().getResourceAsStream(fpath);
            DataInputStream ds = new DataInputStream(is);
            try {
                ds.skipBytes(8);
                int mW = ds.readByte();
                int mH = ds.readByte();
                byte tW = ds.readByte();
                byte tH = ds.readByte();
                tMap = new TiledLayer(mW, mH, ftiles, (int)tW, (int)tH);
                int rCtr = 0;
                while (rCtr < mH) {
                    int cCtr = 0;
                    while (cCtr < mW) {
                        byte nB = ds.readByte();
                        if (nB > 0) {
                            tMap.setCell(cCtr, rCtr, nB + 1);
                        }
                        ++cCtr;
                    }
                    ++rCtr;
                }
            }
            catch (Exception ex) {
                tMap = null;
                System.err.println("map loading error1 : " + ex.getMessage());
            }
            ds.close();
            ds = null;
            is = null;
        }
        catch (Exception ex) {
            tMap = null;
            System.err.println("map loading error2 : " + ex.getMessage());
        }
        return tMap;
    }

    public boolean isSolid(int dX, int dY) {
        boolean isSolid = false;
        isSolid = this.walls.getCell(dX, dY) != this.EMPTY;
        if (this.gateCounter < 9 && (dX == 4 || dX == 5) && dY == 7) {
            isSolid = true;
        }
        return isSolid;
    }

    public void isOnPpad(int dX, int dY) {
        if (this.ppad1.getCell(dX, dY) != this.EMPTY || this.ppad1.getCell(dX, dY + 1) != this.EMPTY) {
            this.ppad1IsActive = !this.ppad1IsActive;
        }
        if (this.ppad2.getCell(dX, dY) != this.EMPTY || this.ppad2.getCell(dX, dY + 1) != this.EMPTY) {
            this.ppad2IsActive = !this.ppad2IsActive;
        }
        if (this.ppad3.getCell(dX, dY) != this.EMPTY || this.ppad3.getCell(dX, dY + 1) != this.EMPTY) {
            this.ppad3IsActive = !this.ppad3IsActive;
        }
    }

    private void checkCollision(int direction) {
        if (this.character.collidesWith(this.objective, true)) {
            this.game.endOfLevel(this.resourcesReceived);
            this.gameIsOn = false;
        }
    }

    private void openFirstDoor() {
        this.gateCounterDirection = this.allTorchesOn;
    }

    private void areTorchesOn() {
        if (this.ppad1IsActive && this.ppad2IsActive && this.ppad3IsActive) {
            this.allTorchesOn = true;
            System.out.println("Torches are on");
        } else {
            this.allTorchesOn = false;
        }
    }

    private void randomTorches() {
        Random generate = new Random();
        boolean isNotInArray = false;
        int i = 0;
        while (i < this.randoms.length) {
            int random = generate.nextInt(this.randoms.length) + 1;
            int x = 0;
            while (x < this.randoms.length) {
                if (this.randoms[x] == random) {
                    isNotInArray = false;
                    break;
                }
                isNotInArray = true;
                ++x;
            }
            if (!isNotInArray) continue;
            this.randoms[i] = random;
            ++i;
        }
        i = 0;
        while (i < this.randoms.length) {
            ++i;
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.backCommand) {
            this.game.save();
            this.game.endOfLevel(0);
        }
    }
}

