/*
 * Decompiled with CFR 0.152.
 */
package fi.tamk.tiko.gameprogramming.Slumber.ui;

import fi.tamk.tiko.gameprogramming.Slumber.levels.level1;
import fi.tamk.tiko.gameprogramming.Slumber.levels.level2;
import fi.tamk.tiko.gameprogramming.Slumber.levels.level3;
import fi.tamk.tiko.gameprogramming.Slumber.ui.BuildingScreen;
import fi.tamk.tiko.gameprogramming.Slumber.ui.CharSelect;
import fi.tamk.tiko.gameprogramming.Slumber.ui.ContinueScreen;
import fi.tamk.tiko.gameprogramming.Slumber.ui.LevelSelect;
import fi.tamk.tiko.gameprogramming.Slumber.ui.LevelSelecter;
import fi.tamk.tiko.gameprogramming.Slumber.ui.LogoScreen;
import fi.tamk.tiko.gameprogramming.Slumber.ui.MainMenu;
import fi.tamk.tiko.gameprogramming.Slumber.ui.ScreenChanger;
import fi.tamk.tiko.gameprogramming.Slumber.ui.SplashScreen;
import fi.tamk.tiko.gameprogramming.Slumber.ui.StoryScreen;
import fi.tamk.tiko.gameprogramming.Slumber.ui.VillageScreen;
import fi.tamk.tiko.gameprogramming.Slumber.ui.WarningScreen;
import fi.tamk.tiko.gameprogramming.Slumber.ui.about;
import fi.tamk.tiko.gameprogramming.Slumber.ui.endOfLevel;
import fi.tamk.tiko.gameprogramming.Slumber.ui.helpScreen;
import java.io.IOException;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Slumber
extends MIDlet
implements ScreenChanger,
LevelSelecter {
    private Display display;
    private LogoScreen logo;
    private VillageScreen village;
    private LevelSelect level;
    private CharSelect character;
    private MainMenu start;
    private StoryScreen story;
    private BuildingScreen build;
    private about about;
    private helpScreen help;
    private RecordStore rs;
    private ContinueScreen save;
    private WarningScreen warning;
    private level1 currentLevel;
    private level2 currentLevel2;
    private level3 currentLevel3;
    private int selectedLevel;
    byte[] saveData = new byte[4];

    protected void destroyApp(boolean unconditional) throws MIDletStateChangeException {
        this.close();
    }

    protected void pauseApp() {
    }

    protected void startApp() throws MIDletStateChangeException {
        this.display = Display.getDisplay((MIDlet)this);
        this.display.setCurrent((Displayable)new SplashScreen(this));
        this.start = new MainMenu(true, this);
        this.village = new VillageScreen(true, this);
        this.level = new LevelSelect(true, this);
        this.story = new StoryScreen(true, this);
        this.character = new CharSelect(true, this);
        this.build = new BuildingScreen(true, this);
    }

    protected void splashScreenDone() {
        this.logo = new LogoScreen(true, this);
        this.display.setCurrent((Displayable)this.logo);
    }

    protected void addResourcesToVillage(int x) {
        this.village.setResources(x);
    }

    protected void buildVillage(int x) {
        if (this.village.getResources() >= this.village.getBuildingCost(x)) {
            this.village.addBuilding(x);
            this.village.setResources(this.village.getBuildingCost(x) * -1);
        } else {
            System.out.println("Not enough resources");
        }
    }

    protected void gameLevel(int x) {
        switch (this.selectedLevel) {
            case 1: {
                this.currentLevel = new level1(true, this, x);
                this.display.setCurrent((Displayable)this.currentLevel);
                break;
            }
            case 2: {
                this.currentLevel2 = new level2(true, this, x);
                this.display.setCurrent((Displayable)this.currentLevel2);
                break;
            }
            case 3: {
                this.currentLevel3 = new level3(true, this, x);
                this.display.setCurrent((Displayable)this.currentLevel3);
            }
        }
    }

    public void endOfLevel(int x) {
        endOfLevel end = new endOfLevel(true, this, x);
        this.display.setCurrent((Displayable)end);
        this.killLevels();
    }

    public void changeScreen(int screen) {
        switch (screen) {
            case 1: {
                this.display.vibrate(100);
                this.display.setCurrent((Displayable)this.start);
                this.killStartupScreens();
                break;
            }
            case 2: {
                this.village.paintAgain();
                this.display.vibrate(100);
                this.display.setCurrent((Displayable)this.village);
                break;
            }
            case 3: {
                this.level.paintAgain();
                this.display.vibrate(100);
                this.display.setCurrent((Displayable)this.level);
                break;
            }
            case 4: {
                this.character.paintAgain();
                this.display.vibrate(100);
                this.display.setCurrent((Displayable)this.character);
                break;
            }
            case 5: {
                this.story.paintAgain();
                this.display.vibrate(100);
                this.display.setCurrent((Displayable)this.story);
                break;
            }
            case 6: {
                this.build.paintAgain();
                this.display.vibrate(100);
                this.display.setCurrent((Displayable)this.build);
                break;
            }
            case 7: {
                this.logo = new LogoScreen(true, this);
                this.display.vibrate(100);
                this.display.setCurrent((Displayable)this.logo);
                break;
            }
            case 8: {
                this.about = new about(true, this);
                this.logo = null;
                this.display.vibrate(100);
                this.display.setCurrent((Displayable)this.about);
                break;
            }
            case 9: {
                this.help = new helpScreen(true, this);
                this.logo = null;
                this.display.vibrate(100);
                this.display.setCurrent((Displayable)this.help);
                break;
            }
            case 10: {
                this.save = new ContinueScreen(true, this);
                this.logo = null;
                this.save.paintAgain();
                this.display.vibrate(100);
                this.display.setCurrent((Displayable)this.save);
                break;
            }
            case 11: {
                this.warning = new WarningScreen(true, this);
                this.save = null;
                this.warning.paintAgain();
                this.display.vibrate(100);
                this.display.setCurrent((Displayable)this.warning);
            }
        }
    }

    public void setLevel(int x) {
        this.selectedLevel = x;
    }

    public int getLevel() {
        int selectedLevel = this.selectedLevel;
        return selectedLevel;
    }

    static Image createImage(String filename) {
        Image image = null;
        try {
            image = Image.createImage((String)filename);
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        return image;
    }

    public void saveProgress() {
        int i = 0;
        while (i < 3) {
            boolean built = this.village.getBuilding(i);
            this.saveData[i] = (byte)(built ? 1 : 0);
            ++i;
        }
        this.saveData[3] = (byte)this.village.getResources();
        byte[] tb = this.saveData;
        try {
            if (this.rs.getNumRecords() == 0) {
                this.rs.addRecord(tb, 0, tb.length);
            } else {
                this.rs.setRecord(1, tb, 0, tb.length);
            }
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
    }

    public void connect() {
        try {
            this.rs = RecordStore.openRecordStore((String)"SimpleRMSEnumerationExample", (boolean)true);
            System.out.println("RecordStore opened!");
        }
        catch (RecordStoreException e) {
            System.out.println("Problem..." + (Object)((Object)e));
        }
    }

    public void getSaves() {
        try {
            if (this.rs.getRecord(1) != null) {
                this.saveData = this.rs.getRecord(1);
            }
        }
        catch (Exception e) {
            System.out.println("Save failed");
        }
        int i = 0;
        while (i < 3) {
            System.out.println(i);
            if (this.saveData[i] == 1) {
                this.village.addBuilding(i + 1);
                System.out.println("Add " + i);
            }
            ++i;
        }
        byte resources = this.saveData[3];
        this.village.setResources(resources);
    }

    public void close() {
        try {
            if (this.rs != null) {
                this.rs.closeRecordStore();
                System.out.println("RecordStore closed!");
            }
        }
        catch (RecordStoreException e) {
            System.out.println("Problem..." + (Object)((Object)e));
        }
    }

    public void save() {
        this.connect();
        this.saveProgress();
        this.close();
    }

    public void load() {
        this.connect();
        this.getSaves();
        this.close();
    }

    public void eraseSave() {
        this.connect();
        int i = 0;
        while (i < 3) {
            boolean built = false;
            this.saveData[i] = (byte)(built ? 1 : 0);
            ++i;
        }
        this.saveData[3] = 0;
        byte[] tb = this.saveData;
        try {
            if (this.rs.getNumRecords() == 0) {
                this.rs.addRecord(tb, 0, tb.length);
            } else {
                this.rs.setRecord(1, tb, 0, tb.length);
            }
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
        this.close();
    }

    public void killLevels() {
        this.currentLevel = null;
        this.currentLevel2 = null;
        this.currentLevel3 = null;
    }

    public void killStartupScreens() {
        this.logo = null;
        this.about = null;
        this.help = null;
        this.save = null;
        this.warning = null;
    }
}

