/*
 * Decompiled with CFR 0.152.
 */
package bluegammon.gui.menu;

import bluegammon.gui.menu.ItemAction;
import bluegammon.gui.menu.MenuListener;
import bluegammon.gui.menu.MenuPage;
import bluegammon.gui.menu.MenuPainter;
import bluegammon.gui.menu.PageItem;
import java.util.Stack;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public class Menu
implements Runnable {
    protected MenuPainter m_painter;
    protected MenuPage m_startPage;
    protected MenuPage m_curPage;
    protected int m_curItemIndex;
    protected boolean m_inTransition;
    protected boolean m_transitionBack;
    protected MenuPage m_transPage;
    protected int m_frame;
    protected int m_frames;
    protected long m_frameDelay = 500L;
    protected MenuListener m_listener;
    protected final Object ANIM_LOCK = new Object();
    protected volatile boolean m_running = true;
    protected Canvas m_canvas;
    protected Stack m_history = new Stack();
    protected int m_width = 0;
    protected int m_height = 0;
    protected int m_x = 0;
    protected int m_y = 0;

    public Menu(MenuPage menuPage, Canvas canvas, MenuPainter menuPainter) {
        this.m_startPage = menuPage;
        this.setCanvas(canvas);
        this.setPainter(menuPainter);
    }

    public void start() {
        new Thread((Runnable)this, "Menu thread").start();
        this.gotoPage(this.m_startPage);
    }

    public void paint(Graphics graphics) {
        if (this.m_width == 0 && this.m_height == 0 && this.m_canvas != null) {
            this.m_width = this.m_canvas.getWidth() - this.m_x;
            this.m_height = this.m_canvas.getHeight() - this.m_y;
        }
        if (this.m_inTransition && this.m_frames > 0) {
            this.m_painter.paintTransition(graphics, this.m_curPage, this.m_transPage, this.m_x, this.m_y, this.m_width, this.m_height, this.m_frame, this.m_frames, this.m_transitionBack);
        } else {
            this.m_painter.paintMenu(graphics, this.m_curPage, this.m_x, this.m_y, this.m_width, this.m_height);
        }
    }

    public void keyPressed(int n) {
        MenuPage menuPage = this.getCurrentPage();
        if (menuPage != null && this.m_canvas != null) {
            if (n == -11) {
                this.goBack();
                return;
            }
            int n2 = this.m_canvas.getGameAction(n);
            switch (n2) {
                case 2: {
                    this.goBack();
                    break;
                }
                case 5: 
                case 8: {
                    PageItem pageItem = this.getSelectedItem();
                    if (n2 == 8 && pageItem != null && pageItem.getAction() != null) {
                        this.doAction(pageItem.getAction(), menuPage, pageItem);
                    }
                    if (pageItem == null || pageItem.getSubPage() == null) break;
                    this.gotoPage(pageItem.getSubPage());
                    break;
                }
                case 1: {
                    this.setSelectedItemIndex(this.getSelectedItemIndex() - 1);
                    break;
                }
                case 6: {
                    this.setSelectedItemIndex(this.getSelectedItemIndex() + 1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gotoPage(MenuPage menuPage) {
        MenuPage menuPage2 = null;
        Object object = this.ANIM_LOCK;
        synchronized (object) {
            menuPage2 = this.getCurrentPage();
            if (menuPage2 != null) {
                this.m_history.push(menuPage2);
            }
        }
        if (this.m_listener != null) {
            this.m_listener.newPage(menuPage2, menuPage, false);
            this.m_listener.itemSelected(menuPage, null, menuPage == null ? null : menuPage.itemAt(menuPage.getSelectedIndex()));
        }
        this.startTransition(menuPage2, menuPage, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goBack() {
        MenuPage menuPage = null;
        MenuPage menuPage2 = null;
        Object object = this.ANIM_LOCK;
        synchronized (object) {
            menuPage = this.getCurrentPage();
            if (this.m_history.size() > 0) {
                menuPage2 = (MenuPage)this.m_history.pop();
            }
        }
        if (menuPage2 != null) {
            if (this.m_listener != null) {
                this.m_listener.newPage(menuPage, menuPage2, true);
                this.m_listener.itemSelected(menuPage2, null, menuPage2 == null ? null : menuPage2.itemAt(menuPage2.getSelectedIndex()));
            }
            this.startTransition(menuPage, menuPage2, true);
        }
    }

    protected void doAction(final ItemAction itemAction, final MenuPage menuPage, final PageItem pageItem) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    itemAction.itemAction(menuPage, pageItem);
                    if (Menu.this.m_listener != null) {
                        Menu.this.m_listener.actionCalled(menuPage, pageItem, itemAction);
                    }
                    if (Menu.this.m_canvas != null) {
                        Menu.this.m_canvas.repaint();
                    }
                }
                catch (Throwable throwable) {
                    System.out.println("Exception in ItemAction");
                    throwable.printStackTrace();
                }
            }
        }, "ItemAction runner").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuPage getCurrentPage() {
        MenuPage menuPage = null;
        Object object = this.ANIM_LOCK;
        synchronized (object) {
            menuPage = this.m_inTransition ? this.m_transPage : this.m_curPage;
        }
        return menuPage;
    }

    public PageItem getSelectedItem() {
        MenuPage menuPage = this.getCurrentPage();
        if (menuPage != null) {
            return menuPage.itemAt(menuPage.getSelectedIndex());
        }
        return null;
    }

    public int getSelectedItemIndex() {
        MenuPage menuPage = this.getCurrentPage();
        if (menuPage != null) {
            return menuPage.getSelectedIndex();
        }
        return -1;
    }

    public void setSelectedItemIndex(int n) {
        MenuPage menuPage = this.getCurrentPage();
        if (menuPage != null) {
            PageItem pageItem = menuPage.itemAt(menuPage.getSelectedIndex());
            menuPage.setSelectedIndex(n);
            PageItem pageItem2 = menuPage.itemAt(menuPage.getSelectedIndex());
            if (this.m_listener != null) {
                this.m_listener.itemSelected(menuPage, pageItem, pageItem2);
            }
            if (this.m_canvas != null) {
                this.m_canvas.repaint();
            }
        }
    }

    public Canvas getCanvas() {
        return this.m_canvas;
    }

    public void setCanvas(Canvas canvas) {
        this.m_canvas = canvas;
    }

    public MenuListener getListener() {
        return this.m_listener;
    }

    public void setListener(MenuListener menuListener) {
        this.m_listener = menuListener;
    }

    public MenuPainter getPainter() {
        return this.m_painter;
    }

    public void setPainter(MenuPainter menuPainter) {
        this.m_painter = menuPainter;
    }

    public long getFrameDelay() {
        return this.m_frameDelay;
    }

    public int getFrames() {
        return this.m_frames;
    }

    public int getHeight() {
        return this.m_height;
    }

    public MenuPage getStartPage() {
        return this.m_startPage;
    }

    public int getWidth() {
        return this.m_width;
    }

    public int getX() {
        return this.m_x;
    }

    public int getY() {
        return this.m_y;
    }

    public void setLocation(int n, int n2) {
        this.m_x = n;
        this.m_y = n2;
    }

    public void setDimensions(int n, int n2) {
        this.m_width = n;
        this.m_height = n2;
    }

    public void setFrameData(int n, long l) {
        this.m_frames = n;
        this.m_frameDelay = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startTransition(MenuPage menuPage, MenuPage menuPage2, boolean bl) {
        Object object = this.ANIM_LOCK;
        synchronized (object) {
            this.m_curPage = menuPage;
            this.m_transPage = menuPage2;
            if (this.m_inTransition) {
                this.ANIM_LOCK.notifyAll();
            }
            while (this.m_inTransition) {
                try {
                    this.ANIM_LOCK.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.m_transitionBack = bl;
            this.m_inTransition = true;
            this.ANIM_LOCK.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.m_running) {
            Object object = this.ANIM_LOCK;
            synchronized (object) {
                while (!this.m_inTransition) {
                    try {
                        this.ANIM_LOCK.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.m_inTransition = true;
                int n = this.m_frames;
                long l = this.m_frameDelay;
                MenuPage menuPage = this.m_curPage;
                MenuPage menuPage2 = this.m_transPage;
                boolean bl = this.m_transitionBack;
                if (this.m_listener != null) {
                    this.m_listener.transitionStarted(menuPage, menuPage2, l, n, bl);
                }
                while (this.m_frame < n) {
                    try {
                        this.ANIM_LOCK.wait(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.m_canvas != null) {
                        this.m_canvas.repaint();
                    }
                    if (this.m_curPage != menuPage || this.m_transPage != menuPage2) break;
                    ++this.m_frame;
                }
                this.m_frame = 0;
                this.m_curPage = menuPage2;
                if (this.m_canvas != null) {
                    this.m_canvas.repaint();
                }
                this.m_inTransition = false;
                if (this.m_listener != null) {
                    this.m_listener.transitionStopped(menuPage, menuPage2);
                }
                if (this.m_canvas != null) {
                    this.m_canvas.repaint();
                }
                this.ANIM_LOCK.notifyAll();
            }
        }
    }
}

