/*
 * Decompiled with CFR 0.152.
 */
package bluegammon.gui;

import bluegammon.Bluegammon;
import bluegammon.Resources;
import bluegammon.gui.Context3D;
import bluegammon.gui.PopupCanvas;
import bluegammon.gui.SoftButtonControl;
import bluegammon.gui.animation.Animation;
import bluegammon.gui.animation.AnimationEngine;
import bluegammon.gui.animation.CommitMoveAnim;
import bluegammon.gui.animation.CursorAnim;
import bluegammon.gui.animation.DicesNewTurnAnim;
import bluegammon.gui.animation.DicesSelectTurnAnim;
import bluegammon.gui.animation.PieceMoveAnim;
import bluegammon.gui.animation.RepaintRequestable;
import bluegammon.gui.animation.WinnerAnim;
import bluegammon.gui.animation.WinnerPieceMoveAnim;
import bluegammon.logic.Board;
import bluegammon.logic.BoardMediator;
import bluegammon.logic.LocalPlayer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Transform;

public class BoardCanvas
extends PopupCanvas
implements CommandListener,
RepaintRequestable {
    public static final float PIECE_Z = -55.0f;
    protected static BoardCanvas m_inst;
    protected static final int COL_BOARD = 34816;
    protected static final int COL_BOARD_LT = 43520;
    protected static final int COL_BOARD_DK = 26112;
    protected static final int COL_WHITE_DIAG = 0xDDDDDD;
    protected static final int COL_BLACK_DIAG = 0x222222;
    protected static final int COL_WHITE_PIECE = 0xFFFFFF;
    protected static final int COL_BLACK_PIECE = 0;
    protected static final int COL_WHITE_PIECE_DK = 0xBBBBBB;
    protected static final int COL_BLACK_PIECE_DK = 0x444444;
    protected static final int[] COL_BLACK_DICE_VAL;
    protected static final int[] COL_WHITE_DICE_VAL;
    protected static int m_diceValueUnit;
    public static final Command CMD_UNDO;
    public static final Command CMD_EXIT;
    protected Board m_board = new Board();
    protected SoftButtonControl m_softbuttons = new SoftButtonControl();
    protected int m_width;
    protected int m_height;
    protected int m_diagW;
    protected int m_diagH;
    protected int m_triangK;
    protected int m_boardH;
    protected int m_pieceDiameter;
    protected int[][] m_boardRegions = new int[26][4];
    protected int[][][] m_diceValPts = new int[6][][];
    protected Image m_cleanBoardImg;
    protected Image m_pieceBoardImg;
    protected boolean[] m_dirtyRows = new boolean[26];
    protected boolean m_undoOn = false;
    protected AnimationEngine m_animationEngine;
    protected LocalPlayer m_player;
    protected int m_cursor = 0;
    protected CursorAnim m_cursorAnimation;
    protected int[] m_diceValues = new int[2];
    protected int[] m_consumeStatuses = new int[2];
    protected boolean m_allowInteraction = false;
    protected boolean m_queryCommit = false;
    protected Animation m_diceAnimation = null;
    protected boolean m_drawDiceValues = false;
    protected volatile boolean m_repaint = false;
    protected Transform m_transform = new Transform();

    public void setStartPositions() {
        this.m_board.setStartPositions();
        for (int i = 0; i < 26; ++i) {
            this.m_dirtyRows[i] = true;
        }
    }

    public void selectTurns(int n, int n2) {
        this.m_animationEngine.addAnimation(new DicesSelectTurnAnim(n, n2, this.getWidth(), this.getBoardHeight()));
    }

    public void throwDices(boolean bl) {
        if (this.m_diceAnimation != null) {
            this.m_animationEngine.remove(this.m_diceAnimation);
        }
        this.m_diceAnimation = new DicesNewTurnAnim(bl, BoardMediator.getDiceValue(0), BoardMediator.getDiceValue(1));
        this.m_animationEngine.addAnimation(this.m_diceAnimation);
        this.setDiceValues(BoardMediator.getDiceValue(0), BoardMediator.getDiceValue(1));
        this.updateCursor();
    }

    public void movePiece(boolean bl, int n, int n2, int n3, int n4) {
        this.m_animationEngine.addAnimation(new PieceMoveAnim(bl, n, n2, n3, n4));
    }

    public void consumeDiceValue(int n) {
        if (this.m_diceValues[0] == this.m_diceValues[1]) {
            if (this.m_consumeStatuses[0] == 2) {
                this.m_consumeStatuses[1] = this.m_consumeStatuses[1] + 1;
            } else {
                this.m_consumeStatuses[0] = this.m_consumeStatuses[0] + 1;
            }
        } else if (this.m_diceValues[0] == n) {
            this.m_consumeStatuses[0] = 2;
        } else {
            this.m_consumeStatuses[1] = 2;
        }
    }

    public void undoConsumedDiceValue(int n) {
        if (this.m_diceValues[0] == this.m_diceValues[1]) {
            if (this.m_consumeStatuses[1] == 0) {
                this.m_consumeStatuses[0] = this.m_consumeStatuses[0] - 1;
            } else {
                this.m_consumeStatuses[1] = this.m_consumeStatuses[1] - 1;
            }
        } else if (this.m_diceValues[0] == n) {
            this.m_consumeStatuses[0] = 0;
        } else {
            this.m_consumeStatuses[1] = 0;
        }
    }

    public void setQueryCommit(boolean bl) {
        this.m_queryCommit = bl;
        if (bl) {
            this.m_cursor = -1;
            this.m_animationEngine.addAnimation(new CommitMoveAnim(!BoardMediator.isCurrentPlayerWhite()));
        } else {
            this.m_cursor = 0;
            this.updateUndoCommand();
        }
    }

    public void finishGame(boolean bl, int n, int n2) {
        this.m_animationEngine.addAnimation(new WinnerAnim(bl, n, n2));
    }

    public void invalidate() {
        this.m_pieceBoardImg.getGraphics().drawImage(this.getBoardImage(), 0, 0, 20);
        for (int i = 0; i < 26; ++i) {
            this.m_dirtyRows[i] = true;
        }
        this.drawBoard(null);
        if (this.m_cursorAnimation != null) {
            this.m_cursorAnimation.stop();
        }
        this.m_cursorAnimation = null;
        this.m_diceAnimation = null;
        this.m_animationEngine.removeAll();
        this.updateUndoCommand();
        if (BoardMediator.countPossibleMoves() > 0) {
            this.cursorNearestIndex(0, 0);
        } else {
            this.m_cursor = -1;
        }
        this.updateCursor();
    }

    public void shutdown() {
        m_inst = null;
        this.m_animationEngine.shutdown();
    }

    public void setCurrentLocalPlayer(LocalPlayer localPlayer) {
        this.m_player = localPlayer;
        this.updateCursor();
    }

    public void addPiece(boolean bl, int n) {
        this.m_board.addPiece(bl, n);
        this.m_dirtyRows[n] = true;
        this.requestRepaint();
    }

    public void removePiece(boolean bl, int n) {
        this.m_board.removePiece(bl, n);
        this.m_dirtyRows[n] = true;
        this.requestRepaint();
    }

    public void setPieces(boolean bl, int n, int n2) {
        this.m_board.setPieces(bl, n, n2);
        this.m_dirtyRows[n] = true;
        this.requestRepaint();
    }

    public int getPieces(int n) {
        return this.m_board.countPieces(n);
    }

    public int getPieces(boolean bl, int n) {
        return this.m_board.countPieces(bl, n);
    }

    public boolean isWhite(int n) {
        return this.m_board.isWhite(n);
    }

    public boolean isUserMovable() {
        return this.m_allowInteraction && !BoardMediator.isRemoteTurn();
    }

    public int getCurrentCursorIndex() {
        return this.m_cursor;
    }

    public boolean waitingForCommit() {
        return this.m_queryCommit;
    }

    public void updateCursor() {
        if (this.m_cursorAnimation != null) {
            this.m_cursorAnimation.stop();
            this.m_cursorAnimation = null;
        }
        if (this.m_cursor >= 0 && BoardMediator.countPossibleMoves() > 0 && this.isUserMovable()) {
            int n = BoardMediator.getPossibleMoves()[this.m_cursor][0];
            int n2 = BoardMediator.getPossibleMoves()[this.m_cursor][1];
            this.m_cursorAnimation = new CursorAnim(n, n2, BoardMediator.countStatePieces(n), BoardMediator.countStatePieces(n2), BoardMediator.isCurrentPlayerWhite());
            this.m_animationEngine.addAnimation(this.m_cursorAnimation);
        }
    }

    public void updateUndoCommand() {
        if (!BoardMediator.isGameFinished() && !this.m_undoOn && BoardMediator.countUndoableMoves() > 0) {
            this.m_undoOn = true;
        } else if (BoardMediator.isGameFinished() || this.m_undoOn && BoardMediator.countUndoableMoves() == 0) {
            this.m_undoOn = false;
        }
        this.m_softbuttons.enable(CMD_UNDO, this.m_undoOn);
    }

    public void allowInteraction(boolean bl) {
        this.m_allowInteraction = bl;
    }

    public void setDiceValues(int n, int n2) {
        this.m_diceValues[0] = n;
        this.m_diceValues[1] = n2;
        this.m_consumeStatuses[0] = 0;
        this.m_consumeStatuses[1] = 0;
    }

    public void setDrawDiceValues(boolean bl) {
        this.m_drawDiceValues = bl;
        this.repaint();
    }

    protected void keyPressed(int n) {
        try {
            this.m_softbuttons.keyPressed(n);
            if (this.m_popup != null && this.m_popup.isActive()) {
                this.getPopup().keyPressed(n, this.getGameAction(n));
                this.repaint();
                return;
            }
            boolean bl = false;
            int n2 = this.getGameAction(n);
            if (this.m_player != null) {
                bl = this.m_player.keyPressed(n, n2);
            }
            if (n == 35 && Bluegammon.getGameType() != Bluegammon.GAME_TYPE_LOCAL) {
                LocalPlayer localPlayer = BoardMediator.getLocalPlayer();
                Bluegammon.getStringInput(Resources.getString(Resources.TXT_MESSAGE) + " " + new String(BoardMediator.getOpponentPlayer().getName()), null, 1024, 0, localPlayer);
            }
            this.repaint();
        }
        catch (Throwable throwable) {
            System.err.println("Error in board interaction thread");
            throwable.printStackTrace();
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        boolean bl = false;
        if (!BoardMediator.isRemoteTurn()) {
            bl = BoardMediator.getLocalPlayer().commandAction(command);
        }
        if (!bl && command == CMD_EXIT) {
            bl = BoardMediator.getLocalPlayer().commandAction(command);
        }
        this.repaint();
    }

    public void cursorNearestIndex(int n, int n2) {
        int[][] nArray = BoardMediator.getPossibleMoves();
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MAX_VALUE;
        int n5 = -1;
        for (int i = 0; i < BoardMediator.countPossibleMoves(); ++i) {
            int n6 = Math.abs(nArray[i][0] - n);
            if (n6 > n3) continue;
            int n7 = Math.abs(nArray[i][0] - n2);
            if (n3 == n6) {
                if (n7 >= n4) continue;
                n3 = n6;
                n4 = n7;
                n5 = i;
                continue;
            }
            n3 = n6;
            n4 = n7;
            n5 = i;
        }
        this.m_cursor = n5;
    }

    public void cursorSwapSide() {
        if (this.m_cursor < 0) {
            return;
        }
        int[][] nArray = BoardMediator.getPossibleMoves();
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = this.m_cursor;
        int n4 = 23 - nArray[this.m_cursor][0];
        int n5 = 23 - nArray[this.m_cursor][1];
        for (int i = 0; i < BoardMediator.countPossibleMoves(); ++i) {
            int n6;
            if ((n4 < 12 && nArray[i][0] > 11 || n4 > 11 && nArray[i][0] < 12) && (n5 < 12 && nArray[i][1] > 11 || n5 > 11 && nArray[i][1] < 12) || (n6 = Math.abs(nArray[i][0] - n4)) > n) continue;
            int n7 = Math.abs(nArray[i][0] - n5);
            if (n == n6) {
                if (n7 >= n2) continue;
                n = n6;
                n2 = n7;
                n3 = i;
                continue;
            }
            n = n6;
            n2 = n7;
            n3 = i;
        }
        this.m_cursor = n3;
    }

    public void cursorNextIndex() {
        this.m_cursor = BoardMediator.countPossibleMoves() > 0 ? (this.m_cursor + 1) % BoardMediator.countPossibleMoves() : -1;
    }

    public void cursorBackIndex() {
        int n = this.m_cursor - 1;
        if (n < 0) {
            n = BoardMediator.countPossibleMoves() - 1;
        }
        this.m_cursor = n;
    }

    public boolean isCursorValid() {
        return this.m_cursor >= 0;
    }

    protected void paint(Graphics graphics) {
        try {
            graphics.setColor(26112);
            graphics.fillRect(0, this.m_boardH, this.m_width, this.m_height - this.m_boardH);
            this.drawBoard(graphics);
            if (!BoardMediator.isGameFinished() && this.m_drawDiceValues) {
                this.drawDiceValues(graphics, BoardMediator.isCurrentPlayerWhite(), this.m_diceValues, this.m_consumeStatuses);
            }
            this.m_animationEngine.paint(graphics);
            this.m_softbuttons.paint(graphics);
            if (this.m_popup != null && this.m_popup.isActive()) {
                this.m_popup.paint(graphics);
            }
        }
        catch (Throwable throwable) {
            System.err.println("Error in board paint thread");
            throwable.printStackTrace();
        }
    }

    public int getBoardHeight() {
        return this.m_boardH;
    }

    public void addWinningPieceAnimation(boolean bl, WinnerAnim winnerAnim) {
        int n;
        int n2 = -1;
        if (this.getPieces(bl, 25) > 0) {
            n2 = 25;
        } else {
            for (n = 0; n2 == -1 && n <= 23; ++n) {
                if (this.getPieces(bl, n) <= 0) continue;
                n2 = n;
            }
        }
        if (n2 >= 0) {
            n = n2 > 11 ? 0 : this.getWidth();
            this.m_animationEngine.addAnimation(new WinnerPieceMoveAnim(winnerAnim, bl, n2, n, this.getHeight() / 2, this.getPieces(bl, n2) - 1));
        }
    }

    protected void drawBoard(Graphics graphics) {
        Graphics graphics2 = this.m_pieceBoardImg.getGraphics();
        for (int i = 0; i < 26; ++i) {
            if (!this.m_dirtyRows[i]) continue;
            graphics2.setClip(this.m_boardRegions[i][0], this.m_boardRegions[i][1], this.m_boardRegions[i][2], this.m_boardRegions[i][3]);
            graphics2.drawImage(this.m_cleanBoardImg, 0, 0, 20);
            graphics2.setClip(0, 0, this.m_width, this.m_height);
            this.drawPieces(graphics2, i);
        }
        if (graphics != null) {
            graphics.drawImage(this.m_pieceBoardImg, 0, 0, 20);
        }
    }

    protected void drawDiceValues(Graphics graphics, boolean bl, int[] nArray, int[] nArray2) {
        int n = 2 * (m_diceValueUnit * 8) - m_diceValueUnit;
        int n2 = (this.m_width - n) / 2;
        int n3 = this.m_boardH - m_diceValueUnit * 7 - 1;
        for (int i = 0; i < 2; ++i) {
            this.drawDiceValue(graphics, bl, nArray[i], nArray2[i], n2, n3);
            n2 += m_diceValueUnit * 8;
        }
    }

    protected void drawDiceValue(Graphics graphics, boolean bl, int n, int n2, int n3, int n4) {
        int[] nArray = COL_WHITE_DICE_VAL;
        int[] nArray2 = COL_BLACK_DICE_VAL;
        if (!bl) {
            nArray = COL_BLACK_DICE_VAL;
            nArray2 = COL_WHITE_DICE_VAL;
        }
        int n5 = nArray[n2];
        int n6 = nArray[3];
        int n7 = nArray2[n2];
        graphics.setColor(n6);
        graphics.fillRect(n3 + 1, n4 + 1, m_diceValueUnit * 7, m_diceValueUnit * 7);
        graphics.setColor(n5);
        graphics.fillRect(n3, n4, m_diceValueUnit * 7, m_diceValueUnit * 7);
        graphics.setColor(n7);
        int[][] nArray3 = this.m_diceValPts[n - 1];
        for (int i = 0; i < nArray3.length; ++i) {
            graphics.fillRect(n3 + nArray3[i][0], n4 + nArray3[i][1], m_diceValueUnit, m_diceValueUnit);
        }
    }

    public synchronized Image getBoardImage() {
        if (this.m_cleanBoardImg == null) {
            this.m_cleanBoardImg = Image.createImage((int)this.m_width, (int)this.m_boardH);
            Graphics graphics = this.m_cleanBoardImg.getGraphics();
            graphics.setColor(34816);
            graphics.fillRect(0, 0, this.m_width, this.m_boardH);
            int n = 0;
            int n2 = 0;
            int n3 = 0xDDDDDD;
            int n4 = 0x222222;
            block3: for (int i = 0; i < this.m_height - this.m_diagH; i += this.m_diagH) {
                switch (++n) {
                    case 1: 
                    case 8: 
                    case 15: {
                        graphics.setColor(43520);
                        graphics.drawLine(0, ++i, this.m_width - 1, i);
                        graphics.drawLine(0, i, 0, i + this.m_diagH);
                        graphics.setColor(26112);
                        graphics.drawLine(0, i + this.m_diagH, this.m_width - 1, i + this.m_diagH);
                        graphics.drawLine(this.m_width - 1, i, this.m_width - 1, i + this.m_diagH);
                        ++i;
                        continue block3;
                    }
                    default: {
                        int n5;
                        this.m_boardRegions[n2][0] = 0;
                        this.m_boardRegions[n2][1] = i;
                        this.m_boardRegions[n2][2] = this.m_width / 2;
                        this.m_boardRegions[n2][3] = this.m_diagH;
                        this.m_boardRegions[23 - n2][0] = this.m_width / 2 + 1;
                        this.m_boardRegions[23 - n2][1] = i;
                        this.m_boardRegions[23 - n2][2] = this.m_width / 2;
                        this.m_boardRegions[23 - n2][3] = this.m_diagH;
                        ++n2;
                        int n6 = n3;
                        n3 = n4;
                        n4 = n6;
                        int n7 = 0;
                        int n8 = 2 * this.m_triangK / 2;
                        for (n5 = i; n5 < i + this.m_diagH / 2; ++n5) {
                            this.drawAntialiasedLine(0, n7, n5, n3, 34816, graphics, n8);
                            this.drawAntialiasedLine(this.m_width, this.m_width - n7, n5, n4, 34816, graphics, n8);
                            n7 += n8;
                        }
                        for (n5 = i + this.m_diagH / 2; n5 < i + this.m_diagH; ++n5) {
                            this.drawAntialiasedLine(this.m_width, this.m_width - n7, n5, n4, 34816, graphics, n8);
                            this.drawAntialiasedLine(0, n7, n5, n3, 34816, graphics, n8);
                            n7 -= n8;
                        }
                    }
                }
            }
            this.m_boardRegions[24][0] = 0;
            this.m_boardRegions[24][1] = 0;
            this.m_boardRegions[24][2] = this.m_width;
            this.m_boardRegions[24][3] = this.m_boardRegions[0][1] - 1;
            this.m_boardRegions[25][0] = 0;
            this.m_boardRegions[25][1] = this.m_boardRegions[5][1] + this.m_boardRegions[5][3];
            this.m_boardRegions[25][2] = this.m_width;
            this.m_boardRegions[25][3] = this.m_boardRegions[6][1] - this.m_boardRegions[5][1] - this.m_boardRegions[5][3] - 1;
        }
        return this.m_cleanBoardImg;
    }

    protected void drawPieces(Graphics graphics, int n) {
        Context3D context3D = Context3D.getInstance();
        Graphics3D graphics3D = context3D.bindScene(graphics);
        if (n <= 23) {
            for (int i = 0; i < this.getPieces(n); ++i) {
                this.drawPiece3D(this.getPieceX(n, i, this.isWhite(n)), this.getPieceY(n, i, this.isWhite(n)), 0.0f, false, 0.0f, this.isWhite(n), context3D, graphics3D);
            }
        } else if (n == 25) {
            int n2;
            for (n2 = 0; n2 < this.getPieces(true, 25); ++n2) {
                this.drawPiece3D(this.getPieceX(25, n2, true), this.getPieceY(25, n2, true), 0.0f, false, 0.0f, true, context3D, graphics3D);
            }
            for (n2 = 0; n2 < this.getPieces(false, 25); ++n2) {
                this.drawPiece3D(this.getPieceX(25, n2, false), this.getPieceY(25, n2, false), 0.0f, false, 0.0f, false, context3D, graphics3D);
            }
        } else if (n == 24) {
            int n3;
            for (n3 = 0; n3 < this.getPieces(true, 24); ++n3) {
                this.drawPiece3D(this.getPieceX(24, n3, true), this.getPieceY(24, n3, true), -60.0f, false, 0.0f, true, context3D, graphics3D);
            }
            for (n3 = 0; n3 < this.getPieces(false, 24); ++n3) {
                this.drawPiece3D(this.getPieceX(24, n3, false), this.getPieceY(24, n3, false), 60.0f, false, 0.0f, false, context3D, graphics3D);
            }
        }
        this.m_dirtyRows[n] = false;
        graphics3D.releaseTarget();
    }

    public int getPieceX(int n, int n2, boolean bl) {
        int n3 = 0;
        if (n == 25) {
            n3 = bl ? this.m_width / 2 + 1 * this.m_pieceDiameter / 2 + 1 : this.m_width / 2 - 3 * this.m_pieceDiameter / 2 - 1;
            n3 -= 2 * n2;
        } else if (n == 24) {
            n3 = bl ? this.m_width - this.m_pieceDiameter - 1 - n2 * 2 : 1 + n2 * 2;
        } else {
            n3 = n < 12 ? 0 : this.m_width - this.m_pieceDiameter - 1;
            int n4 = Math.min(n2, 4) * (this.m_diagH + 1);
            n3 = n <= 11 ? (n3 += n4) : (n3 -= (n4 += (n2 - Math.min(n2, 4)) * 2));
        }
        return n3;
    }

    public int getPieceY(int n, int n2, boolean bl) {
        int n3 = 0;
        n3 = n == 25 ? 2 + 7 * this.m_diagH : (n == 24 ? 1 : (n < 6 ? 2 + (n + 1) * this.m_diagH : (n < 12 ? 4 + (n + 2) * this.m_diagH : (n < 18 ? this.m_boardH - 2 - (n - 10) * this.m_diagH : this.m_boardH - 4 - (n - 9) * this.m_diagH))));
        return n3;
    }

    public void drawPiece(int n, int n2, float f, boolean bl, float f2, boolean bl2, Graphics graphics) {
        Context3D context3D = Context3D.getInstance();
        Graphics3D graphics3D = context3D.bindScene(graphics);
        this.drawPiece3D(n, n2, f, bl, f2, bl2, context3D, graphics3D);
        graphics3D.releaseTarget();
    }

    public void drawPiece3D(int n, int n2, float f, boolean bl, float f2, boolean bl2, Context3D context3D, Graphics3D graphics3D) {
        float f3 = -55.0f + f2;
        int n3 = (int)(context3D.toScreenCoordinateX(2.0f, f3) + 0.5f);
        this.m_transform.setIdentity();
        this.m_transform.postTranslate(context3D.to3DCoordinateX(n += n3 / 2, f3 - f2), context3D.to3DCoordinateY((n2 += n3 / 2) + 1, f3 - f2), f3);
        if (bl) {
            this.m_transform.postRotate(f, 1.0f, 0.0f, 0.0f);
        } else {
            this.m_transform.postRotate(f, 0.0f, 1.0f, 0.0f);
        }
        graphics3D.render(context3D.getPieceVertexBuffer(), context3D.getPieceIndexBuffer(), context3D.getPieceAppearance(bl2), this.m_transform);
    }

    protected void drawAntialiasedLine(int n, int n2, int n3, int n4, int n5, Graphics graphics, int n6) {
        if (n == n2) {
            return;
        }
        graphics.setColor(n4);
        if (n > n2) {
            n6 = -n6;
        }
        int n7 = n2 - n6 << 8;
        int n8 = n6 << 8 >> 3;
        graphics.drawLine(n, n3, n7 >> 8, n3);
        for (int i = 0; i < 8; ++i) {
            int n9 = this.blendColors(n4, n5, i);
            graphics.setColor(n9);
            graphics.drawLine(n7 >> 8, n3, n7 + n8 >> 8, n3);
            n7 += n8;
        }
    }

    protected int blendColors(int n, int n2, int n3) {
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > 8) {
            n3 = 8;
        }
        int n4 = 8 - n3;
        return (n3 * (n2 & 0xFF0000) >>> 3 & 0xFF0000) + (n4 * (n & 0xFF0000) >>> 3 & 0xFF0000) | (n3 * (n2 & 0xFF00) >>> 3 & 0xFF00) + (n4 * (n & 0xFF00) >>> 3 & 0xFF00) | (n3 * (n2 & 0xFF) >>> 3 & 0xFF) + (n4 * (n & 0xFF) >>> 3 & 0xFF);
    }

    public void requestRepaint() {
        this.m_repaint = true;
    }

    public void commitRepaint() {
        if (this.m_repaint) {
            this.repaint();
            this.m_repaint = false;
        }
    }

    public int saveCanvas(DataOutputStream dataOutputStream) throws IOException {
        int n = 0;
        dataOutputStream.writeBoolean(this.m_queryCommit);
        ++n;
        dataOutputStream.writeBoolean(this.m_undoOn);
        ++n;
        dataOutputStream.writeInt(this.m_diceValues[0]);
        n += 4;
        dataOutputStream.writeInt(this.m_diceValues[1]);
        n += 4;
        dataOutputStream.writeInt(this.m_consumeStatuses[0]);
        n += 4;
        dataOutputStream.writeInt(this.m_consumeStatuses[1]);
        return n += 4;
    }

    public int loadCanvas(DataInputStream dataInputStream) throws IOException {
        int n = 0;
        this.m_queryCommit = dataInputStream.readBoolean();
        ++n;
        this.m_undoOn = dataInputStream.readBoolean();
        ++n;
        this.m_diceValues[0] = dataInputStream.readInt();
        n += 4;
        this.m_diceValues[1] = dataInputStream.readInt();
        n += 4;
        this.m_consumeStatuses[0] = dataInputStream.readInt();
        n += 4;
        this.m_consumeStatuses[1] = dataInputStream.readInt();
        n += 4;
        this.m_animationEngine.removeAll();
        this.allowInteraction(true);
        this.setDrawDiceValues(true);
        this.setQueryCommit(this.m_queryCommit);
        this.updateUndoCommand();
        return n;
    }

    protected BoardCanvas() {
        this.setFullScreenMode(true);
        this.m_width = this.getWidth();
        this.m_height = this.getHeight();
        this.m_diagW = 3 * this.m_width / 8;
        this.m_diagH = (this.m_height - 6) / 15;
        this.m_triangK = 2 * this.m_diagW / this.m_diagH;
        this.m_boardH = this.m_diagH * 15 + 6;
        this.m_pieceDiameter = this.m_diagH - 2;
        m_diceValueUnit = 1 + this.m_pieceDiameter / 7;
        block8: for (int i = 0; i < 6; ++i) {
            this.m_diceValPts[i] = new int[i + 1][2];
            switch (i) {
                case 0: {
                    this.m_diceValPts[0][0][0] = 3 * m_diceValueUnit;
                    this.m_diceValPts[0][0][1] = 3 * m_diceValueUnit;
                    continue block8;
                }
                case 1: {
                    this.m_diceValPts[1][0][0] = 1 * m_diceValueUnit;
                    this.m_diceValPts[1][0][1] = 1 * m_diceValueUnit;
                    this.m_diceValPts[1][1][0] = 5 * m_diceValueUnit;
                    this.m_diceValPts[1][1][1] = 5 * m_diceValueUnit;
                    continue block8;
                }
                case 2: {
                    this.m_diceValPts[2][0][0] = 5 * m_diceValueUnit;
                    this.m_diceValPts[2][0][1] = 1 * m_diceValueUnit;
                    this.m_diceValPts[2][1][0] = 3 * m_diceValueUnit;
                    this.m_diceValPts[2][1][1] = 3 * m_diceValueUnit;
                    this.m_diceValPts[2][2][0] = 1 * m_diceValueUnit;
                    this.m_diceValPts[2][2][1] = 5 * m_diceValueUnit;
                    continue block8;
                }
                case 3: {
                    this.m_diceValPts[3][0][0] = 1 * m_diceValueUnit;
                    this.m_diceValPts[3][0][1] = 1 * m_diceValueUnit;
                    this.m_diceValPts[3][1][0] = 5 * m_diceValueUnit;
                    this.m_diceValPts[3][1][1] = 1 * m_diceValueUnit;
                    this.m_diceValPts[3][2][0] = 1 * m_diceValueUnit;
                    this.m_diceValPts[3][2][1] = 5 * m_diceValueUnit;
                    this.m_diceValPts[3][3][0] = 5 * m_diceValueUnit;
                    this.m_diceValPts[3][3][1] = 5 * m_diceValueUnit;
                    continue block8;
                }
                case 4: {
                    this.m_diceValPts[4][0][0] = 1 * m_diceValueUnit;
                    this.m_diceValPts[4][0][1] = 1 * m_diceValueUnit;
                    this.m_diceValPts[4][1][0] = 5 * m_diceValueUnit;
                    this.m_diceValPts[4][1][1] = 1 * m_diceValueUnit;
                    this.m_diceValPts[4][2][0] = 1 * m_diceValueUnit;
                    this.m_diceValPts[4][2][1] = 5 * m_diceValueUnit;
                    this.m_diceValPts[4][3][0] = 5 * m_diceValueUnit;
                    this.m_diceValPts[4][3][1] = 5 * m_diceValueUnit;
                    this.m_diceValPts[4][4][0] = 3 * m_diceValueUnit;
                    this.m_diceValPts[4][4][1] = 3 * m_diceValueUnit;
                    continue block8;
                }
                case 5: {
                    this.m_diceValPts[5][0][0] = 1 * m_diceValueUnit;
                    this.m_diceValPts[5][0][1] = 1 * m_diceValueUnit;
                    this.m_diceValPts[5][1][0] = 1 * m_diceValueUnit;
                    this.m_diceValPts[5][1][1] = 3 * m_diceValueUnit;
                    this.m_diceValPts[5][2][0] = 1 * m_diceValueUnit;
                    this.m_diceValPts[5][2][1] = 5 * m_diceValueUnit;
                    this.m_diceValPts[5][3][0] = 5 * m_diceValueUnit;
                    this.m_diceValPts[5][3][1] = 1 * m_diceValueUnit;
                    this.m_diceValPts[5][4][0] = 5 * m_diceValueUnit;
                    this.m_diceValPts[5][4][1] = 3 * m_diceValueUnit;
                    this.m_diceValPts[5][5][0] = 5 * m_diceValueUnit;
                    this.m_diceValPts[5][5][1] = 5 * m_diceValueUnit;
                }
            }
        }
        Context3D.getInstance().init(this.getWidth(), this.getHeight());
        CursorAnim.init(this.m_pieceDiameter);
        PieceMoveAnim.init(this.m_pieceDiameter);
        DicesNewTurnAnim.init(m_diceValueUnit);
        this.m_animationEngine = new AnimationEngine(this);
        new Thread((Runnable)this.m_animationEngine, "AnimationThread").start();
        this.m_pieceBoardImg = Image.createImage((int)this.m_width, (int)this.m_boardH);
        this.m_softbuttons.init((Displayable)this, Font.getFont((int)32, (int)1, (int)8), CMD_UNDO, CMD_EXIT);
        this.m_softbuttons.setCommandListener(this);
    }

    public static BoardCanvas getInstance() {
        if (m_inst == null) {
            m_inst = new BoardCanvas();
            m_inst.setFullScreenMode(true);
        }
        return m_inst;
    }

    static {
        COL_BLACK_DICE_VAL = new int[]{0, 0x333333, 0x666666, 0};
        COL_WHITE_DICE_VAL = new int[]{0xFFFFFF, 0xCCCCCC, 0x999999, 0x666666};
        m_diceValueUnit = 1;
        CMD_UNDO = new Command(Resources.getString(Resources.TXT_C_UNDO), 3, 1);
        CMD_EXIT = new Command(Resources.getString(Resources.TXT_C_QUIT), 2, 1);
    }
}

