/*
 * Decompiled with CFR 0.152.
 */
package bluegammon.gui;

import bluegammon.Resources;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Light;
import javax.microedition.m3g.Material;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;

public class Context3D {
    public static final float FOVY = 35.0f;
    public static final float NEAR_CLIPPING_PLANE = 1.0f;
    public static final float FAR_CLIPPING_PLANE = 512.0f;
    protected Camera m_camera;
    protected Transform m_cameraTransform;
    protected Light m_light;
    protected Transform m_lightTransform;
    protected Appearance[] m_appearances = new Appearance[2];
    protected Texture2D[] m_textures = new Texture2D[2];
    protected VertexBuffer m_diceVertBuffer;
    protected IndexBuffer m_diceIndexBuffer;
    protected VertexBuffer m_pieceVertBuffer;
    protected IndexBuffer m_pieceIndexBuffer;
    protected double m_scr2ThreeD;
    protected double m_threeD2Scr;
    protected int m_width;
    protected int m_height;
    protected int m_halfWidth;
    protected int m_halfHeight;
    protected static Context3D m_inst = null;
    protected static final float LIGHT_ROT = 33.0f;
    protected static final double TAN_LIGHT_ROT = Math.tan(Math.toRadians(33.0));
    protected static final int PIECE_SLICES = 10;
    protected static final short UNITY = 4095;

    public static Context3D getInstance() {
        if (m_inst == null) {
            m_inst = new Context3D();
        }
        return m_inst;
    }

    public void init(int n, int n2) {
        this.m_width = n;
        this.m_height = n2;
        this.m_halfWidth = n / 2 - 1;
        this.m_halfHeight = n2 / 2 - 1;
        this.m_camera = new Camera();
        this.m_camera.setPerspective(35.0f, (float)n / (float)n2, 1.0f, 512.0f);
        this.m_cameraTransform = new Transform();
        this.m_cameraTransform.setIdentity();
        this.m_cameraTransform.postTranslate(0.0f, 0.0f, 1.0f);
        this.m_light = new Light();
        this.m_light.setColor(0xFFFFFF);
        this.m_light.setIntensity(1.1f);
        this.m_light.setMode(129);
        this.m_lightTransform = new Transform();
        this.m_lightTransform.setIdentity();
        this.m_lightTransform.postTranslate(0.0f, 0.0f, 10.0f);
        this.m_lightTransform.postRotate(33.0f, 0.0f, 1.0f, 0.0f);
        double d = 2.15;
        double d2 = Math.tan(Math.toRadians(35.0));
        this.m_threeD2Scr = d * (double)n2 / (2.0 * d2);
        this.m_scr2ThreeD = 2.0 * d2 / (d * (double)n2);
    }

    public float toScreenCoordinateX(float f, float f2) {
        return (float)((double)(-f) * this.m_threeD2Scr / (double)f2);
    }

    public float to3DCoordinateX(float f, float f2) {
        return (float)((double)(-f + (float)this.m_halfWidth) * this.m_scr2ThreeD * (double)f2);
    }

    public float toScreenCoordinateY(float f, float f2) {
        return (float)((double)f * this.m_threeD2Scr / (double)f2);
    }

    public float to3DCoordinateY(float f, float f2) {
        return (float)((double)(f - (float)this.m_halfHeight) * this.m_scr2ThreeD * (double)f2);
    }

    public float getShadowProjectionDeltaX(float f) {
        if (f == 0.0f) {
            return 0.0f;
        }
        return (float)((double)Math.abs(f) * TAN_LIGHT_ROT);
    }

    public Graphics3D bindScene(Graphics graphics) {
        Graphics3D graphics3D = Graphics3D.getInstance();
        graphics3D.bindTarget((Object)graphics, false, 12);
        graphics3D.setCamera(this.m_camera, this.m_cameraTransform);
        graphics3D.resetLights();
        graphics3D.addLight(this.m_light, this.m_lightTransform);
        return graphics3D;
    }

    public static int[] createShadowRGB(int n, int n2) {
        int n3;
        int[] nArray = new int[n * n];
        Image image = Image.createImage((int)n, (int)n);
        Graphics graphics = image.getGraphics();
        graphics.setColor(0xFF0000);
        graphics.fillRect(0, 0, n * 2, n * 2);
        for (n3 = 0; n3 < 4; ++n3) {
            graphics.setColor(n3 + 1 << 4);
            graphics.fillArc(n3 + n2, n3 + n2, n - 2 * (n3 + n2), n - 2 * (n3 + n2), 0, 360);
        }
        image.getRGB(nArray, 0, n, 0, 0, n, n);
        for (n3 = 0; n3 < nArray.length; ++n3) {
            int n4;
            nArray[n3] = (nArray[n3] & 0xFFFFFF) == 0xFF0000 ? 0 : (n4 = (nArray[n3] & 0xFF) << 56 & 0xFF000000);
        }
        return nArray;
    }

    public Appearance getPieceAppearance(boolean bl) {
        return this.getDiceAppearance(bl);
    }

    public Appearance getDiceAppearance(boolean bl) {
        int n;
        int n2 = n = bl ? 0 : 1;
        if (this.m_appearances[n] == null) {
            Material material = new Material();
            material.setColor(1024, 0x606060);
            material.setColor(2048, 15788256);
            material.setColor(8192, 0xFFFFFF);
            material.setShininess(50.0f);
            this.m_appearances[n] = new Appearance();
            this.m_appearances[n].setTexture(0, this.getTexture(bl));
            this.m_appearances[n].setMaterial(material);
        }
        return this.m_appearances[n];
    }

    public Texture2D getTexture(boolean bl) {
        int n;
        int n2 = n = bl ? 0 : 1;
        if (this.m_textures[n] == null) {
            Image2D image2D = null;
            image2D = bl ? new Image2D(99, (Object)Resources.getImage(101)) : new Image2D(99, (Object)Resources.getImage(102));
            this.m_textures[n] = new Texture2D(image2D);
            this.m_textures[n].setFiltering(209, 209);
            this.m_textures[n].setWrapping(240, 240);
            this.m_textures[n].setBlending(227);
        }
        return this.m_textures[n];
    }

    public VertexBuffer getPieceVertexBuffer() {
        if (this.m_pieceVertBuffer == null) {
            this.calculatePieceBuffers();
        }
        return this.m_pieceVertBuffer;
    }

    public IndexBuffer getPieceIndexBuffer() {
        if (this.m_pieceIndexBuffer == null) {
            this.calculatePieceBuffers();
        }
        return this.m_pieceIndexBuffer;
    }

    public VertexBuffer getDiceVertexBuffer() {
        if (this.m_diceVertBuffer == null) {
            this.calculateDiceBuffers();
        }
        return this.m_diceVertBuffer;
    }

    public IndexBuffer getDiceIndexBuffer() {
        if (this.m_diceIndexBuffer == null) {
            this.calculateDiceBuffers();
        }
        return this.m_diceIndexBuffer;
    }

    protected void calculatePieceBuffers() {
        int n;
        int n2;
        short s;
        short s2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = 10;
        int n11 = 4095;
        short s3 = (short)(n11 / 8);
        short s4 = -s3;
        short[] sArray = new short[n10 * 3 * 10];
        double d = Math.PI * 2 / (double)n10 / 2.0;
        for (int i = 0; i < n10; ++i) {
            int n12 = i * 3 * 3;
            n9 = i * 3 * 3 + n10 * 3 * 3;
            n8 = i * 3 * 4 + 2 * (n10 * 3 * 3);
            n7 = (int)((double)n11 * Math.sin(d));
            n6 = (int)((double)n11 * Math.cos(d));
            n5 = (int)((double)n11 * Math.sin(d += Math.PI * 2 / (double)n10));
            n4 = (int)((double)n11 * Math.cos(d));
            sArray[n12++] = 0;
            sArray[n12++] = 0;
            sArray[n12++] = s3;
            sArray[n12++] = n6;
            sArray[n12++] = n7;
            sArray[n12++] = s3;
            sArray[n12++] = n4;
            sArray[n12++] = n5;
            sArray[n12++] = s3;
            sArray[n9++] = 0;
            sArray[n9++] = 0;
            sArray[n9++] = s4;
            sArray[n9++] = n4;
            sArray[n9++] = n5;
            sArray[n9++] = s4;
            sArray[n9++] = n6;
            sArray[n9++] = n7;
            sArray[n9++] = s4;
            sArray[n8++] = n6;
            sArray[n8++] = n7;
            sArray[n8++] = s3;
            sArray[n8++] = n6;
            sArray[n8++] = n7;
            sArray[n8++] = s4;
            sArray[n8++] = n4;
            sArray[n8++] = n5;
            sArray[n8++] = s3;
            sArray[n8++] = n4;
            sArray[n8++] = n5;
            sArray[n8++] = s4;
        }
        VertexArray vertexArray = new VertexArray(sArray.length / 3, 3, 2);
        vertexArray.set(0, sArray.length / 3, sArray);
        byte[] byArray = new byte[n10 * 3 * 10];
        d = Math.PI * 2 / (double)n10 / 2.0;
        for (n9 = 0; n9 < n10; ++n9) {
            n8 = n9 * 3 * 3;
            n7 = n9 * 3 * 3 + n10 * 3 * 3;
            n6 = n9 * 3 * 4 + 2 * (n10 * 3 * 3);
            n5 = (byte)(127.0 * Math.sin(d));
            n4 = (byte)(127.0 * Math.cos(d));
            n3 = (int)(127.0 * Math.sin(d += Math.PI * 2 / (double)n10));
            s2 = (short)(127.0 * Math.cos(d));
            byArray[n8++] = 0;
            byArray[n8++] = 0;
            byArray[n8++] = 127;
            byArray[n8++] = 0;
            byArray[n8++] = 0;
            byArray[n8++] = 127;
            byArray[n8++] = 0;
            byArray[n8++] = 0;
            byArray[n8++] = 127;
            byArray[n7++] = 0;
            byArray[n7++] = 0;
            byArray[n7++] = -127;
            byArray[n7++] = 0;
            byArray[n7++] = 0;
            byArray[n7++] = -127;
            byArray[n7++] = 0;
            byArray[n7++] = 0;
            byArray[n7++] = -127;
            byArray[n6++] = n4;
            byArray[n6++] = n5;
            byArray[n6++] = 0;
            byArray[n6++] = n4;
            byArray[n6++] = n5;
            byArray[n6++] = 0;
            byArray[n6++] = s2;
            byArray[n6++] = n3;
            byArray[n6++] = 0;
            byArray[n6++] = s2;
            byArray[n6++] = n3;
            byArray[n6++] = 0;
        }
        VertexArray vertexArray2 = new VertexArray(byArray.length / 3, 3, 1);
        vertexArray2.set(0, byArray.length / 3, byArray);
        short[] sArray2 = new short[n10 * 2 * 10];
        d = Math.PI * 2 / (double)n10 / 2.0;
        n7 = 14 * n11 / 8;
        for (n6 = 0; n6 < n10; ++n6) {
            n5 = n6 * 3 * 2;
            n4 = n6 * 3 * 2 + n10 * 3 * 2;
            n3 = n6 * 4 * 2 + 2 * (n10 * 3 * 2);
            s2 = (short)((double)n11 * Math.sin(d));
            s = (short)((double)n11 * Math.cos(d));
            n2 = (int)((double)n11 * Math.sin(d += Math.PI * 2 / (double)n10));
            n = (int)((double)n11 * Math.cos(d));
            sArray2[n5++] = (short)(n11 / 8 + n7);
            sArray2[n5++] = n11;
            sArray2[n5++] = (short)((n11 + s) / 8 + n7);
            sArray2[n5++] = (short)(n11 + s2);
            sArray2[n5++] = (short)((n11 + n) / 8 + n7);
            sArray2[n5++] = (short)(n11 + n2);
            sArray2[n4++] = (short)(n11 / 8 + n7);
            sArray2[n4++] = n11;
            sArray2[n4++] = (short)((n11 + n) / 8 + n7);
            sArray2[n4++] = (short)(n11 + n2);
            sArray2[n4++] = (short)((n11 + s) / 8 + n7);
            sArray2[n4++] = (short)(n11 + s2);
            sArray2[n3++] = 0;
            sArray2[n3++] = 0;
            sArray2[n3++] = (short)(2 * n11 / 8);
            sArray2[n3++] = 0;
            sArray2[n3++] = 0;
            sArray2[n3++] = (short)(2 * n11);
            sArray2[n3++] = (short)(2 * n11 / 8);
            sArray2[n3++] = (short)(2 * n11);
        }
        VertexArray vertexArray3 = new VertexArray(sArray2.length / 2, 2, 2);
        vertexArray3.set(0, sArray2.length / 2, sArray2);
        float f = 1.0f / (float)n11;
        float f2 = 1.0f / (2.0f * (float)n11);
        this.m_pieceVertBuffer = new VertexBuffer();
        this.m_pieceVertBuffer.setPositions(vertexArray, f, null);
        this.m_pieceVertBuffer.setNormals(vertexArray2);
        this.m_pieceVertBuffer.setTexCoords(0, vertexArray3, f2, null);
        int[] nArray = new int[n10 * 3];
        for (s2 = 0; s2 < n10; s2 = (short)(s2 + 1)) {
            s = s2;
            n2 = s2 + n10;
            n = s2 + 2 * n10;
            nArray[s] = 3;
            nArray[n2] = 3;
            nArray[n] = 4;
        }
        this.m_pieceIndexBuffer = new TriangleStripArray(0, nArray);
    }

    protected void calculateDiceBuffers() {
        short s = 4095;
        short s2 = (short)(s / 2);
        short s3 = (short)(s - s2);
        short s4 = -s;
        short s5 = (short)(s4 + s2);
        short[] sArray = new short[]{s4, s5, s, s5, s4, s, s, s5, s, s3, s4, s, s4, s3, s, s4, s5, s, s, s3, s, s, s5, s, s5, s, s, s4, s3, s, s3, s, s, s, s3, s, s, s5, s4, s3, s4, s4, s4, s5, s4, s5, s4, s4, s, s3, s4, s, s5, s4, s4, s3, s4, s4, s5, s4, s3, s, s4, s, s3, s4, s5, s, s4, s4, s3, s4, s, s4, s5, s, s5, s4, s, s, s5, s, s3, s4, s, s4, s3, s, s4, s5, s, s, s3, s, s, s5, s, s5, s, s, s4, s3, s, s3, s, s, s, s3, s4, s, s5, s4, s3, s4, s4, s4, s5, s4, s5, s4, s4, s, s3, s4, s, s5, s4, s4, s3, s4, s4, s5, s4, s3, s, s4, s, s3, s4, s5, s, s4, s4, s3, s4, s4, s5, s5, s4, s4, s, s4, s5, s3, s4, s4, s4, s4, s3, s4, s4, s5, s, s4, s3, s, s4, s5, s5, s4, s, s4, s4, s3, s3, s4, s, s, s4, s3, s, s, s5, s3, s, s4, s4, s, s5, s5, s, s4, s, s, s3, s, s, s5, s4, s, s3, s4, s, s5, s3, s, s, s, s, s3, s5, s, s, s4, s, s3, s4, s3, s, s5, s, s, s4, s, s3, s, s3, s, s, s, s3, s3, s, s, s4, s5, s, s4, s4, s3, s5, s4, s, s, s5, s, s3, s4, s, s, s4, s3, s4, s3, s4, s4, s, s5, s5, s, s4, s, s3, s4, s3, s, s4, s, s, s5, s4, s5, s4, s5, s4, s4, s4, s4, s5, s, s5, s4, s, s4, s5, s3, s4, s4};
        VertexArray vertexArray = new VertexArray(sArray.length / 3, 3, 2);
        vertexArray.set(0, sArray.length / 3, sArray);
        double d = Math.sqrt(s * s + s * s + s3 * s3);
        byte by = (byte)(127.0 * (double)s / d);
        byte by2 = -by;
        byte by3 = (byte)(127.0 * (double)s3 / d);
        byte by4 = -by3;
        byte[] byArray = new byte[]{0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, by2, by3, by, by4, by, by, by2, by, by3, by, by3, by, by, by, by3, by3, by, by, by2, by4, by, by2, by2, by3, by4, by2, by, by, by4, by, by3, by2, by, by, by2, by3, by2, by3, by2, by2, by, by4, by4, by, by2, by, by3, by2, by3, by, by2, by, by, by4, by2, by4, by2, by4, by2, by2, by2, by2, by4, by, by4, by2, by, by2, by4, by3, by2, by2};
        VertexArray vertexArray2 = new VertexArray(byArray.length / 3, 3, 1);
        vertexArray2.set(0, byArray.length / 3, byArray);
        short s6 = (short)((s + s) / 8);
        short s7 = (short)((s4 + s) / 8);
        short s8 = (short)((s3 + s) / 8);
        short s9 = (short)((s5 + s) / 8);
        short s10 = (short)(s + 7 * s / 8);
        short s11 = (short)(s4 + s);
        short s12 = (short)(s3 + s);
        short s13 = (short)(s5 + s);
        short[] sArray2 = new short[8];
        short[] sArray3 = new short[8];
        short[] sArray4 = new short[8];
        short[] sArray5 = new short[8];
        for (int i = 0; i < 8; ++i) {
            sArray2[i] = (short)(s6 + s6 * i);
            sArray3[i] = (short)(s7 + s6 * i);
            sArray4[i] = (short)(s8 + s6 * i);
            sArray5[i] = (short)(s9 + s6 * i);
        }
        short[] sArray6 = new short[]{sArray3[1], s13, sArray5[1], s11, sArray2[1], s13, sArray4[1], s11, sArray3[1], s12, sArray3[1], s13, sArray2[1], s12, sArray2[1], s13, sArray5[1], s10, sArray3[1], s12, sArray4[1], s10, sArray2[1], s12, sArray3[6], s13, sArray5[6], s11, sArray2[6], s13, sArray4[6], s11, sArray3[6], s12, sArray3[6], s13, sArray2[6], s12, sArray2[6], s13, sArray5[6], s10, sArray3[6], s12, sArray4[6], s10, sArray2[6], s12, sArray3[4], s13, sArray5[4], s11, sArray2[4], s13, sArray4[4], s11, sArray3[4], s12, sArray3[4], s13, sArray2[4], s12, sArray2[4], s13, sArray5[4], s10, sArray3[4], s12, sArray4[4], s10, sArray2[4], s12, sArray3[3], s13, sArray5[3], s11, sArray2[3], s13, sArray4[3], s11, sArray3[3], s12, sArray3[3], s13, sArray2[3], s12, sArray2[3], s13, sArray5[3], s10, sArray3[3], s12, sArray4[3], s10, sArray2[3], s12, sArray3[5], s13, sArray5[5], s11, sArray2[5], s13, sArray4[5], s11, sArray3[5], s12, sArray3[5], s13, sArray2[5], s12, sArray2[5], s13, sArray5[5], s10, sArray3[5], s12, sArray4[5], s10, sArray2[5], s12, sArray3[2], s13, sArray5[2], s11, sArray2[2], s13, sArray4[2], s11, sArray3[2], s12, sArray3[2], s13, sArray2[2], s12, sArray2[2], s13, sArray5[2], s10, sArray3[2], s12, sArray4[2], s10, sArray2[2], s12, sArray3[0], s10, sArray2[0], s11, sArray3[0], s11, sArray3[0], s10, sArray2[0], s11, sArray2[0], s10, sArray3[0], s10, sArray2[0], s11, sArray3[0], s11, sArray3[0], s10, sArray2[0], s11, sArray2[0], s10, sArray3[0], s10, sArray2[0], s11, sArray3[0], s11, sArray3[0], s10, sArray2[0], s11, sArray2[0], s10, sArray3[0], s10, sArray2[0], s11, sArray3[0], s11, sArray3[0], s10, sArray2[0], s11, sArray2[0], s10};
        VertexArray vertexArray3 = new VertexArray(sArray6.length / 2, 2, 2);
        vertexArray3.set(0, sArray6.length / 2, sArray6);
        float f = 1.0f / (float)s;
        float f2 = 1.0f / (float)(2 * s);
        this.m_diceVertBuffer = new VertexBuffer();
        this.m_diceVertBuffer.setPositions(vertexArray, f, null);
        this.m_diceVertBuffer.setNormals(vertexArray2);
        this.m_diceVertBuffer.setTexCoords(0, vertexArray3, f2, null);
        int[] nArray = new int[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3};
        this.m_diceIndexBuffer = new TriangleStripArray(0, nArray);
    }
}

