/*
 * Decompiled with CFR 0.152.
 */
package bluegammon.gui.animation;

import bluegammon.gui.animation.Animation;
import bluegammon.gui.animation.RepaintRequestable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class AnimationEngine
implements Runnable {
    protected volatile boolean m_running = true;
    protected Vector m_animations = new Vector();
    protected long m_animationInterval = Long.MAX_VALUE;
    protected RepaintRequestable m_canvas;

    public AnimationEngine(RepaintRequestable repaintRequestable) {
        this.m_canvas = repaintRequestable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean animate() {
        boolean bl = false;
        Vector vector = this.m_animations;
        synchronized (vector) {
            long l = System.currentTimeMillis();
            this.m_animationInterval = Long.MAX_VALUE;
            for (int i = this.m_animations.size() - 1; i >= 0; --i) {
                Animation animation = (Animation)this.m_animations.elementAt(i);
                long l2 = animation.getInterval();
                if (l - animation.getLastInvoke() >= l2) {
                    animation.callNext(l);
                    bl = true;
                }
                if (animation.isFinished()) {
                    animation.onExit();
                    this.m_animations.removeElement(animation);
                    continue;
                }
                if (l2 >= this.m_animationInterval) continue;
                this.m_animationInterval = l2;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnimation(Animation animation) {
        Vector vector = this.m_animations;
        synchronized (vector) {
            this.m_animations.insertElementAt(animation, 0);
            if (this.m_animationInterval > animation.getInterval()) {
                this.m_animationInterval = animation.getInterval();
            }
            this.m_animations.notifyAll();
            animation.onStart();
        }
        this.m_canvas.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Animation animation) {
        Vector vector = this.m_animations;
        synchronized (vector) {
            this.m_animations.removeElement(animation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Vector vector = this.m_animations;
        synchronized (vector) {
            this.m_animations.removeAllElements();
        }
    }

    public void shutdown() {
        this.m_running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        Vector vector = this.m_animations;
        synchronized (vector) {
            for (int i = this.m_animations.size() - 1; i >= 0; --i) {
                ((Animation)this.m_animations.elementAt(i)).paint(graphics);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            boolean bl = false;
            while (this.m_running) {
                Vector vector;
                bl = false;
                if (this.m_canvas.isShown() && !this.m_animations.isEmpty()) {
                    bl = this.animate();
                } else {
                    vector = this.m_animations;
                    synchronized (vector) {
                        try {
                            this.m_animations.wait(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (this.m_canvas.isShown()) {
                    if (bl) {
                        this.m_canvas.commitRepaint();
                    }
                    vector = this.m_animations;
                    synchronized (vector) {
                        try {
                            this.m_animations.wait(Math.min(this.m_animationInterval, 500L));
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (this.m_running) continue;
                this.m_animations = null;
            }
        }
        catch (Throwable throwable) {
            System.err.println("Error in anim thread");
            throwable.printStackTrace();
        }
    }
}

