/*
 * Decompiled with CFR 0.152.
 */
package bluegammon.gui.animation;

import bluegammon.gui.BoardCanvas;
import bluegammon.gui.animation.Animation;
import bluegammon.logic.BoardMediator;
import javax.microedition.lcdui.Graphics;

public class CursorAnim
extends Animation {
    protected static final int SOURCE_COL = 0x22FFFF;
    protected static final int DEST_COL = 0xFFFF22;
    protected static int m_cursorSize;
    protected int m_sx;
    protected int m_sy;
    protected int m_dx;
    protected int m_dy;
    protected int m_csx;
    protected int m_cdx;
    protected int m_xAdjustS;
    protected int m_xAdjustD;
    protected int m_frame;
    protected boolean m_sourceLeft;
    protected boolean m_destLeft;
    protected volatile boolean m_stopped;

    public static void init(int n) {
        m_cursorSize = n;
    }

    public CursorAnim(int n, int n2, int n3, int n4, boolean bl) {
        BoardCanvas boardCanvas = BoardCanvas.getInstance();
        int n5 = Math.min(5, n3);
        int n6 = Math.min(5, n4);
        n5 = Math.max(n5, 1);
        if (n3 > 4) {
            this.m_xAdjustS = -m_cursorSize;
        }
        if (n4 > 4) {
            this.m_xAdjustD = m_cursorSize;
        }
        this.m_sx = boardCanvas.getPieceX(n, n5, bl);
        this.m_sy = boardCanvas.getPieceY(n, n5, bl);
        this.m_dx = boardCanvas.getPieceX(n2, n6, bl);
        this.m_dy = boardCanvas.getPieceY(n2, n6, bl);
        if (n <= 23) {
            this.m_sourceLeft = n > 11;
        } else if (n == 25) {
            this.m_sourceLeft = bl;
        }
        if (n2 <= 23) {
            this.m_destLeft = n2 < 12;
        } else if (n2 == 24) {
            this.m_destLeft = !bl;
        }
    }

    public void paint(Graphics graphics) {
        if (!this.m_stopped) {
            graphics.setColor(0x22FFFF);
            this.m_csx = this.m_sx;
            this.m_csx = this.m_sourceLeft ? (this.m_csx += this.m_xAdjustS + this.m_frame) : (this.m_csx -= this.m_xAdjustS + this.m_frame);
            this.drawArrow(graphics, this.m_csx, this.m_sy, this.m_sourceLeft);
            graphics.setColor(0xFFFF22);
            this.m_cdx = this.m_dx;
            this.m_cdx = this.m_destLeft ? (this.m_cdx += this.m_xAdjustD + this.m_frame) : (this.m_cdx -= this.m_xAdjustD + this.m_frame);
            this.drawArrow(graphics, this.m_cdx, this.m_dy, this.m_destLeft);
        }
    }

    protected void drawArrow(Graphics graphics, int n, int n2, boolean bl) {
        int n3 = 3;
        int n4 = m_cursorSize / 2;
        if (bl) {
            int n5;
            for (n5 = 0; n5 < n4; ++n5) {
                graphics.drawLine(n + (n4 - n5), n2 + n5, n + (n4 - n5) + n3, n2 + n5);
            }
            for (n5 = n4; n5 <= n4 << 1; ++n5) {
                graphics.drawLine(n + (n5 - n4), n2 + n5, n + (n5 - n4) + n3, n2 + n5);
            }
        } else {
            int n6;
            for (n6 = 0; n6 < n4; ++n6) {
                graphics.drawLine(n + n6, n2 + n6, n + n6 + n3, n2 + n6);
            }
            for (n6 = n4; n6 <= n4 << 1; ++n6) {
                graphics.drawLine(n + ((n4 << 1) - n6), n2 + n6, n + ((n4 << 1) - n6) + n3, n2 + n6);
            }
        }
    }

    public void next() {
        this.m_frame = this.m_frame - 1 & 3;
        BoardCanvas.getInstance().requestRepaint();
    }

    public boolean isFinished() {
        return this.m_stopped || BoardMediator.isGameFinished() || !BoardCanvas.getInstance().isUserMovable();
    }

    public long getInterval() {
        return 200L;
    }

    public void stop() {
        this.m_stopped = true;
    }
}

