/*
 * Decompiled with CFR 0.152.
 */
package bluegammon.gui.animation;

import bluegammon.Resources;
import bluegammon.gui.BoardCanvas;
import bluegammon.gui.animation.Animation;
import bluegammon.logic.BoardMediator;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class WinnerAnim
extends Animation {
    protected static final int WHITE_COL = 0xFFFFFF;
    protected static final int BLACK_COL = 0;
    protected static final char[] TXT_WHITE_WINS = Resources.getChars(Resources.TXT_A_WHITE_WINS);
    protected static final char[] TXT_BLACK_WINS = Resources.getChars(Resources.TXT_A_BLACK_WINS);
    protected static final Font BIG_FONT = Font.getFont((int)64, (int)1, (int)16);
    protected static final Font SMALL_FONT = Font.getFont((int)64, (int)1, (int)0);
    protected boolean m_whiteWinner;
    protected int m_pieces = 0;
    protected int m_piecesLeft;
    protected int m_pts;
    protected int m_d;
    protected int m_x;
    protected int m_y;
    protected int m_fg;
    protected int m_bg;
    protected int m_step;
    protected int m_tw;
    protected int m_th;
    protected char[] m_colWinnerTxt;
    protected char[] m_piecesTxt;
    protected char[] m_ptsTxt;
    protected char[] m_totalTxt;

    public WinnerAnim(boolean bl, int n, int n2) {
        this.m_whiteWinner = bl;
        this.m_ptsTxt = ("x" + n2 + " " + Resources.getString(n2 > 1 ? Resources.TXT_A_POINTS : Resources.TXT_A_POINT)).toCharArray();
        this.m_piecesLeft = n;
        this.m_pts = n2;
        this.m_d = Math.min(BoardCanvas.getInstance().getWidth(), BoardCanvas.getInstance().getHeight()) / 2;
        this.m_x = BoardCanvas.getInstance().getWidth() / 2;
        this.m_y = (BoardCanvas.getInstance().getHeight() - this.m_d) / 2;
        this.m_fg = 0xFFFFFF;
        this.m_bg = 0;
        this.m_colWinnerTxt = TXT_BLACK_WINS;
        if (bl) {
            this.m_fg = 0;
            this.m_bg = 0xFFFFFF;
            this.m_colWinnerTxt = TXT_WHITE_WINS;
        }
        this.m_tw = BIG_FONT.charsWidth(this.m_colWinnerTxt, 0, this.m_colWinnerTxt.length);
        this.m_th = BIG_FONT.getHeight();
    }

    public void paint(Graphics graphics) {
        if (BoardMediator.isGameFinished()) {
            int n = this.m_y;
            this.drawText(this.m_colWinnerTxt, graphics, BIG_FONT, n);
            n = (int)((float)n + 1.5f * (float)this.m_th);
            if (this.m_pieces > 0) {
                this.drawText(this.m_piecesTxt, graphics, SMALL_FONT, n);
                this.drawText(this.m_ptsTxt, graphics, SMALL_FONT, n += this.m_th);
                n = (int)((float)n + 1.5f * (float)this.m_th);
                this.drawText(this.m_totalTxt, graphics, BIG_FONT, n);
            }
        }
    }

    public void next() {
        ++this.m_step;
        BoardCanvas.getInstance().requestRepaint();
        if (this.m_pieces < this.m_piecesLeft) {
            BoardCanvas.getInstance().addWinningPieceAnimation(!this.m_whiteWinner, this);
        }
    }

    public boolean isFinished() {
        return !BoardMediator.isGameFinished();
    }

    public long getInterval() {
        return 500L;
    }

    public void piecePlus() {
        ++this.m_pieces;
        int n = this.m_pieces * this.m_pts;
        this.m_piecesTxt = (this.m_pieces + " " + Resources.getString(this.m_pieces > 1 ? Resources.TXT_A_PIECES : Resources.TXT_A_PIECE)).toCharArray();
        this.m_totalTxt = (n + " " + Resources.getString(n > 1 ? Resources.TXT_A_POINTS : Resources.TXT_A_POINT)).toCharArray();
    }

    protected void drawText(char[] cArray, Graphics graphics, Font font, int n) {
        graphics.setFont(font);
        graphics.setColor(this.m_fg);
        graphics.drawChars(cArray, 0, cArray.length, this.m_x + 1, n, 65);
        graphics.drawChars(cArray, 0, cArray.length, this.m_x - 1, n, 65);
        graphics.drawChars(cArray, 0, cArray.length, this.m_x, n + 1, 65);
        graphics.drawChars(cArray, 0, cArray.length, this.m_x, n - 1, 65);
        graphics.setColor(this.m_bg);
        graphics.drawChars(cArray, 0, cArray.length, this.m_x, n, 65);
    }
}

