/*
 * Decompiled with CFR 0.152.
 */
package bluegammon.io;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;

public class BluetoothFacade
implements DiscoveryListener {
    public static final String BT_PROTOCOL = "btspp";
    protected Hashtable m_servers = new Hashtable();
    protected final Object DEVICE_LOCK = new Object();
    protected final Object SERVICE_LOCK = new Object();
    protected Vector m_devices = new Vector();
    protected ServiceRecord m_record = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector findDevices() throws IOException {
        Object object = this.DEVICE_LOCK;
        synchronized (object) {
            this.m_devices.removeAllElements();
            DiscoveryAgent discoveryAgent = LocalDevice.getLocalDevice().getDiscoveryAgent();
            discoveryAgent.startInquiry(10390323, (DiscoveryListener)this);
            try {
                this.DEVICE_LOCK.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.m_devices;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamConnection connect(String string, RemoteDevice remoteDevice) throws IOException {
        ServiceRecord serviceRecord = null;
        Object object = this.SERVICE_LOCK;
        synchronized (object) {
            this.m_record = null;
            UUID[] uUIDArray = new UUID[]{new UUID(string, false)};
            DiscoveryAgent discoveryAgent = LocalDevice.getLocalDevice().getDiscoveryAgent();
            int n = discoveryAgent.searchServices(null, uUIDArray, remoteDevice, (DiscoveryListener)this);
            try {
                this.SERVICE_LOCK.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            serviceRecord = this.m_record;
            this.m_record = null;
        }
        if (serviceRecord != null) {
            return this.connect(serviceRecord);
        }
        return null;
    }

    public StreamConnection connect(ServiceRecord serviceRecord) throws IOException {
        int n = 0;
        String string = serviceRecord.getConnectionURL(n, false);
        if (!string.startsWith(BT_PROTOCOL)) {
            throw new IOException("Protocol mismatch, expected btspp");
        }
        StreamConnection streamConnection = (StreamConnection)Connector.open((String)string);
        return streamConnection;
    }

    public StreamConnection waitForClient(String string) throws IOException {
        LocalDevice.getLocalDevice().setDiscoverable(10390323);
        StreamConnectionNotifier streamConnectionNotifier = (StreamConnectionNotifier)this.m_servers.get(string);
        if (streamConnectionNotifier == null) {
            streamConnectionNotifier = (StreamConnectionNotifier)Connector.open((String)("btspp://localhost:" + string));
            this.m_servers.put(string, streamConnectionNotifier);
        }
        StreamConnection streamConnection = streamConnectionNotifier.acceptAndOpen();
        return streamConnection;
    }

    public void closeServer(String string) throws IOException {
        StreamConnectionNotifier streamConnectionNotifier = (StreamConnectionNotifier)this.m_servers.get(string);
        if (streamConnectionNotifier != null) {
            streamConnectionNotifier.close();
            this.m_servers.remove(string);
            streamConnectionNotifier = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void servicesDiscovered(int n, ServiceRecord[] serviceRecordArray) {
        for (int i = 0; i < serviceRecordArray.length; ++i) {
            String string = serviceRecordArray[i].getConnectionURL(0, false);
            if (!string.startsWith(BT_PROTOCOL)) continue;
            Object object = this.SERVICE_LOCK;
            synchronized (object) {
                this.m_record = serviceRecordArray[i];
                this.SERVICE_LOCK.notifyAll();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceSearchCompleted(int n, int n2) {
        Object object = this.SERVICE_LOCK;
        synchronized (object) {
            this.SERVICE_LOCK.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
        Object object = this.DEVICE_LOCK;
        synchronized (object) {
            this.m_devices.addElement(remoteDevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inquiryCompleted(int n) {
        Object object = this.DEVICE_LOCK;
        synchronized (object) {
            this.DEVICE_LOCK.notifyAll();
        }
    }
}

