/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public final class BPGraphics {
    private static final int DEFAULT_ANCHOR = 20;
    public Image[][] images;
    boolean isDoublePixel;
    static int[] crc_table;
    static int dataptr;
    static int crcfrom;
    static int pngsize;
    static byte[] data;
    static byte[] PNG_header;
    static byte[] PNG_End;
    static byte[] blockStart;
    static byte[] finalBlockStart;
    static int blockCount;
    static int currBlock;
    static final int maxZlibBlockSize = 32768;

    public BPGraphics() {
        this.images = null;
        this.isDoublePixel = false;
    }

    public BPGraphics(MIDlet midlet, String name, boolean[] isImage) {
        this(midlet, name, isImage, false);
    }

    public BPGraphics(MIDlet midlet, String name, boolean[] isImage, boolean doublePixel) {
        block31: {
            this.images = null;
            this.isDoublePixel = false;
            this.isDoublePixel = doublePixel;
            InputStream is = null;
            DataInputStream dis = null;
            int _tmp1 = 0;
            try {
                is = midlet.getClass().getResourceAsStream(name);
                dis = new DataInputStream(is);
                dis.readByte();
                dis.readByte();
                dis.readByte();
                byte BGSversion = dis.readByte();
                int _palSets = dis.readUnsignedByte();
                int _palGroups = dis.readUnsignedByte();
                short[][] _palettesIndices = new short[_palSets][_palGroups];
                for (int z = 0; z < _palSets; ++z) {
                    for (int i = 0; i < _palGroups; ++i) {
                        _palettesIndices[z][i] = (short)dis.readUnsignedByte();
                        if (_palettesIndices[z][i] <= _tmp1) continue;
                        _tmp1 = _palettesIndices[z][i];
                    }
                }
                byte[][] _palEntries = new byte[++_tmp1][];
                byte[][] _alphaEntries = new byte[_tmp1][];
                int _palettesInFile = dis.readUnsignedByte();
                for (int i = 0; i < _palettesInFile; ++i) {
                    boolean _isPaletteUsed = false;
                    block18: for (int z = 0; z < _palSets; ++z) {
                        for (int g = 0; g < _palGroups; ++g) {
                            if (_palettesIndices[z][g] != (short)i) continue;
                            _tmp1 = dis.readUnsignedByte() + 1;
                            _palEntries[i] = new byte[_tmp1 * 3];
                            dis.read(_palEntries[i]);
                            _tmp1 = dis.readUnsignedByte() + 1;
                            _alphaEntries[i] = new byte[_tmp1];
                            dis.read(_alphaEntries[i]);
                            _isPaletteUsed = true;
                            continue block18;
                        }
                    }
                    if (_isPaletteUsed) continue;
                    dis.skipBytes((dis.readUnsignedByte() + 1) * 3);
                    dis.skipBytes(dis.readUnsignedByte() + 1);
                }
                int _imagesNumber = dis.readUnsignedByte();
                this.images = new Image[_palSets][_imagesNumber];
                byte[] _imagesTransformations = new byte[_imagesNumber];
                short[] _imagesDataIndices = new short[_imagesNumber];
                short[] _imagesGroupIndices = new short[_imagesNumber];
                byte[] _imagesAlphaUsage = null;
                if (BGSversion >= 2) {
                    _imagesAlphaUsage = new byte[_imagesNumber];
                }
                for (int i = 0; i < _imagesNumber; ++i) {
                    _imagesTransformations[i] = dis.readByte();
                    _imagesGroupIndices[i] = (short)dis.readUnsignedByte();
                    _imagesDataIndices[i] = (short)dis.readUnsignedByte();
                    if (BGSversion < 2) continue;
                    _imagesAlphaUsage[i] = dis.readByte();
                }
                _tmp1 = dis.readUnsignedByte();
                short[] _rawDataSetsWidths = new short[_tmp1];
                short[] _rawDataSetsHeights = new short[_tmp1];
                byte[] _rawDataSetsFormats = new byte[_tmp1];
                for (int i = 0; i < _tmp1; ++i) {
                    _rawDataSetsWidths[i] = (short)dis.readUnsignedShort();
                    _rawDataSetsHeights[i] = (short)dis.readUnsignedShort();
                    _rawDataSetsFormats[i] = dis.readByte();
                }
                for (int i = 0; i < _tmp1; ++i) {
                    int _Bpp = (short)_rawDataSetsFormats[i] == 0 ? 1 : ((short)_rawDataSetsFormats[i] == 1 ? 3 : 4);
                    int rawSize = _rawDataSetsWidths[i] * _rawDataSetsHeights[i] * _Bpp;
                    boolean _isDataLoaded = false;
                    byte[] _rawData = null;
                    int[] _rawDataInt = null;
                    block23: for (int im = 0; im < _imagesNumber; ++im) {
                        if (isImage != null && !isImage[im] || _imagesDataIndices[im] != (short)i) continue;
                        if (!_isDataLoaded) {
                            switch (_Bpp) {
                                case 1: {
                                    _rawData = new byte[rawSize];
                                    dis.read(_rawData);
                                    break;
                                }
                                case 3: {
                                    _rawDataInt = new int[_rawDataSetsWidths[i] * _rawDataSetsHeights[i]];
                                    _rawData = new byte[rawSize];
                                    dis.read(_rawData);
                                    int offInt = 0;
                                    int offBytes = 0;
                                    while (offInt < _rawDataInt.length) {
                                        _rawDataInt[offInt] = -16777216;
                                        int n = offInt;
                                        _rawDataInt[n] = _rawDataInt[n] | (_rawData[offBytes++] & 0xFF) << 16 & 0xFF0000;
                                        int n2 = offInt;
                                        _rawDataInt[n2] = _rawDataInt[n2] | (_rawData[offBytes++] & 0xFF) << 8 & 0xFF00;
                                        int n3 = offInt++;
                                        _rawDataInt[n3] = _rawDataInt[n3] | _rawData[offBytes++] & 0xFF & 0xFF;
                                    }
                                    _rawData = null;
                                    break;
                                }
                                case 4: {
                                    int size = _rawDataSetsWidths[i] * _rawDataSetsHeights[i];
                                    _rawDataInt = new int[size];
                                    for (int offInt = 0; offInt < size; ++offInt) {
                                        _rawDataInt[offInt] = dis.readInt();
                                    }
                                    break;
                                }
                            }
                            _isDataLoaded = true;
                        }
                        switch (_Bpp) {
                            case 1: {
                                int z;
                                for (z = 0; z < _palSets; ++z) {
                                    int alphaUsageBit = 1;
                                    alphaUsageBit = (short)(alphaUsageBit << z);
                                    boolean isAlpha = BGSversion >= 2 ? (_imagesAlphaUsage[im] & 0xFF & alphaUsageBit) != 0 : true;
                                    this.images[z][im] = BPGraphics.createImagePNG(_rawDataSetsWidths[i], _rawDataSetsHeights[i], _rawDataSetsFormats[i], _imagesTransformations[im], _rawData, _palEntries[_palettesIndices[z][_imagesGroupIndices[im]]], _alphaEntries[_palettesIndices[z][_imagesGroupIndices[im]]], isAlpha, this.isDoublePixel);
                                }
                                continue block23;
                            }
                            case 3: 
                            case 4: {
                                int z;
                                this.images[0][im] = BPGraphics.createFromBGSTrueColorImage(_rawDataSetsWidths[i], _rawDataSetsHeights[i], _rawDataSetsFormats[i], _imagesTransformations[im], _rawDataInt, this.isDoublePixel);
                                for (z = 1; z < _palSets; ++z) {
                                    this.images[z][im] = this.images[0][im];
                                }
                                continue block23;
                            }
                        }
                    }
                    if (_isDataLoaded) continue;
                    dis.skipBytes(rawSize);
                }
                dis.close();
                dis = null;
                is = null;
            }
            catch (Exception e) {
                System.out.println("loadImages Exception: B??d pliku o nazwie:  " + name);
                this.images = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception ed) {
                        // empty catch block
                    }
                    is = null;
                }
                if (dis == null) break block31;
                try {
                    dis.close();
                }
                catch (Exception ed) {
                    // empty catch block
                }
                dis = null;
            }
        }
    }

    public int getWidth(int n) {
        return this.images[0][n].getWidth();
    }

    public int getHeight(int n) {
        return this.images[0][n].getHeight();
    }

    public int getWidth() {
        int m = this.images[0][0].getWidth();
        for (int i = 1; i < this.images.length; ++i) {
            int w = this.images[0][i].getWidth();
            if (w <= m) continue;
            m = w;
        }
        return m;
    }

    public int getHeight() {
        int m = this.images[0][0].getHeight();
        for (int i = 1; i < this.images.length; ++i) {
            int w = this.images[0][i].getHeight();
            if (w <= m) continue;
            m = w;
        }
        return m;
    }

    public int getSetsNum() {
        return this.images.length;
    }

    static Image createFromBGSCreateRGBImageVersion(int width, int height, byte imageFormat, byte transform, byte[] rawData, int[] rgbEntries, boolean processAlpha, boolean doublePixel) {
        processAlpha = true;
        if (doublePixel) {
            System.out.println("podwojny pixel");
            int[] _data = new int[width * height * 4];
            int _srcPtr = 0;
            int hx2 = height << 1;
            int wx2 = width << 1;
            switch (transform & 3) {
                case 0: {
                    for (int y = 0; y < height; ++y) {
                        int _offset = (transform & 4) == 0 ? (y << 1) * width : ((y << 1) + 1) * width - 1;
                        for (int x = 0; x < width; ++x) {
                            if ((rawData[_srcPtr] & 0xFF) < rgbEntries.length) {
                                _data[_offset << 1] = rgbEntries[rawData[_srcPtr] & 0xFF];
                                _data[(_offset << 1) + 1] = rgbEntries[rawData[_srcPtr] & 0xFF];
                                _data[(_offset << 1) + wx2] = rgbEntries[rawData[_srcPtr] & 0xFF];
                                _data[(_offset << 1) + wx2 + 1] = rgbEntries[rawData[_srcPtr] & 0xFF];
                            } else {
                                _data[_offset << 1] = 0;
                                _data[(_offset << 1) + 1] = 0;
                                _data[(_offset << 1) + wx2] = 0;
                                _data[(_offset << 1) + wx2 + 1] = 0;
                            }
                            ++_srcPtr;
                            if ((transform & 4) == 0) {
                                ++_offset;
                                continue;
                            }
                            --_offset;
                        }
                    }
                    break;
                }
                case 1: {
                    for (int y = 0; y < height; ++y) {
                        int _offset = (transform & 4) == 0 ? height - y - 1 : y;
                        for (int x = 0; x < width; ++x) {
                            if (rawData[_srcPtr] < rgbEntries.length) {
                                _data[_offset << 1] = rgbEntries[rawData[_srcPtr] & 0xFF];
                                _data[(_offset << 1) + 1] = rgbEntries[rawData[_srcPtr] & 0xFF];
                                _data[(_offset << 1) + hx2] = rgbEntries[rawData[_srcPtr] & 0xFF];
                                _data[(_offset << 1) + hx2 + 1] = rgbEntries[rawData[_srcPtr] & 0xFF];
                            } else {
                                _data[_offset << 1] = 0;
                                _data[(_offset << 1) + 1] = 0;
                                _data[(_offset << 1) + hx2] = 0;
                                _data[(_offset << 1) + hx2 + 1] = 0;
                            }
                            ++_srcPtr;
                            _offset += hx2;
                        }
                    }
                    break;
                }
                case 2: {
                    for (int y = height; y > 0; --y) {
                        int _offset = (transform & 4) == 0 ? ((y << 1) - 1) * wx2 - 2 : ((y << 1) - 2) * wx2;
                        for (int x = 0; x < width; ++x) {
                            if (rawData[_srcPtr] < rgbEntries.length) {
                                _data[_offset] = rgbEntries[rawData[_srcPtr] & 0xFF];
                                _data[_offset + 1] = rgbEntries[rawData[_srcPtr] & 0xFF];
                                _data[_offset + wx2] = rgbEntries[rawData[_srcPtr] & 0xFF];
                                _data[_offset + wx2 + 1] = rgbEntries[rawData[_srcPtr] & 0xFF];
                            } else {
                                _data[_offset] = 0;
                                _data[_offset + 1] = 0;
                                _data[_offset + wx2] = 0;
                                _data[_offset + wx2 + 1] = 0;
                            }
                            ++_srcPtr;
                            if ((transform & 4) == 0) {
                                _offset -= 2;
                                continue;
                            }
                            _offset += 2;
                        }
                    }
                    break;
                }
                case 3: {
                    for (int y = height; y > 0; --y) {
                        int _offset = (transform & 4) == 0 ? wx2 * hx2 - (y << 1) : wx2 * hx2 - (height - y << 1) - 2;
                        for (int x = 0; x < width; ++x) {
                            if (rawData[_srcPtr] < rgbEntries.length) {
                                _data[_offset] = rgbEntries[rawData[_srcPtr] & 0xFF];
                                _data[_offset + 1] = rgbEntries[rawData[_srcPtr] & 0xFF];
                                _data[_offset - hx2] = rgbEntries[rawData[_srcPtr] & 0xFF];
                                _data[_offset - hx2 + 1] = rgbEntries[rawData[_srcPtr] & 0xFF];
                            } else {
                                _data[_offset] = 0;
                                _data[_offset + 1] = 0;
                                _data[_offset - hx2] = 0;
                                _data[_offset - hx2 + 1] = 0;
                            }
                            ++_srcPtr;
                            _offset -= height << 2;
                        }
                    }
                    break;
                }
            }
            if ((transform & 1) == 0) {
                return Image.createRGBImage((int[])_data, (int)(width << 1), (int)(height << 1), (boolean)processAlpha);
            }
            return Image.createRGBImage((int[])_data, (int)(height << 1), (int)(width << 1), (boolean)processAlpha);
        }
        int[] _data = new int[width * height];
        int _srcPtr = 0;
        switch (transform & 3) {
            case 0: {
                for (int y = 0; y < height; ++y) {
                    int _offset = (transform & 4) == 0 ? y * width : (y + 1) * width - 1;
                    for (int x = 0; x < width; ++x) {
                        _data[_offset] = (rawData[_srcPtr] & 0xFF) < rgbEntries.length ? rgbEntries[rawData[_srcPtr] & 0xFF] : 0;
                        ++_srcPtr;
                        if ((transform & 4) == 0) {
                            ++_offset;
                            continue;
                        }
                        --_offset;
                    }
                }
                break;
            }
            case 1: {
                for (int y = 0; y < height; ++y) {
                    int _offset = (transform & 4) == 0 ? height - y - 1 : y;
                    for (int x = 0; x < width; ++x) {
                        _data[_offset] = rawData[_srcPtr] < rgbEntries.length ? rgbEntries[rawData[_srcPtr] & 0xFF] : 0;
                        ++_srcPtr;
                        _offset += height;
                    }
                }
                break;
            }
            case 2: {
                for (int y = height; y > 0; --y) {
                    int _offset = (transform & 4) == 0 ? y * width - 1 : (y - 1) * width;
                    for (int x = 0; x < width; ++x) {
                        _data[_offset] = rawData[_srcPtr] < rgbEntries.length ? rgbEntries[rawData[_srcPtr] & 0xFF] : 0;
                        ++_srcPtr;
                        if ((transform & 4) == 0) {
                            --_offset;
                            continue;
                        }
                        ++_offset;
                    }
                }
                break;
            }
            case 3: {
                for (int y = height; y > 0; --y) {
                    int _offset = (transform & 4) == 0 ? width * height - y : width * height - (height - y) - 1;
                    for (int x = 0; x < width; ++x) {
                        _data[_offset] = rawData[_srcPtr] < rgbEntries.length ? rgbEntries[rawData[_srcPtr] & 0xFF] : 0;
                        ++_srcPtr;
                        _offset -= height;
                    }
                }
                break;
            }
        }
        if ((transform & 1) == 0) {
            return Image.createRGBImage((int[])_data, (int)width, (int)height, (boolean)processAlpha);
        }
        return Image.createRGBImage((int[])_data, (int)height, (int)width, (boolean)processAlpha);
    }

    static Image createFromBGSTrueColorImage(int width, int height, byte imageFormat, byte transform, int[] rawData, boolean doublePixel) {
        if (doublePixel) {
            System.out.println("podwojny pixel 2");
            int[] _data = new int[width * height * 4];
            int _srcPtr = 0;
            int hx2 = height << 1;
            int wx2 = width << 1;
            switch (transform & 3) {
                case 0: {
                    for (int y = 0; y < height; ++y) {
                        int _offset = (transform & 4) == 0 ? (y << 1) * width : ((y << 1) + 1) * width - 1;
                        for (int x = 0; x < width; ++x) {
                            _data[_offset << 1] = rawData[_srcPtr];
                            _data[(_offset << 1) + 1] = rawData[_srcPtr];
                            _data[(_offset << 1) + wx2] = rawData[_srcPtr];
                            _data[(_offset << 1) + wx2 + 1] = rawData[_srcPtr];
                            ++_srcPtr;
                            if ((transform & 4) == 0) {
                                ++_offset;
                                continue;
                            }
                            --_offset;
                        }
                    }
                    break;
                }
                case 1: {
                    for (int y = 0; y < height; ++y) {
                        int _offset = (transform & 4) == 0 ? height - y - 1 : y;
                        for (int x = 0; x < width; ++x) {
                            _data[_offset << 1] = rawData[_srcPtr];
                            _data[(_offset << 1) + 1] = rawData[_srcPtr];
                            _data[(_offset << 1) + hx2] = rawData[_srcPtr];
                            _data[(_offset << 1) + hx2 + 1] = rawData[_srcPtr];
                            ++_srcPtr;
                            _offset += hx2;
                        }
                    }
                    break;
                }
                case 2: {
                    for (int y = height; y > 0; --y) {
                        int _offset = (transform & 4) == 0 ? ((y << 1) - 1) * wx2 - 2 : ((y << 1) - 2) * wx2;
                        for (int x = 0; x < width; ++x) {
                            _data[_offset] = rawData[_srcPtr];
                            _data[_offset + 1] = rawData[_srcPtr];
                            _data[_offset + wx2] = rawData[_srcPtr];
                            _data[_offset + wx2 + 1] = rawData[_srcPtr];
                            ++_srcPtr;
                            if ((transform & 4) == 0) {
                                _offset -= 2;
                                continue;
                            }
                            _offset += 2;
                        }
                    }
                    break;
                }
                case 3: {
                    for (int y = height; y > 0; --y) {
                        int _offset = (transform & 4) == 0 ? wx2 * hx2 - (y << 1) : wx2 * hx2 - (height - y << 1) - 2;
                        for (int x = 0; x < width; ++x) {
                            _data[_offset] = rawData[_srcPtr];
                            _data[_offset + 1] = rawData[_srcPtr];
                            _data[_offset - hx2] = rawData[_srcPtr];
                            _data[_offset - hx2 + 1] = rawData[_srcPtr];
                            ++_srcPtr;
                            _offset -= height << 2;
                        }
                    }
                    break;
                }
            }
            if ((transform & 1) == 0) {
                if (imageFormat == 2) {
                    return Image.createRGBImage((int[])_data, (int)(width << 1), (int)(height << 1), (boolean)true);
                }
                return Image.createRGBImage((int[])_data, (int)(width << 1), (int)(height << 1), (boolean)false);
            }
            if (imageFormat == 2) {
                return Image.createRGBImage((int[])_data, (int)(height << 1), (int)(width << 1), (boolean)true);
            }
            return Image.createRGBImage((int[])_data, (int)(height << 1), (int)(width << 1), (boolean)false);
        }
        if ((transform & 7) == 0) {
            if (imageFormat == 2) {
                return Image.createRGBImage((int[])rawData, (int)width, (int)height, (boolean)true);
            }
            return Image.createRGBImage((int[])rawData, (int)width, (int)height, (boolean)false);
        }
        int[] _data = new int[width * height];
        int _srcPtr = 0;
        switch (transform & 3) {
            case 0: {
                for (int y = 0; y < height; ++y) {
                    int _offset = (y + 1) * width - 1;
                    for (int x = 0; x < width; ++x) {
                        _data[_offset] = rawData[_srcPtr];
                        ++_srcPtr;
                        if ((transform & 4) == 0) {
                            ++_offset;
                            continue;
                        }
                        --_offset;
                    }
                }
                break;
            }
            case 1: {
                for (int y = 0; y < height; ++y) {
                    int _offset = (transform & 4) == 0 ? height - y - 1 : y;
                    for (int x = 0; x < width; ++x) {
                        _data[_offset] = rawData[_srcPtr];
                        ++_srcPtr;
                        _offset += height;
                    }
                }
                break;
            }
            case 2: {
                for (int y = height; y > 0; --y) {
                    int _offset = (transform & 4) == 0 ? y * width - 1 : (y - 1) * width;
                    for (int x = 0; x < width; ++x) {
                        _data[_offset] = rawData[_srcPtr];
                        ++_srcPtr;
                        if ((transform & 4) == 0) {
                            --_offset;
                            continue;
                        }
                        ++_offset;
                    }
                }
                break;
            }
            case 3: {
                int wxh = width * height;
                for (int y = height; y > 0; --y) {
                    int _offset = (transform & 4) == 0 ? wxh - y : wxh - (height - y) - 1;
                    for (int x = 0; x < width; ++x) {
                        _data[_offset] = rawData[_srcPtr];
                        ++_srcPtr;
                        _offset -= height;
                    }
                }
                break;
            }
        }
        if ((transform & 1) == 0) {
            if (imageFormat == 2) {
                return Image.createRGBImage((int[])_data, (int)width, (int)height, (boolean)true);
            }
            return Image.createRGBImage((int[])_data, (int)width, (int)height, (boolean)false);
        }
        if (imageFormat == 2) {
            return Image.createRGBImage((int[])_data, (int)width, (int)height, (boolean)true);
        }
        return Image.createRGBImage((int[])_data, (int)width, (int)height, (boolean)false);
    }

    public void drawImage(Graphics g, int imgId, int setId, int x, int y, int anchor) {
        if (setId > 0) {
            setId = 0;
        }
        g.drawImage(this.images[setId][imgId], x, y, anchor);
    }

    public void drawImage(Graphics g, int imgId, int setId, int x, int y) {
        if (setId > 0) {
            setId = 0;
        }
        g.drawImage(this.images[setId][imgId], x, y, 20);
    }

    static Image createImagePNG(int width, int height, byte imageFormat, byte transform, byte[] idata, byte[] pal, byte[] alphaEntries, boolean isAlpha, boolean doublePixel) {
        int adler2;
        int adler1;
        int i;
        block66: {
            int _offset;
            boolean _srcPtr;
            int numLinesPerBlock;
            block65: {
                int compsize;
                int paletteSize = pal.length;
                if (doublePixel) {
                    width <<= 1;
                    height <<= 1;
                }
                int blockSize = 0;
                int finalBlockSize = 0;
                numLinesPerBlock = 1;
                blockCount = 0;
                currBlock = 0;
                if ((transform & 1) == 0) {
                    compsize = (width + 1) * height;
                    if (compsize > 32768) {
                        numLinesPerBlock = 32768 / (width + 1 << 1);
                        blockSize = (numLinesPerBlock <<= 1) * (width + 1);
                        blockCount = compsize / blockSize;
                        finalBlockSize = compsize % blockSize;
                        BPGraphics.blockStart[1] = (byte)(blockSize & 0xFF);
                        BPGraphics.blockStart[2] = (byte)(blockSize >>> 8 & 0xFF);
                        BPGraphics.blockStart[3] = ~blockStart[1];
                        BPGraphics.blockStart[4] = ~blockStart[2];
                    } else {
                        finalBlockSize = compsize;
                    }
                } else {
                    compsize = width * (height + 1);
                    if (compsize > 32768) {
                        numLinesPerBlock = 32768 / (height + 1 << 1);
                        blockSize = (numLinesPerBlock <<= 1) * (height + 1);
                        blockCount = compsize / blockSize;
                        finalBlockSize = compsize % blockSize;
                        BPGraphics.blockStart[1] = (byte)(blockSize & 0xFF);
                        BPGraphics.blockStart[2] = (byte)(blockSize >>> 8 & 0xFF);
                        BPGraphics.blockStart[3] = ~blockStart[1];
                        BPGraphics.blockStart[4] = ~blockStart[2];
                    } else {
                        finalBlockSize = compsize;
                    }
                }
                BPGraphics.finalBlockStart[1] = (byte)(finalBlockSize & 0xFF);
                BPGraphics.finalBlockStart[2] = (byte)(finalBlockSize >>> 8 & 0xFF);
                BPGraphics.finalBlockStart[3] = ~finalBlockStart[1];
                BPGraphics.finalBlockStart[4] = ~finalBlockStart[2];
                pngsize = paletteSize + compsize + 80 + blockCount * 5;
                boolean write_tRNS = false;
                if (alphaEntries != null && alphaEntries.length > 0 && alphaEntries.length == 1 ? alphaEntries[0] != 255 : isAlpha) {
                    pngsize += 12 + alphaEntries.length;
                    write_tRNS = true;
                }
                data = new byte[pngsize];
                for (i = 0; i < PNG_header.length; ++i) {
                    BPGraphics.data[i] = PNG_header[i];
                }
                dataptr = 16;
                if ((transform & 1) == 0) {
                    BPGraphics.writeInt(width);
                    BPGraphics.writeInt(height);
                } else {
                    BPGraphics.writeInt(height);
                    BPGraphics.writeInt(width);
                }
                dataptr = 29;
                BPGraphics.writeInt(BPGraphics.calc_crc(data, 12, 17));
                BPGraphics.writeInt(paletteSize);
                crcfrom = dataptr;
                BPGraphics.writeInt(1347179589L);
                for (i = 0; i < paletteSize; ++i) {
                    BPGraphics.data[BPGraphics.dataptr++] = pal[i];
                }
                BPGraphics.writeInt(BPGraphics.calc_crc(data, crcfrom, dataptr - crcfrom));
                if (write_tRNS) {
                    BPGraphics.writeInt(alphaEntries.length);
                    crcfrom = dataptr;
                    BPGraphics.writeInt(1951551059L);
                    for (i = 0; i < alphaEntries.length; ++i) {
                        BPGraphics.data[BPGraphics.dataptr++] = alphaEntries[i];
                    }
                    BPGraphics.writeInt(BPGraphics.calc_crc(data, crcfrom, dataptr - crcfrom));
                }
                BPGraphics.writeInt(compsize + 6 + (blockCount + 1) * 5);
                crcfrom = dataptr;
                BPGraphics.writeInt(1229209940L);
                BPGraphics.data[BPGraphics.dataptr++] = 120;
                BPGraphics.data[BPGraphics.dataptr++] = -38;
                if (blockCount == 0) {
                    BPGraphics.data[BPGraphics.dataptr++] = finalBlockStart[0];
                    BPGraphics.data[BPGraphics.dataptr++] = finalBlockStart[1];
                    BPGraphics.data[BPGraphics.dataptr++] = finalBlockStart[2];
                    BPGraphics.data[BPGraphics.dataptr++] = finalBlockStart[3];
                    BPGraphics.data[BPGraphics.dataptr++] = finalBlockStart[4];
                } else {
                    currBlock = 1;
                }
                int adlerstart = dataptr;
                adler1 = 1;
                adler2 = 0;
                if (!doublePixel) break block65;
                _srcPtr = false;
                int heightSrc = height >> 1;
                int widthSrc = width >> 1;
                switch (transform & 3) {
                    case 0: {
                        byte tmp;
                        int z;
                        int x;
                        int y;
                        for (y = 0; y < heightSrc; ++y) {
                            if (currBlock > 0 && (y << 1) % numLinesPerBlock == 0) {
                                BPGraphics.writeBlockStart();
                            }
                            _offset = (transform & 4) == 0 ? y * widthSrc : (y + 1) * widthSrc - 1;
                            BPGraphics.data[BPGraphics.dataptr++] = 0;
                            adler2 += adler1;
                            adler1 %= 65521;
                            adler2 %= 65521;
                            for (x = 0; x < widthSrc; ++x) {
                                BPGraphics.data[BPGraphics.dataptr++] = idata[_offset];
                                adler2 += (adler1 += idata[_offset] & 0xFF);
                                adler1 %= 65521;
                                adler2 %= 65521;
                                BPGraphics.data[BPGraphics.dataptr++] = idata[_offset];
                                adler2 += (adler1 += idata[_offset] & 0xFF);
                                adler1 %= 65521;
                                adler2 %= 65521;
                                if ((transform & 4) == 0) {
                                    ++_offset;
                                    continue;
                                }
                                --_offset;
                            }
                            BPGraphics.data[BPGraphics.dataptr++] = 0;
                            adler2 += adler1;
                            adler1 %= 65521;
                            adler2 %= 65521;
                            z = dataptr - width - 1;
                            for (x = 0; x < width; ++x) {
                                tmp = data[z++];
                                BPGraphics.data[BPGraphics.dataptr++] = tmp;
                                adler2 += (adler1 += tmp & 0xFF);
                                adler1 %= 65521;
                                adler2 %= 65521;
                            }
                        }
                        break block66;
                    }
                    case 1: {
                        byte tmp;
                        int z;
                        int x;
                        int y;
                        for (y = widthSrc; y > 0; --y) {
                            if (currBlock > 0 && (widthSrc - y << 1) % numLinesPerBlock == 0) {
                                BPGraphics.writeBlockStart();
                            }
                            _offset = (transform & 4) == 0 ? heightSrc * widthSrc - y : widthSrc - y;
                            BPGraphics.data[BPGraphics.dataptr++] = 0;
                            adler2 += adler1;
                            adler1 %= 65521;
                            adler2 %= 65521;
                            for (x = 0; x < heightSrc; ++x) {
                                BPGraphics.data[BPGraphics.dataptr++] = idata[_offset];
                                adler2 += (adler1 += idata[_offset] & 0xFF);
                                adler1 %= 65521;
                                adler2 %= 65521;
                                BPGraphics.data[BPGraphics.dataptr++] = idata[_offset];
                                adler2 += (adler1 += idata[_offset] & 0xFF);
                                adler1 %= 65521;
                                adler2 %= 65521;
                                if ((transform & 4) == 0) {
                                    _offset -= widthSrc;
                                    continue;
                                }
                                _offset += widthSrc;
                            }
                            BPGraphics.data[BPGraphics.dataptr++] = 0;
                            adler2 += adler1;
                            adler1 %= 65521;
                            adler2 %= 65521;
                            z = dataptr - height - 1;
                            for (x = 0; x < height; ++x) {
                                tmp = data[z++];
                                BPGraphics.data[BPGraphics.dataptr++] = tmp;
                                adler2 += (adler1 += tmp & 0xFF);
                                adler1 %= 65521;
                                adler2 %= 65521;
                            }
                        }
                        break block66;
                    }
                    case 2: {
                        byte tmp;
                        int z;
                        int x;
                        int y;
                        for (y = heightSrc; y > 0; --y) {
                            if (currBlock > 0 && (heightSrc - y << 1) % numLinesPerBlock == 0) {
                                BPGraphics.writeBlockStart();
                            }
                            _offset = (transform & 4) == 0 ? y * widthSrc - 1 : (y - 1) * widthSrc;
                            BPGraphics.data[BPGraphics.dataptr++] = 0;
                            adler2 += adler1;
                            adler1 %= 65521;
                            adler2 %= 65521;
                            for (x = 0; x < widthSrc; ++x) {
                                BPGraphics.data[BPGraphics.dataptr++] = idata[_offset];
                                adler2 += (adler1 += idata[_offset] & 0xFF);
                                adler1 %= 65521;
                                adler2 %= 65521;
                                BPGraphics.data[BPGraphics.dataptr++] = idata[_offset];
                                adler2 += (adler1 += idata[_offset] & 0xFF);
                                adler1 %= 65521;
                                adler2 %= 65521;
                                if ((transform & 4) == 0) {
                                    --_offset;
                                    continue;
                                }
                                ++_offset;
                            }
                            BPGraphics.data[BPGraphics.dataptr++] = 0;
                            adler2 += adler1;
                            adler1 %= 65521;
                            adler2 %= 65521;
                            z = dataptr - width - 1;
                            for (x = 0; x < width; ++x) {
                                tmp = data[z++];
                                BPGraphics.data[BPGraphics.dataptr++] = tmp;
                                adler2 += (adler1 += tmp & 0xFF);
                                adler1 %= 65521;
                                adler2 %= 65521;
                            }
                        }
                        break block66;
                    }
                    case 3: {
                        byte tmp;
                        int z;
                        int x;
                        int y;
                        for (y = widthSrc; y > 0; --y) {
                            if (currBlock > 0 && (widthSrc - y << 1) % numLinesPerBlock == 0) {
                                BPGraphics.writeBlockStart();
                            }
                            _offset = (transform & 4) == 0 ? y - 1 : widthSrc * (heightSrc - 1) + y - 1;
                            BPGraphics.data[BPGraphics.dataptr++] = 0;
                            adler2 += adler1;
                            adler1 %= 65521;
                            adler2 %= 65521;
                            for (x = 0; x < heightSrc; ++x) {
                                BPGraphics.data[BPGraphics.dataptr++] = idata[_offset];
                                adler2 += (adler1 += idata[_offset] & 0xFF);
                                adler1 %= 65521;
                                adler2 %= 65521;
                                BPGraphics.data[BPGraphics.dataptr++] = idata[_offset];
                                adler2 += (adler1 += idata[_offset] & 0xFF);
                                adler1 %= 65521;
                                adler2 %= 65521;
                                if ((transform & 4) == 0) {
                                    _offset += widthSrc;
                                    continue;
                                }
                                _offset -= widthSrc;
                            }
                            BPGraphics.data[BPGraphics.dataptr++] = 0;
                            adler2 += adler1;
                            adler1 %= 65521;
                            adler2 %= 65521;
                            z = dataptr - height - 1;
                            for (x = 0; x < height; ++x) {
                                tmp = data[z++];
                                BPGraphics.data[BPGraphics.dataptr++] = tmp;
                                adler2 += (adler1 += tmp & 0xFF);
                                adler1 %= 65521;
                                adler2 %= 65521;
                            }
                        }
                        break;
                    }
                }
                break block66;
            }
            _srcPtr = false;
            switch (transform & 3) {
                case 0: {
                    int x;
                    int y;
                    for (y = 0; y < height; ++y) {
                        if (currBlock > 0 && y % numLinesPerBlock == 0) {
                            BPGraphics.writeBlockStart();
                        }
                        _offset = (transform & 4) == 0 ? y * width : (y + 1) * width - 1;
                        BPGraphics.data[BPGraphics.dataptr++] = 0;
                        adler2 += adler1;
                        adler1 %= 65521;
                        adler2 %= 65521;
                        for (x = 0; x < width; ++x) {
                            BPGraphics.data[BPGraphics.dataptr++] = idata[_offset];
                            adler2 += (adler1 += idata[_offset] & 0xFF);
                            adler1 %= 65521;
                            adler2 %= 65521;
                            if ((transform & 4) == 0) {
                                ++_offset;
                                continue;
                            }
                            --_offset;
                        }
                    }
                    break;
                }
                case 1: {
                    int x;
                    int y;
                    for (y = width; y > 0; --y) {
                        if (currBlock > 0 && (width - y) % numLinesPerBlock == 0) {
                            BPGraphics.writeBlockStart();
                        }
                        _offset = (transform & 4) == 0 ? height * width - y : width - y;
                        BPGraphics.data[BPGraphics.dataptr++] = 0;
                        adler2 += adler1;
                        adler1 %= 65521;
                        adler2 %= 65521;
                        for (x = 0; x < height; ++x) {
                            BPGraphics.data[BPGraphics.dataptr++] = idata[_offset];
                            adler2 += (adler1 += idata[_offset] & 0xFF);
                            adler1 %= 65521;
                            adler2 %= 65521;
                            if ((transform & 4) == 0) {
                                _offset -= width;
                                continue;
                            }
                            _offset += width;
                        }
                    }
                    break;
                }
                case 2: {
                    int x;
                    int y;
                    for (y = height; y > 0; --y) {
                        if (currBlock > 0 && (height - y) % numLinesPerBlock == 0) {
                            BPGraphics.writeBlockStart();
                        }
                        _offset = (transform & 4) == 0 ? y * width - 1 : (y - 1) * width;
                        BPGraphics.data[BPGraphics.dataptr++] = 0;
                        adler2 += adler1;
                        adler1 %= 65521;
                        adler2 %= 65521;
                        for (x = 0; x < width; ++x) {
                            BPGraphics.data[BPGraphics.dataptr++] = idata[_offset];
                            adler2 += (adler1 += idata[_offset] & 0xFF);
                            adler1 %= 65521;
                            adler2 %= 65521;
                            if ((transform & 4) == 0) {
                                --_offset;
                                continue;
                            }
                            ++_offset;
                        }
                    }
                    break;
                }
                case 3: {
                    int x;
                    int y;
                    for (y = width; y > 0; --y) {
                        if (currBlock > 0 && (width - y) % numLinesPerBlock == 0) {
                            BPGraphics.writeBlockStart();
                        }
                        _offset = (transform & 4) == 0 ? y - 1 : width * (height - 1) + y - 1;
                        BPGraphics.data[BPGraphics.dataptr++] = 0;
                        adler2 += adler1;
                        adler1 %= 65521;
                        adler2 %= 65521;
                        for (x = 0; x < height; ++x) {
                            BPGraphics.data[BPGraphics.dataptr++] = idata[_offset];
                            adler2 += (adler1 += idata[_offset] & 0xFF);
                            adler1 %= 65521;
                            adler2 %= 65521;
                            if ((transform & 4) == 0) {
                                _offset += width;
                                continue;
                            }
                            _offset -= width;
                        }
                    }
                    break;
                }
            }
        }
        BPGraphics.writeInt(adler2 << 16 | adler1);
        BPGraphics.writeInt(BPGraphics.calc_crc(data, crcfrom, dataptr - crcfrom));
        for (i = 0; i < PNG_End.length; ++i) {
            BPGraphics.data[BPGraphics.dataptr++] = PNG_End[i];
        }
        Image temp = Image.createImage((byte[])data, (int)0, (int)dataptr);
        data = null;
        return temp;
    }

    static void writeBlockStart() {
        if (currBlock <= blockCount) {
            BPGraphics.data[BPGraphics.dataptr++] = blockStart[0];
            BPGraphics.data[BPGraphics.dataptr++] = blockStart[1];
            BPGraphics.data[BPGraphics.dataptr++] = blockStart[2];
            BPGraphics.data[BPGraphics.dataptr++] = blockStart[3];
            BPGraphics.data[BPGraphics.dataptr++] = blockStart[4];
            ++currBlock;
        } else {
            BPGraphics.data[BPGraphics.dataptr++] = finalBlockStart[0];
            BPGraphics.data[BPGraphics.dataptr++] = finalBlockStart[1];
            BPGraphics.data[BPGraphics.dataptr++] = finalBlockStart[2];
            BPGraphics.data[BPGraphics.dataptr++] = finalBlockStart[3];
            BPGraphics.data[BPGraphics.dataptr++] = finalBlockStart[4];
        }
    }

    static void writeInt(long crc) {
        BPGraphics.data[BPGraphics.dataptr++] = (byte)(crc >>> 24 & 0xFFL);
        BPGraphics.data[BPGraphics.dataptr++] = (byte)(crc >>> 16 & 0xFFL);
        BPGraphics.data[BPGraphics.dataptr++] = (byte)(crc >>> 8 & 0xFFL);
        BPGraphics.data[BPGraphics.dataptr++] = (byte)(crc & 0xFFL);
    }

    static long calc_crc(byte[] buf, int off, int len) {
        int c = -1;
        while (--len >= 0) {
            c = crc_table[(c ^ buf[off++]) & 0xFF] ^ c >>> 8;
        }
        return (long)(~c) & 0xFFFFFFFFL;
    }

    static {
        PNG_header = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 0, 0, 0, 0, 0, 8, 3, 0, 0, 0};
        PNG_End = new byte[]{0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
        blockStart = new byte[]{0, 0, 0, 0, 0};
        finalBlockStart = new byte[]{1, 0, 0, 0, 0};
        blockCount = 0;
        currBlock = 0;
        crc_table = new int[256];
        for (int n = 0; n < 256; ++n) {
            int c = n;
            int k = 8;
            while (--k >= 0) {
                if ((c & 1) != 0) {
                    c = 0xEDB88320 ^ c >>> 1;
                    continue;
                }
                c >>>= 1;
            }
            BPGraphics.crc_table[n] = c;
        }
    }
}

