/*
 * Decompiled with CFR 0.152.
 */
package com.movilenio.game;

import com.movilenio.game.GameSection;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class Kernel
extends Canvas
implements Runnable {
    public static Kernel instance;
    public Thread thread;
    private boolean a;
    private MIDlet b;
    private boolean c;
    public boolean bPause;
    public boolean bVisible;
    public byte[] keyMap;
    public short keyStatus;
    public static final byte K_UP = 0;
    public static final byte K_DOWN = 1;
    public static final byte K_LEFT = 2;
    public static final byte K_RIGHT = 3;
    public static final byte K_A = 4;
    public static final byte K_B = 5;
    public static final byte K_C = 6;
    public static final byte K_D = 7;
    public static final byte K_CUP = 8;
    public static final byte K_CDOWN = 9;
    public static final byte K_CLEFT = 10;
    public static final byte K_CRIGHT = 11;
    public static final byte K_CFIRE = 12;
    public static final byte K_SK_LEFT = 13;
    public static final byte K_SK_RIGHT = 14;
    public static final byte K_OK = 13;
    public static final byte K_CANCEL = 14;
    public static final byte K_UP_LEFT = 15;
    public static final byte K_UP_RIGHT = 16;
    public static final byte K_DOWN_LEFT = 17;
    public static final byte K_DOWN_RIGHT = 18;
    public static final byte SND_LOOP = 1;
    public long frameTicks;
    public GameSection gameSection;
    private boolean d;
    private Image e;
    private Graphics f;

    private Kernel(MIDlet mIDlet) {
        this.b = mIDlet;
        this.a = true;
        this.c = false;
        this.bPause = false;
        this.bVisible = true;
        this.keyStatus = 0;
        this.frameTicks = 66L;
        this.setFullScreenMode(true);
        this.keyMap = this.loadResource("/keymap.bin");
    }

    public static Kernel createInstance(MIDlet mIDlet) {
        instance = new Kernel(mIDlet);
        Display.getDisplay((MIDlet)mIDlet).setCurrent((Displayable)instance);
        Kernel.instance.thread = new Thread(instance);
        Kernel.instance.thread.start();
        return instance;
    }

    public void paint(Graphics graphics) {
        if (this.bVisible && this.gameSection != null) {
            if (this.isDoubleBuffered()) {
                this.gameSection.paint(graphics);
                return;
            }
            if (this.e == null) {
                this.e = Image.createImage((int)this.getWidth(), (int)this.getHeight());
                this.f = this.e.getGraphics();
            }
            this.gameSection.paint(this.f);
            graphics.drawImage(this.e, 0, 0, 0);
        }
    }

    public void run() {
        while (!this.c) {
            if (this.bVisible) {
                long l = System.currentTimeMillis();
                if (!this.bPause && this.gameSection != null) {
                    this.gameSection.doFrame();
                }
                this.repaint();
                this.serviceRepaints();
                l = System.currentTimeMillis() - l;
                if (l >= this.frameTicks) continue;
                try {
                    Thread.sleep(this.frameTicks - l);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.bPause = false;
        this.c = false;
        this.setGameSection(null);
        instance = null;
        if (this.a) {
            this.b.notifyDestroyed();
        }
    }

    public final synchronized void stop(boolean bl) {
        this.a = bl;
        this.c = true;
    }

    public final synchronized void stop() {
        this.stop(true);
    }

    public synchronized void setGameSection(GameSection gameSection) {
        if (this.gameSection != null) {
            this.gameSection.endSection();
            if (!this.d) {
                this.gameSection.freeResources();
            }
            this.gameSection = null;
        }
        if (gameSection != null) {
            this.d = gameSection.resourcesLoaded;
            if (!this.d) {
                gameSection.loadResources();
            }
            if (gameSection.initSection()) {
                if (!this.bVisible) {
                    gameSection.show(false);
                }
                this.gameSection = gameSection;
            }
        }
    }

    public void keyPressed(int n) {
        boolean bl = false;
        for (int i = 14; i >= 0; --i) {
            if (n != this.keyMap[i]) continue;
            this.keyStatus = (short)(this.keyStatus | 1 << i);
            bl = true;
            break;
        }
        if (!bl) {
            if (n == this.keyMap[15]) {
                this.keyStatus = (short)(this.keyStatus | 5);
            } else if (n == this.keyMap[16]) {
                this.keyStatus = (short)(this.keyStatus | 9);
            } else if (n == this.keyMap[17]) {
                this.keyStatus = (short)(this.keyStatus | 6);
            } else if (n == this.keyMap[18]) {
                this.keyStatus = (short)(this.keyStatus | 0xA);
            }
        }
        if (this.bVisible && this.gameSection != null) {
            this.gameSection.keyPressed(n);
        }
    }

    public void keyReleased(int n) {
        boolean bl = false;
        for (int i = 14; i >= 0; --i) {
            if (n != this.keyMap[i]) continue;
            this.keyStatus = (short)(this.keyStatus & ~(1 << i));
            bl = true;
            break;
        }
        if (!bl) {
            if (n == this.keyMap[15]) {
                this.keyStatus = (short)(this.keyStatus & 0xFFFFFFFA);
            } else if (n == this.keyMap[16]) {
                this.keyStatus = (short)(this.keyStatus & 0xFFFFFFF6);
            } else if (n == this.keyMap[17]) {
                this.keyStatus = (short)(this.keyStatus & 0xFFFFFFF9);
            } else if (n == this.keyMap[18]) {
                this.keyStatus = (short)(this.keyStatus & 0xFFFFFFF5);
            }
        }
        if (this.bVisible && this.gameSection != null) {
            this.gameSection.keyReleased(n);
        }
    }

    public final boolean getKeyPressedStatus(int n) {
        return (this.keyStatus & 1 << n) != 0;
    }

    public final void setKeyPressedStatus(int n, boolean bl) {
        if (bl) {
            this.keyStatus = (short)(this.keyStatus | 1 << n);
            return;
        }
        this.keyStatus = (short)(this.keyStatus & ~(1 << n));
    }

    public synchronized void pause(boolean bl) {
        this.bPause = bl;
    }

    public void hideNotify() {
        this.bVisible = false;
        this.bPause = true;
        if (this.gameSection != null) {
            this.gameSection.show(false);
        }
    }

    public void showNotify() {
        this.bVisible = true;
        if (this.gameSection != null) {
            this.gameSection.show(true);
            return;
        }
        this.bPause = false;
    }

    public Object openSound(String string, String string2) {
        Player player = null;
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            if (inputStream != null) {
                player = Manager.createPlayer((InputStream)inputStream, (String)string2);
            }
        }
        catch (Exception exception) {}
        return player;
    }

    public void closeSound(Object object) {
        if (object != null) {
            ((Player)object).deallocate();
            ((Player)object).close();
        }
    }

    public void playSound(Object object, int n) {
        if (object == null) {
            return;
        }
        try {
            if ((n & 1) != 0) {
                ((Player)object).setLoopCount(-1);
            }
            ((Player)object).prefetch();
            ((Player)object).start();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void stopSound(Object object) {
        if (object != null) {
            try {
                ((Player)object).stop();
                return;
            }
            catch (Exception exception) {}
        }
    }

    public Object openMusic(String string, String string2) {
        return this.openSound(string, string2);
    }

    public void closeMusic(Object object) {
        this.closeSound(object);
    }

    public void playMusic(Object object, int n) {
        this.playSound(object, n);
    }

    public void stopMusic(Object object) {
        this.stopSound(object);
    }

    public void playTone(int n, int n2, int n3) {
        try {
            Manager.playTone((int)n, (int)n2, (int)n3);
            return;
        }
        catch (MediaException mediaException) {
            return;
        }
    }

    public void vibrate(int n) {
        Display.getDisplay((MIDlet)this.b).vibrate(n);
    }

    public static void writeInt(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >>> 24);
        byArray[n2 + 1] = (byte)(n >>> 16);
        byArray[n2 + 2] = (byte)(n >>> 8);
        byArray[n2 + 3] = (byte)n;
    }

    public static int readInt(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    public static byte[][] loadRMS(String string, int n) {
        Object object = null;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)false);
            int n2 = recordStore.getNumRecords();
            object = new byte[n2][];
            for (int i = 0; i < n2; ++i) {
                object[i] = recordStore.getRecord(i + 1);
            }
        }
        catch (Exception exception) {}
        return object;
    }

    public static void saveRMS(String string, byte[][] byArray, int n) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            for (int i = 0; i < byArray.length; ++i) {
                if (recordStore.getNumRecords() < i + 1) {
                    recordStore.addRecord(byArray[i], 0, byArray[i].length);
                    continue;
                }
                recordStore.setRecord(i + 1, byArray[i], 0, byArray[i].length);
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static final void readStreamData(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = inputStream.read(byArray, n, n2);
            n += n3;
            n2 -= n3;
        }
    }

    public byte[] loadResource(String string) {
        byte[] byArray = null;
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream != null) {
            try {
                int n;
                byte[] byArray2 = new byte[1024];
                while ((n = inputStream.read(byArray2)) != -1) {
                    int n2 = byArray != null ? byArray.length : 0;
                    byte[] byArray3 = new byte[n2 + n];
                    if (byArray != null) {
                        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                    }
                    System.arraycopy(byArray2, 0, byArray3, n2, n);
                    byArray = byArray3;
                    if (n >= byArray2.length) continue;
                    break;
                }
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return byArray;
    }

    public Image loadImage(String string) {
        Image image = null;
        try {
            image = Image.createImage((String)string);
        }
        catch (IOException iOException) {}
        return image;
    }
}

