/*
 * Decompiled with CFR 0.152.
 */
import com.dvidearts.dvj2me.dvPoint;
import com.dvidearts.dvj2me.dvScreen;
import com.dvidearts.dvj2me.dvUtil;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

public class ManageGames
extends dvScreen {
    private Game game;
    private byte cursor;
    public byte mode;
    private int nameX;
    private int nameY;
    private String[] time;
    private String[] name;
    private static final byte NUM_OPTIONS = 3;
    public static final byte MG_LOAD = 0;
    public static final byte MG_DELETE = 1;

    public ManageGames(Game g) {
        this.game = g;
        this.mode = 0;
        this.nameX = this.game.x + this.game.resw / 16;
        this.nameY = this.game.y + this.game.sprOptions.getHeight() + this.game.resh / 16;
        switch (this.game.buildType) {
            case 0: {
                this.nameY = (short)(this.game.y + this.game.sprOptions.getHeight() + 20);
            }
        }
        this.cursor = 0;
        this.name = new String[3];
        this.time = new String[3];
        this.reset();
    }

    public void reset() {
        for (int i = 0; i < 3; ++i) {
            this.name[i] = i + 1 + ".";
            if (this.game.sinfo[i].name.length() > 0) {
                int n = i;
                this.name[n] = this.name[n] + this.game.sinfo[i].name;
            }
            if (this.game.sinfo[i].minsPlayed <= 0L) continue;
            int hours = (int)(this.game.sinfo[i].minsPlayed / 60L);
            int mins = (int)(this.game.sinfo[i].minsPlayed % 60L);
            this.game.temp = mins < 10 ? "0" + mins : "" + mins;
            this.time[i] = "time (" + hours + ":" + this.game.temp + ")";
        }
    }

    public void Show() {
        if (this.game.buildType == 0) {
            this.game.controls.show(true);
            this.game.controls.setLeftCmdVisible(true);
            this.game.controls.setRightCmdVisible(true);
            this.game.controls.setLeftCmd(2);
            this.game.controls.setRightCmd(1);
        }
    }

    public void Hide() {
        if (this.game.buildType == 0) {
            this.game.controls.show(true);
            this.game.controls.setLeftCmdVisible(false);
            this.game.controls.setRightCmdVisible(false);
        }
    }

    public void Render(Graphics g) {
        this.game.dvrender.ClearScreen(g, 0, 0, 0);
        g.drawImage(this.game.imgClouds, this.game.dvGetMidWidth(), this.game.dvGetMidHeight(), 3);
        this.game.sprOptions.setPosition(this.game.wcenter - this.game.sprOptions.getWidth() / 2, this.game.y);
        if (this.mode == 0) {
            this.game.sprOptions.setFrame(4);
        } else {
            this.game.sprOptions.setFrame(0);
        }
        this.game.sprOptions.paint(g);
        if (!this.game.dvpopup.IsActive()) {
            int i;
            for (i = 0; i < 3; ++i) {
                int tmpY = this.nameY + i * this.game.cfont.getHeight() * 4;
                if (this.game.buildType == 0 && this.cursor == i) {
                    g.drawImage(this.game.imgFontbox, this.game.reswc - this.game.imgFontbox.getWidth() / 2, tmpY + this.game.cfont.getHeight() / 2 - this.game.imgFontbox.getHeight() / 2, 20);
                }
                this.game.cfont.drawString(g, this.name[i], this.nameX + 2, tmpY);
                if (this.game.buildType == 0 && this.cursor == i && this.game.currframe > 2) {
                    this.game.cfont2.drawString(g, this.name[i], this.nameX + 2, tmpY);
                }
                if (this.game.sinfo[i].minsPlayed <= 0L) continue;
                if (this.game.buildType == 0 || this.game.buildType == 1) {
                    this.game.smallfont.drawString(g, this.time[i], this.nameX + 2 + this.game.cfont.getWidth() * 2, tmpY + this.game.cfont.getHeight() + 3);
                    continue;
                }
                this.game.cfont.drawString(g, this.time[i], this.nameX + 2 + this.game.cfont.getWidth() * 2, tmpY + this.game.cfont.getHeight() + 3);
            }
            if (this.game.buildType != 0 && this.game.currframe % 10 != 0) {
                g.setColor(255, 0, 0);
                for (i = 0; i < 3; ++i) {
                    if (this.cursor != i) continue;
                    g.drawRect(this.nameX, this.nameY + i * this.game.cfont.getHeight() * 4 - 2, this.game.resw - this.game.resw / 16 * 2, this.game.cfont.getHeight() + 2);
                    break;
                }
            }
        }
        if (this.game.buildType == 0) {
            this.game.controls.Render(g);
        } else if (!this.game.dvpopup.IsActive()) {
            this.game.drawCommand(g, (byte)2, (byte)0);
            this.game.drawCommand(g, (byte)1, (byte)2);
        }
    }

    private void doNext() {
        if (this.game.sinfo[this.cursor].name.length() > 0) {
            if (this.mode == 0) {
                this.game.infoSlot = this.cursor;
                Loader loader = this.game.loader;
                this.game.loader.getClass();
                loader.init("Loading", (byte)2, this.game.reswc - this.game.loader.width / 2, this.game.reshc, true);
                this.game.setGameState((byte)3);
            } else {
                this.game.dvpopup.clearText();
                this.game.temp = "Delete?";
                this.game.dvpopup.addLineText(this.game.temp, false);
                this.game.dvpopup.addLineText(this.game.sinfo[this.cursor].name, false);
                this.game.dvpopup.confirm(Text.txtYES, Text.txtNO);
            }
        } else {
            this.game.dvpopup.clearText();
            this.game.temp = "No entry";
            this.game.dvpopup.addLineText(this.game.temp, false);
            this.game.dvpopup.flash(20);
        }
    }

    public void keyPressed(int gameAction) {
        if (this.game.wipe.IsActive()) {
            return;
        }
        if (this.game.dvpopup.IsActive()) {
            int result = this.game.dvpopup.keyPressed(gameAction);
            if (result == 1) {
                this.game.sinfo[this.cursor] = null;
                this.game.sinfo[this.cursor] = new SaveInfo();
                this.game.infoSlot = this.cursor;
                this.reset();
                this.game.title.newgame.Show();
                this.game.title.currScreen = 1;
            } else if (result == 0) {
                // empty if block
            }
            return;
        }
        switch (this.game.dvrender.getInput()) {
            case '*': {
                this.game.title.currScreen = 0;
                this.Hide();
                break;
            }
            case '0': {
                break;
            }
            case '#': {
                this.doNext();
            }
        }
        switch (gameAction) {
            case 1: 
            case 2: {
                this.cursor = (byte)(this.cursor - 1);
                if (this.cursor >= 0) break;
                this.cursor = (byte)2;
                break;
            }
            case 5: 
            case 6: {
                this.cursor = (byte)(this.cursor + 1);
                if (this.cursor <= 2) break;
                this.cursor = 0;
                break;
            }
            case 8: {
                this.doNext();
            }
        }
    }

    public void commandAction(Command command, Displayable arg1) {
        if (command == this.game.cmdExit) {
            this.game.SaveSettings();
            this.game.close();
        }
    }

    public void pointerPressed(dvPoint point) {
        for (int i = 0; i < 3; ++i) {
            int tmpY;
            if (this.game.buildType == 0 || !dvUtil.dvClickRect(point, this.game.x, tmpY = this.nameY + i * this.game.cfont.getHeight() * 4, this.game.dvGetWidth(), this.game.cfont.getHeight())) continue;
            this.cursor = (byte)i;
            return;
        }
        if (this.game.buildType == 0) {
            this.game.controls.touchBegan(point);
            if (this.game.controls.isBeganOK()) {
                this.keyPressed(8);
            } else if (this.game.controls.isBeganDown()) {
                this.keyPressed(6);
            } else if (this.game.controls.isBeganUp()) {
                this.keyPressed(1);
            } else if (this.game.controls.isBeganLeft()) {
                this.keyPressed(2);
            } else if (this.game.controls.isBeganRight()) {
                this.keyPressed(5);
            } else if (this.game.controls.isBeganCmdLeft()) {
                if (!this.game.dvpopup.IsActive()) {
                    this.game.title.currScreen = 0;
                    this.Hide();
                }
            } else if (this.game.controls.isBeganCmdRight() && !this.game.dvpopup.IsActive()) {
                this.doNext();
            }
        } else if (!this.game.dvpopup.IsActive()) {
            if (this.game.clickCommand(point, (byte)0)) {
                this.game.title.currScreen = 0;
                this.Hide();
            } else if (this.game.clickCommand(point, (byte)2)) {
                this.doNext();
            }
        }
    }

    public void pointerReleased(dvPoint point) {
    }

    public void pointerDragged(dvPoint point, dvPoint amount) {
    }

    public void Load() {
    }

    public void Free() {
    }

    public void Process(int arg0) {
    }

    public void keyReleased(int arg0) {
    }
}

