/*
 * Decompiled with CFR 0.152.
 */
import com.dvidearts.dvj2me.dvPoint;
import com.dvidearts.dvj2me.dvScreen;
import com.dvidearts.dvj2me.dvTouchKeyboard;
import com.dvidearts.dvj2me.dvVirtualKeyboard;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

public class NewGame
extends dvScreen {
    private Game game;
    private dvVirtualKeyboard kb = null;
    private dvTouchKeyboard vk = null;

    public NewGame(Game g) {
        this.game = g;
        if (this.game.buildType == 0) {
            this.vk = new dvTouchKeyboard(this.game, this.game.vkfont, this.game.dvGetMidWidth(), this.game.dvGetTrueMidHeight() - 40);
            this.vk.setKey(Game.PATH_320x480 + "keyblack.png");
            this.vk.setTextboxImage(Game.PATH_320x480 + "textboxblack.png", 20, 42);
            this.vk.setCaretImage(Game.PATH_320x480 + "caretwhite.png");
        } else {
            this.kb = new dvVirtualKeyboard(this.game.cfont, this.game.reswc, this.game.reshc, this.game.resw, this.game.resh);
        }
    }

    public void Free() {
        this.kb = null;
        this.vk = null;
    }

    public void Show() {
        if (this.game.buildType == 0) {
            this.vk.reset();
            this.vk.clearTextbox();
            this.vk.hide();
            this.vk.slideIn(25);
            this.game.controls.show(false);
        } else {
            this.kb.reset();
            this.kb.clearTextbox();
        }
    }

    public void Hide() {
        if (this.game.buildType == 0) {
            this.game.controls.show(true);
            this.game.controls.setLeftCmdVisible(false);
            this.game.controls.setRightCmdVisible(false);
        }
    }

    public void Render(Graphics g) {
        this.game.dvpopup.center = true;
        this.game.dvrender.ClearScreen(g, 0, 0, 0);
        if (this.game.buildType == 0) {
            g.drawImage(this.game.imgClouds2, (int)this.game.x, (int)this.game.y, 20);
        } else {
            g.drawImage(this.game.imgClouds, this.game.dvGetMidWidth(), this.game.dvGetMidHeight(), 3);
        }
        this.game.sprOptions.setFrame(2);
        this.game.sprOptions.setPosition(this.game.wcenter - this.game.sprOptions.getWidth() / 2, this.game.y);
        this.game.sprOptions.paint(g);
        if (this.game.dvpopup.IsActive()) {
            return;
        }
        if (this.game.buildType == 0) {
            this.vk.paint(g);
        } else {
            this.kb.paint(g);
        }
        if (this.game.isDemo) {
            if (this.game.currframe % 10 != 0) {
                g.setColor(255, 0, 0);
            }
            int fx = this.game.reswc - this.game.smallfont.stringWidth(Text.txtNoSaveDemo) / 2;
            int fy = this.game.y + this.game.resh / 20 * 16;
            g.fillRect(fx - 2, fy - 2, this.game.smallfont.stringWidth(Text.txtNoSaveDemo) + 2, this.game.smallfont.getHeight() + 2);
            this.game.smallfont.drawString(g, Text.txtNoSaveDemo, fx, fy);
        }
        if (!this.game.dvpopup.IsActive()) {
            this.game.drawCommand(g, (byte)2, (byte)0);
            this.game.drawCommand(g, (byte)1, (byte)2);
        }
        if (this.game.buildType == 0) {
            this.game.controls.Render(g);
        }
    }

    private void doNext() {
        int len = 0;
        String tempName = "";
        if (this.game.buildType == 0) {
            len = this.vk.getTextboxValue().length();
            tempName = this.vk.getTextboxValue();
        } else {
            len = this.kb.getTextboxValue().length();
            tempName = this.kb.getTextboxValue();
        }
        if (len > 0) {
            boolean error = false;
            for (int i = 0; i < 3; ++i) {
                if (!this.game.sinfo[i].name.equals(tempName)) continue;
                error = true;
                this.game.dvpopup.clearText();
                this.game.temp = "Name Already";
                this.game.dvpopup.addLineText(this.game.temp, false);
                this.game.temp = "exist";
                this.game.dvpopup.addLineText(this.game.temp, false);
                this.game.dvpopup.flash(20);
                break;
            }
            if (!error) {
                boolean found = false;
                for (int i = 0; i < 3; i = (int)((byte)(i + 1))) {
                    if (this.game.sinfo[i].name.length() != 0) continue;
                    this.game.infoSlot = (byte)i;
                    this.game.sinfo[i].name = tempName;
                    this.game.SaveSettings();
                    found = true;
                    break;
                }
                if (found) {
                    tempName = null;
                    Loader loader = this.game.loader;
                    this.game.loader.getClass();
                    loader.init("Loading", (byte)1, this.game.reswc - this.game.loader.width / 2, this.game.reshc, true);
                    this.game.setGameState((byte)3);
                } else {
                    this.game.dvpopup.clearText();
                    this.game.temp = "Game Full";
                    this.game.dvpopup.addLineText(this.game.temp, false);
                    this.game.dvpopup.flash(20);
                }
            }
        } else {
            this.game.dvpopup.clearText();
            this.game.temp = "Blank Name";
            this.game.dvpopup.addLineText(this.game.temp, false);
            this.game.dvpopup.flash(20);
            if (this.game.buildType == 0) {
                this.vk.clearTextbox();
            } else {
                this.kb.clearTextbox();
            }
        }
    }

    public void keyPressed(int gameAction) {
        if (this.game.wipe.IsActive()) {
            return;
        }
        if (this.game.dvpopup.IsActive()) {
            this.game.dvpopup.keyPressed(gameAction);
            return;
        }
        switch (this.game.dvrender.getInput()) {
            case '*': {
                this.game.title.currScreen = 0;
                this.Hide();
                break;
            }
            case '0': {
                break;
            }
            case '#': {
                this.doNext();
            }
        }
        if (this.kb != null) {
            switch (gameAction) {
                case 6: {
                    this.kb.moveCursorDown();
                    break;
                }
                case 1: {
                    this.kb.moveCursorUp();
                    break;
                }
                case 2: {
                    this.kb.moveCursorLeft();
                    break;
                }
                case 5: {
                    this.kb.moveCursorRight();
                    break;
                }
                case 8: {
                    this.kb.selectCharacter();
                }
            }
        }
    }

    public void commandAction(Command command, Displayable arg1) {
        if (command == this.game.cmdExit) {
            this.game.SaveSettings();
            this.game.close();
        }
    }

    public void pointerPressed(dvPoint point) {
        if (this.game.buildType == 0) {
            this.vk.click(point);
        } else {
            this.kb.click(point);
        }
        if (this.game.clickCommand(point, (byte)0)) {
            this.game.title.currScreen = 0;
            this.Hide();
        } else if (this.game.clickCommand(point, (byte)2)) {
            this.doNext();
        }
    }

    public void pointerReleased(dvPoint point) {
    }

    public void pointerDragged(dvPoint point, dvPoint amount) {
    }

    public void Load() {
    }

    public void Process(int arg0) {
    }

    public void keyReleased(int arg0) {
    }
}

