/*
 * Decompiled with CFR 0.152.
 */
package com.dvidearts.dvj2me;

import com.dvidearts.dvj2me.dvCustomFont;
import com.dvidearts.dvj2me.dvPoint;
import com.dvidearts.dvj2me.dvUtil;
import javax.microedition.lcdui.Graphics;

public class dvVirtualKeyboard {
    private final byte YOFFESET = (byte)-5;
    private final byte BORDER_OFFSET = (byte)2;
    private final byte MAX_NAME_SIZE = (byte)10;
    private byte caretPos;
    private byte numchars;
    private short cursorx;
    private short cursory;
    private short lastkey;
    private short cursor;
    private short textboxX;
    private short textboxY;
    private short gridcellW;
    private short gridcellH;
    private byte numRows = (byte)5;
    private byte numCols = (byte)10;
    private short[] gridx = new short[this.numCols];
    private short[] gridy = new short[this.numRows];
    private byte[] textbox = new byte[10];
    private byte currfrm;
    private dvCustomFont cf;
    private String temp = "";

    public dvVirtualKeyboard(dvCustomFont cfont, int xCenter, int yCenter, int screenWidth, int screenHeight) {
        this.lastkey = (short)-1;
        this.cf = cfont;
        this.gridcellW = (short)(this.cf.getWidth() + 1);
        this.gridcellH = this.cf.getHeight();
        this.gridx[0] = (short)(xCenter - this.gridcellW * this.numCols / 2);
        int i = 0;
        while (i < this.numCols - 1) {
            this.gridx[i + 1] = (short)(this.gridx[i] + this.gridcellW);
            ++i;
        }
        int yspacing = 2;
        this.gridy[this.numRows - 1] = (short)(yCenter + (this.gridcellH * this.numRows + yspacing * this.numRows + this.gridcellH * 2 + 4) / 2 + -5);
        int i2 = this.numRows - 1;
        while (i2 > 0) {
            this.gridy[i2 - 1] = (short)(this.gridy[i2] - this.gridcellH - yspacing);
            --i2;
        }
        this.textboxX = (short)(xCenter - this.cf.getWidth() * 10 / 2);
        this.textboxY = (short)(this.gridy[0] - (this.cf.getHeight() + this.gridcellH + 4));
        this.numchars = 0;
        this.reset();
    }

    public void reset() {
        this.currfrm = 0;
        this.cursor = 0;
        this.cursorx = 0;
        this.cursory = 0;
        this.caretPos = this.numchars;
        if (this.caretPos > 9) {
            this.caretPos = (byte)9;
        }
    }

    private void update() {
        this.currfrm = (byte)(this.currfrm + 1);
        if (this.currfrm > 9) {
            this.currfrm = 0;
        }
    }

    private void updateCursor() {
        this.cursorx = (short)(this.cursor % this.numCols);
        this.cursory = (short)(this.cursor / this.numCols);
    }

    public String getTextboxValue() {
        return this.keyMapToString(this.textbox, this.numchars).trim();
    }

    public String getEncodedTextboxValue() {
        return this.keyMapToStringEncoded(this.textbox, this.numchars).trim();
    }

    public void clearTextbox() {
        this.numchars = 0;
        this.caretPos = 0;
    }

    public void moveCursorUp() {
        this.cursor = (short)(this.cursor - this.numCols);
        if (this.cursor < 0) {
            this.cursor = (short)(this.cursor + this.numCols * this.numRows);
        }
        if (this.cursor >= this.cf.getSprite().getFrameSequenceLength() - 1) {
            this.cursor = (short)(this.cursor - this.numCols);
        }
        this.updateCursor();
    }

    public void moveCursorDown() {
        this.cursor = (short)(this.cursor + this.numCols);
        if (this.cursor >= this.numCols * this.numRows) {
            this.cursor = (short)(this.cursor - this.numCols * this.numRows);
        }
        if (this.cursor < 0) {
            this.cursor = (short)(this.cursor + this.numCols);
        }
        this.updateCursor();
    }

    public void moveCursorLeft() {
        this.cursor = this.cursor % this.numCols == 0 ? (short)(this.cursor + (this.numCols - 1)) : (short)(this.cursor - 1);
        if (this.cursor < 0) {
            this.cursor = (byte)(this.cf.getSprite().getFrameSequenceLength() - 2);
        }
        if (this.cursor >= this.cf.getSprite().getFrameSequenceLength() - 1) {
            this.cursor = (byte)(this.cf.getSprite().getFrameSequenceLength() - 2);
        }
        this.updateCursor();
    }

    public void moveCursorRight() {
        this.cursor = this.cursor % this.numCols == this.numCols - 1 ? (short)(this.cursor - (this.numCols - 1)) : (short)(this.cursor + 1);
        if (this.cursor >= this.cf.getSprite().getFrameSequenceLength() - 1) {
            this.cursor = (short)(this.cursor - this.cursor % this.numCols);
        }
        this.updateCursor();
    }

    public void backSpace() {
        this.numchars = (byte)(this.numchars - 1);
        if (this.numchars < 0) {
            this.numchars = 0;
        }
        this.caretPos = this.numchars;
    }

    public void selectCharacter() {
        if (this.cursor == 49) {
            this.numchars = (byte)(this.numchars - 1);
            if (this.numchars < 0) {
                this.numchars = 0;
            }
            this.caretPos = this.numchars;
        } else {
            if (this.numchars == 10) {
                this.numchars = (byte)(this.numchars - 1);
            }
            this.textbox[this.numchars] = (byte)this.cursor;
            this.numchars = (byte)(this.numchars + 1);
            if (this.numchars >= 10) {
                this.numchars = (byte)10;
            }
            this.caretPos = this.numchars;
            if (this.caretPos > 9) {
                this.caretPos = (byte)9;
            }
        }
    }

    public void keyReleased(int gameAction) {
        switch (gameAction) {
            case 1: {
                this.moveCursorUp();
                break;
            }
            case 2: {
                this.moveCursorLeft();
                break;
            }
            case 5: {
                this.moveCursorRight();
                break;
            }
            case 6: {
                this.moveCursorDown();
                break;
            }
            case 8: {
                this.selectCharacter();
            }
        }
    }

    public void paint(Graphics g) {
        this.update();
        this.cf.getSprite().setFrame(0);
        int row = 0;
        while (row < this.numRows) {
            int col = 0;
            while (col < this.numCols) {
                this.cf.getSprite().setPosition(this.gridx[col], this.gridy[row]);
                this.cf.getSprite().paint(g);
                this.cf.getSprite().nextFrame();
                if (this.cf.getSprite().getFrame() == 0) {
                    row = this.numRows;
                    col = this.numCols;
                }
                ++col;
            }
            ++row;
        }
        this.cf.drawString(g, this.getTextboxValue(), this.textboxX, this.textboxY);
        g.setColor(255, 255, 255);
        g.drawRect(this.textboxX - 2, this.textboxY - 2, this.cf.getWidth() * 10 + 4, this.cf.getHeight() + 4);
        if (this.currfrm != 0 && this.currfrm != 5) {
            g.setColor(255, 0, 0);
            g.drawRect(this.gridx[this.cursorx] - 1, this.gridy[this.cursory] - 1, (int)this.gridcellW, (int)this.gridcellH);
            g.drawRect(this.textboxX + this.caretPos * this.cf.getWidth(), this.textboxY + this.cf.getHeight(), (int)this.cf.getWidth(), 1);
        }
    }

    private String keyMapToString(byte[] values, int size) {
        this.temp = "";
        int i = 0;
        while (i < size) {
            this.temp = String.valueOf(this.temp) + this.cf.getAscii(values[i]);
            ++i;
        }
        return this.temp;
    }

    private String keyMapToStringEncoded(byte[] values, int size) {
        this.temp = "";
        int i = 0;
        while (i < size) {
            this.temp = String.valueOf(this.temp) + this.cf.getEncoded(values[i]);
            ++i;
        }
        return this.temp;
    }

    private byte[] stringToKeyMap(String string, int maxsize) {
        if (string == null) {
            string = "";
        }
        byte[] ret = new byte[maxsize];
        int i = 0;
        while (i < string.length()) {
            ret[i] = this.cf.getValue(string.charAt(i));
            ++i;
        }
        return ret;
    }

    public void setTextboxValue(String text) {
        if (text == null) {
            return;
        }
        int len = text.length();
        if (len > 10) {
            len = 10;
        }
        this.textbox = this.stringToKeyMap(text, len);
        this.caretPos = this.numchars = (byte)len;
        if (this.caretPos > 9) {
            this.caretPos = (byte)9;
        }
    }

    public boolean click(dvPoint point) {
        int row = 0;
        while (row < this.numRows) {
            int col = 0;
            while (col < this.numCols) {
                if (dvUtil.dvClickRect(point, this.gridx[col], this.gridy[row], this.gridcellW, this.gridcellH)) {
                    this.lastkey = this.cursor = (short)(row * this.numCols + col);
                    this.updateCursor();
                    this.selectCharacter();
                    row = this.numRows;
                    col = this.numCols;
                    return true;
                }
                ++col;
            }
            ++row;
        }
        return false;
    }

    public short lastKey() {
        return this.lastkey;
    }
}

