/*
 * Decompiled with CFR 0.152.
 */
package fi.darkwood;

import java.util.Random;

public class GameConstants {
    public static final boolean TESTINGMODE = false;
    public static final boolean SCALE_GRAPHICS_TO_FULLSCREEN = true;
    public static final boolean LOG_SLEEPTIME = false;
    public static final int maxLevel = 30;
    public static final int ticksPerRound = 15;
    public static final double statDPSpercent = 0.3;
    public static final int monsterHPConstant = 10;
    public static final int monsterELITEHPConstant = 3;
    public static final double eliteEXPmultiplier = 1.5;
    public static final int monsterMPConstant = 10;
    public static final double monsterStatConst = 2.5;
    public static final double monsterDPSConstant = 1.45;
    public static final int playerHPConstant = 1;
    public static final int playerMPConstant = 10;
    public static final double playerStatConst = 2.5;
    public static final double playerDPSConstant = 1.45;
    public static final double playerRestConst = 0.05;
    public static final int weaponDamageCoef = 1;
    public static final int monsterEXPConstant = 10;
    public static final double monsterMONEYConstant = 2.0;
    public static final double itemsPerLevel = 0.8;
    public static final int levelCostConstant = 50;
    public static final double dpsConstant = 1.0;
    public static final double attackDexHaste = 0.02;
    public static final int armorClassConstant = 2;
    public static final double armorClassCoef = 1.0;
    public static final int NUMBER_OF_CLASSES = 3;
    public static final int CLASS_WARRIOR = 0;
    public static final int CLASS_MAGE = 1;
    public static final int CLASS_CLERIC = 2;
    public static final int ARMOR_HEAVY = 0;
    public static final int ARMOR_MEDIUM = 1;
    public static final int ARMOR_LIGHT = 3;
    public static final int ARMOR_CLOTH = 2;
    public static final int QUALITY_COMMON = 0;
    public static final int QUALITY_UNCOMMON = 1;
    public static final int QUALITY_RARE = 2;
    public static final int QUALITY_EPIC = 3;
    public static final int STAT_STR = 0;
    public static final int STAT_DEX = 1;
    public static final int STAT_CON = 2;
    public static final int STAT_WP = 3;
    public static final int ITEM_STATS_PER_LEVEL = 2;
    public static final int SLOT_HEAD = 0;
    public static final int SLOT_CHEST = 1;
    public static final int SLOT_RIGHT_HAND = 2;
    public static final int SLOT_LEFT_HAND = 3;
    public static final int NUMBER_OF_SLOTS = 4;
    public static final int NUMBER_OF_TYPES = 3;
    public static final int NUMBER_OF_STATS = 4;
    public static final int baseCritChance = 2;
    public static final int EQUIPMENT_LEVEL_REQUIREMENT_GAP = 3;
    public static final int HEAL_TICK_DELAY = 10;
    public static final int HEAL_TICKS_TO_HEAL_HEALTH_TO_MAX = 50;
    public static final int HEAL_TICKS_TO_HEAL_MANA_TO_MAX = 25;

    public static double timeToLevel(int n) {
        double d = 60.0 * (0.15 * (double)n * (double)n + 0.35);
        if (n > 20) {
            d += 6.0 * (double)(n * n - 400);
        }
        return d;
    }

    public static int levelCost(int n) {
        return (int)(GameConstants.timeToLevel(n - 1) * 6.8965517241379315);
    }

    public static int playerStat(int n, int n2, int n3) {
        int n4 = 0;
        if (n2 == 0 && n3 == 0) {
            ++n4;
        }
        if (n2 == 3 && n3 == 1) {
            ++n4;
        }
        if (n2 == 2 && n3 == 2) {
            ++n4;
        }
        return n4 * n;
    }

    public static int getArmorTypeforClass(int n) {
        if (n == 0) {
            return 0;
        }
        if (n == 2) {
            return 1;
        }
        if (n == 1) {
            return 2;
        }
        return 2;
    }

    public static int getMonsterMoney(int n) {
        return n * 2;
    }

    public static double getMonsterDPS(int n) {
        return 1.45 * (double)n;
    }

    public static int getItemTier(int n) {
        if (n < 9) {
            return 1;
        }
        if (n < 20) {
            return 2;
        }
        return 3;
    }

    public static int[] assignStats(int n, int n2) {
        int[] nArray;
        block4: {
            block3: {
                float[] fArray = new float[4];
                nArray = new int[4];
                float f = 0.0f;
                int n3 = 0;
                if (n2 == 0) break block3;
                Random random = new Random();
                int n4 = 4 * (n2 - 1);
                for (n2 = 0; n2 < 4; ++n2) {
                    fArray[n2] = random.nextFloat();
                    f += fArray[n2];
                }
                n = 2 * (n + n4);
                for (n2 = 0; n2 < 4; ++n2) {
                    nArray[n2] = (int)(fArray[n2] / f * (float)n);
                    n3 += nArray[n2];
                }
                if (n3 == n) break block4;
                int n5 = n2 = random.nextInt(4);
                nArray[n5] = nArray[n5] + (n - n3);
                if (nArray[n2] >= 0) break block4;
                nArray[n2] = 0;
                break block4;
            }
            for (n2 = 0; n2 < 4; ++n2) {
                nArray[n2] = 0;
            }
        }
        return nArray;
    }

    public static int itemCost(int n, int n2) {
        double d = GameConstants.levelCost(n) / 10;
        d = d / 0.8 * 2.0;
        if (n2 == 0) {
            d /= 2.0;
        }
        return (int)d;
    }

    public static int weaponCost(int n, int n2) {
        return GameConstants.itemCost(n, n2) << 1;
    }

    public static int classArmorReduction(int n) {
        switch (n) {
            case 0: {
                return 45;
            }
            case 2: {
                return 5;
            }
            case 1: {
                return 30;
            }
            case 3: {
                return 15;
            }
        }
        return 0;
    }

    public static double classMeleeCoef(int n) {
        switch (n) {
            case 0: {
                return 0.6;
            }
            case 1: {
                return 0.3;
            }
            case 2: {
                return 0.45;
            }
        }
        return 0.0;
    }

    public static double classAbilityCoef(int n) {
        switch (n) {
            case 0: {
                return 0.4;
            }
            case 1: {
                return 0.7;
            }
            case 2: {
                return 0.55;
            }
        }
        return 0.0;
    }

    public static int itemACValue(int n, int n2, int n3) {
        double d = (double)(n2 + 2) * (double)GameConstants.classArmorReduction(n);
        switch (n3) {
            case 3: {
                n = 40;
                break;
            }
            case 1: {
                n = 40;
                break;
            }
            case 0: {
                n = 20;
                break;
            }
            default: {
                n = 0;
            }
        }
        d = d * (double)n / 100.0;
        return (int)d;
    }

    public static int itemStatRequirement(int n, int n2, int n3) {
        if (n3 == 0) {
            switch (n) {
                case 0: {
                    return n2 * 3;
                }
            }
            return 0;
        }
        if (n3 == 1) {
            switch (n) {
                case 0: {
                    return n2 * 3 / 2;
                }
                case 3: {
                    return n2 * 3 / 2;
                }
            }
            return 0;
        }
        if (n3 == 2) {
            switch (n) {
                case 3: {
                    return n2 * 3;
                }
            }
            return 0;
        }
        if (n3 == 3) {
            switch (n) {
                case 1: {
                    return n2 << 1;
                }
            }
            return 0;
        }
        return 0;
    }

    public static int calculateAreaLevel(int n, int n2, int n3) {
        if (n3 == 0) {
            return -1;
        }
        double d = (double)n2 / (double)n3;
        double d2 = (double)n3 / (double)n;
        if (d2 == 0.0) {
            d2 = 1.0;
        }
        double d3 = d * d * d2;
        double d4 = d3 * 4.761904761904762;
        int n4 = (int)Math.sqrt(d4);
        System.out.println("AREALEVEL: " + n + " " + n2 + " " + n3 + " out " + 4.761904761904762 + " " + d3 + " " + n4);
        if (n4 < 2) {
            n4 = 2;
        }
        return n4;
    }
}

