/*
 * Decompiled with CFR 0.152.
 */
package fi.darkwood.network;

import fi.darkwood.Equipment;
import fi.darkwood.EquipmentFactory;
import fi.darkwood.Game;
import fi.darkwood.Humanoid;
import fi.darkwood.Item;
import fi.darkwood.Player;
import fi.darkwood.Quest;
import fi.darkwood.util.LocalDatabase;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import nanoxml.kXMLElement;

public class CharacterSerializer {
    public static String createXmlString(Player player) {
        kXMLElement kXMLElement2;
        kXMLElement kXMLElement3;
        int n;
        kXMLElement kXMLElement4 = new kXMLElement();
        kXMLElement4.setTagName("character");
        kXMLElement4.addProperty("name", player.name);
        kXMLElement4.addProperty("class", player.characterClass);
        kXMLElement4.addProperty("level", player.level);
        kXMLElement4.addProperty("experience", player.experience);
        kXMLElement4.addProperty("totalExperience", player.totalExperience);
        kXMLElement4.addProperty("money", player.money);
        kXMLElement4.addProperty("hp", player.health);
        kXMLElement4.addProperty("mana", player.mana);
        kXMLElement4.addProperty("str", player.strength);
        kXMLElement4.addProperty("dex", player.dexterity);
        kXMLElement4.addProperty("con", player.constitution);
        kXMLElement4.addProperty("int", player.willpower);
        kXMLElement4.addProperty("healingPotions", player.healingPotions);
        kXMLElement4.addProperty("trainedStr", player.trainedStats[0]);
        kXMLElement4.addProperty("trainedDex", player.trainedStats[1]);
        kXMLElement4.addProperty("trainedCon", player.trainedStats[2]);
        kXMLElement4.addProperty("trainedWp", player.trainedStats[3]);
        kXMLElement4.addProperty("deathPenaltyExpValue", player.getDeathPenaltyExpBuffer());
        Object object = player.room.zone.getFallbackZone();
        if (object == null) {
            System.out.println("SAVER fallbackZONE: NULL!");
            object = player.room.zone.getClass().getName();
        }
        kXMLElement4.addProperty("fallbackzone", object);
        System.out.println("SAVER fallbackZONE: " + (String)object);
        object = new kXMLElement();
        ((kXMLElement)object).setTagName("dateWhenGainedLevel");
        for (n = 0; n <= 30; ++n) {
            if (player.dateWhenGainedLevel[n] == null) continue;
            ((kXMLElement)object).addProperty("dateWhenGainedLevel" + Integer.toString(n), player.dateWhenGainedLevel[n]);
        }
        kXMLElement4.addChild((kXMLElement)object);
        for (n = 0; n < player.equipmentSlots.length; ++n) {
            kXMLElement3 = kXMLElement4;
            object = player.equipmentSlots[n];
            if (object == null) continue;
            kXMLElement2 = new kXMLElement();
            kXMLElement2.setTagName("item");
            kXMLElement2.addProperty("level", ((Item)object).getLevel());
            kXMLElement2.addProperty("slot", ((Equipment)object).getSlot());
            kXMLElement2.addProperty("type", ((Equipment)object).getType());
            kXMLElement2.addProperty("quality", ((Equipment)object).quality);
            kXMLElement2.addProperty("imagefile", ((Equipment)object).getPaperdollImage());
            kXMLElement2.addProperty("strength", ((Equipment)object).getStrength());
            kXMLElement2.addProperty("dexterity", ((Equipment)object).getDexterity());
            kXMLElement2.addProperty("constitution", ((Equipment)object).getConstitution());
            kXMLElement2.addProperty("willpower", ((Equipment)object).getWillpower());
            kXMLElement2.addProperty("desc", ((Equipment)object).description);
            kXMLElement2.addProperty("name", ((Equipment)object).name);
            kXMLElement2.addProperty("randomSeed", ((Equipment)object).getRandomSeed());
            kXMLElement2.addProperty("image", ((Equipment)object).image);
            kXMLElement3.addChild(kXMLElement2);
        }
        for (n = 0; n < player.completedQuests.size(); ++n) {
            kXMLElement3 = kXMLElement4;
            object = (Quest)player.completedQuests.elementAt(n);
            kXMLElement2 = new kXMLElement();
            kXMLElement2.setTagName("quest");
            kXMLElement2.addProperty("class", object.getClass().getName());
            kXMLElement2.addProperty("status", "completed");
            kXMLElement3.addChild(kXMLElement2);
        }
        CharacterSerializer.a(player.currentQuest, kXMLElement4);
        return kXMLElement4.toString();
    }

    private static void a(Quest quest, kXMLElement kXMLElement2) {
        if (quest == null) {
            return;
        }
        kXMLElement kXMLElement3 = new kXMLElement();
        kXMLElement3.setTagName("quest");
        kXMLElement3.addProperty("class", quest.getClass().getName());
        kXMLElement3.addProperty("status", "current");
        Enumeration enumeration = quest.requirementsDone.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Integer n = (Integer)quest.requirementsDone.get(string);
            int n2 = n;
            kXMLElement kXMLElement4 = new kXMLElement();
            kXMLElement4.setTagName("requirement");
            kXMLElement4.addProperty("id", string);
            kXMLElement4.addProperty("value", n2);
            kXMLElement3.addChild(kXMLElement4);
        }
        kXMLElement2.addChild(kXMLElement3);
    }

    public static Vector loadCharactersToMenu(String object) {
        Object object2 = new kXMLElement();
        Vector<Object> vector = new Vector<Object>();
        ((kXMLElement)object2).parseString((String)object);
        object = ((kXMLElement)object2).getChildren().elements();
        while (object.hasMoreElements()) {
            kXMLElement kXMLElement2 = (kXMLElement)object.nextElement();
            int n = kXMLElement2.getProperty("id", 0);
            object2 = CharacterSerializer.loadCharacter((kXMLElement)kXMLElement2.getChildren().firstElement(), n);
            vector.addElement(object2);
        }
        return vector;
    }

    public static Vector loadCharactersToMenuOffline() {
        Random random = new Random(System.currentTimeMillis());
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < 5; ++i) {
            Object object = LocalDatabase.loadCharacterXML(i);
            if (object == null || "".equals(object) || ((String)object).length() <= 0) {
                vector.addElement("Slot " + (i + 1));
                continue;
            }
            kXMLElement kXMLElement2 = new kXMLElement();
            kXMLElement2.parseString((String)object);
            int n = random.nextInt(1000000) + 1000;
            object = CharacterSerializer.loadCharacter(kXMLElement2, n);
            vector.addElement(object);
        }
        return vector;
    }

    public static Player loadCharacter(kXMLElement object, int n) {
        System.out.println("Loading character id:" + n);
        Object object2 = ((kXMLElement)object).getProperty("name");
        int n2 = ((kXMLElement)object).getProperty("class", -1);
        ((kXMLElement)object).getProperty("str", -1);
        ((kXMLElement)object).getProperty("int", -1);
        ((kXMLElement)object).getProperty("dex", -1);
        ((kXMLElement)object).getProperty("con", -1);
        int n3 = ((kXMLElement)object).getProperty("level", -1);
        int[] nArray = new int[4];
        int[] nArray2 = nArray;
        nArray[0] = ((kXMLElement)object).getProperty("trainedStr", -1);
        nArray2[1] = ((kXMLElement)object).getProperty("trainedDex", -1);
        nArray2[2] = ((kXMLElement)object).getProperty("trainedCon", -1);
        nArray2[3] = ((kXMLElement)object).getProperty("trainedWp", -1);
        int n4 = ((kXMLElement)object).getProperty("hp", 1);
        int n5 = ((kXMLElement)object).getProperty("mana", 1);
        int n6 = ((kXMLElement)object).getProperty("experience", -1);
        int n7 = ((kXMLElement)object).getProperty("totalExperience", -1);
        int n8 = ((kXMLElement)object).getProperty("money", -1);
        int n9 = ((kXMLElement)object).getProperty("healingPotions", -1);
        String string = Game.getAnimationFramesFile(n2);
        int n10 = Game.getAnimationFrameWidth(n2);
        int n11 = ((kXMLElement)object).getProperty("deathPenaltyExpValue", 0);
        String string2 = ((kXMLElement)object).getProperty("fallbackzone", "");
        object2 = new Player((String)object2, "", string, n3, n10, n2);
        ((Player)object2).setGlobalCharacterId(n);
        ((Player)object2).health = n4;
        ((Player)object2).mana = n5;
        ((Player)object2).trainedStats = nArray2;
        ((Player)object2).experience = n6;
        ((Player)object2).totalExperience = n7;
        ((Player)object2).money = n8;
        ((Player)object2).healingPotions = n9;
        ((Player)object2).setDeathPenaltyExpBuffer(n11);
        ((Player)object2).startZone = string2;
        System.out.println("STARTZONE LOADER: " + ((Player)object2).startZone + " id:" + n);
        object = ((kXMLElement)object).getChildren().elements();
        while (object.hasMoreElements()) {
            Object object3 = (kXMLElement)object.nextElement();
            if ("item".equals(((kXMLElement)object3).getTagName())) {
                Object object4 = object2;
                n3 = ((kXMLElement)object3).getProperty("level", 0);
                int n12 = ((kXMLElement)object3).getProperty("type", 0);
                n4 = ((kXMLElement)object3).getProperty("slot", 0);
                n5 = ((kXMLElement)object3).getProperty("quality", 0);
                int[] nArray3 = new int[4];
                int[] nArray4 = nArray3;
                nArray3[0] = ((kXMLElement)object3).getProperty("strength", 0);
                nArray4[1] = ((kXMLElement)object3).getProperty("dexterity", 0);
                nArray4[2] = ((kXMLElement)object3).getProperty("constitution", 0);
                nArray4[3] = ((kXMLElement)object3).getProperty("willpower", 0);
                String string3 = ((kXMLElement)object3).getProperty("desc", "loadedweapon");
                String string4 = ((kXMLElement)object3).getProperty("name", "loadedname");
                n9 = ((kXMLElement)object3).getProperty("randomSeed", 0);
                string = ((kXMLElement)object3).getProperty("imagefile", "");
                object3 = ((kXMLElement)object3).getProperty("image", "");
                try {
                    object3 = EquipmentFactory.getInstance().createEquipment(n3, n4, n12, n5, nArray4, (String)object3, string, string4, string3, n9);
                    ((Humanoid)object4).equip((Equipment)object3);
                }
                catch (Exception exception) {
                    System.out.println("Unable to load item: " + n3 + ", " + n4 + ", " + n12 + ", " + n5 + " ERROR: " + exception.getMessage());
                }
                continue;
            }
            if ("quest".equals(((kXMLElement)object3).getTagName())) {
                CharacterSerializer.b((kXMLElement)object3, (Player)object2);
                continue;
            }
            if (!"dateWhenGainedLevel".equals(((kXMLElement)object3).getTagName())) continue;
            CharacterSerializer.a((kXMLElement)object3, (Player)object2);
        }
        ((Player)object2).updateStats();
        ((Player)object2).updateAbilities();
        return object2;
    }

    private static void a(kXMLElement kXMLElement2, Player player) {
        for (int i = 0; i <= 30; ++i) {
            player.dateWhenGainedLevel[i] = kXMLElement2.getProperty("dateWhenGainedLevel" + Integer.toString(i));
        }
    }

    private static void b(kXMLElement object, Player player) {
        Object object2 = ((kXMLElement)object).getProperty("class");
        try {
            object2 = Class.forName((String)object2);
            object2 = (Quest)((Class)object2).newInstance();
            Object object3 = ((kXMLElement)object).getProperty("status");
            if (object3 == null || !((String)object3).equals("completed")) {
                if (object3 != null && ((String)object3).equals("current")) {
                    object = ((kXMLElement)object).getChildren().elements();
                    while (object.hasMoreElements()) {
                        object3 = (kXMLElement)object.nextElement();
                        ((Quest)object2).setCompletedKills(((kXMLElement)object3).getProperty("id"), ((kXMLElement)object3).getProperty("value", 0));
                    }
                    player.currentQuest = object2;
                }
                return;
            }
            player.completedQuests.addElement(object2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            object2 = classNotFoundException;
            classNotFoundException.printStackTrace();
            return;
        }
        catch (InstantiationException instantiationException) {
            object2 = instantiationException;
            instantiationException.printStackTrace();
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            object2 = illegalAccessException;
            illegalAccessException.printStackTrace();
            return;
        }
        catch (NullPointerException nullPointerException) {
            object2 = nullPointerException;
            nullPointerException.printStackTrace();
        }
    }
}

