/*
 * Decompiled with CFR 0.152.
 */
package fi.darkwood.ability;

import fi.darkwood.Ability;
import fi.darkwood.Creature;
import fi.darkwood.Game;
import fi.darkwood.Monster;
import fi.darkwood.ui.component.MessageLog;
import java.util.Enumeration;

public abstract class Debuff
extends Ability {
    public Debuff(String string, String string2, int n) {
        super(string, string2, n);
    }

    public boolean effect(Creature creature) {
        if (!creature.isReadyToAct(this.getAbilitySlot())) {
            return false;
        }
        Creature creature2 = null;
        Creature creature3 = creature;
        Enumeration enumeration = Game.player.room.getCreatures().elements();
        while (enumeration.hasMoreElements()) {
            Creature creature4 = (Creature)enumeration.nextElement();
            if (!(creature4 instanceof Monster) || !creature4.isAlive()) continue;
            creature2 = creature4;
            break;
        }
        if (creature2 == null) {
            System.out.println("No target for debuff, returning");
            return false;
        }
        if (creature3.mana < this.getManaCost()) {
            if (creature.getId() == Game.player.getId()) {
                MessageLog.getInstance().addMessage("Not enough energy!");
            }
            return false;
        }
        creature3.reduceMana(this.getManaCost());
        Game.player.addAbilityCooldown(this.getCooldownInRounds(), this.getAbilitySlot());
        creature2.addAbilityEffect(this.getTargetVisualEffect());
        Game.party.sendVisualEffect(creature2.getId(), this.getTargetVisualEffect());
        this.start(creature3, creature2, System.currentTimeMillis() + (long)this.getDurationMillis(), this.a);
        return true;
    }

    public abstract void start(Creature var1, Creature var2, long var3, int var5);

    public String getDescription() {
        return "Mana cost: " + this.getManaCost();
    }

    public abstract int getManaCost();

    public abstract int getDurationMillis();
}

