/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.CommandHandler;
import graph.GraphTable;
import graph.ProgressBarAlert;
import graph.core.PlotterWithFunctionEvaluation;
import graph.core.ProgressBar;
import graph.lang.Phrases;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;

public class CalculateTable
implements Runnable {
    PlotterWithFunctionEvaluation plotter;
    GraphTable graphTable;
    Thread thisThread;

    public CalculateTable(PlotterWithFunctionEvaluation plotter, GraphTable graphTable) {
        this.plotter = plotter;
        this.graphTable = graphTable;
    }

    public void run() {
        try {
            this.thisThread = Thread.currentThread();
            ProgressBar.InvokeAble endTask = new ProgressBar.InvokeAble(){

                public void invoke() {
                    CommandHandler.getInstance().setCurrentDisplayable((Displayable)CalculateTable.this.graphTable);
                }
            };
            ProgressBar.InvokeAble cancelTask = new ProgressBar.InvokeAble(){

                public void invoke() {
                    PlotterWithFunctionEvaluation.setRunning(false);
                    CalculateTable.this.thisThread.interrupt();
                }
            };
            ProgressBarAlert progressBar = new ProgressBarAlert(Phrases.busy, Phrases.calculatingTable, 10, endTask);
            progressBar.setCancellable(true, cancelTask);
            progressBar.show(null);
            PlotterWithFunctionEvaluation.setRunning(true);
            Vector criticalPoints = this.plotter.getCriticalPoints(progressBar);
            this.graphTable.setCriticalPoints(criticalPoints, progressBar);
            progressBar.taskEnded();
        }
        catch (Exception e) {
            e.printStackTrace();
            CommandHandler.getInstance().alertException(e);
        }
    }
}

