/*
 * Decompiled with CFR 0.152.
 */
package graph.eqn;

import graph.eqn.BinaryExpression;
import graph.eqn.Expression;
import graph.utils.Utils;

public class Permutation
extends BinaryExpression {
    public Permutation(Expression n, Expression r) {
        super(n, r);
    }

    public double getValue(double xValue, double yValue) {
        double nValue = this.expr1.getValue(xValue, yValue);
        double rValue = this.expr2.getValue(xValue, yValue);
        if (rValue < 0.0 || nValue < 0.0 || !Utils.isValidDouble(rValue) || !Utils.isValidDouble(nValue)) {
            return Double.NaN;
        }
        double result = 1.0;
        double i = nValue - rValue + 1.0;
        while (i <= nValue) {
            result *= i;
            i += 1.0;
        }
        return result;
    }

    public String getFunctionAsString() {
        return "P(" + this.expr1.getFunctionAsString() + "," + this.expr2.getFunctionAsString() + ")";
    }
}

