/*
 * Decompiled with CFR 0.152.
 */
package graph.utils;

public class DebugTools {
    public static final String getCurrentThreadName() {
        return Thread.currentThread().getName();
    }

    public static final void printToScreen(String string) {
        DebugTools.printToScreen(string, null);
    }

    public static final void printToScreen(String string, String parameter) {
        StringBuffer result = new StringBuffer();
        result.append(DebugTools.getCurrentThreadName());
        result.append(" - ");
        result.append(string);
        if (parameter != null) {
            result.append(":\t");
            result.append(parameter);
        }
        System.out.println(result.toString());
        System.out.flush();
    }

    public static final void printToScreen(String string, String parameter, String fromWichMethodCall) {
        StringBuffer result = new StringBuffer();
        result.append(DebugTools.getCurrentThreadName());
        result.append(" ");
        result.append(fromWichMethodCall);
        result.append(" - ");
        result.append(string);
        if (parameter != null) {
            result.append(":\t");
            result.append(parameter);
        }
        System.out.println(result.toString());
        System.out.flush();
    }

    public static final void printStateChanging(int previousState, int newState, String fromWichMethodCall) {
        DebugTools.printToScreen("state from " + new String(DebugTools.getStateAsString(previousState)).toLowerCase() + " set to ", DebugTools.getStateAsString(newState), fromWichMethodCall);
    }

    public static final String getStateAsString(int state) {
        if (state == 0) {
            return "FIRST_TIME";
        }
        if (state == 15) {
            return "IS_RUNNING";
        }
        if (state == 20) {
            return "IS_STOPPING";
        }
        if (state == 30) {
            return "IS_STARTING";
        }
        if (state == 40) {
            return "STOPPED";
        }
        return "! UNKNOWN STATE !";
    }
}

