/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.CalculateTable;
import graph.CommandHandler;
import graph.EvaluateFunction;
import graph.GraphForm;
import graph.GraphTable;
import graph.GraphViewer;
import graph.MyDisplayable;
import graph.SaveAsImageForm;
import graph.SettingsForm;
import graph.core.ParseException;
import graph.core.PlotterRunnable;
import graph.core.PlotterScreen;
import graph.core.PlotterWithFunctionEvaluation;
import graph.core.Sample;
import graph.core.Settings;
import graph.lang.Phrases;
import graph.utils.DebugTools;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

public class GraphCanvas
extends Canvas
implements CommandListener,
MyDisplayable {
    private Command equationsCommand = new Command(Phrases.equations, 1, 0);
    private Command resetZoomCommand = new Command(Phrases.resetZoom, 1, 3);
    private Command zoomOutCommand = new Command(Phrases.zoomOut, 1, 4);
    private Command tableCommand = new Command(Phrases.showTable, 1, 1);
    private Command evaluateCommand = new Command(Phrases.evaluateFunction, 1, 2);
    private Command stopEvaluateCommand = new Command(Phrases.stopEvaluate, 1, 2);
    private Command settingsCommand = new Command(Phrases.Settings, 1, 5);
    private Command saveImageCommand = new Command(Phrases.saveAsImage, 1, 6);
    public static PlotterWithFunctionEvaluation plotter;
    public static final int FIRST_TIME_STATE = 0;
    public static final int IS_RUNNING_STATE = 15;
    public static final int IS_STOPPING_STATE = 20;
    public static final int IS_STARTING_STATE = 30;
    public static final int STOPPED_STATE = 40;
    public static final int DRAGGING_STATE = 50;
    public static final int POINTER_RELEASED_STATE = 60;
    private static int state;
    private PlotterRunnable plotterRunnable;
    private Thread redrawingThread;
    private int xScreenPointerDown;
    private int yScreenPointerDown;
    private boolean isDragging;
    private static final int MOVE_MARGIN = 10;

    static {
        state = 0;
    }

    public GraphCanvas() {
        try {
            this.ndsInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void ndsInit() throws Exception {
        CommandHandler.getInstance().registerDisplayable((Displayable)this);
        this.setCommandListener(this);
        this.setFullScreenMode(Settings.FULLSCREEN);
        this.setTitle(Phrases.graphcanvasTitle);
        this.addCommand(this.equationsCommand);
        this.addCommand(CommandHandler.getGlobalBackCommand());
        this.addCommand(this.resetZoomCommand);
        this.addCommand(this.zoomOutCommand);
        this.addCommand(this.tableCommand);
        this.addCommand(this.evaluateCommand);
        this.addCommand(this.settingsCommand);
        this.addCommand(this.saveImageCommand);
    }

    public void initNbDrawingStaps() {
        Settings.NB_REDRAWING_STEPS = this.hasPointerMotionEvents() ? 1 : 3;
    }

    protected void sizeChanged(int width, int height) {
        super.sizeChanged(width, height);
        plotter.setSize(width, height);
    }

    public static int getState() {
        return state;
    }

    public static synchronized void setState(int newState, String fromWichMethodCall) {
        DebugTools.printStateChanging(state, newState, fromWichMethodCall);
        state = newState;
    }

    public void StartEvaluateCommand() {
        this.removeCommand(this.stopEvaluateCommand);
        this.addCommand(this.evaluateCommand);
    }

    public void reinit(Sample sample) throws ParseException {
        this.setFullScreenMode(Settings.FULLSCREEN);
        GraphCanvas.setState(0, "GraphCanvas.reinit");
        plotter = new PlotterWithFunctionEvaluation(sample, this.getWidth(), this.getHeight());
        this.StartEvaluateCommand();
        this.repaint();
    }

    public void interruptRedrawingThread() {
        try {
            DebugTools.printToScreen("GraphCanvas.interruptRedrawingThread() started");
            if (this.redrawingThread != null && this.plotterRunnable != null && this.redrawingThread.isAlive()) {
                this.plotterRunnable.getPlotter().setInterrupted(true);
                this.redrawingThread.join();
                this.plotterRunnable.getPlotter().setInterrupted(false);
                GraphCanvas.setState(40, "GraphCanvas.interruptRedrawingThread()");
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void paint(Graphics g) {
        try {
            DebugTools.printToScreen("GraphCanvas.paint() started");
            this.paintMethod(g);
        }
        catch (Throwable e) {
            System.err.println("! ! ! ERROR ! ! !");
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    protected void paintMethod(Graphics g) {
        if (Settings.NB_REDRAWING_STEPS == 0 || GraphCanvas.getState() == 50 || GraphCanvas.getState() == 60) {
            Settings.setInternalPrecision(100);
            Settings.PRECISION_DERIVATE = true;
            this.plotterRunnable = new PlotterRunnable(this, plotter);
            this.plotterRunnable.getPlotter().createImage(this.plotterRunnable);
            plotter.showLastImage(g);
        } else if (GraphCanvas.getState() == 0 || GraphCanvas.getState() == 40) {
            Settings.setInternalPrecision(0);
            Settings.PRECISION_DERIVATE = false;
            this.plotterRunnable = new PlotterRunnable(this, plotter);
            this.plotterRunnable.getPlotter().createImage(this.plotterRunnable);
            plotter.showLastImage(g);
            this.redrawingThread = new Thread((Runnable)this.plotterRunnable, "Redrawing Thread");
            this.redrawingThread.start();
            GraphCanvas.setState(15, "GraphCanvas.paint (very 1st)");
        } else if (GraphCanvas.getState() == 20) {
            plotter.showLastImage(g);
            GraphCanvas.setState(40, "GraphCanvas.paint (stopping)");
        } else if (GraphCanvas.getState() == 30) {
            Settings.PRECISION_DERIVATE = false;
            Settings.setInternalPrecision(0);
            this.plotterRunnable = new PlotterRunnable(this, plotter);
            this.plotterRunnable.getPlotter().createImage(this.plotterRunnable);
            plotter.showLastImage(g);
            this.redrawingThread = new Thread((Runnable)this.plotterRunnable, "Redrawing Thread");
            this.redrawingThread.start();
            GraphCanvas.setState(15, "GraphCanvas.paint (not yet)");
        } else if (GraphCanvas.getState() == 15) {
            plotter.showLastImage(g);
        }
    }

    public void updateGraphForm() {
        GraphForm graphForm = (GraphForm)CommandHandler.getInstance().getDisplayable("graph.GraphForm");
        if (plotter != null) {
            graphForm.updateFromGraphCanvas(plotter);
        }
    }

    protected void keyRepeated(int key) {
        this.interruptRedrawingThread();
        PlotterScreen.MOVE_SCREENS = 0.5;
        PlotterScreen.ZOOM_FACTOR = 4.0;
        if (plotter.getInteractiveMode()) {
            this.interactiveKeyHandler(key);
        } else {
            this.keyHandler(key);
        }
        this.repaint();
    }

    protected void keyPressed(int key) {
        this.interruptRedrawingThread();
        PlotterScreen.MOVE_SCREENS = 0.1;
        PlotterScreen.ZOOM_FACTOR = 2.0;
        if (plotter.getInteractiveMode()) {
            this.interactiveKeyHandler(key);
        } else {
            this.keyHandler(key);
        }
        this.repaint();
    }

    private void interactiveKeyHandler(int key) {
        int gameAction = this.getGameAction(key);
        if (gameAction == 2) {
            plotter.selectPreviousCriticalPoint();
        } else if (gameAction == 5) {
            plotter.selectNextCriticalPoint();
        } else if (key == 49 || key == 55) {
            plotter.moveLeft();
        } else if (key == 51 || key == 57) {
            plotter.moveRight();
        } else {
            this.keyHandler(key);
        }
    }

    private void keyHandler(int key) {
        int gameAction = this.getGameAction(key);
        if (key == 49) {
            plotter.moveLeft();
            plotter.moveUp();
        } else if (key == 50 || gameAction == 1) {
            plotter.moveUp();
        } else if (key == 51) {
            plotter.moveUp();
            plotter.moveRight();
        } else if (key == 52 || gameAction == 2) {
            plotter.moveLeft();
        } else if (key == 54 || gameAction == 5) {
            plotter.moveRight();
        } else if (key == 55) {
            plotter.moveLeft();
            plotter.moveDown();
        } else if (key == 56 || gameAction == 6) {
            plotter.moveDown();
        } else if (key == 57) {
            plotter.moveRight();
            plotter.moveDown();
        }
        if (key == 42) {
            plotter.zoomOutHorizontal();
        } else if (key == 35) {
            plotter.zoomInHorizontal();
        } else if (key == 53) {
            plotter.zoomInHorizontal();
            plotter.zoomInVertical();
        } else if (key == 48) {
            plotter.zoomOutHorizontal();
            plotter.zoomOutVertical();
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        this.interruptRedrawingThread();
        if (command == this.tableCommand) {
            new Thread(new CalculateTable(plotter, new GraphTable())).start();
        } else if (command == this.resetZoomCommand) {
            plotter.resetZoom();
        } else if (command == this.zoomOutCommand) {
            plotter.zoomOutHorizontal();
            plotter.zoomOutVertical();
        } else if (command == this.evaluateCommand) {
            new Thread(new EvaluateFunction(plotter)).start();
            this.removeCommand(this.evaluateCommand);
            this.addCommand(this.stopEvaluateCommand);
        } else if (command == this.stopEvaluateCommand) {
            plotter.disableInteractiveMode();
            this.removeCommand(this.stopEvaluateCommand);
            this.addCommand(this.evaluateCommand);
        } else if (command == this.equationsCommand) {
            CommandHandler.getInstance().setCurrentDisplayable((Displayable)GraphViewer.graphForm);
        } else if (command == this.settingsCommand) {
            CommandHandler.getInstance().setCurrentDisplayable((Displayable)new SettingsForm());
        } else if (command == this.saveImageCommand) {
            SaveAsImageForm form = new SaveAsImageForm(this.plotterRunnable.getPlotter());
            CommandHandler.getInstance().setCurrentDisplayable((Displayable)form);
        } else {
            CommandHandler.getInstance().handleCommand(command);
        }
        this.repaint();
    }

    protected void pointerReleased(int xScreen, int yScreen) {
        if (!this.isDragging) {
            if (plotter.getInteractiveMode()) {
                plotter.setCurrentCriticalPointAroundCoordinate(xScreen, yScreen);
            } else {
                plotter.zoomInRoundPoint(xScreen, yScreen);
            }
        } else {
            GraphCanvas.setState(60, "pointerReleased");
        }
        this.repaint();
    }

    protected void pointerPressed(int xScreen, int yScreen) {
        this.isDragging = false;
        this.xScreenPointerDown = xScreen;
        this.yScreenPointerDown = yScreen;
    }

    protected void pointerDragged(int newXScreen, int newYScreen) {
        this.interruptRedrawingThread();
        if (Math.abs(newXScreen - this.xScreenPointerDown) > 10 || Math.abs(newYScreen - this.yScreenPointerDown) > 10) {
            this.isDragging = true;
            plotter.moveFromTo(this.xScreenPointerDown, this.yScreenPointerDown, newXScreen, newYScreen);
            this.xScreenPointerDown = newXScreen;
            this.yScreenPointerDown = newYScreen;
            GraphCanvas.setState(50, "Pointer Dragged");
            this.repaint();
        }
    }

    public void show(Displayable previousDisplayable) throws ParseException {
        DebugTools.printToScreen("GraphCanvas.show started");
        if (previousDisplayable instanceof GraphForm || previousDisplayable instanceof GraphTable || previousDisplayable instanceof SettingsForm) {
            this.reinit(GraphViewer.graphForm.getSample());
        }
    }

    public void hide(Displayable nextDisplayable) {
        DebugTools.printToScreen("GraphCanvas.hide started");
        GraphViewer.graphForm.updateFromGraphCanvas(plotter);
    }
}

