/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.CommandHandler;
import graph.GraphForm;
import graph.GraphViewer;
import graph.MyDisplayable;
import graph.core.Sample;
import graph.core.SampleStore;
import graph.lang.Phrases;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;

public class AddSampleForm
extends Form
implements CommandListener,
ItemCommandListener,
MyDisplayable {
    Command cancelCommand = new Command(Phrases.Cancel, 3, 0);
    Command okCommand = new Command(Phrases.OK, 4, 0);
    Command okItemCommand = new Command(Phrases.OK, 8, 0);
    TextField name = new TextField(Phrases.name, "", 50, 524288);
    StringItem okButton = new StringItem("", Phrases.OK, 2);

    public AddSampleForm() {
        super(Phrases.addSampleFormTitle);
        try {
            this.ndsInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void ndsInit() throws Exception {
        CommandHandler.getInstance().registerDisplayable((Displayable)this);
        this.setCommandListener(this);
        this.addCommand(this.okCommand);
        this.addCommand(this.cancelCommand);
        this.append((Item)this.name);
        this.append((Item)this.okButton);
        this.okButton.setDefaultCommand(this.okItemCommand);
        this.okButton.setItemCommandListener((ItemCommandListener)this);
    }

    public void commandAction(Command command, Displayable disp) {
        CommandHandler commandHandler = CommandHandler.getInstance();
        if (command == this.okCommand || command == this.okItemCommand) {
            GraphForm graphForm = (GraphForm)commandHandler.getDisplayable("graph.GraphForm");
            Sample sample = graphForm.getSample();
            sample.sampleName = this.name.getString();
            SampleStore.getInstance().addSample(sample);
            commandHandler.alertMessage(Phrases.savedTitle, Phrases.savedMessage, (Displayable)GraphViewer.graphForm);
            this.name.setString("");
        } else if (command == this.cancelCommand) {
            this.name.setString("");
            commandHandler.setCurrentDisplayable(commandHandler.getDisplayable("graph.GraphForm"));
        }
    }

    public void commandAction(Command command, Item item) {
        this.commandAction(command, (Displayable)this);
    }

    public void show(Displayable previousDisplayable) {
    }

    public void hide(Displayable nextDisplayable) {
    }
}

