/*
 * Decompiled with CFR 0.152.
 */
package graph.core;

import graph.lang.Phrases;

public class Color {
    public static final Color RED = new Color(255, 0, 0, Phrases.Red);
    public static final Color DARK_RED = new Color(150, 0, 0, Phrases.DarkRed);
    public static final Color GREEN = new Color(0, 255, 0, Phrases.Green);
    public static final Color DARK_GREEN = new Color(0, 100, 0, Phrases.DarkGreen);
    public static final Color BLUE = new Color(0, 0, 255, Phrases.Blue);
    public static final Color DARK_BLUE = new Color(0, 0, 100, Phrases.DarkBlue);
    public static final Color YELLOW = new Color(255, 255, 0, Phrases.Yellow);
    public static final Color ORANGE = new Color(255, 120, 0, Phrases.Orange);
    public static final Color CYAN = new Color(0, 255, 255, Phrases.Cyan);
    public static final Color PINK = new Color(255, 0, 255, Phrases.Pink);
    public static final Color PURPLE = new Color(100, 0, 128, Phrases.Purple);
    public static final Color WHITE = new Color(255, 255, 255, Phrases.White);
    public static final Color BLACK = new Color(0, 0, 0, Phrases.Black);
    public static final Color LIGHT_GREY = new Color(190, 190, 190, Phrases.LightGrey);
    public static final Color DARK_GREY = new Color(80, 80, 80, Phrases.DarkGrey);
    public static final Color GREY = new Color(128, 128, 128, Phrases.DarkGrey);
    public static final Color[] ColorArray = new Color[]{RED, GREEN, BLUE, ORANGE, YELLOW, CYAN, PURPLE, PINK, DARK_RED, DARK_GREEN, DARK_BLUE, LIGHT_GREY, DARK_GREY};
    public static final Color[] RGBArray = new Color[]{RED, GREEN, BLUE};
    protected int red;
    protected int green;
    protected int blue;
    protected String name;

    public Color(int red, int green, int blue) {
        this(red, green, blue, "Default Color");
    }

    public Color(int red, int green, int blue, String name) {
        if (!(this.isValidColorValue(red) && this.isValidColorValue(green) && this.isValidColorValue(blue))) {
            throw new IllegalArgumentException("The red, green and blue values must be between 0 and 255");
        }
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.name = name;
    }

    private boolean isValidColorValue(int value) {
        return value >= 0 && value <= 255;
    }

    public int getRGBValue() {
        int result = this.red;
        result <<= 8;
        result += this.green;
        result <<= 8;
        return result += this.blue;
    }

    public String getName() {
        return this.name;
    }

    public Color mix(Color other) {
        int newRed = (this.red + other.red) / 2;
        int newGreen = (this.green + other.green) / 2;
        int newBlue = (this.blue + other.blue) / 2;
        return new Color(newRed, newGreen, newBlue);
    }
}

