/*
 * Decompiled with CFR 0.152.
 */
package graph.core;

import graph.core.CriticalPoint;
import graph.core.ParseException;
import graph.core.Plotter;
import graph.core.PlotterRunnable;
import graph.core.ProgressBar;
import graph.core.Sample;
import graph.core.Settings;
import graph.eqn.Derivate;
import graph.eqn.Difference;
import graph.eqn.Equation;
import graph.eqn.SecondDerivate;
import graph.lang.Phrases;
import graph.utils.Utils;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class PlotterWithFunctionEvaluation
extends Plotter {
    private boolean interactiveMode = false;
    private Vector criticalPoints;
    final int CIRCLE_SIZE;
    final int VMARGIN;
    final int HMARGIN;
    private int realScreenWidth;
    private int realScreenHeight;
    public int selectedPointIndex = 0;
    private int rectangleHeight = this.font == null ? 100 : 16 + 3 * this.font.getHeight();
    private int lineY;
    private static final int NB_ITERATIONS = 40;
    private static volatile boolean isRunning = true;
    private static final int NB_SIMPLE_POINTS = 10;

    public PlotterWithFunctionEvaluation(Sample sample, int screenWidth, int screenHeight) throws ParseException {
        super(sample, screenWidth, screenHeight);
        this.CIRCLE_SIZE = 4;
        this.VMARGIN = 4;
        this.HMARGIN = 10;
        this.realScreenHeight = screenHeight;
        this.realScreenWidth = screenWidth;
    }

    public CriticalPoint getSelectedCriticalPoint() {
        return (CriticalPoint)this.criticalPoints.elementAt(this.selectedPointIndex);
    }

    public void enableInteractiveMode(boolean flag, ProgressBar progressBar) throws Exception {
        this.updateCriticalPoints(progressBar);
        this.interactiveMode = true;
    }

    public void disableInteractiveMode() {
        this.interactiveMode = false;
        this.criticalPoints = null;
    }

    public boolean getInteractiveMode() {
        return this.interactiveMode;
    }

    public Vector getCriticalPoints(ProgressBar progressBar) throws Exception {
        if (this.interactiveMode) {
            return this.criticalPoints;
        }
        return this.calculateCriticalPoints(progressBar);
    }

    private void updateCriticalPoints(ProgressBar progressBar) throws Exception {
        this.criticalPoints = this.calculateCriticalPoints(progressBar);
        this.selectedPointIndex = this.criticalPoints.size() / 2;
    }

    public void selectNextCriticalPoint() {
        this.selectedPointIndex = (this.selectedPointIndex + 1) % this.criticalPoints.size();
    }

    public void selectPreviousCriticalPoint() {
        this.selectedPointIndex = (this.selectedPointIndex - 1 + this.criticalPoints.size()) % this.criticalPoints.size();
    }

    public void plot(Graphics realGraphics) {
        if (this.interactiveMode) {
            int realScreenHeight = realGraphics.getClipHeight();
            this.lineY = realScreenHeight - this.rectangleHeight;
            this.changeVirtualScreenDimensions();
            Image subImage = Image.createImage((int)realGraphics.getClipWidth(), (int)(realGraphics.getClipHeight() - this.rectangleHeight));
            Graphics subgraphics = subImage.getGraphics();
            super.plot(subgraphics);
            realGraphics.drawImage(subImage, 0, 0, 20);
            if (!this.isInterrupted()) {
                this.plotFunctionEvaluation(realGraphics);
            } else {
                this.plotTextBackground(realGraphics);
            }
            this.restoreVirtualScreenDimensions();
        } else {
            super.plot(realGraphics);
        }
    }

    private void restoreVirtualScreenDimensions() {
        this.setScreenHeight(this.realScreenHeight);
    }

    private void changeVirtualScreenDimensions() {
        this.setScreenHeight(this.realScreenHeight - this.rectangleHeight);
    }

    public void createImage(PlotterRunnable runnable) {
        runnable.image = Image.createImage((int)this.realScreenWidth, (int)this.realScreenHeight);
        this.plot(runnable.getGraphics());
        this.setLastImage(runnable.image);
    }

    private void plotFunctionEvaluation(Graphics g) {
        if (this.criticalPoints != null && this.criticalPoints.size() > 0) {
            CriticalPoint selectedPoint = (CriticalPoint)this.criticalPoints.elementAt(this.selectedPointIndex);
            g.setColor(this.getForegroundColor().getRGBValue());
            int screenX = this.transformXCoordinateToScreen(selectedPoint.getX());
            int screenY = this.transformYCoordinateToScreen(selectedPoint.getY());
            g.drawArc(screenX - 4, screenY - 4, 8, 8, 0, 360);
            g.setStrokeStyle(1);
            g.drawLine(this.getXScreenCoordinateOrigin(), screenY, screenX, screenY);
            g.drawLine(screenX, screenY, screenX, this.getYScreenCoordinateOrigin());
            g.setStrokeStyle(0);
            this.plotTextBackground(g);
            g.setColor(selectedPoint.getColor().getRGBValue());
            String description = String.valueOf(Phrases.functionF) + selectedPoint.getEqnNumberString() + ": " + selectedPoint.getDescription();
            g.drawString(description, 10, this.realScreenHeight - (12 + 2 * this.font.getHeight()), 36);
            g.drawString("x = " + selectedPoint.getX(), 10, this.realScreenHeight - (8 + this.font.getHeight()), 36);
            g.drawString("y = " + selectedPoint.getY(), 10, this.realScreenHeight - 4, 36);
        }
    }

    private void plotTextBackground(Graphics g) {
        int screenWidth = g.getClipWidth();
        g.setColor(this.getBackgroundColor().getRGBValue());
        g.fillRect(0, this.lineY, screenWidth, this.lineY);
        g.setColor(this.getForegroundColor().getRGBValue());
        g.drawLine(0, this.lineY, screenWidth, this.lineY);
    }

    protected void screenSizeChanged() {
        super.screenSizeChanged();
        if (this.interactiveMode) {
            PlotterWithFunctionEvaluation.setRunning(true);
            try {
                this.updateCriticalPoints(null);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.interactiveMode = false;
            }
        }
    }

    public static synchronized void setRunning(boolean isRunning) {
        PlotterWithFunctionEvaluation.isRunning = isRunning;
    }

    public static boolean isRunning() {
        return isRunning;
    }

    public Vector calculateCriticalPoints(ProgressBar progressBar) throws Exception {
        try {
            if (Settings.CALCULATE_CRITICAL_POINTS) {
                return this.calculateCriticalPoints(Settings.getNbDecimals(), progressBar);
            }
            return this.calculateSimpleCriticalPoints(progressBar);
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Phrases.calculatingError) + "\n\n" + e.getMessage());
        }
    }

    public Vector calculateSimpleCriticalPoints(ProgressBar progressBar) {
        Vector<CriticalPoint> result = new Vector<CriticalPoint>();
        if (this.equations == null) {
            return result;
        }
        int n = this.equations.length;
        double stepsize = (xmax - xmin) / 10.0;
        if (progressBar != null) {
            progressBar.setMaxValue((10 * n + 5) / 10);
        }
        double x = xmin;
        int j = 0;
        while (j < 10) {
            int i = 0;
            while (i < n) {
                Equation eqn = this.equations[i];
                if (eqn != null) {
                    double xRounded = Utils.round(x, this.getNbRelevantXDecimals(2));
                    double yFunction = Utils.round(eqn.getFunctionValue(xRounded), Settings.getNbDecimals());
                    result.addElement(new CriticalPoint(eqn, xRounded, yFunction, new int[]{i}, null));
                }
                if (progressBar != null) {
                    progressBar.incrementValue();
                }
                ++i;
            }
            x += stepsize;
            ++j;
        }
        return result;
    }

    public Vector calculateCriticalPoints(int nbSignificantFigures, ProgressBar progressBar) {
        double yfunction;
        double xfunction;
        Equation eqn;
        Vector<CriticalPoint> result = new Vector<CriticalPoint>();
        if (this.equations == null) {
            return result;
        }
        int n = this.equations.length;
        double interval = xmax - xmin;
        double step = interval / 40.0;
        if (progressBar != null) {
            progressBar.setMaxValue(40 + 2 * n + 2);
        }
        double lastXfunction = xmin;
        double[] lastYfunction = new double[n];
        double[] lastDerivate = new double[n];
        double[] lastSecondDerivate = new double[n];
        Derivate[] derivates = new Derivate[n];
        SecondDerivate[] secondDerivates = new SecondDerivate[n];
        double[][] differences = new double[n - 1][n - 1];
        Utils.resetMatrix(differences);
        int i = 0;
        while (i < n && isRunning) {
            eqn = this.equations[i];
            if (eqn != null) {
                lastYfunction[i] = eqn.getFunctionValue(lastXfunction);
                lastDerivate[i] = Double.NaN;
                lastSecondDerivate[i] = Double.NaN;
                derivates[i] = new Derivate(eqn);
                secondDerivates[i] = new SecondDerivate(eqn);
                xfunction = Utils.round(xmin, this.getNbRelevantXDecimals(2));
                yfunction = Utils.round(eqn.getFunctionValue(xfunction), this.getNbRelevantXDecimals(2));
                int[] eqnNumbers = new int[]{i};
                String description = Phrases.leftScreenMargin;
                CriticalPoint criticalPoint = new CriticalPoint(eqn, xfunction, yfunction, eqnNumbers, description);
                result.addElement(criticalPoint);
                if (progressBar != null) {
                    progressBar.incrementValue();
                }
            }
            ++i;
        }
        double xfunction2 = xmin;
        while (xfunction2 < xmax && isRunning) {
            int i2 = 0;
            while (i2 < n && isRunning) {
                Equation eqn2 = this.equations[i2];
                if (eqn2 != null) {
                    yfunction = eqn2.getFunctionValue(xfunction2);
                    double derivate = derivates[i2].getFunctionValue(xfunction2);
                    double secondDerivate = secondDerivates[i2].getFunctionValue(xfunction2);
                    int j = i2 - 1;
                    while (j >= 0 && isRunning) {
                        if (this.equations[j] != null) {
                            double difference = yfunction - lastYfunction[j];
                            if (Utils.hasOppositeSign(difference, differences[j][i2 - 1]) && Utils.isValidDouble(differences[j][i2 - 1]) && Utils.isValidDouble(difference)) {
                                result.addElement(new CriticalPoint(eqn2, new Difference(eqn2.getExpression(), this.equations[j].getExpression()), lastXfunction, xfunction2, new int[]{j, i2}, Phrases.intersection));
                            }
                            differences[j][i2 - 1] = difference;
                        }
                        --j;
                    }
                    if (Utils.hasOppositeSign(lastYfunction[i2], yfunction)) {
                        result.addElement(new CriticalPoint(eqn2, eqn2.getExpression(), lastXfunction, xfunction2, new int[]{i2}, Phrases.nullpoint));
                    } else if (Utils.hasOppositeSign(lastXfunction, xfunction2)) {
                        result.addElement(new CriticalPoint(eqn2, 0.0, eqn2.getFunctionValue(0.0), new int[]{i2}, Phrases.yaxisIntersection));
                    }
                    if (Utils.isValidDouble(derivate) && Utils.isValidDouble(lastDerivate[i2]) && Utils.hasOppositeSign(lastDerivate[i2], derivate)) {
                        if (secondDerivate > 0.0) {
                            result.addElement(new CriticalPoint(eqn2, derivates[i2], lastXfunction, xfunction2, new int[]{i2}, Phrases.minimum));
                        } else {
                            result.addElement(new CriticalPoint(eqn2, derivates[i2], lastXfunction, xfunction2, new int[]{i2}, Phrases.maximum));
                        }
                    }
                    if (Utils.isValidDouble(secondDerivate) && Utils.isValidDouble(lastSecondDerivate[i2]) && Utils.hasOppositeSign(lastSecondDerivate[i2], secondDerivate)) {
                        result.addElement(new CriticalPoint(eqn2, secondDerivates[i2], lastXfunction, xfunction2, new int[]{i2}, Phrases.inflectionPoint));
                    }
                    lastYfunction[i2] = yfunction;
                    lastDerivate[i2] = derivate;
                    lastSecondDerivate[i2] = secondDerivate;
                }
                ++i2;
            }
            lastXfunction = xfunction2;
            if (progressBar != null) {
                progressBar.incrementValue();
            }
            xfunction2 += step;
        }
        i = 0;
        while (i < n && isRunning) {
            eqn = this.equations[i];
            if (eqn != null) {
                xfunction = Utils.round(xmax, this.getNbRelevantXDecimals(2));
                yfunction = Utils.round(eqn.getFunctionValue(xfunction), this.getNbRelevantXDecimals(2));
                result.addElement(new CriticalPoint(eqn, xfunction, yfunction, new int[]{i}, Phrases.rightScreenMargin));
                if (progressBar != null) {
                    progressBar.incrementValue();
                }
            }
            ++i;
        }
        return result;
    }

    public void setCurrentCriticalPointAroundCoordinate(int xScreen, int yScreen) {
        if (this.criticalPoints != null && this.criticalPoints.size() != 0) {
            this.changeVirtualScreenDimensions();
            double xCoord = this.transformXCoordinateFromScreen(xScreen);
            double yCoord = this.transformYCoordinateFromScreen(yScreen);
            this.restoreVirtualScreenDimensions();
            double smallestDistance = Double.MAX_VALUE;
            int nearestCriticalPointIndex = 0;
            int i = 0;
            while (i < this.criticalPoints.size()) {
                double currentYCoord;
                double yDistance;
                CriticalPoint currentCriticalPoint = (CriticalPoint)this.criticalPoints.elementAt(i);
                double currentXCoord = currentCriticalPoint.getX();
                double xDistance = (currentXCoord - xCoord) * (currentXCoord - xCoord);
                double currentDistance = Math.sqrt(xDistance + (yDistance = ((currentYCoord = currentCriticalPoint.getY()) - yCoord) * (currentYCoord - yCoord)));
                if (smallestDistance > currentDistance) {
                    smallestDistance = currentDistance;
                    nearestCriticalPointIndex = i;
                }
                ++i;
            }
            this.selectedPointIndex = nearestCriticalPointIndex;
        }
    }
}

