/*
 * Decompiled with CFR 0.152.
 */
package graph.core;

import graph.core.Sample;
import graph.lang.Phrases;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;

public class SampleStore {
    private static SampleStore instance;
    public static final String RECORD_STORE_NAME_SAMPLES = "Samples";
    private Vector samples = null;
    private boolean isChanged = false;
    private SampleListener listener;

    private Sample[] getDefaultSamples() {
        return new Sample[]{new Sample(Phrases.ClimbingSine, new String[]{"y=sin(x)+x", "y=sin(x)-x", "y=-sin(x)-x", "y=-sin(x)+x"}, -3.2, 3.2, -3.2, 3.2), new Sample(Phrases.Cubical, new String[]{"y=-0.01x^3+0.1x^2+x-2"}, -15.0, 20.0, -5.0, 10.0, false, true, true, false), new Sample(Phrases.DampedOscillation, new String[]{"y=10e^(-0.2x)sin(2x)", "y=10e^(-0.2x)", "y=-10e^(-0.2x)"}, 0.0, 20.0, -10.0, 10.0), new Sample(Phrases.DiscreteFunctions, new String[]{"y=x%3", "", "y=frac(x-1)+1", "", "y=ceil(x)", "y=floor(x)"}, 0.99, 3.02, 0.99, 3.02), new Sample(Phrases.Exponential, new String[]{"y=e^(x)", "y=ln(x)", "y=x"}, -3.0, 3.0, -3.0, 3.0), new Sample(Phrases.Hyperboles, new String[]{"y=1/x", "y=4*f(1)", "y=6*f(1)", "y=2*f(1)", "y=3*f(1)", "y=5*f(1)", "y=7*f(1)"}, 0.0, 4.0, 0.0, 4.0), new Sample(Phrases.GaussCurve, new String[]{"y=1/(0.4sqrt(2pi))e^(-0.5((x-1)/0.4)^2)"}, -0.5, 3.0, -1.6, 1.6, false, true, false, false), new Sample(Phrases.LineairSine, new String[]{"y=xsin(x)", "y=x", "y=-x"}, -10.0, 10.0, -10.0, 10.0), new Sample(Phrases.goniometricExponentialFunction, new String[]{"y=3^(2sin(x))"}, 0.0, 10.0, 0.0, 20.0, false, false, false, true), new Sample(Phrases.Muscle, new String[]{"y=sinh(x)", "y=f(1)+3", "y=f(1)+5", "y=f(1)+1", "y=f(1)+2", "y=f(1)+4", "y=f(1)+6"}, -5.0, 5.0, -10.0, 10.0), new Sample(Phrases.Paraboles, new String[]{"y=0.2x^2-5", "y=-0.1xx+6", "y=-0.3xx-3"}, -10.0, 10.0, -10.0, 10.0), new Sample(Phrases.Rainbow, new String[]{"x^2+y^2=10", "f(1)-3", "f(1)-5", "f(1)-1", "f(1)-2", "f(1)-4", "f(1)-6"}, -4.0, 4.0, -4.0, 6.0), new Sample(Phrases.SineWave, new String[]{"y=sin(x)", "y=cos(x)", "y=-sin(x)", "", "y=-cos(x)"}, -3.0, 3.0, -2.0, 2.0), new Sample("sin(x)/x", new String[]{"y=sin(x)/x", "y=4*f(1)", "y=6*f(1)", "y=2*f(1)", "y=3*f(1)", "y=5*f(1)", "y=7*f(1)"}, -6.3, 6.3, -2.0, 8.0), new Sample(Phrases.SquareRoot, new String[]{"y=sqrt(x)", "y=x^2", "y=x"}, 0.0, 1.5, 0.0, 1.5), new Sample(Phrases.Tangent, new String[]{"y=tan(x)", "y=-tan(x)"}, -1.5, 1.5, -1.5, 1.5), new Sample(Phrases.Triangle, new String[]{"y=20", "y=x", "y=-x+100"}, 20.0, 80.0, 10.0, 50.0)};
    }

    public static SampleStore getInstance() {
        if (instance == null) {
            instance = new SampleStore();
        }
        return instance;
    }

    public SampleStore() {
        this.loadSamples();
    }

    public Sample[] getSamples() {
        if (this.samples == null) {
            return this.getDefaultSamples();
        }
        Object[] result = new Sample[this.samples.size()];
        this.samples.copyInto(result);
        return result;
    }

    public Sample getSample(int index) {
        if (this.samples == null) {
            return this.getDefaultSamples()[index];
        }
        return (Sample)this.samples.elementAt(index);
    }

    public void addSample(Sample sample) {
        if (this.samples == null) {
            this.loadDefaultSamples();
        }
        this.samples.addElement(sample);
        this.notifyChanged();
    }

    public void deleteSample(int index) {
        if (this.samples == null) {
            this.loadDefaultSamples();
        }
        this.samples.removeElementAt(index);
        this.notifyChanged();
    }

    public void resetSamples() {
        this.samples = null;
        this.notifyChanged();
    }

    private void loadDefaultSamples() {
        if (this.samples == null) {
            this.samples = new Vector();
        } else {
            this.samples.removeAllElements();
        }
        Sample[] defaultSamples = this.getDefaultSamples();
        int i = 0;
        while (i < defaultSamples.length) {
            this.samples.addElement(defaultSamples[i]);
            ++i;
        }
    }

    public void loadSamples() {
        RecordStore store = null;
        try {
            try {
                store = RecordStore.openRecordStore((String)RECORD_STORE_NAME_SAMPLES, (boolean)false, (int)0, (boolean)false);
                this.samples = new Vector();
                if (store.getNumRecords() != 0) {
                    RecordEnumeration records = store.enumerateRecords(null, Sample.sampleComparator, false);
                    while (records.hasNextElement()) {
                        byte[] record = records.nextRecord();
                        this.samples.addElement(new Sample(record));
                    }
                }
            }
            catch (RecordStoreNotFoundException e) {
                System.out.println("No saved samples found yet");
            }
            catch (Exception e) {
                System.err.println("Error in SampleStore.loadsamples(): " + e.getMessage());
            }
        }
        finally {
            try {
                if (store != null) {
                    store.closeRecordStore();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void saveSamples() {
        if (this.isChanged) {
            RecordStore store = null;
            try {
                RecordStore.deleteRecordStore((String)RECORD_STORE_NAME_SAMPLES);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.samples != null) {
                try {
                    try {
                        store = RecordStore.openRecordStore((String)RECORD_STORE_NAME_SAMPLES, (boolean)true, (int)0, (boolean)true);
                        int i = 0;
                        while (i < this.samples.size()) {
                            byte[] sampleBytes = ((Sample)this.samples.elementAt(i)).toByteArray();
                            store.addRecord(sampleBytes, 0, sampleBytes.length);
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        System.err.println("No samples saved yet.");
                        e.printStackTrace();
                    }
                }
                finally {
                    try {
                        if (store != null) {
                            store.closeRecordStore();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void setListener(SampleListener list) {
        this.listener = list;
    }

    private void notifyChanged() {
        this.isChanged = true;
        if (this.listener != null) {
            this.listener.samplesChanged();
        }
    }

    public static interface SampleListener {
        public void samplesChanged();
    }
}

