/*
 * Decompiled with CFR 0.152.
 */
package graph.eqn;

import graph.core.CalculateException;
import graph.core.Settings;
import graph.eqn.Difference;
import graph.eqn.Expression;
import graph.eqn.Number;
import graph.eqn.Tangens;
import graph.eqn.UnaryExpression;
import graph.eqn.X;
import graph.utils.Utils;

public class ArcTangens
extends UnaryExpression {
    private Number number = new Number(0.0);
    private Expression nullpointEqn = new Difference(new Tangens(new X()), this.number);

    public ArcTangens(Expression eqn) {
        super(eqn);
    }

    public double getValue(double xValue, double yValue) {
        try {
            double t = this.expr1.getValue(xValue, yValue);
            this.number.setNumber(t);
            int nbDecimals = Settings.getNbDecimals();
            double x = Utils.getNullpoint(this.nullpointEqn, -1.5707963267948966, 1.5707963267948966, Utils.pow(0.1, nbDecimals));
            return x;
        }
        catch (CalculateException e) {
            e.printStackTrace();
            return Double.NaN;
        }
    }

    public String getFunctionAsString() {
        return "atan(" + this.expr1.getFunctionAsString() + ")";
    }
}

