/*
 * Decompiled with CFR 0.152.
 */
package graph.eqn;

import graph.eqn.BinaryExpression;
import graph.eqn.Expression;
import graph.utils.Utils;

public class Combination
extends BinaryExpression {
    public Combination(Expression n, Expression k) {
        super(n, k);
    }

    public double getValue(double xValue, double yValue) {
        double nValue = this.expr1.getValue(xValue, yValue);
        double kValue = this.expr2.getValue(xValue, yValue);
        if (kValue < 0.0 || nValue < 0.0 || !Utils.isValidDouble(kValue) || !Utils.isValidDouble(nValue)) {
            return Double.NaN;
        }
        double kFaculty = Utils.faculty(kValue);
        double result = 1.0;
        int i = 0;
        while ((double)i < kValue) {
            result *= nValue - (double)i;
            ++i;
        }
        return result /= kFaculty;
    }

    public String getFunctionAsString() {
        return "C(" + this.expr1.getFunctionAsString() + "," + this.expr2.getFunctionAsString() + ")";
    }
}

