/*
 * Decompiled with CFR 0.152.
 */
package graph.eqn;

import graph.core.Settings;
import graph.eqn.Equation;
import graph.eqn.Expression;
import graph.eqn.SimpleEquation;

public class Integral
extends Expression {
    private Expression x1;
    private Expression x2;
    private Equation eqn;

    public Integral(Expression x1, Expression x2, Equation eqn) {
        this.eqn = eqn;
        this.x1 = x1;
        this.x2 = x2;
    }

    public Integral(Expression x1, Expression x2, Expression expr) {
        this.eqn = new SimpleEquation(expr);
        this.x1 = x1;
        this.x2 = x2;
    }

    public double getFunctionValue(double xValue) {
        double x1Value = this.x1.getValue(xValue, 0.0);
        double x2Value = this.x2.getValue(xValue, 0.0);
        int nbIterations = Settings.getMaxDepth();
        double stepSize = (x2Value - x1Value) / (double)nbIterations;
        double sum = 0.0;
        if (stepSize == 0.0) {
            return 0.0;
        }
        double x = x1Value;
        int i = 0;
        while (i < nbIterations) {
            sum += this.eqn.getFunctionValue(x + stepSize / 2.0) * stepSize;
            x += stepSize;
            ++i;
        }
        return sum;
    }

    public String getFunctionAsString() {
        return "I(" + this.x1.getFunctionAsString() + "," + this.x2.getFunctionAsString() + "," + this.eqn.getFunctionAsString() + ")";
    }

    public double getValue(double xValue, double yValue) {
        return this.getFunctionValue(xValue);
    }
}

