/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;

final class EntityDef {
    public short tileIndex;
    public short name;
    public short longName;
    public short description;
    public byte eType;
    public byte eSubType;
    public byte parm;
    public static int touchMe = 1;
    private static EntityDef[] list;
    public static int numDefs;

    EntityDef() {
    }

    public static final boolean startup() {
        numDefs = 0;
        App.checkPausedState();
        try {
            int n;
            InputStream inputStream = App.getResourceAsStream("/entities.bin");
            Resource.read(inputStream, 2);
            numDefs = Resource.shiftShort();
            list = new EntityDef[numDefs];
            for (n = 0; n < numDefs; ++n) {
                EntityDef.list[n] = new EntityDef();
            }
            for (n = 0; n < numDefs; ++n) {
                EntityDef entityDef = list[n];
                Resource.read(inputStream, 8);
                entityDef.tileIndex = Resource.shiftShort();
                entityDef.eType = Resource.shiftByte();
                entityDef.eSubType = Resource.shiftByte();
                entityDef.parm = Resource.shiftByte();
                entityDef.name = Resource.shiftUByte();
                entityDef.longName = Resource.shiftUByte();
                entityDef.description = Resource.shiftUByte();
            }
            return true;
        }
        catch (IOException iOException) {
            App.Error(iOException, 18);
            return false;
        }
    }

    public static final EntityDef find(int n, int n2) {
        return EntityDef.find(n, n2, -1);
    }

    public static final EntityDef find(int n, int n2, int n3) {
        for (int i = 0; i < numDefs; ++i) {
            if (EntityDef.list[i].eType != n || EntityDef.list[i].eSubType != n2 || n3 != -1 && EntityDef.list[i].parm != n3) continue;
            return list[i];
        }
        return null;
    }

    public static final EntityDef lookup(int n) {
        for (int i = 0; i < numDefs; ++i) {
            short s = EntityDef.list[i].tileIndex;
            if (s != n) continue;
            return list[i];
        }
        return null;
    }
}

