/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

final class Hud {
    public static int touchMe = 1;
    private static final int MSG_DISPLAY_TIME = 700;
    private static final int MSG_FLASH_TIME = 100;
    private static final int SCROLL_START_DELAY = 750;
    private static final int MS_PER_CHAR = 50;
    private static final int MAX_MESSAGES = 5;
    public static final int REPAINT_EFFECTS = 1;
    public static final int REPAINT_TOP_BAR = 2;
    public static final int REPAINT_BOTTOM_BAR = 4;
    public static final int REPAINT_BUBBLE_TEXT = 8;
    public static final int REPAINT_SUBTITLES = 16;
    public static final int REPAINT_PLAYING_FLAGS = 11;
    public static final int REPAINT_CAMERA_FLAGS = 16;
    public static int repaintFlags = 0;
    public static final int MSG_FLAG_NONE = 0;
    public static final int MSG_FLAG_FORCE = 1;
    public static final int MSG_FLAG_CENTER = 2;
    public static final int MSG_FLAG_BLUE = 4;
    private static final int STATUSBAR_ICON_PICKUP = 0;
    private static final int STATUSBAR_ICON_ATTACK = 1;
    private static final int STATUSBAR_ICON_CHAT = 2;
    private static final int STATUSBAR_ICON_USE = 3;
    public static final int HUDARROWS_SIZE = 12;
    private static final int BUBBLE_TEXT_TIME = 1500;
    public static Image imgScope;
    public static Image imgActions;
    public static Image imgAttArrow;
    public static Image imgDamageVignette;
    public static Image imgBottomBarIcons;
    public static Image imgAmmoIcons;
    public static Image imgSoftKeyFill;
    public static final int ACTION_ICON_SIZE = 18;
    public static Image imgPortraitsSM;
    public static Image imgPlayerFaces;
    public static Image imgHudFill;
    public static Image imgIce;
    private static Text[] messages;
    static int[] messageFlags;
    public static int msgCount;
    static int msgTime;
    private static int msgDuration;
    public static int subTitleID;
    public static int subTitleTime;
    public static int cinTitleID;
    public static int cinTitleTime;
    private static Text bubbleText;
    private static int bubbleTextTime;
    public static int damageTime;
    public static int damageCount;
    public static int damageDir;
    public static Entity lastTarget;
    private static int monsterStartHealth;
    private static int monsterDestHealth;
    public static int playerStartHealth;
    public static int playerDestHealth;
    private static int monsterHealthChangeTime;
    public static int playerHealthChangeTime;
    public static boolean showCinPlayer;
    public static int drawTime;
    private static final int DEF_MESSAGE_TIME = 1500;
    private static final int FILLER_BEVEL_COLOR1 = -6645369;
    private static final int FILLER_BEVEL_COLOR2 = -14868980;
    static final int IMG_FACE_WIDTH = 25;
    static final int IMG_FACE_HALF_WIDTH = 12;
    static final int ARROW_WIDTH = 20;
    public static final int BTM_ICON_W = 30;
    public static final int BTM_ICON_H = 15;
    public static final int BTM_AMMO_H = 14;
    public static final int CHAT_HOOK_HEIGHT = 6;
    public static final int CHAT_HOOK_WIDTH = 10;

    Hud() {
    }

    public static final boolean startup() {
        for (int i = 0; i < messages.length; ++i) {
            Hud.messages[i] = new Text(64);
        }
        msgCount = 0;
        return true;
    }

    private static final void shiftMsgs() {
        if ((messageFlags[0] & 2) != 0) {
            Canvas.invalidateRect();
        }
        for (int i = 0; i < msgCount - 1; ++i) {
            messages[i].setLength(0);
            messages[i].append(messages[i + 1]);
            Hud.messageFlags[i] = messageFlags[i + 1];
        }
        messages[--msgCount].setLength(0);
        Hud.messageFlags[Hud.msgCount] = 0;
        if (msgCount > 0) {
            Hud.calcMsgTime();
        }
    }

    private static final void calcMsgTime() {
        msgTime = App.time;
        int n = messages[0].length();
        if (n <= Canvas.menuHelpMaxChars) {
            msgDuration = 700;
        } else {
            msgDuration = n * 50;
            if ((messageFlags[0] & 2) != 0 && msgDuration > 1500) {
                msgDuration = 1500;
            }
        }
    }

    public static final void addMessage(short s) {
        Hud.addMessage((short)1, s, 0);
    }

    public static final void addMessage(short s, short s2) {
        Hud.addMessage(s, s2, 0);
    }

    public static final void addMessage(short s, int n) {
        Hud.addMessage((short)1, s, n);
    }

    public static final void addMessage(short s, short s2, int n) {
        Text text = Text.getSmallBuffer();
        Text.composeText(s, s2, text);
        Hud.addMessage(text, n);
        text.dispose();
    }

    public static final void addMessage(Text text) {
        Hud.addMessage(text, 0);
    }

    public static final void addMessage(Text text, int n) {
        if (text == null) {
            return;
        }
        if ((n & 1) != 0) {
            msgCount = 0;
        }
        if (msgCount > 0 && text.equals(messages[msgCount - 1])) {
            return;
        }
        if (msgCount == 5) {
            Hud.shiftMsgs();
        }
        messages[msgCount].setLength(0);
        messages[msgCount].append(text);
        if ((n & 2) != 0) {
            messages[msgCount].wrapText((Canvas.viewRect[2] - 7) / 7);
        } else {
            messages[msgCount].dehyphenate();
        }
        Hud.messageFlags[Hud.msgCount] = n;
        if (++msgCount == 1) {
            Hud.calcMsgTime();
            if ((n & 1) != 0) {
                msgDuration *= 2;
            }
        }
    }

    public static final Text getMessageBuffer() {
        return Hud.getMessageBuffer(0);
    }

    public static final Text getMessageBuffer(int n) {
        if ((n & 1) != 0) {
            msgCount = 0;
        }
        if (msgCount == 5) {
            Hud.shiftMsgs();
        }
        messages[msgCount].setLength(0);
        Hud.messageFlags[Hud.msgCount] = n;
        return messages[msgCount];
    }

    public static final void finishMessageBuffer() {
        messages[msgCount].dehyphenate();
        if (++msgCount == 1) {
            Hud.calcMsgTime();
        }
    }

    private static final void drawFiller(Graphics graphics) {
        int[] nArray = Canvas.screenRect;
        int[] nArray2 = Canvas.viewRect;
        int n = (nArray[2] - nArray2[2]) / 2;
        int n2 = nArray[3] - 50;
        if (n < 1) {
            return;
        }
        graphics.fillRegion(imgHudFill, nArray[0], 25, n, n2);
        graphics.drawBevel(-6645369, -14868980, nArray[0], 25, n, n2);
        graphics.fillRegion(imgHudFill, nArray2[0] + nArray2[2], 25, n, n2);
        graphics.drawBevel(-6645369, -14868980, nArray2[0] + nArray2[2], 25, n, n2);
        graphics.eraseRgn(nArray[0] + n, 25, nArray2[2], (n2 - nArray2[3]) / 2);
        graphics.eraseRgn(nArray[0] + n, nArray2[1] + nArray2[3], nArray2[2], (n2 - nArray2[3]) / 2);
    }

    public static boolean isShiftingCenterMsg() {
        return msgCount > 0 && App.time - msgTime > msgDuration && (messageFlags[0] & 2) != 0;
    }

    private static final void drawTopBar(Graphics graphics) {
        int n;
        Text text = Text.getSmallBuffer();
        int n2 = 2;
        Entity entity = Player.facingEntity;
        graphics.fillRegion(imgHudFill, -Canvas.screenRect[0], 0, Canvas.hudRect[2], 25);
        graphics.drawBevel(-6645369, -14868980, -Canvas.screenRect[0], 0, Canvas.hudRect[2], 25);
        if (Canvas.state != 13) {
            Hud.drawMonsterHealth(graphics);
        }
        if (msgCount > 0 && App.time - msgTime > msgDuration + 100) {
            Hud.shiftMsgs();
        }
        int n3 = -1;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n4 = 0;
        if (msgCount > 0) {
            text.setLength(0);
            text.append(messages[0]);
            bl2 = (messageFlags[0] & 2) != 0;
            boolean bl4 = bl3 = (messageFlags[0] & 4) != 0;
            if (App.time - msgTime > msgDuration) {
                bl = true;
            } else {
                int n5;
                n = text.length() - Canvas.menuHelpMaxChars;
                if (n > 0 && (n5 = App.time - msgTime) > 750 && (n4 = (n5 - 750) / 50) > n) {
                    n4 = n;
                }
            }
        } else if (Canvas.state != 1 && entity != null && entity.def.eType != 0 && (entity.def.eType != 12 || (entity.info & 0x40000) != 0)) {
            text.setLength(0);
            n = (entity.info & 0xFFFF) - 1;
            int n6 = Render.mapSpriteInfo[n] & 0xFF;
            byte by = entity.def.eType;
            if ((entity.name & 0x3FF) != entity.def.name || entity.def.longName == 92) {
                Text.composeTextField(entity.name, text);
            } else {
                Text.composeTextField(0x800 | entity.def.longName, text);
            }
            text.dehyphenate();
            if (by == 3) {
                n3 = 2;
            } else if (by == 2) {
                text.setLength(0);
                if ((entity.name & 0x3FF) != entity.def.name) {
                    Text.composeTextField(entity.name, text);
                } else {
                    Text.composeTextField(entity.def.longName | 0x800, text);
                }
                n3 = by == 2 && (entity.monster.flags & 0x800) != 0 ? 2 : 1;
                text.dehyphenate();
            } else if (by == 6) {
                n3 = 0;
            } else if (by == 5) {
                n3 = 3;
                if (by == 5 && (entity.def.parm & 2) != 0) {
                    bl2 = true;
                }
            } else if (by == 12) {
                bl2 = true;
            } else if (by == 7 && entity.def.eSubType == 1) {
                bl2 = true;
            } else if (by == 7) {
                byte by2 = entity.def.eSubType;
                if (by2 == 3) {
                    n3 = 1;
                } else if (n6 == 153 && (Render.mapSpriteInfo[n] & 0xFF00) >> 8 == 0) {
                    n3 = 3;
                } else if (entity.def.parm == 1) {
                    n3 = 3;
                } else if (entity.def.parm == 2) {
                    int n7 = 0;
                    if ((Render.mapSpriteInfo[n] & 0xFF) == 158) {
                        n7 = 1;
                    }
                    if ((Render.mapSpriteInfo[n] & 0xFF00) >> 8 == n7) {
                        n3 = 3;
                    }
                }
            } else if (by == 14) {
                if (n6 == 62) {
                    bl2 = true;
                } else if (n6 == 63) {
                    n3 = 3;
                } else if (n6 == 61) {
                    n3 = 1;
                } else if (entity.def.eSubType == 4) {
                    n3 = 0;
                }
            } else if (by == 10) {
                n3 = entity.def.eSubType == 10 ? 0 : 1;
            }
        } else if (entity != null && entity.def.eType == 12) {
            n = (entity.info & 0xFFFF) - 1;
            if ((Render.mapSpriteInfo[n] & 0xFF) == 153 && (Render.mapSpriteInfo[n] & 0xFF00) >> 8 == 0) {
                n3 = 3;
            } else {
                bl = true;
            }
        } else {
            bl = true;
        }
        if (!bl) {
            if (bl2 && text.length() > 0) {
                Hud.drawCenterMessage(graphics, text, bl3 ? -16777097 : -16777216);
            } else {
                if (n3 != -1) {
                    graphics.drawRegion(imgActions, 0, n3 * 18, 18, 18, n2 - Canvas.screenRect[0], Canvas.screenRect[1] + 3, 20, 0);
                    n2 += 20;
                }
                if (n2 + 9 * ((n = text.length()) + 1) > Canvas.hudRect[2]) {
                    n = (Canvas.hudRect[2] - n2) / 7 - 1;
                }
                graphics.drawString(text, n2 - Canvas.screenRect[0], 7, 0, n4, n);
            }
        }
        text.dispose();
    }

    private static final void drawCenterMessage(Graphics graphics, Text text, int n) {
        int n2;
        int n3 = text.length();
        int n4 = text.getStringWidth() + 8;
        if (n4 > Canvas.hudRect[2]) {
            n4 = Canvas.hudRect[2];
        }
        int n5 = -Canvas.screenRect[1] + 50;
        int n6 = -Canvas.screenRect[0] + Canvas.hudRect[2] / 2;
        int n7 = text.getNumLines();
        graphics.setColor(n);
        graphics.fillRect(n6 - n4 / 2, n5, n4 - 1, 12 * n7 + 3);
        graphics.setColor(-5592406);
        graphics.drawRect(n6 - n4 / 2, n5, n4 - 1, 12 * n7 + 3);
        int n8 = n5 + 3;
        int n9 = 0;
        Text text2 = Text.getSmallBuffer();
        while ((n2 = text.findFirstOf('|', n9)) >= 0) {
            text2.setLength(0);
            text.substring(text2, n9, n2);
            graphics.drawString(text2, n6, n8, 17, 0, n2 - n9);
            n8 += 12;
            n9 = n2 + 1;
        }
        text2.setLength(0);
        text.substring(text2, n9);
        graphics.drawString(text2, n6, n8, 17, 0, text.length() - n9);
        text2.dispose();
    }

    public static final void drawCinematicText(Graphics graphics) {
        int n = Canvas.SCR_CX;
        int n2 = 1;
        int n3 = imgPlayerFaces.getWidth();
        int[] nArray = Canvas.displayRect;
        int[] nArray2 = Canvas.cinRect;
        int[] nArray3 = Canvas.viewRect;
        graphics.eraseRgn(0, 0, nArray[2], nArray2[1] + nArray3[1]);
        graphics.eraseRgn(0, nArray2[1] + nArray2[3] + nArray3[1], nArray[2], Canvas.softKeyY - (nArray3[1] + nArray2[1] + nArray2[3]));
        int n4 = showCinPlayer ? Canvas.subtitleMaxChars - 5 : Canvas.subtitleMaxChars;
        Text text = Text.getLargeBuffer();
        if (cinTitleID != -1 && cinTitleTime > App.gameTime) {
            text.setLength(0);
            Text.composeText(cinTitleID, text);
            text.wrapText(n4, 1, '\n');
            graphics.drawString(text, n, 1, 1);
        }
        if (subTitleID != -1 && subTitleTime > App.gameTime) {
            int n5 = Canvas.viewRect[1] + Canvas.cinRect[1] + Canvas.cinRect[3];
            n5 += Canvas.screenRect[3] - n5 - 24 >> 1;
            text.setLength(0);
            Text.composeText(subTitleID, text);
            text.wrapText(n4, 2, '\n');
            int n6 = text.findFirstOf('\n', 0);
            if (n6 == -1) {
                if (showCinPlayer) {
                    n = n3 + 5;
                    n2 = 4;
                    graphics.drawRegion(imgPlayerFaces, 0, 0, 25, 25, n - n3, n5);
                    n += 5;
                }
                graphics.drawString(text, n, n5, n2);
            } else {
                if (showCinPlayer) {
                    n = n3 + 5;
                    n2 = 4;
                    if (n6 > text.length() - n6) {
                        graphics.drawRegion(imgPlayerFaces, 0, 0, 25, 25, n - n3, n5);
                    } else {
                        graphics.drawRegion(imgPlayerFaces, 0, 0, 25, 25, n - n3, n5);
                    }
                    n += 5;
                }
                graphics.drawString(text, n, n5, n2, 0, n6);
                graphics.drawString(text, n, n5 += 12, n2, n6 + 1, 9999);
            }
        }
        text.dispose();
        Hud.drawBubbleText(graphics);
    }

    private static final void drawEffects(Graphics graphics) {
        int n;
        int n2;
        int n3;
        if (Canvas.loadMapID >= 8 && TinyGL.fogRange < -1) {
            n3 = TinyGL.fogRange >> 4;
            n2 = (1024 + n3 << 8) / 1024;
            n = imgIce.getHeight();
            int n4 = 0;
            int n5 = -(n2 * n >> 8);
            graphics.setScreenSpace(Canvas.viewRect);
            graphics.drawImage(imgIce, n4, n5, 0, 0);
            graphics.drawImage(imgIce, n4 + Canvas.viewRect[2], n5, 24, 2);
            graphics.resetScreenSpace();
        }
        if (Canvas.state != 13) {
            Player.drawBuffs(graphics);
        }
        if (App.time < damageTime && damageCount > 0 && Combat.totalDamage > 0) {
            if ((1 << damageDir & 0xC1) != 0) {
                n3 = 0;
                n2 = Canvas.screenRect[3] - 25 - 25;
                n = 0;
                if (damageDir == 0) {
                    n3 = Canvas.screenRect[2] - 20;
                    n = 24;
                } else if (damageDir == 6) {
                    n3 = 20;
                    n = 12;
                } else {
                    n3 = Canvas.screenRect[2] >> 1;
                }
                graphics.drawRegion(imgAttArrow, 0, n, 12, 12, n3, n2, 3, 0);
            }
        } else if (damageTime != 0) {
            damageTime = 0;
        }
    }

    public static final void drawDamageVignette(Graphics graphics) {
        if (App.time < damageTime && damageCount >= 0 && Combat.totalDamage > 0) {
            int n = 0;
            switch (damageDir) {
                case 1: {
                    n = 2;
                    break;
                }
                case 2: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 15;
                    break;
                }
                case 4: {
                    n = 5;
                    break;
                }
                case 5: {
                    n = 4;
                    break;
                }
                case 0: 
                case 6: 
                case 7: {
                    n = 8;
                }
            }
            int n2 = imgDamageVignette.getWidth();
            int[] nArray = Canvas.viewRect;
            if ((n & 1) != 0) {
                graphics.fillRegion(imgDamageVignette, nArray[0], nArray[1], nArray[2], n2, 5);
            }
            if ((n & 2) != 0) {
                graphics.fillRegion(imgDamageVignette, nArray[0] + (nArray[2] - n2), nArray[1], n2, nArray[3], 2);
            }
            if ((n & 4) != 0) {
                graphics.fillRegion(imgDamageVignette, nArray[0], nArray[1], n2, nArray[3], 0);
            }
            if ((n & 8) != 0) {
                graphics.fillRegion(imgDamageVignette, nArray[0], nArray[1] + (nArray[3] - n2), nArray[2], n2, 6);
            }
        }
    }

    private static final void drawBottomBar(Graphics graphics) {
        Text text = Text.getSmallBuffer();
        int n = Canvas.SCR_CX;
        int n2 = Canvas.hudRect[3] - 25;
        graphics.fillRegion(imgHudFill, -Canvas.screenRect[0], n2, Canvas.hudRect[2], 25);
        int n3 = (n - 12) / 4 + 1;
        graphics.drawRegion(imgBottomBarIcons, 0, 0, 30, 14, n3, n2 + 1, 17, 0);
        text.setLength(0);
        text.append(Player.ce.getStat(2));
        graphics.drawString(text, n3 - 2, n2 + 25 + 2, 33);
        n3 = (n - 12) / 4 * 3 + 1;
        graphics.drawRegion(imgBottomBarIcons, 0, 16, 30, 14, n3, n2 + 1, 17, 0);
        text.setLength(0);
        text.append(Player.ce.getStat(0));
        graphics.drawString(text, n3 - 2, n2 + 25 + 2, 33);
        int n4 = 5 - Player.ce.getStat(0) * 5 / Player.ce.getStat(1);
        graphics.drawRegion(imgPlayerFaces, 0, n4 * 25, 25, 25, n, n2, 17, 0);
        n3 = n + 12 + (n - 12) / 4 + 1;
        int n5 = 0;
        if (Player.ce.weapon == 3) {
            graphics.drawRegion(imgAmmoIcons, 0, 126, 30, 14, n3, n2 + 1, 17, 0);
        } else if (Player.ce.weapon != 16) {
            n5 = Combat.weapons[Player.ce.weapon * 9 + 4];
            graphics.drawRegion(imgAmmoIcons, 0, 14 * n5, 30, 14, n3, n2 + 1, 17, 0);
        }
        text.setLength(0);
        if (n5 == 0) {
            text.append("--");
        } else if (n5 == 8 && Player.ammo[n5] < 50) {
            text.append("...");
            n2 -= 4;
        } else {
            text.append(Player.ammo[n5]);
            if (Player.ce.weapon == 14) {
                text.append('%');
            }
        }
        graphics.drawString(text, n3 - 2, n2 + 25 + 2, 33);
        n2 = Canvas.hudRect[3] - 25;
        graphics.setColor(-6645369);
        graphics.drawLine(Canvas.screenRect[0], n2, Canvas.screenRect[2], n2);
        graphics.drawLine(Canvas.screenRect[0], n2, Canvas.screenRect[0], n2 + 25);
        graphics.drawLine(n - 12, n2, n - 12, n2 + 25);
        graphics.drawLine(n + 13, n2, n + 13, n2 + 25);
        n3 = (n - 12) / 2 + 1;
        graphics.drawLine(n3, n2, n3, n2 + 25);
        n3 = n + 12 + ((n - 12) / 2 + 1);
        if (Player.inventory[20] > 0) {
            graphics.drawRegion(imgBottomBarIcons, 0, 30, 30, 15, n3 + (Canvas.screenRect[2] - n3) / 2, n2, 17, 0);
        }
        if (Player.inventory[19] > 0) {
            graphics.drawRegion(imgBottomBarIcons, 0, 45, 30, 15, n3 + (Canvas.screenRect[2] - n3) / 2, n2 + 12 + 1, 17, 0);
        }
        graphics.drawLine(n3, n2, n3, n2 + 25);
        graphics.drawLine(n3, n2 + 12, Canvas.screenRect[2], n2 + 12);
        graphics.setColor(-14868980);
        graphics.drawLine(n3, n2 + 12 + 1, Canvas.screenRect[2], n2 + 12 + 1);
        graphics.drawLine(Canvas.screenRect[0], n2 + 25, Canvas.screenRect[2], n2 + 25);
        graphics.drawLine(Canvas.screenRect[2] - 1, n2, Canvas.screenRect[2] - 1, n2 + 25);
        graphics.drawLine(n - 13, n2, n - 13, n2 + 25);
        graphics.drawLine(n + 12, n2, n + 12, n2 + 25);
        n3 = (n - 12) / 2;
        graphics.drawLine(n3, n2, n3, n2 + 25);
        n3 = n + 12 + (n - 12) / 2;
        graphics.drawLine(n3, n2, n3, n2 + 25);
        text.dispose();
    }

    public static final void draw(Graphics graphics) {
        drawTime = App.getUpTimeMs();
        if ((repaintFlags & 1) != 0) {
            repaintFlags &= 0xFFFFFFFE;
            if (Canvas.isZoomedIn) {
                int[] nArray = Canvas.viewRect;
                int n = imgScope.getWidth();
                int n2 = imgScope.getHeight();
                int n3 = nArray[0] + (nArray[2] - 2 * n) / 2;
                int n4 = nArray[1] + (nArray[3] - 2 * n2) / 2;
                graphics.drawRegion(imgScope, 0, 0, n, n2, n3, n4, 0, 0);
                graphics.drawRegion(imgScope, 0, 0, n, n2, n3 + (n - 1), n4, 0, 2);
                graphics.drawRegion(imgScope, 0, 0, n, n2, n3 + (n - 1), n4 + (n2 - 1), 0, 3);
                graphics.drawRegion(imgScope, 0, 0, n, n2, n3, n4 + (n2 - 1), 0, 6);
                graphics.setColor(0);
                int n5 = n3 - nArray[0];
                int n6 = nArray[0] + nArray[2] - (n3 + (2 * n - 1));
                graphics.fillRect(nArray[0], nArray[1], n5, nArray[3]);
                graphics.fillRect(n3 + (2 * n - 1), nArray[1], n6, nArray[3]);
                int n7 = n4 - nArray[1];
                int n8 = nArray[1] + nArray[3] - (n4 + (2 * n2 - 1));
                graphics.fillRect(nArray[0] + n5, nArray[1], nArray[2] - (n5 + n6), n7);
                graphics.fillRect(nArray[0] + n5, n4 + (2 * n2 - 1), nArray[2] - (n5 + n6), n8);
            }
            Hud.drawEffects(graphics);
        }
        if ((repaintFlags & 2) != 0) {
            repaintFlags &= 0xFFFFFFFD;
            Canvas.checkFacingEntity();
            Hud.drawTopBar(graphics);
        }
        if ((repaintFlags & 8) != 0) {
            repaintFlags &= 0xFFFFFFF7;
            Hud.drawBubbleText(graphics);
        }
        if ((repaintFlags & 4) != 0) {
            repaintFlags &= 0xFFFFFFFB;
            Hud.drawFiller(graphics);
            Hud.drawBottomBar(graphics);
        }
        if (cinTitleID != -1 && cinTitleTime < App.gameTime) {
            cinTitleID = -1;
            if (Canvas.state == 18) {
                repaintFlags |= 0x10;
            }
        }
        if (subTitleID != -1 && subTitleTime < App.gameTime) {
            subTitleID = -1;
            if (Canvas.state == 18) {
                repaintFlags |= 0x10;
            }
        }
        if ((repaintFlags & 0x10) != 0) {
            repaintFlags &= 0xFFFFFFEF;
            Hud.drawCinematicText(graphics);
        }
        drawTime = App.getUpTimeMs() - drawTime;
    }

    private static final void drawMonsterHealth(Graphics graphics) {
        int n;
        Entity entity = Player.facingEntity;
        if (entity == null || entity.monster == null) {
            if (lastTarget != null) {
                Canvas.invalidateRect();
            }
            lastTarget = null;
            return;
        }
        if (entity.def.eType == 3 || entity.def.eType == 2 && (entity.info & 0x20000) == 0) {
            return;
        }
        int n2 = entity.monster.ce.getStat(1);
        int n3 = entity.monster.ce.getStat(0);
        if (entity != lastTarget) {
            if (lastTarget != null) {
                Canvas.invalidateRect();
            }
            lastTarget = entity;
            monsterDestHealth = monsterStartHealth = n3;
            monsterHealthChangeTime = 0;
        } else if (n3 != monsterDestHealth) {
            monsterStartHealth = monsterDestHealth;
            monsterDestHealth = n3;
            monsterHealthChangeTime = App.time;
        }
        if (monsterStartHealth > n2) {
            monsterStartHealth = n2;
        }
        if (App.time - monsterHealthChangeTime > 250) {
            monsterStartHealth = n3;
        } else {
            n3 = monsterStartHealth - (monsterStartHealth - monsterDestHealth) * (App.time - monsterHealthChangeTime) / 250;
        }
        int n4 = 25;
        if (entity.def.eSubType == 13) {
            n4 = 3072 * ((n2 << 16) / 51200) >> 8;
            n4 = n4 + 256 - 1 >> 8;
        } else if (n2 <= 200 && entity.def.eSubType != 11) {
            n4 = 12800 * ((n2 << 16) / 51200) >> 8;
            n4 = n4 + 256 - 1 >> 8;
        }
        int n5 = (n4 << 8) * ((n3 << 16) / (n2 << 8)) >> 8;
        n5 = n5 + 256 - 1 >> 8;
        if (n5 == 0 && n3 > 0) {
            n5 = 1;
        }
        if (((n = 2 * (Canvas.screenRect[2] << 8) / 128 >> 8) & 1) != 0) {
            ++n;
        }
        int n6 = 2 + n * n4;
        int n7 = Canvas.SCR_CX - (n6 >> 1);
        int n8 = 6;
        if (entity.def.eSubType == 14) {
            n8 = 0;
        }
        graphics.setColor(-16777216);
        graphics.fillRect(n7, Canvas.viewRect[1] + n8, n6, n * 2 + 1);
        graphics.setColor(-5592406);
        graphics.drawRect(n7, Canvas.viewRect[1] + n8, n6, n * 2 + 1);
        if (n5 <= n4 / 3) {
            graphics.setColor(-65536);
        } else if (n4 - n5 <= n4 / 3) {
            graphics.setColor(-16711936);
        } else {
            graphics.setColor(-30720);
        }
        n7 += 2;
        for (int i = 0; i < n5; ++i) {
            graphics.fillRect(n7, Canvas.viewRect[1] + n8 + 2, n - 1, n * 2 - 2);
            n7 += n;
        }
    }

    public static final void showSpeechBubble(int n) {
        if (bubbleText == null) {
            bubbleText = Text.getSmallBuffer();
        }
        Text.composeText(Canvas.loadMapStringID, (short)n, bubbleText);
        bubbleText.dehyphenate();
        bubbleTextTime = App.time + 1500;
    }

    public static final void drawBubbleText(Graphics graphics) {
        int n;
        if (bubbleText == null) {
            return;
        }
        if (App.time >= bubbleTextTime) {
            bubbleTextTime = 0;
            bubbleText.dispose();
            bubbleText = null;
            return;
        }
        int n2 = Canvas.viewRect[1] + 1;
        int n3 = Canvas.SCR_CX + 5;
        int n4 = 6;
        if (Canvas.state == 18) {
            n2 = Canvas.cinRect[1] + 1;
        } else if (Player.facingEntity != null) {
            n = Player.facingEntity.distFrom(Canvas.destX, Canvas.destY);
            n2 = n <= Combat.tileDistances[0] ? (n2 += 10) : (n2 += 25);
        }
        n = bubbleText.length() * 7 + 6;
        int n5 = 16;
        int n6 = Math.max(0, n + 2 - (Canvas.viewRect[2] - n3));
        if ((n3 -= n6) + 15 < Canvas.SCR_CX) {
            n4 = 12;
        }
        graphics.setColor(-8388608);
        graphics.fillRect(n3, n2, n, n5);
        graphics.setColor(-1);
        graphics.drawLine(n3, n2, n3 + n, n2);
        graphics.drawLine(n3, n2, n3, n2 + n5);
        graphics.drawLine(n3 + n, n2, n3 + n, n2 + n5);
        graphics.drawLine(n3, n2 + n5, n3 + n, n2 + n5);
        graphics.drawString(bubbleText, n3 + 2, n2 + 3, 4);
        graphics.drawRegion(Canvas.imgUIImages, 0, n4, 10, 6, n3 + 5, n2 + n5);
    }

    static {
        messages = new Text[5];
        messageFlags = new int[5];
        subTitleID = -1;
        subTitleTime = 0;
        cinTitleID = -1;
        cinTitleTime = 0;
        bubbleText = null;
        bubbleTextTime = 0;
        showCinPlayer = false;
    }
}

