/*
 * Decompiled with CFR 0.152.
 */
final class Combat {
    public static int touchMe = 1;
    private static final int SEQ_INVALID = -1;
    private static final int SEQ_STARTATTACK = 0;
    public static final int SEQ_ENDATTACK = 1;
    private static final int FIELD_COUNT = 6;
    private static final int FLD_WPIDLEX = 0;
    private static final int FLD_WPIDLEY = 1;
    private static final int FLD_WPATKX = 2;
    private static final int FLD_WPATKY = 3;
    private static final int FLD_WPFLASHX = 4;
    private static final int FLD_WPFLASHY = 5;
    public static final int OUTOFCOMBAT_TURNS = 4;
    private static final int MAX_TILEDISTANCES = 16;
    public static final int[] tileDistances = new int[16];
    private static short[] monsterAttacks = null;
    private static byte[] wpinfo = null;
    private static byte[] monsterStats = null;
    public static Entity curAttacker;
    public static Entity curTarget;
    public static Entity lastTarget;
    public static int dodgeDir;
    private static EntityMonster targetMonster;
    private static EntityMonster attackerMonster;
    private static int targetSubType;
    private static int targetType;
    public static int stage;
    public static int nextStageTime;
    public static int nextStage;
    static final int EXPLOSION_OFFSET2 = 38;
    private static final int MAX_ACTIVE_MISSILES = 8;
    private static GameSprite[] activeMissiles;
    public static int numActiveMissiles;
    public static int missileAnim;
    public static final int EXPLOSION_OFFSET = 48;
    public static boolean targetKilled;
    private static boolean exploded;
    public static ScriptThread explodeThread;
    public static int damage;
    public static int totalDamage;
    public static int deathAmt;
    public static int accumRoundDamage;
    private static int totalArmorDamage;
    private static int hitType;
    public static int animStartTime;
    public static int animTime;
    public static int animEndTime;
    public static int attackerWeaponId;
    public static int attackerWeaponProj;
    public static int attackerWeapon;
    public static int weaponDistance;
    public static boolean lerpingWeapon;
    public static boolean weaponDown;
    public static boolean lerpWpDown;
    private static int lerpWpStartTime;
    private static int lerpWpDur;
    public static boolean flashDone;
    public static int flashDoneTime;
    public static int flashTime;
    public static boolean settingDynamite;
    public static boolean dynamitePlaced;
    public static int settingDynamiteTime;
    public static int currentBombIndex;
    public static final int DEF_PLACING_BOMB_Z = 18;
    public static int placingBombZ;
    public static final int PLACING_BOMB_TIME = 750;
    public static final int BOMB_RECOVER_TIME = 500;
    private static int attackFrame;
    public static int animLoopCount;
    private static boolean gotCrit;
    private static boolean gotHit;
    public static boolean isGibbed;
    public static int reflectionDmg;
    public static int playerMissRepetition;
    public static int monsterMissRepetition;
    public static int renderTime;
    private static int attackX;
    private static int attackY;
    public static final int WEAPON_FIELD_STRMIN = 0;
    public static final int WEAPON_FIELD_STRMAX = 1;
    public static final int WEAPON_FIELD_RANGEMIN = 2;
    public static final int WEAPON_FIELD_RANGEMAX = 3;
    public static final int WEAPON_FIELD_AMMOTYPE = 4;
    public static final int WEAPON_FIELD_AMMOUSAGE = 5;
    public static final int WEAPON_FIELD_PROJTYPE = 6;
    public static final int WEAPON_FIELD_NUMSHOTS = 7;
    public static final int WEAPON_FIELD_SHOTHOLD = 8;
    public static final int WEAPON_MAX_FIELDS = 9;
    public static byte[] weapons;
    public static byte[] monsterWeakness;
    public static final int WEAPON_STRIDE = 8;
    public static final int MONSTER_FIELD_ATTACK1 = 0;
    public static final int MONSTER_FIELD_ATTACK2 = 1;
    public static final int MONSTER_FIELD_CHANCE = 2;
    public static final int MAX_WRAITH_DRAIN = 45;
    static final int MAP_03_BOOST = 9;
    public static CombatEntity[] monsters;
    public static int worldDist;
    public static int tileDist;
    public static int crFlags;
    public static int crDamage;
    public static int crArmorDamage;
    public static int crCritChance;
    public static int crHitChance;
    public static final int PUNCH_PREP = 1;
    public static final int PUNCH_RIGHTHAND = 2;
    public static final int PUNCH_LEFTHAND = 3;
    public static int punchingMonster;
    public static boolean punchMissed;
    public static boolean oneShotCheat;
    private static int numThornParticleSystems;
    private static final int ONE_FP = 65536;
    private static final int LOWEREDWEAPON_Y = 38;
    private static final int LOWERWEAPON_TIME = 200;
    public static final int WEAPON_SCALE = 131072;
    static final int COMBAT_DONE = 0;
    static final int COMBAT_CONTINUE = 1;
    private static int[] tableCombatMasks;
    public static final int REBOUNDOFFSET = 31;
    private static boolean soulCubeIsAttacking;

    Combat() {
    }

    public static final short getWeaponWeakness(int n, int n2, int n3) {
        byte[] byArray = monsterWeakness;
        int n4 = byArray[(n2 * 3 + n3) * 8 + n / 2] >> ((n & 1) << 2) & 0xF;
        return (short)(n4 + 1 << 5);
    }

    public static final boolean startup() {
        tableCombatMasks = App.TBL_COMBAT_COMBATMASKS;
        monsterAttacks = App.TBL_COMBAT_MONSTERATTACKS;
        wpinfo = App.TBL_COMBAT_WEAPONINFO;
        monsterStats = App.TBL_COMBAT_MONSTERSTATS;
        weapons = App.TBL_COMBAT_WEAPONDATA;
        monsterWeakness = App.TBL_MONSTER_WEAKNESS;
        int n = 0;
        int n2 = 0;
        while (n2 < 51) {
            Combat.monsters[n2] = new CombatEntity(5 * (monsterStats[n + 0] & 0xFF), monsterStats[n + 1], monsterStats[n + 2], monsterStats[n + 3], monsterStats[n + 4], monsterStats[n + 5]);
            ++n2;
            n += 6;
        }
        for (n2 = 0; n2 < 16; ++n2) {
            Combat.tileDistances[n2] = 64 * (n2 + 1) * (64 * (n2 + 1));
        }
        gotCrit = false;
        gotHit = false;
        settingDynamite = false;
        String string = App.app.getAppProperty("App-OneShotKill");
        oneShotCheat = string != null && string.length() != 0 ? Integer.parseInt(string) != 0 : false;
        return true;
    }

    public static final void performAttack(Entity entity, Entity entity2, int n, int n2, boolean bl) {
        int n3;
        attackX = n;
        attackY = n2;
        curAttacker = entity;
        curTarget = entity2;
        accumRoundDamage = 0;
        if (entity == null || entity2 == null) {
            Player.updateStats();
        }
        if (entity != null) {
            entity.info |= 0x200000;
        }
        if (entity2 != null) {
            entity2.info |= 0x200000;
        }
        if (entity2 == null || entity == null && entity2.def.eType == 2) {
            Player.lastCombatTurn = Player.totalMoves;
            Player.inCombat = true;
        }
        if (entity2 != null) {
            targetType = entity2.def.eType;
            targetSubType = entity2.def.eSubType;
            targetMonster = entity2.monster;
        } else {
            targetSubType = 0;
            targetType = 0;
            targetMonster = null;
        }
        if (curAttacker == null) {
            attackerWeaponId = Player.ce.weapon;
            attackerMonster = null;
        } else {
            attackerMonster = Combat.curAttacker.monster;
            attackerWeaponId = Combat.attackerMonster.ce.weapon;
            attackFrame = attackerWeaponId == 18 ? 64 : (attackerWeaponId == Combat.getMonsterField(Combat.curAttacker.def, 1) ? 80 : 64);
        }
        attackerWeapon = attackerWeaponId * 9;
        if (punchingMonster > 0 && !punchMissed) {
            stage = -1;
            nextStage = 0;
            nextStageTime = App.gameTime + 300;
        } else {
            stage = 0;
            nextStageTime = 0;
        }
        animEndTime = 0;
        animLoopCount = weapons[attackerWeapon + 7];
        if (curAttacker == null) {
            short s = Player.ammo[weapons[attackerWeapon + 4]];
            n3 = weapons[attackerWeapon + 5];
            if (n3 > 0) {
                animLoopCount = Math.min(s / n3, animLoopCount);
            }
        }
        attackerWeaponProj = weapons[attackerWeapon + 6];
        if (curAttacker != null) {
            worldDist = curAttacker.distFrom(Canvas.viewX, Canvas.viewY);
            tileDist = Combat.WorldDistToTileDist(worldDist);
        } else {
            worldDist = curTarget.distFrom(Canvas.viewX, Canvas.viewY);
            tileDist = Combat.WorldDistToTileDist(worldDist);
        }
        short[] sArray = Render.mapSprites;
        if (attackerWeaponId == 18) {
            n3 = curAttacker.getSprite();
            int n4 = sArray[Render.S_X + n3] - Canvas.viewX;
            int n5 = sArray[Render.S_Y + n3] - Canvas.viewY;
            int n6 = n4;
            int n7 = n5;
            if (n6 != 0) {
                n6 /= Math.abs(n6);
            }
            if (n7 != 0) {
                n7 /= Math.abs(n7);
            }
            int n8 = Math.abs(n4 + n5) >> 6;
            n4 = Canvas.viewX + n6 * 64;
            n5 = Canvas.viewY + n7 * 64;
            LerpSprite lerpSprite = Game.allocLerpSprite(null, n3, true);
            lerpSprite.startTime = App.gameTime;
            lerpSprite.travelTime = n8 * 200;
            lerpSprite.flags |= 0x10;
            lerpSprite.srcScale = lerpSprite.dstScale = Render.mapSprites[Render.S_SCALEFACTOR + n3];
            lerpSprite.srcX = sArray[Render.S_X + n3];
            lerpSprite.srcY = sArray[Render.S_Y + n3];
            lerpSprite.srcZ = sArray[Render.S_Z + n3];
            lerpSprite.dstX = n4 - n6 * 28;
            lerpSprite.dstY = n5 - n7 * 28;
            lerpSprite.dstZ = Render.getHeight(lerpSprite.dstX, lerpSprite.dstY) + 32;
            Render.mapSpriteInfo[n3] = Render.mapSpriteInfo[n3] & 0xFFFF00FF | attackFrame << 8;
            Combat.curAttacker.monster.frameTime = Integer.MAX_VALUE;
            Game.unlinkEntity(curAttacker);
            Game.linkEntity(curAttacker, n4 >> 6, n5 >> 6);
            stage = -1;
            nextStage = 0;
            nextStageTime = App.gameTime + lerpSprite.travelTime;
        }
        Canvas.setState(5);
    }

    private static final void checkMonsterFX() {
        boolean bl;
        EntityMonster entityMonster = Combat.curTarget.monster;
        int n = entityMonster.monsterEffects;
        boolean bl2 = bl = Player.statusEffects[12] > 0;
        if (bl) {
            int n2 = Player.statusEffects[30];
            n |= n2 - 1 << 5 | 1;
        }
        entityMonster.monsterEffects = n;
    }

    private static final int playerSeq() {
        int n = 0;
        boolean bl = false;
        if (nextStageTime != 0 && App.gameTime > nextStageTime && numActiveMissiles == 0 && Game.animatingEffects == 0) {
            stage = nextStage;
            nextStageTime = 0;
            nextStage = -1;
        }
        if (stage == 0) {
            byte by;
            int n2;
            int n3;
            isGibbed = false;
            totalDamage = 0;
            totalArmorDamage = 0;
            hitType = 0;
            deathAmt = 0;
            gotCrit = false;
            gotHit = false;
            crFlags = 0;
            damage = 0;
            targetKilled = false;
            flashTime = 0;
            Player.counters[6] = Player.counters[6] + 1;
            if (punchingMonster == 1) {
                punchingMonster = 2;
            }
            if ((1 << attackerWeaponId & 0x77FF) == 0) {
                crFlags |= 0x40;
            }
            if (weapons[attackerWeapon + 4] != 0) {
                bl = true;
                if (weapons[attackerWeapon + 5] != 0) {
                    n = Player.ammo[weapons[attackerWeapon + 4]] / weapons[attackerWeapon + 5];
                }
            }
            if (bl && targetType != 2 && attackerWeaponId != 14 && !Player.weaponIsASentryBot(attackerWeaponId)) {
                if (n == 2) {
                    Hud.addMessage((short)62);
                } else if (n < 5 && n > 1) {
                    Text.resetTextArgs();
                    Text.addTextArg(n - 1);
                    Hud.addMessage((short)63);
                }
            }
            if (targetType == 2) {
                if ((1 << attackerWeaponId & 2) == 0) {
                    crFlags |= 0x20;
                }
                CombatEntity.calcCombat(Player.ce, curTarget, false, worldDist, targetSubType);
                if ((crFlags & 0x1007) != 0) {
                    Combat.curTarget.info |= 0x4000000;
                    if ((crFlags & 2) != 0) {
                        gotCrit = true;
                        hitType = 2;
                    } else if ((crFlags & 1) != 0 || (crFlags & 4) != 0) {
                        hitType = 1;
                    }
                    gotHit = true;
                    damage = crDamage;
                    n3 = Combat.targetMonster.ce.getStat(0);
                    deathAmt = n3 - damage;
                    if (damage > 0 && gotHit) {
                        Player.counters[2] = Player.counters[2] + damage;
                        if (damage > Player.counters[1]) {
                            Player.counters[1] = damage;
                        }
                    }
                }
            } else {
                hitType = Combat.calcHit(curTarget);
                n3 = weapons[attackerWeapon + 0];
                n2 = weapons[attackerWeapon + 1];
                if (n3 != n2) {
                    n3 += App.nextByte() % (n2 - n3);
                }
                if (Game.difficulty == 4) {
                    n3 -= n3 >> 2;
                }
                damage = n3;
            }
            n3 = -1;
            switch (attackerWeaponId) {
                case 0: 
                case 3: 
                case 5: 
                case 9: {
                    n3 = 15;
                    break;
                }
                case 2: {
                    n3 = 17;
                    break;
                }
                case 7: {
                    n3 = 18;
                    break;
                }
                case 8: {
                    n3 = 19;
                    break;
                }
                case 10: {
                    n3 = 20;
                    break;
                }
                case 12: {
                    n3 = 22;
                    break;
                }
                case 13: {
                    n3 = 23;
                    break;
                }
                case 1: {
                    n3 = 16;
                }
            }
            if (n3 != -1) {
                Sound.playSound(n3);
            }
            totalDamage += damage;
            totalArmorDamage += crArmorDamage;
            animTime = weapons[attackerWeapon + 8];
            animTime = Player.statusEffects[2] > 0 ? (animTime *= 5) : (animTime *= 10);
            animStartTime = App.gameTime;
            animEndTime = animStartTime + animTime;
            flashDone = false;
            flashDoneTime = animStartTime + flashTime;
            if (bl && n < animLoopCount) {
                animLoopCount = n;
            }
            Combat.launchProjectile();
            if ((1 << attackerWeaponId & 0x2406) == 0) {
                n2 = 2;
                if (attackerWeaponId == 11) {
                    n2 = 6;
                }
                Render.rockView(animTime, Canvas.viewX - n2 * (Canvas.viewStepX >> 6), Canvas.viewY - n2 * (Canvas.viewStepY >> 6), Canvas.viewZ);
            }
            if (totalDamage == 0) {
                if (targetType == 2) {
                    if ((crFlags & 0x100) != 0) {
                        Hud.addMessage((short)59, 1);
                    } else if ((crFlags & 0x400) != 0) {
                        Hud.addMessage((short)64);
                    } else if ((crFlags & 1) == 0) {
                        Hud.addMessage((short)68);
                    }
                }
            } else if (targetType == 2) {
                accumRoundDamage += totalDamage;
            } else if (hitType != 0) {
                targetKilled = true;
            }
            stage = -1;
            Hud.repaintFlags |= 4;
            Hud.repaintFlags |= 0x40;
            n2 = weapons[attackerWeapon + 5];
            byte by2 = by = weapons[attackerWeapon + 4];
            Player.ammo[by2] = (short)(Player.ammo[by2] - n2);
            Player.ammo[by] = (short)Math.max(Player.ammo[by], 0);
            nextStage = 1;
            nextStageTime = animEndTime;
            Combat.updateProjectile();
            Canvas.invalidateRect();
            if (totalDamage == 0 || hitType == 0) {
                Player.counters[7] = Player.counters[7] + 1;
            }
        } else {
            if (stage == 1) {
                int n4;
                int n5;
                settingDynamite = false;
                dynamitePlaced = false;
                Canvas.invalidateRect();
                if (targetType == 2) {
                    Combat.curTarget.info &= 0xFBFFFFFF;
                }
                if (targetType == 9 && targetSubType == 17) {
                    n5 = curTarget.getSprite();
                    Game.executeTile(Render.mapSprites[Render.S_X + n5] >> 6, Render.mapSprites[Render.S_Y + n5] >> 6, 0xFF4 | Canvas.flagForWeapon(attackerWeaponId), true);
                }
                if (attackerWeaponProj == 5) {
                    Combat.checkForBFGDeaths(attackX >> 6, attackY >> 6);
                }
                n5 = 4385;
                if (targetKilled || targetType == 2 && Combat.targetMonster.ce.getStat(0) <= 0) {
                    curTarget.died(true, Player.getPlayerEnt());
                    targetKilled = true;
                } else if (--animLoopCount > 0 && (1 << targetType & n5) == 0 && !punchMissed && targetType != 10) {
                    stage = 0;
                    animTime = 0;
                    animEndTime = 0;
                    nextStageTime = 0;
                    return 1;
                }
                if (punchingMonster > 0 && !targetKilled && !punchMissed && (n4 = curTarget.getSprite()) != -1 && Combat.curTarget.monster != null) {
                    Render.mapSpriteInfo[n4] = Render.mapSpriteInfo[n4] & 0xFFFF00FF | 0;
                }
                punchingMonster = 0;
                punchMissed = false;
                if (targetType == 2 && accumRoundDamage != 0 && (Combat.curTarget.info & 0x20000) != 0) {
                    Text text = Hud.getMessageBuffer();
                    Text.resetTextArgs();
                    if (gotCrit) {
                        Text.composeText((short)0, (short)70, text);
                    }
                    Text.addTextArg(accumRoundDamage);
                    Text.composeText((short)0, (short)71, text);
                    Hud.finishMessageBuffer();
                }
                if (attackerWeaponId == 14) {
                    Player.weapons &= 0xFFFFBFFF;
                    Player.selectWeapon(Player.currentWeaponCopy);
                }
                return 0;
            }
            if (stage == -1) {
                Canvas.staleView = true;
                if (numActiveMissiles != 0) {
                    Combat.updateProjectile();
                }
            }
        }
        return 1;
    }

    private static final int monsterSeq() {
        int n = curAttacker.getSprite();
        int n2 = Render.mapSpriteInfo[n];
        int n3 = (n2 & 0xFF00) >> 8;
        int n4 = n3 & 0xF0;
        int n5 = n3 & 0xF;
        if ((n4 == 64 || n4 == 80) && n5 == 0) {
            if (App.time >= Combat.curAttacker.monster.frameTime) {
                Combat.curAttacker.monster.frameTime = App.time + weapons[attackerWeapon + 8] * 10;
                nextStageTime = App.gameTime + weapons[attackerWeapon + 8] * 10;
                n2 = Render.mapSpriteInfo[n] = n2 & 0xFFFF00FF | (n4 | n5 + 1) << 8;
                Combat.launchProjectile();
            }
        } else if (nextStageTime != 0 && App.gameTime > nextStageTime && numActiveMissiles == 0 && Game.animatingEffects == 0) {
            if (reflectionDmg > 0 && curAttacker != null && Combat.curAttacker.monster != null) {
                ParticleSystem.spawnMonsterBlood(curAttacker, false);
                curAttacker.pain(reflectionDmg / 2, Player.getPlayerEnt());
                reflectionDmg = 0;
                if (Combat.curAttacker.monster.ce.getStat(0) <= 0) {
                    curAttacker.died(true, Player.getPlayerEnt());
                } else {
                    Combat.curAttacker.monster.frameTime = App.time + 250;
                    nextStageTime = App.gameTime + 250;
                }
            } else {
                stage = nextStage;
                nextStageTime = 0;
                nextStage = -1;
            }
        }
        if (stage == 0) {
            totalDamage = 0;
            totalArmorDamage = 0;
            hitType = 0;
            crFlags = 0;
            gotCrit = false;
            gotHit = false;
            targetKilled = false;
            reflectionDmg = 0;
            if (Combat.curAttacker.def.eSubType == 11 || Combat.curAttacker.def.eSubType == 14 && Combat.curAttacker.def.parm != 0) {
                Sound.playSound(15);
            } else {
                Sound.playSound(5);
            }
            if (weapons[attackerWeapon + 1] > 0) {
                if (curTarget == null) {
                    CombatEntity.calcCombat(Combat.attackerMonster.ce, Player.getPlayerEnt(), true, Player.distFrom(curAttacker), -1);
                    if ((crFlags & 0x1007) != 0) {
                        if ((crFlags & 2) != 0) {
                            gotCrit = true;
                            hitType = 2;
                        } else {
                            hitType = 1;
                        }
                        gotHit = true;
                        damage = crDamage;
                    } else {
                        damage = 0;
                    }
                } else {
                    hitType = 1;
                    damage = 1;
                }
                totalDamage += damage;
                totalArmorDamage += crArmorDamage;
            }
            --animLoopCount;
            animTime = weapons[attackerWeapon + 8] * 10;
            animStartTime = App.gameTime;
            animEndTime = animStartTime + animTime;
            if (attackerWeaponId != 18) {
                Render.mapSpriteInfo[n] = Render.mapSpriteInfo[n] & 0xFFFF00FF | attackFrame << 8;
                Combat.curAttacker.monster.frameTime = App.time + animTime;
            }
            if (curTarget != null) {
                targetKilled = true;
            }
            if (attackerWeaponId == 18) {
                short[] sArray = Render.mapSprites;
                LerpSprite lerpSprite = Game.allocLerpSprite(null, n, true);
                lerpSprite.startTime = App.gameTime;
                lerpSprite.travelTime = 500;
                lerpSprite.flags |= 0x10;
                lerpSprite.srcScale = lerpSprite.dstScale = Render.mapSprites[Render.S_SCALEFACTOR + n];
                lerpSprite.srcX = sArray[Render.S_X + n];
                lerpSprite.srcY = sArray[Render.S_Y + n];
                lerpSprite.srcZ = sArray[Render.S_Z + n];
                lerpSprite.dstX = (Combat.curAttacker.linkIndex % 32 << 6) + 32;
                lerpSprite.dstY = (Combat.curAttacker.linkIndex / 32 << 6) + 32;
                lerpSprite.dstZ = Render.getHeight(lerpSprite.dstX, lerpSprite.dstY) + 32;
                lerpSprite.calcDist();
                Render.mapSpriteInfo[n] = Render.mapSpriteInfo[n] & 0xFFFF00FF | 0;
                Combat.curAttacker.monster.frameTime = App.time + lerpSprite.travelTime;
                Combat.launchProjectile();
            }
            if (gotHit && (attackerWeaponId == 23 || Combat.curAttacker.def.eSubType == 2)) {
                Player.addStatusEffect(13, 5, 3);
                Player.translateStatusEffects();
            }
            stage = -1;
            nextStage = animLoopCount <= 0 ? 1 : 0;
            nextStageTime = animEndTime;
            if (Render.isImp(Combat.curAttacker.def.tileIndex) && attackerWeaponId == 16 && animLoopCount == 0) {
                int n6 = n;
                Render.mapSpriteInfo[n6] = Render.mapSpriteInfo[n6] ^ 0x20000;
            }
            Combat.updateProjectile();
            if ((crFlags & 0x80) != 0) {
                Hud.addMessage((short)67);
            }
            Canvas.invalidateRect();
        } else {
            if (stage == 1) {
                if (Combat.curAttacker.def.eType == 2) {
                    Render.mapSpriteInfo[n] = Render.mapSpriteInfo[n] & 0xFFFF00FF | 0;
                }
                if (targetKilled) {
                    curTarget.died(false, null);
                }
                Text.resetTextArgs();
                if (accumRoundDamage > 0 && Player.buffs[0] > 0 && !curAttacker.isBoss()) {
                    Text.addTextArg(accumRoundDamage);
                    Hud.addMessage((short)0, (short)131);
                } else if (accumRoundDamage > 0) {
                    Text.addTextArg((short)1, (short)(Combat.curAttacker.def.name & 0x3FF));
                    Text.addTextArg(accumRoundDamage);
                    Hud.addMessage((short)0, (short)112);
                }
                Canvas.shakeTime = 0;
                Hud.damageDir = 0;
                Hud.damageTime = 0;
                Combat.attackerMonster.flags = (short)(Combat.attackerMonster.flags | 0x400);
                Game.gsprite_clear(64);
                Canvas.invalidateRect();
                return 0;
            }
            if (stage == -1) {
                Canvas.staleView = true;
                if (numActiveMissiles != 0 || exploded) {
                    Combat.updateProjectile();
                }
            }
        }
        if (Canvas.state == 13 || Canvas.state == 25) {
            return 0;
        }
        return 1;
    }

    public static final void drawEffects() {
        if (Player.statusEffects[13] > 0) {
            int n = 131072;
            int n2 = 64 * n / 65536;
            Render.draw2DSprite(234, App.time / 256 & 3, TinyGL.screenWidth / 2 - n2 / 2, TinyGL.screenHeight - n2 / 4, 0, 3, 0, n);
        }
    }

    public static final void drawWeapon(int n, int n2) {
        int n3;
        int n4;
        int n5;
        boolean bl = false;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = Render.screenWidth / 2;
        int n10 = Render.screenHeight;
        renderTime = App.getUpTimeMs();
        if (punchingMonster == 0 && !lerpingWeapon && weaponDown) {
            n10 += 38;
        }
        boolean bl2 = Canvas.state == 18 && Game.cinematicWeapon != -1;
        int n11 = Player.ce.weapon;
        if (Player.isFamiliar) {
            if (Player.familiarType == 1 || Player.familiarType == 3) {
                n11 = 0;
            } else {
                return;
            }
        }
        if (bl2) {
            n11 = Game.cinematicWeapon;
            n10 -= Canvas.CAMERAVIEW_BAR_HEIGHT;
        }
        int n12 = n11 * 6;
        if (Canvas.state == 13 || Player.weapons == 0 || n11 == -1) {
            return;
        }
        n2 = -Math.abs(n2);
        if (!bl2 && App.time < Hud.damageTime && Hud.damageCount >= 0 && totalDamage > 0) {
            n7 |= 0x100;
        }
        int n13 = wpinfo[n12 + 0];
        int n14 = wpinfo[n12 + 1];
        int n15 = wpinfo[n12 + 2];
        int n16 = wpinfo[n12 + 3];
        if (Player.isFamiliar && (Player.familiarType == 1 || Player.familiarType == 3)) {
            n15 = 1 + (n15 - n13);
            n16 = 46 + (n16 - n14);
            n13 = 1;
            n14 = 46;
        }
        byte by = wpinfo[n12 + 4];
        byte by2 = wpinfo[n12 + 5];
        int n17 = n13;
        int n18 = n14;
        int n19 = App.gameTime;
        int n20 = 1 << n11;
        if ((1 << n11 & 0) != 0 && (punchingMonster == 2 || punchingMonster == 3)) {
            bl = true;
        }
        boolean bl3 = bl2 || Canvas.state == 5 && curAttacker == null && nextStage == 1;
        boolean bl4 = false;
        if (bl3) {
            n17 = n15;
            n18 = n16;
            if (!flashDone) {
                boolean bl5 = bl = (n20 & 0x200) == 0;
                if (n19 >= flashDoneTime) {
                    flashDone = true;
                }
            } else {
                int n21 = (n19 - animStartTime << 16) / animTime;
                if (n21 >= 65536) {
                    n17 = n13;
                    n18 = n14;
                } else if (n11 == 1) {
                    if (n21 < 43690) {
                        n5 = 2;
                        n4 = -1;
                        n3 = (n21 & 8) == 8 ? 1 : 0;
                        n17 = n15 + (n3 != 0 ? n5 : 0);
                        n18 = n16 + (n3 != 0 ? n4 : 0);
                    } else {
                        bl4 = true;
                        n17 = 3 * ((65536 - n21) * n15 + (n21 - 43690) * n13) >> 16;
                        n18 = 3 * ((65536 - n21) * n16 + (n21 - 43690) * n14) >> 16;
                    }
                } else {
                    n17 = (65536 - n21) * n15 + n21 * n13 >> 16;
                    n18 = (65536 - n21) * n16 + n21 * n14 >> 16;
                }
            }
        } else if (punchingMonster == 0 && lerpingWeapon) {
            if (lerpWpDown && lerpWpStartTime + lerpWpDur > n19) {
                int n22 = (n19 - lerpWpStartTime << 16) / lerpWpDur;
                n10 += n22 * 38 >> 16;
            } else if (!lerpWpDown && lerpWpStartTime + lerpWpDur > n19) {
                int n23 = (n19 - lerpWpStartTime << 16) / lerpWpDur;
                n10 += (65536 - n23) * 38 >> 16;
            } else {
                lerpWpStartTime = 0;
                lerpingWeapon = false;
                weaponDown = lerpWpDown;
                if (lerpWpDown) {
                    n10 += 38;
                }
            }
        }
        int n24 = 0;
        int n25 = n9 + (n17 + n << 1);
        int n26 = n10 - (n18 + n2 << 1);
        if (Player.weaponIsASentryBot(n11)) {
            n5 = n11 == 4 || n11 == 3 ? 19 : 18;
            n4 = n8;
            n3 = (App.time + n5 * 1337) / 1024 & 0xF;
            if (n3 == 0 || n3 >= 4 && n3 <= 7 || n3 >= 10 && n3 <= 12) {
                n4 ^= 0x20000;
            }
            int n27 = (n3 & 2) == 2 ? 1 : 2;
            Render.draw2DSprite(n5, 2, n25, n26, n8, n24, n7, 131072);
            Render.draw2DSprite(n5, 3, n25, n26 + n27, n4, n24, n7, 131072);
        } else if (n11 == 14) {
            if (Player.ammo[8] > 0) {
                Render.draw2DSprite(Player.activeWeaponDef.tileIndex, 1, n25 + by, n26 + by2, n8, n24, n7, 131072);
            } else {
                Render.draw2DSprite(Combat.getWeaponTileNum(n11), 0, n25, n26, n8, n24, n7, 131072);
            }
        } else {
            if (bl4 |= (n11 == 13 || n11 == 8) && bl3) {
                n6 = 1;
            }
            if (bl && (0x181 & 1 << n11) != 0) {
                n5 = 0;
                Render.draw2DSprite(Combat.getWeaponTileNum(n5), 3, n25 + by, n26 + by2, n8, 5, 0, 65536);
            }
            if (n11 == 9) {
                Render.draw2DSprite(Combat.getWeaponTileNum(0), n6, n25, n26, n8, n24, n7, 131072);
            }
            Render.draw2DSprite(Combat.getWeaponTileNum(n11), n6, n25, n26, n8, n24, n7, 131072);
        }
        Combat.drawEffects();
        renderTime = App.getUpTimeMs() - renderTime;
    }

    public static final void shiftWeapon(boolean bl) {
        if (bl == lerpWpDown || bl == weaponDown) {
            return;
        }
        lerpingWeapon = true;
        lerpWpDown = bl;
        lerpWpStartTime = App.gameTime;
        lerpWpDur = 200;
    }

    public static final int runFrame() {
        if (curAttacker == null) {
            return Combat.playerSeq();
        }
        return Combat.monsterSeq();
    }

    private static final int calcHit(Entity entity) {
        int n = Player.ce.weapon * 9;
        int n2 = entity.distFrom(Canvas.destX, Canvas.destY);
        int n3 = Combat.WorldDistToTileDist(n2);
        byte by = weapons[n + 3];
        if (n3 < weapons[n + 2] || n3 > by) {
            crFlags |= 0x400;
            return 0;
        }
        if ((entity.info & 0x20000) != 0) {
            if (entity.def.eType == 10) {
                if ((tableCombatMasks[entity.def.parm] & 1 << Player.ce.weapon) != 0) {
                    return 1;
                }
                return 0;
            }
            return 1;
        }
        return 0;
    }

    private static final void explodeOnMonster() {
        if (explodeThread != null) {
            explodeThread.run();
            explodeThread = null;
        }
        Render.shotsFired = true;
        if ((1 << attackerWeaponId & 2) != 0 && hitType == 0) {
            Render.shotsFired = false;
        } else if (Combat.curTarget.monster != null && Combat.curTarget.def.eType == 2 && (Combat.curTarget.info & 0x40000) == 0) {
            Game.activate(curTarget, true, false, true, true);
        }
        if (hitType == 0) {
            if (targetType != 2 && attackerWeaponId == 11) {
                Combat.radiusHurtEntities(attackX >> 6, attackY >> 6, 1, damage + crArmorDamage >> 2, Player.getPlayerEnt(), null);
            }
            return;
        }
        if (targetType == 2) {
            if (totalDamage > 0) {
                int n;
                int n2;
                Combat.checkMonsterFX();
                boolean bl = curTarget.pain(totalDamage, Player.getPlayerEnt());
                if (attackerWeaponId != 14) {
                    ParticleSystem.spawnMonsterBlood(curTarget, false);
                }
                if ((n2 = Combat.targetMonster.ce.getStat(0)) > 0) {
                    n = 0;
                    if (0 != (Combat.targetMonster.monsterEffects & 2) || (Combat.targetMonster.flags & 0x1000) != 0 || bl) {
                        n = 0;
                    }
                    if (n > 0) {
                        Player.unlink();
                        curTarget.knockback(Canvas.viewX, Canvas.viewY, n);
                        Player.link();
                    }
                }
                if (attackerWeaponId == 11 || attackerWeaponId == 12) {
                    n = attackerWeaponId == 12 ? 1 : 2;
                    Combat.radiusHurtEntities(attackX >> 6, attackY >> 6, 1, crDamage >> n, Player.getPlayerEnt(), curTarget);
                }
            } else if (totalDamage < 0) {
                if (Combat.targetMonster.ce.getStat(0) - totalDamage > Combat.targetMonster.ce.getStat(1)) {
                    totalDamage = -(Combat.targetMonster.ce.getStat(1) - Combat.targetMonster.ce.getStat(0));
                }
                Combat.targetMonster.ce.setStat(0, Combat.targetMonster.ce.getStat(0) - totalDamage);
            }
        } else if (targetType == 10) {
            if (totalDamage > 0) {
                curTarget.pain(totalDamage, Player.getPlayerEnt());
            }
        } else if (targetType == 9) {
            int n;
            int n3 = n = curTarget.getSprite();
            Render.mapSpriteInfo[n3] = Render.mapSpriteInfo[n3] | 0x10000;
            isGibbed = true;
            ParticleSystem.spawnMonsterBlood(curTarget, isGibbed);
            Game.spawnDropItem(curTarget);
        }
    }

    private static final void explodeOnPlayer() {
        if (curTarget != null) {
            return;
        }
        int n = curAttacker.getSprite();
        int n2 = Canvas.viewAngle;
        if (Canvas.isZoomedIn) {
            n2 += Canvas.zoomAngle;
        }
        Hud.damageDir = Player.calcDamageDir(Canvas.viewX, Canvas.viewY, n2, Render.mapSprites[Render.S_X + n], Render.mapSprites[Render.S_Y + n]);
        Hud.damageTime = animLoopCount > 0 ? App.time + 150 : App.time + 1000;
        if (Hud.damageDir != 3) {
            Canvas.staleTime = Hud.damageTime + 1;
        }
        boolean bl = false;
        if (Player.buffs[0] > 0 && !curAttacker.isBoss()) {
            bl = true;
        }
        if (gotHit && (totalDamage > 0 || totalArmorDamage > 0)) {
            Player.painEvent(curAttacker, true);
            if (curAttacker != null) {
                short s;
                Entity entity = Game.entities[1];
                Game.unlinkEntity(curAttacker);
                if (attackerWeaponProj == 7) {
                    Player.addStatusEffect(13, 5, 3);
                    Player.translateStatusEffects();
                }
                Player.addArmor(-totalArmorDamage);
                if (totalDamage > 0) {
                    if (!bl) {
                        if (Game.difficulty != 1) {
                            int n3 = Canvas.loadMapID;
                            if (Game.difficulty == 4) {
                                n3 *= 2;
                            }
                            totalDamage += (totalDamage >> 1) + (n3 /= weapons[attackerWeapon + 7]);
                        }
                        EntityDef entityDef = Combat.curAttacker.def;
                        if (entityDef.eType == 2 && entityDef.eSubType == 15) {
                            if (entityDef.parm == 4) {
                                totalDamage += Game.numMallocsForVIOS * 8;
                            } else if (Game.angryVIOS) {
                                totalDamage += 8;
                            }
                        }
                        accumRoundDamage += totalDamage;
                        Player.pain(totalDamage, curAttacker, false);
                        if (Player.ce.getStat(0) == 0) {
                            return;
                        }
                        if (Canvas.knockbackDist == 0) {
                            int[] nArray = curAttacker.calcPosition();
                            int n4 = Canvas.viewX - nArray[0];
                            int n5 = Canvas.viewY - nArray[1];
                            if (n4 != 0) {
                                n4 /= Math.abs(n4);
                            }
                            if (n5 != 0) {
                                n5 /= Math.abs(n5);
                            }
                            Render.rockView(200, Canvas.viewX + n4 * 6, Canvas.viewY + n5 * 6, Canvas.viewZ);
                        }
                        if (Player.ce.getStat(0) > 0 && Combat.curAttacker.def.eSubType == 5 && attackerWeaponId == 18) {
                            entity.knockback(Render.mapSprites[Render.S_X + n], Render.mapSprites[Render.S_Y + n], 1);
                        }
                    } else if (Combat.curAttacker.monster != null) {
                        accumRoundDamage = reflectionDmg = totalDamage;
                        animLoopCount = 0;
                        nextStage = 1;
                    }
                } else {
                    Hud.damageCount = 0;
                    totalDamage = 0;
                }
                if (totalDamage <= 0) {
                    Hud.addMessage((short)72);
                }
                Game.linkEntity(curAttacker, Combat.curAttacker.linkIndex % 32, Combat.curAttacker.linkIndex / 32);
                if (Player.isFamiliar && (s = Player.ammo[7]) <= 0) {
                    Player.familiarDying(false);
                }
            }
        } else {
            Hud.damageCount = 0;
            if ((crFlags & 0x100) != 0) {
                Text.resetTextArgs();
                Hud.addMessage((short)73);
            } else if ((crFlags & 0x80) == 0) {
                Text.resetTextArgs();
                Text text = Text.getSmallBuffer();
                Text.composeTextField(Combat.curAttacker.name, text);
                Text.addTextArg(text);
                Hud.addMessage((short)69);
                text.dispose();
            }
            Hud.damageCount = -1;
        }
    }

    public static final int getMonsterField(EntityDef entityDef, int n) {
        return monsterAttacks[n + entityDef.eSubType * 9 + entityDef.parm * 3];
    }

    public static final void checkForBFGDeaths(int n, int n2) {
        int n3 = (n << 6) + 32;
        int n4 = (n2 << 6) + 32;
        int n5 = Render.getHeight(n << 6, n2 << 6) + 32;
        for (int i = n2 - 1; i <= n2 + 1; ++i) {
            for (int j = n - 1; j <= n + 1; ++j) {
                if (j == n && i == n2) continue;
                Game.trace(n3, n4, n5, (j << 6) + 32, (i << 6) + 32, Render.getHeight(j << 6, i << 6) + 32, null, 4129, 1, false);
                if (Game.traceEntity != null) continue;
                Entity entity = Game.findMapEntity(j << 6, i << 6, 30381);
                while (entity != null) {
                    Entity entity2 = entity.nextOnTile;
                    if (entity.monster != null && entity.monster.ce.getStat(0) <= 0 && entity.def.eType != 9) {
                        entity.died(true, Player.getPlayerEnt());
                    }
                    entity = entity2;
                }
            }
        }
    }

    public static final void radiusHurtEntities(int n, int n2, int n3, int n4, Entity entity, Entity entity2) {
        int n5;
        int n6;
        int n7 = (n << 6) + 32;
        int n8 = (n2 << 6) + 32;
        int n9 = Render.getHeight(n << 6, n2 << 6) + 32;
        for (n6 = n2 - 1; n6 <= n2 + 1; ++n6) {
            for (n5 = n - 1; n5 <= n + 1; ++n5) {
                Game.trace(n7, n8, n9, (n5 << 6) + 32, (n6 << 6) + 32, Render.getHeight(n5 << 6, n6 << 6) + 32, null, 4129, 1, true);
                if (Game.traceEntity != null) continue;
                Combat.hurtEntityAt(n5, n6, n, n2, n5 == n && n6 == n2 ? 0 : n3, n4, entity, entity2);
            }
        }
        for (n6 = n2 - 1; n6 <= n2 + 1; ++n6) {
            for (n5 = n - 1; n5 <= n + 1; ++n5) {
                int n10 = 0x4004 | Game.eventFlagForDirection(n - n5, n2 - n6);
                if (!Game.doesScriptExist(n5, n6, n10)) continue;
                ScriptThread scriptThread = Game.allocScriptThread();
                scriptThread.queueTile(n5, n6, n10);
                scriptThread.run();
            }
        }
    }

    public static final void hurtEntityAt(int n, int n2, int n3, int n4, int n5, int n6, Entity entity, Entity entity2) {
        Combat.hurtEntityAt(n, n2, n3, n4, n5, n6, entity, false, entity2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void hurtEntityAt(int n, int n2, int n3, int n4, int n5, int n6, Entity entity, boolean bl, Entity entity2) {
        crFlags = 16;
        Render.shotsFired = true;
        Entity entity3 = Player.getPlayerEnt();
        Entity entity4 = Game.findMapEntity(n << 6, n2 << 6, 30383);
        while (entity4 != null) {
            Entity entity5 = entity4.nextOnTile;
            if (entity4 != entity2 && (entity4.info & 0x20000) != 0) {
                int n7;
                if (entity4 == entity3) {
                    if (attackerWeaponProj != 5) {
                        n7 = (n6 >>= 1) * 10 / 100;
                        n7 = Math.min(n7, Player.ce.getStat(2));
                        n6 -= n7;
                        n6 -= n6 * Player.ce.getStat(3) / 100;
                        Player.painEvent(null, false);
                        entity3.knockback((n3 << 6) + 32, (n4 << 6) + 32, n5);
                        if (n6 > 0) {
                            crArmorDamage = n7;
                            Player.pain(n6, null, true);
                            Player.addArmor(-crArmorDamage);
                            Player.addStatusEffect(13, 5, 3);
                            Player.translateStatusEffects();
                        }
                    }
                } else if (entity4.def.eType == 9) {
                    if (!bl) return;
                    entity4.died(false, entity);
                    entity4.info |= 0x10000;
                    ParticleSystem.spawnMonsterBlood(entity4, true);
                } else if (entity4.monster != null) {
                    entity4.info |= 0x200000;
                    if ((entity4.info & 0x40000) == 0) {
                        Game.activate(entity4, true, false, true, true);
                    }
                    n7 = Combat.getWeaponWeakness(attackerWeaponId, entity4.def.eSubType, entity4.def.parm);
                    n7 = n7 * n6 >> 8;
                    if ((n7 -= entity4.monster.ce.getStatPercent(3) * n7 >> 8) > 0) {
                        int n8;
                        if (attackerWeaponProj == 5) {
                            n8 = entity4.getSprite();
                            short s = Render.mapSprites[Render.S_X + n8];
                            short s2 = Render.mapSprites[Render.S_Y + n8];
                            int n9 = Render.mapSprites[Render.S_Z + n8];
                            n9 += n9 >> 1;
                            GameSprite gameSprite = Game.gsprite_allocAnim(244, s, s2, n9);
                            gameSprite.flags |= 0x800;
                            nextStageTime = App.gameTime + gameSprite.duration;
                            Render.mapSprites[Render.S_RENDERMODE + gameSprite.sprite] = 4;
                            Render.mapSprites[Render.S_SCALEFACTOR + gameSprite.sprite] = 32;
                        }
                        n8 = entity4.pain(n7, null) ? 1 : 0;
                        if ((entity4.monster.flags & 0x1000) == 0 && n8 == 0) {
                            entity4.knockback((n3 << 6) + 32, (n4 << 6) + 32, n5);
                        }
                        Text.resetTextArgs();
                        Text.addTextIDArg(entity4.name);
                        Text.addTextArg(n7);
                        if (entity4.monster.ce.getStat(0) <= 0) {
                            Hud.addMessage((short)74);
                            if (attackerWeaponProj != 5) {
                                if (bl && entity != null && entity.def.eType == 14 && entity.def.eSubType == 6) {
                                    entity4.info |= 0x10000;
                                    ParticleSystem.spawnMonsterBlood(entity4, true);
                                }
                                entity4.died(true, entity);
                            }
                        } else {
                            Hud.addMessage((short)75);
                        }
                    }
                } else if (entity4.def.eType != 8) {
                    if (entity4.def.eType == 10) {
                        // empty if block
                    }
                    entity4.pain(n6, entity);
                    entity4.died(true, entity);
                }
            }
            entity4 = entity5;
        }
    }

    public static final Text getWeaponStatStr(int n) {
        int n2 = n * 9;
        Text text = Text.getLargeBuffer();
        Text.resetTextArgs();
        Text.addTextArg(weapons[n2 + 0]);
        Text.composeText((short)0, (short)77, text);
        Text.resetTextArgs();
        if (weapons[n2 + 3] != 1) {
            Text.addTextArg(weapons[n2 + 2]);
            Text.addTextArg(weapons[n2 + 3]);
            Text.composeText((short)0, (short)78, text);
        } else {
            Text.addTextArg(weapons[n2 + 3]);
            Text.composeText((short)0, (short)79, text);
        }
        byte by = weapons[n2 + 4];
        EntityDef entityDef = EntityDef.find(6, 2, by);
        if (entityDef != null) {
            Text.composeText((short)0, (short)76, text);
            Text.composeText((short)1, entityDef.name, text);
        }
        return text;
    }

    public static final Text getArmorStatStr(int n) {
        Text text = Text.getLargeBuffer();
        if (n != -1) {
            Text.resetTextArgs();
            Text.addTextArg(Player.ce.getStat(2));
            Text.composeText((short)0, (short)80, text);
        }
        Text.composeText((short)0, (short)81, text);
        return text;
    }

    public static final int WorldDistToTileDist(int n) {
        for (int i = 0; i < tileDistances.length - 1; ++i) {
            if (n >= tileDistances[i]) continue;
            return i;
        }
        return tileDistances.length - 1;
    }

    public static final void cleanUpAttack() {
        stage = 1;
        animLoopCount = 0;
    }

    private static void updateProjectile() {
        if (numActiveMissiles > 0) {
            int n = 0;
            for (int i = 0; i < numActiveMissiles; ++i) {
                int n2;
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                GameSprite gameSprite = activeMissiles[i];
                if ((gameSprite.flags & 2) != 0) {
                    if (missileAnim == 248) {
                        int n8 = gameSprite.sprite;
                        Render.mapSpriteInfo[n8] = Render.mapSpriteInfo[n8] ^ 0x20000;
                        continue;
                    }
                    if (missileAnim != 171) continue;
                    n7 = curAttacker.getSprite();
                    n6 = Render.mapSprites[Render.S_X + n7];
                    n5 = Render.mapSprites[Render.S_Y + n7];
                    n4 = Game.viewX;
                    n3 = Game.viewY;
                    n2 = 0;
                    int n9 = 0;
                    if (Math.abs(n3 - n5) > Math.abs(n4 - n6)) {
                        n9 = (n3 - n5 >> 31 << 1) + 1;
                    } else {
                        n2 = (n4 - n6 >> 31 << 1) + 1;
                    }
                    int n10 = n6 + numThornParticleSystems * n2 * 64 + n2 * 32;
                    int n11 = n5 + numThornParticleSystems * n9 * 64 + n9 * 32;
                    if (Math.abs(Render.mapSprites[Render.S_X + gameSprite.sprite] - n10) <= 4 && Math.abs(Render.mapSprites[Render.S_Y + gameSprite.sprite] - n11) <= 4) {
                        int n12 = Render.getHeight(n10, n11);
                        ParticleSystem.spawnParticles(1, -8298435, n10, n11, n12);
                        GameSprite gameSprite2 = Game.gsprite_allocAnim(170, n10, n11, n12 + 32);
                        Render.mapSprites[Render.S_SCALEFACTOR + gameSprite2.sprite] = 48;
                        gameSprite2.duration += gameSprite.duration - (App.gameTime - gameSprite.time);
                        ++numThornParticleSystems;
                    }
                    Canvas.repaintFlags |= 0x20;
                    continue;
                }
                n7 = 1;
                n6 = 64;
                n5 = gameSprite.pos[3];
                n4 = gameSprite.pos[4];
                n3 = gameSprite.pos[5];
                switch (attackerWeaponProj) {
                    case 4: {
                        missileAnim = 242;
                        n = 4;
                        Canvas.startShake(500, 4, 500);
                        Sound.playSound(1);
                        break;
                    }
                    case 10: {
                        missileAnim = 252;
                        n = 4;
                        break;
                    }
                    case 3: {
                        missileAnim = 243;
                        n = 4;
                        break;
                    }
                    case 5: {
                        missileAnim = 244;
                        n = 4;
                        break;
                    }
                    case 2: {
                        EntityMonster entityMonster;
                        missileAnim = 235;
                        n = 4;
                        if (curTarget == null || (crFlags & 0x1007) == 0 || (entityMonster = Combat.curTarget.monster) == null || (1 << Combat.curTarget.def.eSubType & 0x1F801) != 0) break;
                        entityMonster.resetGoal();
                        entityMonster.goalType = (byte)4;
                        entityMonster.goalParam = 3;
                        break;
                    }
                    case 7: {
                        Sound.playSound(1);
                        if (curTarget == null && hitType != 0 && Player.buffs[9] > 0) {
                            missileAnim = 208;
                            n5 += Canvas.viewStepX >> 1;
                            n4 += Canvas.viewStepY >> 1;
                            n = 3;
                            break;
                        }
                        missileAnim = 242;
                        n = 4;
                        break;
                    }
                    case 13: {
                        missileAnim = 0;
                        ParticleSystem.spawnParticles(1, -1, gameSprite.sprite);
                        Sound.playSound(1);
                        break;
                    }
                    case 12: {
                        Game.gsprite_destroy(gameSprite);
                        for (n2 = i + 1; n2 < numActiveMissiles; ++n2) {
                            Combat.activeMissiles[n2 - 1] = activeMissiles[n2];
                        }
                        --numActiveMissiles;
                        if (soulCubeIsAttacking) {
                            soulCubeIsAttacking = false;
                            exploded = true;
                            Combat.explodeOnMonster();
                            Combat.launchSoulCube();
                        }
                        return;
                    }
                    case 9: {
                        n = 0;
                        missileAnim = 170;
                        ParticleSystem.spawnParticles(1, -8298435, n5, n4, n3 + 16);
                        n3 += 48;
                        break;
                    }
                    default: {
                        missileAnim = 0;
                    }
                }
                if (curAttacker != null && (1 << Hud.damageDir & 0x1C) == 0 && n7 == 0) {
                    missileAnim = 0;
                }
                Game.gsprite_destroy(gameSprite);
                if (missileAnim != 0 && (curAttacker == null || curTarget == null && hitType != 0)) {
                    int n13;
                    gameSprite = Game.gsprite_allocAnim(missileAnim, n5, n4, n3);
                    gameSprite.flags |= 0x800;
                    nextStageTime = App.gameTime + gameSprite.duration;
                    Render.mapSprites[Render.S_RENDERMODE + gameSprite.sprite] = (short)n;
                    Render.mapSprites[Render.S_SCALEFACTOR + gameSprite.sprite] = (short)n6;
                    if (missileAnim == 243) {
                        int n14 = Render.S_SCALEFACTOR + gameSprite.sprite;
                        Render.mapSprites[n14] = (short)(Render.mapSprites[n14] - 16);
                    }
                    if (curAttacker != null && (Render.mapSpriteInfo[n13 = (Combat.curAttacker.info & 0xFFFF) - 1] & 0x20000) != 0) {
                        int n15 = gameSprite.sprite;
                        Render.mapSpriteInfo[n15] = Render.mapSpriteInfo[n15] | 0x20000;
                    }
                }
                for (n2 = i + 1; n2 < numActiveMissiles; ++n2) {
                    Combat.activeMissiles[n2 - 1] = activeMissiles[n2];
                }
                --numActiveMissiles;
                exploded = true;
            }
        } else if (gotHit && (totalDamage > 0 || totalArmorDamage > 0) && exploded && (attackerWeaponId == 16 || attackerWeaponId == 15 || attackerWeaponId == 18 || attackerWeaponId == 17)) {
            missileAnim = attackerWeaponId == 16 ? 245 : (attackerWeaponId == 15 ? 246 : 247);
            int[] nArray = curAttacker.calcPosition();
            if (Game.isInFront(nArray[0] >> 6, nArray[1] >> 6)) {
                GameSprite gameSprite = Game.gsprite_allocAnim(missileAnim, Canvas.destZ, Canvas.destY, Canvas.destZ);
                gameSprite.flags |= 0x800;
                Render.mapSprites[Render.S_RENDERMODE + gameSprite.sprite] = 5;
                int n = (Combat.curAttacker.info & 0xFFFF) - 1;
                if ((Render.mapSpriteInfo[n] & 0x20000) != 0 && missileAnim == 245) {
                    int n16 = gameSprite.sprite;
                    Render.mapSpriteInfo[n16] = Render.mapSpriteInfo[n16] | 0x20000;
                }
            }
        }
        if (exploded) {
            if (curTarget == null) {
                Combat.explodeOnPlayer();
                exploded = false;
            } else {
                Combat.explodeOnMonster();
                exploded = false;
            }
        }
    }

    private static void launchProjectile() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = 256;
        boolean bl = true;
        int n10 = 16;
        int n11 = 16;
        int n12 = 0;
        if (attackerWeaponProj == 12) {
            soulCubeIsAttacking = true;
            Combat.launchSoulCube();
            return;
        }
        dodgeDir = App.nextInt() > 0x3FFFFFFF ? 1 : 0;
        int n13 = ((dodgeDir << 1) - 1) * 16;
        if (curAttacker == null) {
            n8 = Game.viewX;
            n7 = Game.viewY;
            n6 = Render.getHeight(n8, n7) + 32;
            n10 = 0;
        } else {
            n5 = (Combat.curAttacker.info & 0xFFFF) - 1;
            n8 = Render.mapSprites[Render.S_X + n5];
            n7 = Render.mapSprites[Render.S_Y + n5];
            n6 = Render.mapSprites[Render.S_Z + n5];
        }
        if (curTarget == null) {
            n4 = Game.viewX;
            n3 = Game.viewY;
            n2 = Render.getHeight(n4, n3) + 32;
        } else if (targetType == 0) {
            n4 = Game.traceCollisionX;
            n3 = Game.traceCollisionY;
            n2 = Game.traceCollisionZ;
        } else {
            n5 = (Combat.curTarget.info & 0xFFFF) - 1;
            n4 = Render.mapSprites[Render.S_X + n5];
            n3 = Render.mapSprites[Render.S_Y + n5];
            n2 = Render.mapSprites[Render.S_Z + n5];
        }
        switch (attackerWeaponProj) {
            case 2: {
                n12 = 3;
                missileAnim = 240;
                bl = false;
                n9 = 512;
                break;
            }
            case 3: {
                n12 = 3;
                missileAnim = 243;
                n9 += n9 >> 1;
                if (Render.mapSprites[Render.S_SCALEFACTOR + curTarget.getSprite()] >= 64) {
                    n2 += 16;
                }
                bl = false;
                break;
            }
            case 4: {
                n12 = 0;
                missileAnim = curAttacker == null ? 225 : 226;
                n9 += 64;
                bl = false;
                break;
            }
            case 5: {
                n12 = 4;
                missileAnim = 244;
                if (curAttacker != null) {
                    n9 += n9 >> 1;
                }
                bl = false;
                break;
            }
            case 6: {
                n12 = 0;
                missileAnim = 227;
                bl = false;
                break;
            }
            case 7: {
                n12 = 3;
                missileAnim = 242;
                bl = false;
                break;
            }
            case 8: {
                n12 = 3;
                missileAnim = 241;
                bl = false;
                break;
            }
            case 9: {
                missileAnim = 171;
                bl = false;
                n6 -= 32;
                n2 -= 32;
                numThornParticleSystems = 0;
                break;
            }
            case 10: {
                n12 = 3;
                missileAnim = 252;
                n6 += 48;
                bl = false;
                break;
            }
            case 11: {
                n12 = 3;
                missileAnim = 248;
                bl = false;
                break;
            }
            case 13: {
                bl = false;
                missileAnim = Player.activeWeaponDef.tileIndex;
                n12 = 0;
                break;
            }
            default: {
                missileAnim = 0;
                exploded = true;
                return;
            }
        }
        n5 = Math.abs(n4 - n8);
        int n14 = Math.abs(n3 - n7);
        if ((crFlags & 0x400) != 0) {
            n = weapons[attackerWeapon + 3] * 64;
            n11 = 0;
            if (n5 != 0 && n5 > n14) {
                n4 = n8 + (n4 - n8) * n / n5;
            } else if (n14 != 0) {
                n3 = n7 + (n3 - n7) * n / n14;
            }
            n5 = Math.abs(n4 - n8);
            n14 = Math.abs(n3 - n7);
            n13 = 0;
        } else if (hitType == 0) {
            if (targetType == 2 || curTarget == null) {
                n11 = 0;
            } else {
                n13 = 0;
            }
        } else {
            n13 = 0;
        }
        if (n14 > n5) {
            n = (n3 - n7 >> 31 << 1) + 1;
            n7 += n10 * n;
            n3 += n11 * -n;
            n4 += n13;
        } else {
            n = (n4 - n8 >> 31 << 1) + 1;
            n8 += n10 * n;
            n4 += n11 * -n;
            n3 += n13;
        }
        if (attackerWeaponProj == 4) {
            if (curAttacker == null) {
                n8 += 4 * Canvas.viewRightStepX >> 6;
                n7 += 4 * Canvas.viewRightStepY >> 6;
                n6 -= 5;
            } else {
                n = 16;
                int n15 = curAttacker.getSprite();
                if ((Render.mapSpriteInfo[n15] & 0x20000) != 0) {
                    n = -16;
                }
                n8 += n * Canvas.viewRightStepX >> 6;
                n7 += n * Canvas.viewRightStepY >> 6;
            }
        }
        n = 1000 * Math.max(n5, n14) / n9;
        GameSprite gameSprite = Combat.allocMissile(n8, n7, n6, n4, n3, n2, n, n12);
        if (missileAnim == 4 && curTarget != null || missileAnim == 243) {
            Render.mapSpriteInfo[gameSprite.sprite] = Render.mapSpriteInfo[gameSprite.sprite] & 0xFFFF00FF | 0x1000;
            if (missileAnim == 243) {
                int n16 = Render.S_SCALEFACTOR + gameSprite.sprite;
                Render.mapSprites[n16] = (short)(Render.mapSprites[n16] - 16);
            }
        } else if (missileAnim >= 241 && missileAnim < 244) {
            Render.mapSpriteInfo[gameSprite.sprite] = Render.mapSpriteInfo[gameSprite.sprite] & 0xFFFF00FF | 0x2000;
        } else if (missileAnim == 244) {
            Render.mapSpriteInfo[gameSprite.sprite] = Render.mapSpriteInfo[gameSprite.sprite] & 0xFFFF00FF | 0x3000;
            if (curAttacker != null) {
                int n17 = Render.S_SCALEFACTOR + gameSprite.sprite;
                Render.mapSprites[n17] = (short)(Render.mapSprites[n17] - 16);
            }
        }
        if (attackerWeaponProj == 2) {
            if (curAttacker == null) {
                Render.mapSprites[Render.S_ENT + gameSprite.sprite] = Player.getPlayerEnt().getIndex();
                Render.relinkSprite(gameSprite.sprite, gameSprite.pos[0] << 4, gameSprite.pos[1] << 4, gameSprite.pos[2] << 4);
            } else {
                Render.mapSprites[Render.S_ENT + gameSprite.sprite] = curAttacker.getIndex();
                Render.relinkSprite(gameSprite.sprite, gameSprite.pos[3] << 4, gameSprite.pos[4] << 4, gameSprite.pos[5] << 4);
            }
            gameSprite.flags |= 4;
            gameSprite.pos[0] = gameSprite.pos[3];
            gameSprite.pos[1] = gameSprite.pos[4];
            gameSprite.pos[2] = gameSprite.pos[5];
            gameSprite.vel[2] = 0;
            gameSprite.vel[1] = 0;
            gameSprite.vel[0] = 0;
        }
        if (!bl) {
            int n18 = gameSprite.sprite;
            Render.mapSpriteInfo[n18] = Render.mapSpriteInfo[n18] & 0xFFF700FF;
        }
        exploded = false;
    }

    private static GameSprite allocMissile(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (numActiveMissiles == 8) {
            App.Error(new Exception("MAX_ACTIVE_MISSILES"), 108);
            return null;
        }
        int n9 = Render.mediaMappings[missileAnim + 1] - Render.mediaMappings[missileAnim];
        GameSprite gameSprite = Combat.activeMissiles[Combat.numActiveMissiles] = Game.gsprite_alloc(missileAnim, n9, 2562);
        ++numActiveMissiles;
        short[] sArray = Render.mapSprites;
        sArray[Render.S_ENT + gameSprite.sprite] = -1;
        sArray[Render.S_RENDERMODE + gameSprite.sprite] = (short)n8;
        sArray[Render.S_X + gameSprite.sprite] = gameSprite.pos[0] = (short)n;
        sArray[Render.S_Y + gameSprite.sprite] = gameSprite.pos[1] = (short)n2;
        sArray[Render.S_Z + gameSprite.sprite] = gameSprite.pos[2] = (short)n3;
        int n10 = gameSprite.sprite;
        Render.mapSpriteInfo[n10] = Render.mapSpriteInfo[n10] | 0x80000;
        gameSprite.pos[3] = (short)n4;
        gameSprite.pos[4] = (short)n5;
        gameSprite.pos[5] = (short)n6;
        gameSprite.duration = n7;
        if (attackerWeaponProj == 13) {
            gameSprite.flags |= 0x4000;
            int n11 = 8;
            if (gameSprite.pos[5] > gameSprite.pos[2]) {
                n11 /= 4;
            }
            gameSprite.pos[5] = (short)(gameSprite.pos[5] + Math.min(tileDist, 5) * n11);
            if (gameSprite.pos[5] < gameSprite.pos[2]) {
                gameSprite.pos[5] = gameSprite.pos[2];
            }
        }
        if (n7 != 0) {
            gameSprite.vel[0] = 1000 * (gameSprite.pos[3] - gameSprite.pos[0]) / n7;
            gameSprite.vel[1] = 1000 * (gameSprite.pos[4] - gameSprite.pos[1]) / n7;
            gameSprite.vel[2] = 1000 * (gameSprite.pos[5] - gameSprite.pos[2]) / n7;
        } else {
            gameSprite.vel[2] = 0;
            gameSprite.vel[1] = 0;
            gameSprite.vel[0] = 0;
        }
        if (missileAnim == 0) {
            int n12 = gameSprite.sprite;
            Render.mapSpriteInfo[n12] = Render.mapSpriteInfo[n12] | 0x10000;
            return gameSprite;
        }
        Render.relinkSprite(gameSprite.sprite);
        return gameSprite;
    }

    private static void launchSoulCube() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = 64;
        int n9 = curTarget.getSprite();
        if (soulCubeIsAttacking) {
            n7 = Game.viewX;
            n6 = Game.viewY;
            n5 = Render.getHeight(n7, n6) + 32;
            n4 = Render.mapSprites[Render.S_X + n9];
            n3 = Render.mapSprites[Render.S_Y + n9];
            n2 = Render.mapSprites[Render.S_Z + n9];
        } else {
            n7 = Render.mapSprites[Render.S_X + n9];
            n6 = Render.mapSprites[Render.S_Y + n9];
            n5 = Render.mapSprites[Render.S_Z + n9];
            n4 = Game.viewX;
            n3 = Game.viewY;
            n2 = Render.getHeight(n7, n6) + 32;
        }
        int n10 = Math.abs(n4 - n7);
        int n11 = Math.abs(n3 - n6);
        if (n11 > n10) {
            n = (n3 - n6 >> 31 << 1) + 1;
            if (soulCubeIsAttacking) {
                n6 += n8 * n;
            } else {
                n3 += n8 * -n;
            }
        } else {
            n = (n4 - n7 >> 31 << 1) + 1;
            if (soulCubeIsAttacking) {
                n7 += n8 * n;
            } else {
                n4 += n8 * -n;
            }
        }
        n = 256;
        int n12 = 1000 * Math.max(n10, n11) / n;
        missileAnim = 239;
        Combat.allocMissile(n7, n6, n5, n4, n3, n2, n12, 0);
    }

    public static int getWeaponTileNum(int n) {
        if (n < 5) {
            return 1 + n;
        }
        switch (n) {
            case 5: {
                return 13;
            }
            case 6: {
                return 14;
            }
            case 14: {
                return 15;
            }
        }
        return 1 + n - 2;
    }

    static {
        activeMissiles = new GameSprite[8];
        explodeThread = null;
        lerpingWeapon = false;
        weaponDown = false;
        reflectionDmg = 0;
        weapons = null;
        monsterWeakness = null;
        monsters = new CombatEntity[51];
        punchingMonster = 0;
        punchMissed = false;
        oneShotCheat = false;
        numThornParticleSystems = 0;
        tableCombatMasks = null;
        soulCubeIsAttacking = false;
    }
}

