/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

public final class HackingGame {
    public static int touchMe = 1;
    private static ScriptThread callingThread = null;
    public static Image imgCoreDisplay = null;
    public static Image imgEnergyCore = null;
    public static Image imgGameColors = null;
    public static Image imgHelpScreenAssets = null;
    private static int columnCount;
    private static final int ROW_COUNT = 5;
    private static int selectedRow;
    private static int selectedColumn;
    private static boolean selected;
    private static short turnsLeft;
    private static int confirmationCursor;
    private static int mainTextScroll;
    private static int currentPress_x;
    private static int currentPress_y;
    private static int pressedColumn;
    private static final int COLOR_BEHIND_BLOCKS = -11513776;
    private static int columnBlockCameFrom;
    private static boolean gamePlayedFromMainMenu;
    private static short[][] gameBoard;
    private static byte[] mostRecentSrc;
    private static byte[] mostRecentDest;
    private static final int BLOCKS_PER_COLOR = 3;
    private static final short BLOCK_SIZE = 18;
    private static final short CIRCLE_DIAMETER = 12;
    private static final int SPACE_BETWEEN_CORES = 1;
    private static int CORE_WIDTH;
    private static int CORE_HEIGHT;
    private static final int DEFAULT_NUMBER_OF_TURNS = 30;
    private static final int FIRST_CORE_OFFSET_X = 12;
    private static final int FIRST_CORE_OFFSET_Y = 78;
    private static final int COLORED_CIRCLES_Y_OFFSET = 119;
    public static final int MG_HELP_SCREEN_X_OFFSET = 200;

    public static final void playFromMainMenu() {
        int n = App.nextInt() % 3 + 3;
        int n2 = (n - 1) * 10;
        int n3 = App.nextInt() % (n2 - 5) + 5;
        HackingGame.initGame(null, n, n3);
    }

    private static final void setupGlobalData() {
        CORE_WIDTH = imgEnergyCore.getWidth() / 2;
        CORE_HEIGHT = imgEnergyCore.getHeight();
        confirmationCursor = 0;
        Canvas.setState(12);
        Canvas.stateVars[0] = 2;
        Canvas.stateVars[1] = 0;
        Canvas.stateVars[2] = 0;
        Canvas.initMiniGameHelpScreen();
        Canvas.clearSoftKeys();
        selected = false;
    }

    public static final void initGame(ScriptThread scriptThread, Text text) {
        HackingGame.initGame(scriptThread, text, 30);
    }

    public static final void initGame(ScriptThread scriptThread, int n) {
        HackingGame.initGame(scriptThread, n, 30);
    }

    public static final void initGame(ScriptThread scriptThread, Text text, int n) {
        callingThread = scriptThread;
        gamePlayedFromMainMenu = callingThread == null;
        try {
            columnCount = text.charAt(0) - 48;
            columnCount = Math.max(3, Math.min(columnCount, 6));
            HackingGame.loadGameFromString(gameBoard, text, columnCount);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("loaded puzzle is empty, random puzzle with 3 columns has been created");
            columnCount = 3;
            HackingGame.fillGameBoardRandomly(gameBoard, 5, columnCount, 3);
        }
        HackingGame.setupGlobalData();
        turnsLeft = (short)n;
        selectedRow = -1;
        for (int i = 0; i < columnCount; ++i) {
            for (int j = 0; j < 5; ++j) {
                if (gameBoard[j][i] == 0) continue;
                selectedRow = (short)j;
                selectedColumn = (short)i;
                break;
            }
            if (selectedRow != -1) break;
        }
    }

    public static final void initGame(ScriptThread scriptThread, int n, int n2) {
        columnCount = Math.max(3, Math.min(n, 6));
        callingThread = scriptThread;
        gamePlayedFromMainMenu = callingThread == null;
        int n3 = n2;
        int n4 = gamePlayedFromMainMenu ? 0 : Player.ce.getIQPercent();
        int n5 = (10000 * n3 + n3 * (100 - n4) * (100 - n4)) / 20000;
        HackingGame.fillGameBoardRandomly(gameBoard, 5, columnCount, 3, n5);
        HackingGame.setupGlobalData();
        turnsLeft = (short)n2;
        selectedRow = -1;
        for (int i = 0; i < columnCount; ++i) {
            for (int j = 0; j < 5; ++j) {
                if (gameBoard[j][i] == 0) continue;
                selectedRow = (short)j;
                selectedColumn = (short)i;
                break;
            }
            if (selectedRow != -1) break;
        }
    }

    private static final void fillGameBoardRandomly(short[][] sArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        for (n6 = 0; n6 < sArray.length; ++n6) {
            for (n5 = 0; n5 < sArray[n6].length; ++n5) {
                sArray[n6][n5] = 0;
            }
        }
        for (n6 = 0; n6 < n2; ++n6) {
            for (n5 = 0; n5 < n3; ++n5) {
                int n7;
                n4 = App.nextByte() / ((255 + n) / n);
                if (sArray[n4][n7 = App.nextByte() / ((255 + n2) / n2)] == 0) {
                    sArray[n4][n7] = (short)(n6 + 1);
                    continue;
                }
                --n5;
            }
        }
        for (n6 = 0; n6 < n2; ++n6) {
            for (n5 = 0; n5 < n - 1; ++n5) {
                if (sArray[n5][n6] == 0 || sArray[n5 + 1][n6] != 0) continue;
                for (n4 = n5; n4 >= 0; --n4) {
                    sArray[n4 + 1][n6] = sArray[n4][n6];
                }
                sArray[0][n6] = 0;
            }
        }
    }

    private static final void fillGameBoardRandomly(short[][] sArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        for (n7 = 0; n7 < sArray.length; ++n7) {
            for (n6 = 0; n6 < sArray[n7].length; ++n6) {
                sArray[n7][n6] = 0;
            }
        }
        for (n7 = 0; n7 < n2; ++n7) {
            for (n6 = 0; n6 < n3; ++n6) {
                sArray[n - n6 - 1][n7] = (short)(n7 + 1);
            }
        }
        int n8 = 0;
        for (n5 = 0; n5 < columnCount; n5 = (int)((byte)(n5 + 1))) {
            HackingGame.mostRecentSrc[n5] = n5;
            HackingGame.mostRecentDest[n5] = n5;
        }
        for (int i = 0; i < n4; ++i) {
            n7 = App.nextByte() / ((255 + n2) / n2);
            if (n7 == (n6 = App.nextByte() / ((255 + n2) / n2))) {
                --i;
                continue;
            }
            if (n7 == n8) {
                --i;
                continue;
            }
            if (mostRecentDest[n7] == n6 && mostRecentSrc[n6] == n7) {
                --i;
                continue;
            }
            if (sArray[n - 1][n7] == 0 || sArray[0][n6] != 0) {
                --i;
                continue;
            }
            for (n5 = n - 1; n5 > 0 && sArray[n5 - 1][n7] != 0; --n5) {
            }
            int n9 = n - 1;
            while (sArray[n9][n6] != 0) {
                --n9;
            }
            sArray[n9][n6] = sArray[n5][n7];
            sArray[n5][n7] = 0;
            HackingGame.mostRecentSrc[n7] = (byte)n6;
            HackingGame.mostRecentDest[n6] = (byte)n7;
            n8 = n6;
        }
        if (HackingGame.gameIsSolved(sArray)) {
            HackingGame.fillGameBoardRandomly(sArray, n, n2, n3, n4);
        }
    }

    private static final void loadGameFromString(short[][] sArray, Text text, int n) {
        try {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < 5; ++j) {
                    sArray[j][i] = (short)(text.charAt(j + i * 5 + 1) - 48);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("loaded puzzle has errors, so a random puzzle was created to replace it");
            HackingGame.fillGameBoardRandomly(sArray, 5, n, 3);
        }
    }

    public static final void handleInput(int n, int n2) {
        if (Canvas.stateVars[1] == 0) {
            if (n == 5 || n == 15) {
                switch (Canvas.stateVars[2]) {
                    case 0: {
                        HackingGame.endGame(2);
                        break;
                    }
                    case 1: {
                        HackingGame.endGame(1);
                        break;
                    }
                    case 2: {
                        HackingGame.endGame(0);
                    }
                }
            } else if (n == 6) {
                Canvas.stateVars[1] = 1;
                mainTextScroll = 0;
                Canvas.clearSoftKeys();
            } else if (n == 1) {
                Canvas.handleMiniGameHelpScreenScroll(-1);
            } else if (n == 2) {
                Canvas.handleMiniGameHelpScreenScroll(1);
            } else if (n == 4) {
                Canvas.handleMiniGameHelpScreenScroll(11);
            } else if (n == 3) {
                Canvas.handleMiniGameHelpScreenScroll(-11);
            }
        } else if (Canvas.stateVars[1] == 1) {
            if (Canvas.stateVars[2] == 0) {
                switch (n) {
                    case 7: {
                        Canvas.stateVars[1] = 0;
                        Canvas.initMiniGameHelpScreen();
                        Canvas.clearSoftKeys();
                        break;
                    }
                    case 5: 
                    case 15: {
                        HackingGame.endGame(2);
                        break;
                    }
                    case 6: {
                        if (selected) {
                            boolean bl = selected = !selected;
                            if (columnBlockCameFrom != selectedColumn) {
                                turnsLeft = (short)(turnsLeft - 1);
                            }
                            if (HackingGame.gameIsSolved(gameBoard)) {
                                Canvas.stateVars[2] = 1;
                                mainTextScroll = 0;
                                Canvas.clearSoftKeys();
                                break;
                            }
                            if (turnsLeft != 0) break;
                            Canvas.stateVars[2] = 2;
                            mainTextScroll = 0;
                            Canvas.clearSoftKeys();
                            break;
                        }
                        if (gameBoard[selectedRow][selectedColumn] == 0) break;
                        selected = !selected;
                        columnBlockCameFrom = selectedColumn;
                        break;
                    }
                    case 3: {
                        HackingGame.attemptToMove((short)(selectedColumn - 1));
                        break;
                    }
                    case 4: {
                        HackingGame.attemptToMove((short)(selectedColumn + 1));
                        break;
                    }
                    case 1: {
                        --mainTextScroll;
                        break;
                    }
                    case 2: {
                        ++mainTextScroll;
                    }
                }
            } else if (Canvas.stateVars[2] == 1) {
                switch (n) {
                    case 5: 
                    case 6: 
                    case 15: {
                        HackingGame.endGame(1);
                        break;
                    }
                    case 1: {
                        --mainTextScroll;
                        break;
                    }
                    case 2: {
                        ++mainTextScroll;
                    }
                }
            } else if (Canvas.stateVars[2] == 2) {
                switch (n) {
                    case 5: 
                    case 6: 
                    case 15: {
                        HackingGame.endGame(0);
                        break;
                    }
                    case 1: {
                        --mainTextScroll;
                        break;
                    }
                    case 2: {
                        ++mainTextScroll;
                    }
                }
            }
        }
    }

    private static final void attemptToMove(short s) {
        if (selectedColumn != (s = (short)((s + columnCount) % columnCount))) {
            int n;
            int n2 = -1;
            for (n = 4; n >= 0; --n) {
                if (gameBoard[n][s] != 0) continue;
                n2 = (short)n;
                break;
            }
            if (selected) {
                n = (short)(s - selectedColumn);
                s = (short)((s + n + columnCount) % columnCount);
                while (s != selectedColumn && n2 == -1) {
                    for (int i = 4; i >= 0; --i) {
                        if (gameBoard[i][s] != 0) continue;
                        n2 = (short)i;
                        break;
                    }
                    s = (short)((s + n + columnCount) % columnCount);
                }
                s = (short)((s - n + columnCount) % columnCount);
                if (n2 != -1) {
                    HackingGame.gameBoard[n2][s] = gameBoard[selectedRow][selectedColumn];
                    HackingGame.gameBoard[HackingGame.selectedRow][HackingGame.selectedColumn] = 0;
                    selectedRow = n2;
                    selectedColumn = s;
                }
            } else {
                if (n2 != 4) {
                    n2 = (short)(n2 + 1);
                }
                selectedRow = n2;
                selectedColumn = s;
            }
        }
    }

    public static final void updateGame(Graphics graphics) {
        graphics.clipRect(0, 0, Canvas.menuRect[2], Canvas.menuRect[3]);
        if (Canvas.stateVars[1] == 0) {
            HackingGame.drawHelpScreen(graphics);
        } else {
            HackingGame.drawGameScreen(graphics);
        }
        Canvas.staleView = true;
        graphics.resetScreenSpace();
    }

    private static final void drawHelpScreen(Graphics graphics) {
        Canvas.drawMiniGameHelpScreen(graphics, Text.STRINGID((short)0, (short)164), Text.STRINGID((short)0, (short)165), imgHelpScreenAssets);
        Canvas.setLeftSoftKey((short)0, (short)29);
    }

    private static final void drawGameScreen(Graphics graphics) {
        int n;
        int n2 = Canvas.dialogMaxChars;
        graphics.fillRect(0, 0, Canvas.screenRect[2], Canvas.screenRect[3], -16777216);
        graphics.drawImage(imgCoreDisplay, 8, 0);
        for (n = 0; n < 6; ++n) {
            boolean bl;
            int n3 = 12 + n * (CORE_WIDTH + 1);
            boolean bl2 = false;
            boolean bl3 = bl = currentPress_x != -1 && currentPress_y != -1 && Canvas.pointInRectangle(currentPress_x, currentPress_y, n3, 78, CORE_WIDTH, CORE_HEIGHT);
            if (bl && (selected && (!HackingGame.columnIsFull(n) || n == selectedColumn) || !selected && !HackingGame.columnIsEmpty(n))) {
                pressedColumn = n;
                bl2 = true;
            }
            graphics.drawRegion(imgEnergyCore, bl2 ? CORE_WIDTH : 0, 0, CORE_WIDTH, CORE_HEIGHT, n3, 78, 0, 0);
        }
        for (n = 0; n < columnCount; ++n) {
            graphics.drawRegion(imgGameColors, n * 12, 18, 12, 12, 24 + n * (CORE_WIDTH + 1), 78 + CORE_HEIGHT + 5 - 119);
        }
        Text text = Text.getSmallBuffer();
        text.setLength(0);
        Text.composeText((short)0, (short)167, text);
        text.dehyphenate();
        text.append(turnsLeft);
        graphics.drawString(text, 62, 21, 1);
        HackingGame.drawGoalTextAndBars(graphics, text);
        text.setLength(0);
        if (Canvas.stateVars[1] == 1) {
            short s;
            switch (Canvas.stateVars[2]) {
                case 0: {
                    s = 166;
                    Canvas.setRightSoftKey((short)0, (short)54);
                    break;
                }
                case 1: {
                    s = 169;
                    break;
                }
                default: {
                    s = 170;
                }
            }
            Text.composeText((short)0, s, text);
            text.wrapText(n2, '\n');
            int n4 = text.getNumLines();
            if (n4 > 5) {
                text.setLength(0);
                Text.composeText((short)0, s, text);
                text.wrapText(n2 - 2, '\n');
                n4 = text.getNumLines();
                int n5 = mainTextScroll = Math.min(Math.max(mainTextScroll, 0), n4 - 5);
                if (Canvas.stateVars[2] == 0 && Canvas.pointInRectangle(currentPress_x, currentPress_y, 12 + (n2 - 4) * 9, 185, 36, 80)) {
                    n5 = (currentPress_y - 185) / 16;
                    if (n5 < 0) {
                        n5 = 0;
                    }
                    if (n5 > n4 - 5) {
                        n5 = n4 - 5;
                    }
                    mainTextScroll = n5;
                }
                for (n = 0; n < n5; ++n) {
                    text.removeLeadingLine();
                }
                for (n = n5 + 5; n < n4; ++n) {
                    text.removeTrailingLine();
                }
                int n6 = Math.min(n5 + 5, n4);
                Canvas.drawScrollBar(graphics, 12 + n2 * 9 + 4, 185, 80, n5, n6, n4, 5);
            }
            graphics.drawString(text, 12, 185, 4);
            Canvas.setLeftSoftKey((short)0, (short)29);
        }
        text.dispose();
        HackingGame.drawGamePieces(graphics);
    }

    private static final void drawGoalTextAndBars(Graphics graphics, Text text) {
        int n = 177 - (5 + 9 * (columnCount - 1)) / 2;
        text.setLength(0);
        Text.composeText((short)0, (short)168, text);
        text.dehyphenate();
        graphics.drawString(text, 177, 30, 1);
        for (int i = 0; i < columnCount; ++i) {
            int n2 = -5641906;
            switch (i) {
                case 0: {
                    n2 = -5641906;
                    break;
                }
                case 1: {
                    n2 = -1608941;
                    break;
                }
                case 2: {
                    n2 = -192256;
                    break;
                }
                case 3: {
                    n2 = -3911425;
                    break;
                }
                case 4: {
                    n2 = -3179;
                    break;
                }
                case 5: {
                    n2 = -15721762;
                }
            }
            int n3 = n + i * 9;
            graphics.fillRect(n3, 14, 5, 15, n2);
        }
    }

    private static final void drawGamePieces(Graphics graphics) {
        int n;
        int n2;
        for (n2 = 0; n2 < 5; ++n2) {
            for (n = 0; n < columnCount; ++n) {
                short s = gameBoard[n2][n];
                if (s == 0) continue;
                HackingGame.drawPiece(s, 21 + n * (CORE_WIDTH + 1), 82 + n2 * 19, graphics);
            }
        }
        n2 = 21 + selectedColumn * (CORE_WIDTH + 1);
        n = 82 + selectedRow * 19;
        int n3 = App.time & 0x3FF;
        int n4 = n3 < 511 ? (95 * n3 >> 9) + 160 : (-95 * (n3 - 511) >> 9) + 255;
        int n5 = 0xFF000000 | n4 << 16 | n4 << 8 | n4;
        if (selected) {
            graphics.drawRect(n2, n, 18, 18, n5);
            graphics.drawRect(n2 + 1, n + 1, 16, 16, n5);
        }
    }

    private static final boolean gameIsSolved(short[][] sArray) {
        for (int i = 0; i < sArray.length; ++i) {
            for (int j = 0; j < sArray[0].length; ++j) {
                if (sArray[i][j] == 0 || sArray[i][j] == j + 1) continue;
                return false;
            }
        }
        return true;
    }

    private static final void drawPiece(int n, int n2, int n3, Graphics graphics) {
        graphics.drawRegion(imgGameColors, (n - 1) * 18, 0, 18, 18, n2, n3);
    }

    public static final void forceWin() {
        for (int i = 0; i < columnCount; ++i) {
            for (int j = 0; j < 5; ++j) {
                HackingGame.gameBoard[4 - j][i] = j < 3 ? (short)(i + 1) : (short)0;
            }
        }
        selectedRow = 2;
        selectedColumn = 0;
        Canvas.stateVars[1] = 1;
        Canvas.stateVars[2] = 1;
        Canvas.clearSoftKeys();
    }

    private static final void endGame(int n) {
        if (!gamePlayedFromMainMenu) {
            Canvas.evaluateMiniGameResults(n);
            Game.scriptStateVars[7] = (short)n;
        }
        if (!gamePlayedFromMainMenu) {
            Canvas.setState(3);
            callingThread.run();
            callingThread = null;
        } else {
            Sound.playSound(10, 1);
            MenuSystem.setMenu(18);
        }
    }

    public static void pointerPressed(int n, int n2) {
        if (Canvas.pointInRectangle(n, n2, Canvas.screenRect[0], Canvas.screenRect[1], Canvas.screenRect[2], Canvas.screenRect[3]) && Canvas.stateVars[1] == 1 && Canvas.stateVars[2] == 0) {
            currentPress_x = n;
            currentPress_y = n2;
        }
    }

    public static void pointerDragged(int n, int n2) {
        if (Canvas.pointInRectangle(n, n2, Canvas.screenRect[0], Canvas.screenRect[1], Canvas.screenRect[2], Canvas.screenRect[3]) && Canvas.stateVars[1] == 1 && Canvas.stateVars[2] == 0) {
            currentPress_x = n;
            currentPress_y = n2;
        }
    }

    public static void pointerReleased(int n, int n2) {
        if (Canvas.pointInRectangle(n, n2, Canvas.screenRect[0], Canvas.screenRect[1], Canvas.screenRect[2], Canvas.screenRect[3])) {
            if (Canvas.stateVars[1] == 0) {
                if (n < 200) {
                    App.canvas.touchKeyPressed(-5);
                }
            } else if (Canvas.stateVars[1] == 1) {
                if (Canvas.stateVars[2] == 0) {
                    if (selected) {
                        int n3 = 12 + pressedColumn * (CORE_WIDTH + 1);
                        int n4 = 78;
                        if (Canvas.pointInRectangle(n, n2, n3, n4, CORE_WIDTH, CORE_HEIGHT)) {
                            selected = false;
                            if (pressedColumn != selectedColumn) {
                                HackingGame.gameBoard[HackingGame.getTopBlockIndex((int)HackingGame.pressedColumn) - 1][HackingGame.pressedColumn] = gameBoard[selectedRow][selectedColumn];
                                HackingGame.gameBoard[HackingGame.selectedRow][HackingGame.selectedColumn] = 0;
                                turnsLeft = (short)(turnsLeft - 1);
                                if (HackingGame.gameIsSolved(gameBoard)) {
                                    Canvas.stateVars[2] = 1;
                                    Canvas.clearSoftKeys();
                                } else if (turnsLeft == 0) {
                                    Canvas.stateVars[2] = 2;
                                    Canvas.clearSoftKeys();
                                }
                            }
                        }
                    } else {
                        int n5 = 12 + pressedColumn * (CORE_WIDTH + 1);
                        int n6 = 78;
                        if (Canvas.pointInRectangle(n, n2, n5, n6, CORE_WIDTH, CORE_HEIGHT)) {
                            selected = true;
                            selectedColumn = pressedColumn;
                            selectedRow = HackingGame.getTopBlockIndex(selectedColumn);
                        }
                    }
                } else {
                    App.canvas.touchKeyPressed(-5);
                }
            }
        }
        pressedColumn = -1;
        currentPress_y = -1;
        currentPress_x = -1;
    }

    public static int getTopBlockIndex(int n) {
        if (n >= 0 && n < columnCount) {
            for (int i = 0; i < 5; ++i) {
                if (gameBoard[i][n] == 0) continue;
                return i;
            }
        }
        return 5;
    }

    public static boolean columnIsFull(int n) {
        if (n >= 0 && n < columnCount) {
            return HackingGame.getTopBlockIndex(n) == 0;
        }
        return true;
    }

    public static boolean columnIsEmpty(int n) {
        if (n >= 0 && n < columnCount) {
            return HackingGame.getTopBlockIndex(n) == 5;
        }
        return true;
    }

    public static int getPressedColumn(int n, int n2) {
        int n3 = Canvas.screenRect[0] + 12 - 0;
        int n4 = Canvas.screenRect[1] + 78 - 20;
        int n5 = n3 + columnCount * (CORE_WIDTH + 1);
        int n6 = n4 + CORE_HEIGHT + 40;
        if (Canvas.pointInRectangle(n, n2, n3, n4, n5 - n3, n6 - n4)) {
            return (n - n3) / (CORE_WIDTH + 1);
        }
        return -1;
    }

    static {
        gameBoard = new short[5][6];
        mostRecentSrc = new byte[6];
        mostRecentDest = new byte[6];
    }
}

