/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

final class Player {
    public static int touchMe = 1;
    private static final int EXPIRE_DURATION = 5;
    private static final int MAX_DISPLAY_BUFFS = 6;
    public static final int ICE_FOG_DIST = 1024;
    public static final int MAX_NOTEBOOK_INDEXES = 8;
    public static Entity facingEntity;
    public static final short[] inventory;
    public static final short[] ammo;
    public static int weapons;
    public static final short[] inventoryCopy;
    public static final short[] ammoCopy;
    public static int weaponsCopy;
    public static int goldCopy;
    public static int currentWeaponCopy;
    public static boolean tookBotsInventory;
    public static boolean botReturnedDueToMonster;
    public static boolean unsetFamiliarOnceOutOfCinematic;
    public static int disabledWeapons;
    public static int level;
    public static int currentXP;
    public static int nextLevelXP;
    public static CombatEntity baseCe;
    public static CombatEntity ce;
    public static EntityDef activeWeaponDef;
    public static boolean noclip;
    public static boolean god;
    public static short characterChoice;
    public static boolean isFamiliar;
    public static short familiarType;
    public static boolean attemptingToSelfDestructFamiliar;
    private static int chainsawStrengthBonusCount;
    public static byte lastSkipCode;
    public static boolean inTargetPractice;
    public static int targetPracticeScore;
    public static final int NUMBER_OF_TARGET_PRACTICE_SHOTS = 8;
    private static final int HEAD_SHOT_POINTS = 30;
    private static final int BODY_SHOT_POINTS = 20;
    private static final int LEG_SHOT_POINTS = 10;
    public static int playTime;
    public static int totalTime;
    public static int moves;
    public static int totalMoves;
    public static int completedLevels;
    public static int killedMonstersLevels;
    public static int foundSecretsLevels;
    public static int xpGained;
    public static int currentLevelDeaths;
    public static int totalDeaths;
    public static int currentGrades;
    public static int bestGrades;
    public static final short[] notebookIndexes;
    public static final short[] notebookPositions;
    public static byte questComplete;
    public static byte questFailed;
    private static int hackedVendingMachines;
    private static int vendingMachineHackTriesLeft1;
    private static int vendingMachineHackTriesLeft2;
    private static final int NUMBER_OF_BITS_PER_VM_TRY = 3;
    public static int numNotebookIndexes;
    public static int helpBitmask;
    public static int invHelpBitmask;
    public static int ammoHelpBitmask;
    public static int weaponHelpBitmask;
    public static int armorHelpBitmask;
    public static int gamePlayedMask;
    public static int lastCombatTurn;
    public static boolean inCombat;
    public static boolean enableHelp;
    private static int turnTime;
    public static int highestMap;
    public static int prevWeapon;
    public static boolean noDeathFlag;
    public static boolean noFamiliarRemains;
    private static int numStatusEffects;
    private static int numStatusEffectsCopy;
    public static int[] statusEffects;
    public static int[] statusEffectsCopy;
    public static final int BUFF_TURNS = 0;
    public static final int BUFF_AMOUNT = 15;
    public static short[] buffs;
    public static short[] buffsCopy;
    public static int numbuffs;
    public static int numbuffsCopy;
    public static boolean gameCompleted;
    public static int playerEntityCopyIndex;
    public static int[] counters;
    public static final int[] monsterStats;
    public static final int DEF_STATUS_TURNS = 30;
    public static final int ANTI_FIRE_TURNS = 10;
    public static final int AGILITY_TURNS = 20;
    public static final int PURIFY_TURNS = 10;
    public static final int FEAR_TURNS = 6;
    public static final int COLD_TURNS = 5;
    private static final int BOX_X1 = 17;
    private static final int BOX_X2 = 31;
    private static final int BOX_X3 = 43;
    private static final int BOX_X4 = 55;

    Player() {
    }

    public static final boolean startup() {
        isFamiliar = false;
        noclip = false;
        god = false;
        helpBitmask = 0;
        invHelpBitmask = 0;
        weaponHelpBitmask = 0;
        armorHelpBitmask = 0;
        enableHelp = true;
        currentLevelDeaths = 0;
        totalDeaths = 0;
        currentGrades = 0;
        bestGrades = 0;
        Player.reset();
        return true;
    }

    public static boolean modifyCollision(Entity entity) {
        int n;
        return null != entity && entity.def.eType == 12 && (n = Render.mapSpriteInfo[(entity.info & 0xFFFF) - 1] & 0xFF) == 131;
    }

    public static final void advanceTurn() {
        ++moves;
        ++totalMoves;
        Player.updateStatusEffects();
        boolean bl = false;
        if (buffs[3] > 0) {
            Player.addHealth(buffs[18], false);
        }
        if (statusEffects[53] > 0) {
            Player.addHealth(-statusEffects[35]);
            bl = true;
        }
        if (statusEffects[13] > 0) {
            Player.addHealth(-3);
            Text text = Hud.getMessageBuffer(0);
            Text.composeText((short)0, (short)82, text);
            text.append(' ');
            Text.resetTextArgs();
            Text.addTextArg(3);
            Text.composeText((short)0, (short)71, text);
            Hud.finishMessageBuffer();
            bl = true;
        }
        if (inCombat && totalMoves - lastCombatTurn >= 4) {
            inCombat = false;
        }
        if (statusEffects[15] > 0) {
            counters[3] = counters[3] + 1;
        }
        turnTime = App.time;
        if (bl && Canvas.state == 6) {
            Canvas.setState(3);
        }
    }

    public static final void levelInit() {
        moves = 0;
        numNotebookIndexes = 0;
        questComplete = 0;
        questFailed = 0;
        turnTime = App.time;
        inCombat = false;
        if (ce.getStat(0) == 0) {
            ce.setStat(0, 1);
        }
    }

    public static final void fillMonsterStats() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < Game.numEntities; ++i) {
            Entity entity = Game.entities[i];
            if (null == entity.monster || (entity.monster.flags & 0x80) != 0) continue;
            ++n;
            if ((Game.entities[i].info & 0x1010000) == 0) continue;
            ++n2;
        }
        Player.monsterStats[0] = n2;
        Player.monsterStats[1] = n;
    }

    public static final void readyWeapon() {
        Canvas.readyWeaponSound = 2;
    }

    public static final void selectWeapon(int n) {
        int n2;
        if (isFamiliar) {
            return;
        }
        if (n != 14) {
            weapons &= 0xFFFFBFFF;
            Player.ammo[8] = 0;
        }
        if (Canvas.isZoomedIn) {
            Canvas.zoomOut();
        }
        if (((n2 = weapons & ~disabledWeapons) & 1 << n) == 0) {
            Player.ce.weapon = n;
            Player.selectNextWeapon();
        }
        if (Player.ce.weapon != n) {
            Canvas.invalidateRect();
            prevWeapon = Player.ce.weapon;
        }
        Player.ce.weapon = n;
        if (Canvas.state != 8 && Canvas.state != 18) {
            Canvas.drawPlayingSoftKeys();
        }
        if (n != prevWeapon) {
            Player.readyWeapon();
        }
        activeWeaponDef = EntityDef.find(6, 1, n);
        Canvas.updateFacingEntity = true;
        Hud.repaintFlags |= 4;
    }

    public static final void selectPrevWeapon() {
        int n;
        int n2;
        int n3 = Player.ce.weapon;
        int n4 = weapons & ~disabledWeapons;
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            if ((n4 & 1 << n2) == 0 || Combat.weapons[(n = n2 * 9) + 5] != 0 && ammo[Combat.weapons[n + 4]] == 0 && n2 != 2) continue;
            Player.selectWeapon(n2);
            return;
        }
        if (Player.ce.weapon == n3 && n3 != 14) {
            for (n2 = 14; n2 > n3; --n2) {
                if ((n4 & 1 << n2) == 0 || Combat.weapons[(n = n2 * 9) + 5] != 0 && ammo[Combat.weapons[n + 4]] == 0 && n2 != 2) continue;
                Player.selectWeapon(n2);
                return;
            }
        }
    }

    public static final void selectNextWeapon() {
        int n;
        int n2;
        int n3 = Player.ce.weapon;
        int n4 = weapons & ~disabledWeapons;
        for (n2 = n3 + 1; n2 < 15; ++n2) {
            if ((n4 & 1 << n2) == 0 || Combat.weapons[(n = n2 * 9) + 5] != 0 && ammo[Combat.weapons[n + 4]] == 0 && n2 != 2) continue;
            Player.selectWeapon(n2);
            return;
        }
        if (Player.ce.weapon == n3 && n3 != 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                if ((n4 & 1 << n2) == 0 || Combat.weapons[(n = n2 * 9) + 5] != 0 && ammo[Combat.weapons[n + 4]] == 0 && n2 != 2) continue;
                Player.selectWeapon(n2);
                return;
            }
        }
    }

    public static final int getHealth() {
        return isFamiliar ? ammo[7] : ce.getStat(0);
    }

    public static final int modifyStat(int n, int n2) {
        int n3;
        int n4;
        if (n == 0) {
            n4 = Player.getHealth();
            Player.addHealth(n2);
            if (n2 < 0) {
                Player.painEvent(null, false);
            }
            n3 = Player.getHealth();
        } else {
            int n5;
            n4 = baseCe.getStat(n);
            int n6 = n5 = n == 7 ? 200 : 99;
            if (n4 + n2 > n5) {
                n2 = n5 - n4;
            }
            if (n2 != 0) {
                baseCe.setStat(n, n4 + n2);
            }
            Player.updateStats();
            n3 = baseCe.getStat(n);
        }
        return n3 - n4;
    }

    public static final boolean requireStat(int n, int n2) {
        return ce.getStat(n) >= n2;
    }

    public static final boolean requireItem(int n, int n2, int n3, int n4) {
        int n5 = 1 << n2;
        if (n == 1) {
            if (n4 != 0) {
                return (weapons & n5) != 0;
            }
            return (weapons & n5) == 0;
        }
        if (n == 0) {
            return inventory[n2 - 0] >= n3 && inventory[n2 - 0] <= n4;
        }
        return false;
    }

    public static final void addXP(int n) {
        Text.resetTextArgs();
        Text.addTextArg(n);
        if (n < 0) {
            Hud.addMessage((short)102);
        } else {
            Hud.addMessage((short)103);
        }
        currentXP += n;
        xpGained += n;
        while (currentXP >= nextLevelXP) {
            Player.addLevel();
        }
        counters[5] = counters[5] + n;
    }

    public static final void addLevel() {
        nextLevelXP = Player.calcLevelXP(++level);
        Text text = Text.getLargeBuffer();
        text.setLength(0);
        Text.resetTextArgs();
        Text.addTextArg(level);
        Text.composeText((short)0, (short)104, text);
        int n = 10;
        int n2 = baseCe.getStat(1);
        if (n2 + n > 999) {
            n = 999 - n2;
        }
        if (n != 0) {
            baseCe.setStat(1, n2 + n);
            Text.resetTextArgs();
            Text.addTextArg(n);
            Text.composeText((short)0, (short)105, text);
        }
        n = 1;
        n2 = baseCe.getStat(3);
        if ((n = Player.modifyStat(3, n)) != 0) {
            Text.resetTextArgs();
            Text.addTextArg(n);
            Text.composeText((short)0, (short)106, text);
        }
        n = 2;
        n2 = baseCe.getStat(4);
        if ((n = Player.modifyStat(4, n)) != 0) {
            Text.resetTextArgs();
            Text.addTextArg(n);
            Text.composeText((short)0, (short)107, text);
        }
        n = 1;
        n2 = baseCe.getStat(5);
        if ((n = Player.modifyStat(5, n)) != 0) {
            Text.resetTextArgs();
            Text.addTextArg(n);
            Text.composeText((short)0, (short)108, text);
        }
        n = 3;
        n2 = baseCe.getStat(6);
        if ((n = Player.modifyStat(6, n)) != 0) {
            Text.resetTextArgs();
            Text.addTextArg(n);
            Text.composeText((short)0, (short)109, text);
        }
        Text.composeText((short)0, (short)110, text);
        ce.setStat(0, ce.getStat(1));
        if ((weapons & 0x78) != 0) {
            Player.ammo[7] = 100;
        }
        Hud.repaintFlags |= 4;
        boolean bl = true;
        if (Canvas.state != 1) {
            Sound.playSound(8);
            boolean bl2 = bl = !Canvas.enqueueHelpDialog(text, 0);
        }
        if (bl) {
            text.dispose();
        }
    }

    public static final int calcLevelXP(int n) {
        return 500 * n + 100 * ((n - 1) * (n - 1) * (n - 1) + (n - 1));
    }

    public static final int calcScore() {
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        for (n2 = 0; n2 <= 8; ++n2) {
            if ((killedMonstersLevels & 1 << n2) != 0) {
                n += 1000;
                continue;
            }
            bl = false;
        }
        if (bl) {
            n += 1000;
        }
        n = totalDeaths == 0 ? (n += 1000) : (totalDeaths < 10 ? (n += (5 - totalDeaths) * 50) : (n -= 250));
        int n3 = (totalTime + (App.gameTime - playTime)) / 60000;
        if (n3 < 120) {
            n += (120 - n3) * 15;
        }
        if (totalMoves < 5000) {
            n += (5000 - totalMoves) / 2;
        }
        boolean bl2 = true;
        while (n2 <= 8) {
            if ((foundSecretsLevels & 1 << n2) != 0) {
                n += 1000;
            } else {
                bl2 = false;
            }
            ++n2;
        }
        if (bl2) {
            n += 1000;
        }
        return n;
    }

    public static final boolean addHealth(int n) {
        return Player.addHealth(n, true);
    }

    public static final boolean addHealth(int n, boolean bl) {
        int n2;
        int n3;
        Hud.repaintFlags |= 4;
        if (isFamiliar) {
            n3 = ammo[7];
            n2 = 100;
        } else {
            n3 = ce.getStat(0);
            n2 = ce.getStat(1);
        }
        if (n > 0 ? n3 == n2 : god) {
            return false;
        }
        if (isFamiliar) {
            Player.ammo[7] = (short)Math.max(0, ammo[7] + n);
        } else {
            Hud.playerStartHealth = n3;
            ce.addStat(0, n);
        }
        int n4 = n2 = isFamiliar ? ammo[7] : ce.getStat(0);
        if (bl && n2 > n3) {
            Text.resetTextArgs();
            Text.addTextArg(n2 - n3);
            Hud.addMessage((short)111);
        }
        return true;
    }

    public static final void setStatsAccordingToCharacterChoice() {
        int n = 0;
        switch (characterChoice) {
            case 1: {
                baseCe.setStat(3, 8);
                baseCe.setStat(4, 9);
                baseCe.setStat(5, 97);
                baseCe.setStat(6, 12);
                baseCe.setStat(7, 110);
                n = 30;
                break;
            }
            case 2: {
                baseCe.setStat(3, 12);
                baseCe.setStat(4, 14);
                baseCe.setStat(5, 92);
                baseCe.setStat(6, 6);
                baseCe.setStat(7, 100);
                n = 10;
                break;
            }
            case 3: {
                baseCe.setStat(3, 8);
                baseCe.setStat(4, 8);
                baseCe.setStat(5, 87);
                baseCe.setStat(6, 6);
                baseCe.setStat(7, 150);
                n = 80;
            }
        }
        Player.give(0, 24, n, true);
    }

    public static final void reset() {
        int n;
        Hud.msgCount = 0;
        numNotebookIndexes = 0;
        Player.resetCounters();
        level = 1;
        currentXP = 0;
        nextLevelXP = Player.calcLevelXP(level);
        facingEntity = null;
        noclip = false;
        questComplete = 0;
        questFailed = 0;
        isFamiliar = false;
        Player.setFamiliarType((short)0);
        attemptingToSelfDestructFamiliar = false;
        inTargetPractice = false;
        targetPracticeScore = 0;
        hackedVendingMachines = 0;
        botReturnedDueToMonster = false;
        unsetFamiliarOnceOutOfCinematic = false;
        vendingMachineHackTriesLeft1 = 0;
        vendingMachineHackTriesLeft2 = 0;
        for (n = 0; n < 9; ++n) {
            vendingMachineHackTriesLeft1 += 4;
            vendingMachineHackTriesLeft2 += 4;
            if (n >= 8) continue;
            vendingMachineHackTriesLeft1 <<= 3;
            vendingMachineHackTriesLeft2 <<= 3;
        }
        chainsawStrengthBonusCount = 0;
        lastSkipCode = 0;
        playerEntityCopyIndex = -1;
        Canvas.prevX = 0;
        Canvas.saveX = 0;
        Canvas.destX = 0;
        Canvas.viewX = 0;
        Canvas.prevY = 0;
        Canvas.saveY = 0;
        Canvas.destY = 0;
        Canvas.viewY = 0;
        Canvas.destZ = 36;
        Canvas.viewZ = 36;
        Canvas.saveAngle = 0;
        Canvas.destAngle = 0;
        Canvas.viewAngle = 0;
        Canvas.savePitch = 0;
        Canvas.destPitch = 0;
        Canvas.viewPitch = 0;
        n = 0;
        inCombat = false;
        for (n = 0; n < 9; ++n) {
            Player.ammo[n] = 0;
        }
        for (n = 0; n < 26; ++n) {
            Player.inventory[n] = 0;
        }
        Player.give(0, 18, 1, true);
        numbuffs = 0;
        for (n = 0; n < 15; ++n) {
            Player.buffs[0 + n] = 0;
            Player.buffs[15 + n] = 0;
        }
        numStatusEffects = 0;
        for (n = 0; n < 18; ++n) {
            Player.statusEffects[0 + n] = 0;
            Player.statusEffects[36 + n] = 0;
            Player.statusEffects[18 + n] = 0;
        }
        numbuffsCopy = 0;
        for (n = 0; n < 15; ++n) {
            Player.buffsCopy[0 + n] = 0;
            Player.buffsCopy[15 + n] = 0;
        }
        numStatusEffectsCopy = 0;
        for (n = 0; n < 18; ++n) {
            Player.statusEffectsCopy[0 + n] = 0;
            Player.statusEffectsCopy[36 + n] = 0;
            Player.statusEffectsCopy[18 + n] = 0;
        }
        weapons = 0;
        foundSecretsLevels = 0;
        killedMonstersLevels = 0;
        baseCe.setStat(1, 100);
        Player.setStatsAccordingToCharacterChoice();
        if (Game.difficulty == 2) {
            baseCe.setStat(3, 0);
        }
        Player.updateStats();
        ce.setStat(0, 100);
        baseCe.setStat(2, 0);
        ce.setStat(2, 0);
        totalTime = 0;
        totalMoves = 0;
        completedLevels = 0;
        highestMap = 1;
        gameCompleted = false;
        gamePlayedMask = 0;
    }

    public static final int calcDamageDir(int n, int n2, int n3, int n4, int n5) {
        int n6 = n4 - n;
        int n7 = n5 - n2;
        n3 &= 0x3FF;
        if (n6 == 0 && n7 == 0) {
            return 3;
        }
        int n8 = n6 > 0 ? (n7 < 0 ? 128 : (n7 > 0 ? 896 : 0)) : (n6 < 0 ? (n7 < 0 ? 384 : (n7 > 0 ? 640 : 512)) : (n7 > 0 ? 768 : 256));
        n8 = n8 - n3 & 0x3FF;
        if (n8 > 512) {
            n8 = -(1024 - n8);
        }
        if ((n8 = 3 + n8 / 128) < 0) {
            n8 = 7;
        }
        return n8;
    }

    public static final void painEvent(Entity entity, boolean bl) {
        if (entity == null) {
            Hud.damageDir = 3;
        }
        Hud.damageCount = 1;
        if (!bl) {
            Canvas.startShake(500, 2, 150);
        }
    }

    public static final void pain(int n, Entity entity, boolean bl) {
        if (god) {
            return;
        }
        if (bl) {
            Text.resetTextArgs();
            if (entity != null) {
                Text text = Text.getSmallBuffer();
                Text.composeText((short)1, (short)(entity.def.name & 0x3FF), text);
                Text.addTextArg(text);
                Text.addTextArg(n);
                Hud.addMessage((short)0, (short)112);
                text.dispose();
            } else {
                Text.addTextArg(n);
                Hud.addMessage((short)0, (short)71);
            }
        }
        if (n == 0) {
            return;
        }
        if (isFamiliar) {
            Player.addHealth(-n);
        } else {
            int n2 = ce.getStat(0);
            if (n >= n2 && noDeathFlag) {
                n = n2 - 1;
            }
            int n3 = (n2 << 16) / (ce.getStat(1) << 8);
            int n4 = (n2 - n << 16) / (ce.getStat(1) << 8);
            if (n4 > 0) {
                if (n3 > 26 && n4 <= 26) {
                    Hud.addMessage((short)113, 3);
                } else if (n3 > 78 && n4 <= 78) {
                    Hud.addMessage((short)114, 3);
                } else if (n3 > 128 && n4 <= 128 && (helpBitmask & 0xC00) == 0) {
                    if (inventory[17] != 0 || inventory[16] != 0) {
                        Player.showHelp((short)10, true);
                    } else {
                        Player.showHelp((short)11, true);
                    }
                }
            }
            Player.addHealth(-n);
        }
        if (Canvas.state == 6) {
            Canvas.setState(3);
        }
        if (ce.getStat(0) <= 0) {
            Player.died();
        }
    }

    public static final void died() {
        if (Canvas.state == 13) {
            return;
        }
        ++currentLevelDeaths;
        ++totalDeaths;
        Sound.playSound(11);
        Canvas.startShake(350, 5, 500);
        ce.setStat(0, 0);
        Canvas.setState(13);
        Game.combatMonsters = null;
    }

    public static final void familiarDying(boolean bl) {
        if (Canvas.state == 25) {
            return;
        }
        if (bl) {
            Combat.curAttacker = null;
        } else {
            Sound.playSound(11);
            Canvas.startShake(350, 5, 500);
        }
        Canvas.familiarSelfDestructed = bl;
        Canvas.setState(25);
    }

    public static final boolean fireWeapon(Entity entity, int n, int n2) {
        int n3;
        if (Player.ce.weapon == 13 && entity.monster == null) {
            return false;
        }
        if (Combat.weaponDown || disabledWeapons != 0 && (weapons & 1 << Player.ce.weapon) == 0) {
            return false;
        }
        if (Combat.lerpingWeapon) {
            if (Combat.lerpWpDown) {
                return false;
            }
            Combat.lerpingWeapon = false;
            Combat.weaponDown = false;
        }
        if (entity.monster != null) {
            entity.monster.flags = (short)(entity.monster.flags & 0xFFFFFFF7);
        }
        if (Player.ce.weapon == 1 && (entity.def.eType == 9 || entity.def.eType == 10 && (entity.def.eSubType == 1 || entity.def.eSubType == 0))) {
            Player.usedChainsaw(false);
        }
        if (Combat.weapons[(n3 = Player.ce.weapon * 9) + 4] != 0) {
            short s = ammo[Combat.weapons[n3 + 4]];
            if (Combat.weapons[n3 + 5] > 0 && s - Combat.weapons[n3 + 5] < 0) {
                if (Player.ce.weapon == 13) {
                    Hud.addMessage((short)117, 3);
                } else if (s == 0) {
                    Hud.addMessage((short)115, 3);
                } else {
                    Hud.addMessage((short)116, 3);
                }
                return false;
            }
        }
        Combat.performAttack(null, entity, n, n2, false);
        return true;
    }

    public static final boolean useItem(int n) {
        if (inventory[n] == 0 && n != 22) {
            return false;
        }
        boolean bl = true;
        boolean bl2 = true;
        switch (n) {
            case 16: {
                if (Player.addHealth(20)) break;
                return false;
            }
            case 17: {
                if (Player.addHealth(80)) break;
                return false;
            }
            case 11: {
                if (Player.addArmor(50)) break;
                return false;
            }
            case 12: {
                if (Player.addArmor(10)) break;
                return false;
            }
            case 7: {
                if (!Player.addStatusEffect(6, 25, 31)) {
                    return false;
                }
                Player.translateStatusEffects();
                break;
            }
            case 6: {
                if (!Player.addStatusEffect(4, 25, 31)) {
                    return false;
                }
                Player.translateStatusEffects();
                break;
            }
            case 1: {
                if (!Player.addStatusEffect(7, 5, 31)) {
                    return false;
                }
                Player.translateStatusEffects();
                break;
            }
            case 3: {
                boolean bl3 = false;
                if (Player.addStatusEffect(8, 25, 31)) {
                    bl3 = true;
                }
                if (Player.addStatusEffect(5, 20, 31)) {
                    bl3 = true;
                }
                if (bl3) {
                    Player.translateStatusEffects();
                    break;
                }
                return false;
            }
            case 2: {
                if (!Player.addStatusEffect(9, 0, 11)) {
                    return false;
                }
                Player.removeStatusEffect(13);
                Player.translateStatusEffects();
                break;
            }
            case 9: {
                if (!Player.addStatusEffect(8, 100, 31)) {
                    return false;
                }
                Player.translateStatusEffects();
                break;
            }
            case 8: {
                if (statusEffects[2] != 0) {
                    return false;
                }
                bl = false;
                Player.addStatusEffect(2, 0, 21);
                Player.translateStatusEffects();
                break;
            }
            case 0: {
                if (!Player.addStatusEffect(10, 20, 31)) {
                    return false;
                }
                Player.translateStatusEffects();
                Player.addHealth(20);
                break;
            }
            case 5: {
                if (!Player.addStatusEffect(3, 5, 31)) {
                    return false;
                }
                Player.translateStatusEffects();
                break;
            }
            case 10: {
                boolean bl4 = false;
                if (Player.addStatusEffect(6, 25, 31)) {
                    bl4 = true;
                }
                if (Player.addStatusEffect(8, 25, 31)) {
                    bl4 = true;
                }
                if (Player.addStatusEffect(4, 25, 31)) {
                    bl4 = true;
                }
                if (Player.addStatusEffect(7, 5, 31)) {
                    bl4 = true;
                }
                if (bl4) {
                    Player.translateStatusEffects();
                    break;
                }
                return false;
            }
            case 4: {
                if (!Player.addStatusEffect(12, 10, 11)) {
                    return false;
                }
                Player.translateStatusEffects();
                break;
            }
            case 22: {
                boolean bl5 = Player.addHealth(25);
                bl2 = false;
                if (bl5 |= Player.addStatusEffect(11, 100, 3)) {
                    ammo[3] = (short)(ammo[3] - 25);
                    Player.translateStatusEffects();
                    break;
                }
                return false;
            }
            case 23: {
                return true;
            }
            default: {
                return false;
            }
        }
        Sound.playSound(13);
        if (bl2) {
            int n2 = n;
            inventory[n2] = (short)(inventory[n2] - 1);
        }
        if (bl) {
            Game.advanceTurn();
        }
        return true;
    }

    public static final boolean give(int n, int n2, int n3) {
        return Player.give(n, n2, n3, false);
    }

    public static final boolean give(int n, int n2, int n3, boolean bl) {
        return Player.give(n, n2, n3, bl, false);
    }

    public static final boolean give(int n, int n2, int n3, boolean bl, boolean bl2) {
        if (n3 == 0) {
            return false;
        }
        int n4 = 1 << n2;
        switch (n) {
            case 1: {
                boolean bl3;
                if (Player.weaponIsASentryBot(n2) && n3 > 0) {
                    if (isFamiliar) {
                        return false;
                    }
                    Player.give(2, 7, 100, true);
                    weapons &= 0xFFFFFFEF;
                    weapons &= 0xFFFFFFF7;
                    weapons &= 0xFFFFFFBF;
                    weapons &= 0xFFFFFFDF;
                }
                boolean bl4 = bl3 = (weapons & n4) == 0;
                if (n3 < 0) {
                    if (!isFamiliar || bl2) {
                        weapons &= ~n4;
                        if (n2 == Player.ce.weapon) {
                            Player.selectNextWeapon();
                        }
                    }
                    return true;
                }
                if (isFamiliar && !bl2) {
                    weaponsCopy |= n4;
                } else {
                    weapons |= n4;
                }
                if (!bl) {
                    Player.showWeaponHelp(n2, false);
                }
                if (!bl3 || isFamiliar) break;
                Player.selectWeapon(n2);
                break;
            }
            case 0: {
                short[] sArray = isFamiliar && !bl2 ? inventoryCopy : inventory;
                int n5 = n3 + sArray[n2 - 0];
                if (n2 == 24) {
                    if (n5 > 9999) {
                        n5 = 9999;
                    }
                } else if (n5 > 999) {
                    n5 = 999;
                }
                if (n5 < 0) {
                    return false;
                }
                if (n2 == 13 && (!isFamiliar || bl2)) {
                    Player.give(2, 3, n5 * 20, true, true);
                } else {
                    sArray[n2 - 0] = (short)n5;
                }
                if (bl) break;
                Player.showInvHelp(n2 - 0, false);
                break;
            }
            case 2: {
                short[] sArray = isFamiliar && !bl2 && n2 != 6 ? ammoCopy : ammo;
                int n6 = n3 + sArray[n2];
                if (n6 > 100) {
                    n6 = 100;
                }
                if (n2 == 6 && n6 > 5) {
                    n6 = 5;
                }
                if (n6 < 0) {
                    return false;
                }
                sArray[n2] = (short)n6;
                if (!bl) {
                    Player.showAmmoHelp(n2, false);
                }
                Hud.repaintFlags |= 4;
                break;
            }
            case 3: {
                Player.addHealth(n3);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public static final void giveAmmoWeapon(int n, boolean bl) {
        weapons |= 1 << n;
        Player.selectWeapon(n);
        if (!bl) {
            Player.showWeaponHelp(n, false);
        }
    }

    public static final void updateQuests(short s, int n) {
        if (n == 0) {
            if (numNotebookIndexes == 8) {
                App.Error(39);
                return;
            }
            questComplete = (byte)(questComplete & ~(1 << numNotebookIndexes));
            questFailed = (byte)(questFailed & ~(1 << numNotebookIndexes));
            Player.notebookIndexes[Player.numNotebookIndexes++] = s;
        } else {
            for (int i = 0; i < numNotebookIndexes; ++i) {
                if (s != notebookIndexes[i]) continue;
                if (n == 1) {
                    questComplete = (byte)(questComplete | 1 << i);
                } else if (n == 2) {
                    questFailed = (byte)(questFailed | 1 << i);
                }
                return;
            }
            if (n == 1) {
                questComplete = (byte)(questComplete | 1 << numNotebookIndexes);
                questFailed = (byte)(questFailed & ~(1 << numNotebookIndexes));
            } else if (n == 2) {
                questComplete = (byte)(questComplete & ~(1 << numNotebookIndexes));
                questFailed = (byte)(questFailed | 1 << numNotebookIndexes);
            }
            Player.notebookPositions[Player.numNotebookIndexes] = 0;
            Player.notebookIndexes[Player.numNotebookIndexes++] = s;
        }
    }

    public static final void setQuestTile(int n, int n2, int n3) {
        for (int i = 0; i < numNotebookIndexes; ++i) {
            if (n != notebookIndexes[i]) continue;
            Player.notebookPositions[i] = (short)(n2 << 5 | n3);
            return;
        }
    }

    public static final boolean isQuestDone(int n) {
        return (questComplete & 1 << n) != 0;
    }

    public static final boolean isQuestFailed(int n) {
        return (questFailed & 1 << n) != 0;
    }

    public static final void formatTime(int n, Text text) {
        text.setLength(0);
        int n2 = n / 1000;
        int n3 = n2 / 60;
        int n4 = n3 / 60;
        int n5 = n3 % 60;
        text.append(n4);
        text.append(":");
        if (n5 < 10) {
            text.append("0");
        }
        text.append(n5);
        text.append(":");
        if ((n2 -= n3 * 60) < 10) {
            text.append("0");
        }
        text.append(n2);
    }

    public static final void showInvHelp(int n, boolean bl) {
        if (!enableHelp && !bl) {
            return;
        }
        int n2 = n - 0;
        if ((invHelpBitmask & 1 << n2) != 0) {
            return;
        }
        invHelpBitmask |= 1 << n2;
        EntityDef entityDef = EntityDef.find(6, 0, n);
        Canvas.enqueueHelpDialog(entityDef);
    }

    public static final void showAmmoHelp(int n, boolean bl) {
        if (!enableHelp && !bl) {
            return;
        }
        int n2 = 1 << n;
        if ((ammoHelpBitmask & n2) != 0) {
            return;
        }
        ammoHelpBitmask |= n2;
        EntityDef entityDef = EntityDef.find(6, 2, n);
        Canvas.enqueueHelpDialog(entityDef);
    }

    public static final boolean showHelp(short s, boolean bl) {
        if (Game.isCameraActive()) {
            return false;
        }
        if (!enableHelp && !bl) {
            return false;
        }
        if ((helpBitmask & 1 << s) != 0 && !bl) {
            return false;
        }
        helpBitmask |= 1 << s;
        Canvas.enqueueHelpDialog(s);
        if (s != 5 && Canvas.state == 3) {
            Canvas.dequeueHelpDialog();
        }
        return true;
    }

    public static final void showWeaponHelp(int n, boolean bl) {
        if (!enableHelp && !bl) {
            return;
        }
        if ((weaponHelpBitmask & 1 << n) != 0) {
            return;
        }
        weaponHelpBitmask |= 1 << n;
        EntityDef entityDef = EntityDef.find(6, 1, n);
        Canvas.enqueueHelpDialog(entityDef);
    }

    public static final void drawBuffs(Graphics graphics) {
        int n;
        if (numbuffs == 0 || Canvas.state == 8) {
            return;
        }
        int n2 = Canvas.viewRect[0] + Canvas.viewRect[2];
        int n3 = n2 - 17;
        int n4 = Canvas.viewRect[1] + 30;
        int n5 = 0;
        boolean bl = false;
        int n6 = numbuffs;
        if (n6 > 6) {
            n6 = 6;
            bl = true;
        }
        int n7 = n6 * 13 + 6;
        for (n = 0; n < 15 && n5 < 6; ++n) {
            if (buffs[0 + n] <= 0 || (1 << n & 0x3A07) != 0) continue;
            if (buffs[15 + n] > 99 || buffs[15 + n] < -99) {
                n3 = n2 - 55;
                break;
            }
            if (buffs[15 + n] > 9 || buffs[15 + n] < -9) {
                n3 = n2 - 43;
                continue;
            }
            if (n3 != n2 - 17) continue;
            n3 = n2 - 31;
        }
        n = n2 - n3 + 4;
        if (bl) {
            n7 += 5;
        }
        graphics.setColor(0);
        graphics.fillRect(n3 - 5, n4 - 2, n, n7);
        graphics.setColor(-5592406);
        graphics.drawRect(n3 - 5, n4 - 2, n, n7);
        int n8 = n2 - 18;
        for (int i = 0; i < 15 && n5 < 6; ++i) {
            if (buffs[0 + i] == 0) continue;
            ++n5;
            Player.drawStatusEffectIcon(graphics, i, buffs[15 + i], buffs[0 + i], n8, n4);
            n4 += 13;
        }
        if (bl) {
            Text text = Text.getSmallBuffer();
            text.setLength(0);
            text.append('\u0085');
            graphics.drawString(text, n3 + n / 2 - 4, n4 - 4, 1);
            text.dispose();
        }
    }

    public static final void setCharacterChoice(short s) {
        Game.scriptStateVars[14] = characterChoice = s;
    }

    public static final boolean loadState(DataInputStream dataInputStream) throws IOException {
        int n;
        baseCe.loadState(dataInputStream, true);
        ce.loadState(dataInputStream, true);
        Player.setCharacterChoice(dataInputStream.readShort());
        weapons = dataInputStream.readInt();
        weaponsCopy = dataInputStream.readInt();
        level = dataInputStream.readByte() & 0xFF;
        currentXP = dataInputStream.readInt();
        nextLevelXP = Player.calcLevelXP(level);
        totalTime = dataInputStream.readInt();
        totalMoves = dataInputStream.readInt();
        completedLevels = dataInputStream.readInt();
        killedMonstersLevels = dataInputStream.readInt();
        foundSecretsLevels = dataInputStream.readInt();
        disabledWeapons = dataInputStream.readInt();
        prevWeapon = dataInputStream.readByte();
        gamePlayedMask = dataInputStream.readInt();
        lastCombatTurn = dataInputStream.readInt();
        inCombat = dataInputStream.readBoolean();
        highestMap = dataInputStream.readShort();
        isFamiliar = dataInputStream.readBoolean();
        short s = dataInputStream.readShort();
        Player.setFamiliarType(s);
        playerEntityCopyIndex = dataInputStream.readInt();
        hackedVendingMachines = dataInputStream.readInt();
        vendingMachineHackTriesLeft1 = dataInputStream.readInt();
        vendingMachineHackTriesLeft2 = dataInputStream.readInt();
        chainsawStrengthBonusCount = dataInputStream.readInt();
        lastSkipCode = dataInputStream.readByte();
        int n2 = 9;
        for (n = 0; n < n2; ++n) {
            Player.ammo[n] = dataInputStream.readShort();
        }
        for (n = 0; n < n2; ++n) {
            Player.ammoCopy[n] = dataInputStream.readShort();
        }
        n2 = 26;
        for (n = 0; n < n2; ++n) {
            Player.inventory[n] = dataInputStream.readShort();
        }
        for (n = 0; n < n2; ++n) {
            Player.inventoryCopy[n] = dataInputStream.readShort();
        }
        numStatusEffects = dataInputStream.readByte();
        if (numStatusEffects == 0) {
            for (n = 0; n < 18; ++n) {
                Player.statusEffects[36 + n] = 0;
                Player.statusEffects[0 + n] = 0;
                Player.statusEffects[18 + n] = 0;
            }
        } else {
            for (n = 0; n < 18; ++n) {
                Player.statusEffects[36 + n] = dataInputStream.readShort();
                Player.statusEffects[0 + n] = dataInputStream.readShort();
                Player.statusEffects[18 + n] = dataInputStream.readShort();
            }
        }
        if ((numStatusEffectsCopy = (int)(isFamiliar ? dataInputStream.readByte() : (byte)0)) == 0) {
            for (n = 0; n < 18; ++n) {
                Player.statusEffectsCopy[36 + n] = 0;
                Player.statusEffectsCopy[0 + n] = 0;
                Player.statusEffectsCopy[18 + n] = 0;
            }
        } else {
            for (n = 0; n < 18; ++n) {
                Player.statusEffectsCopy[36 + n] = dataInputStream.readShort();
                Player.statusEffectsCopy[0 + n] = dataInputStream.readShort();
                Player.statusEffectsCopy[18 + n] = dataInputStream.readShort();
            }
        }
        for (n = 0; n < 8; ++n) {
            Player.counters[n] = dataInputStream.readInt();
        }
        gameCompleted = dataInputStream.readBoolean();
        Player.translateStatusEffects();
        Player.updateStats();
        return true;
    }

    public static final boolean saveState(DataOutputStream dataOutputStream) throws IOException {
        baseCe.saveState(dataOutputStream, true);
        ce.saveState(dataOutputStream, true);
        dataOutputStream.writeShort(characterChoice);
        dataOutputStream.writeInt(weapons);
        dataOutputStream.writeInt(weaponsCopy);
        dataOutputStream.writeByte(level);
        dataOutputStream.writeInt(currentXP);
        int n = App.gameTime;
        totalTime += n - playTime;
        playTime = n;
        dataOutputStream.writeInt(totalTime);
        dataOutputStream.writeInt(totalMoves);
        dataOutputStream.writeInt(completedLevels);
        dataOutputStream.writeInt(killedMonstersLevels);
        dataOutputStream.writeInt(foundSecretsLevels);
        dataOutputStream.writeInt(disabledWeapons);
        dataOutputStream.writeByte(prevWeapon);
        dataOutputStream.writeInt(gamePlayedMask);
        dataOutputStream.writeInt(lastCombatTurn);
        dataOutputStream.writeBoolean(inCombat);
        dataOutputStream.writeShort(highestMap);
        dataOutputStream.writeBoolean(isFamiliar);
        dataOutputStream.writeShort(familiarType);
        dataOutputStream.writeInt(playerEntityCopyIndex);
        dataOutputStream.writeInt(hackedVendingMachines);
        dataOutputStream.writeInt(vendingMachineHackTriesLeft1);
        dataOutputStream.writeInt(vendingMachineHackTriesLeft2);
        dataOutputStream.writeInt(chainsawStrengthBonusCount);
        dataOutputStream.writeByte(lastSkipCode);
        int n2 = 9;
        int n3 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            dataOutputStream.writeShort(ammo[n3]);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            dataOutputStream.writeShort(ammoCopy[n3]);
        }
        n2 = 26;
        for (n3 = 0; n3 < n2; ++n3) {
            dataOutputStream.writeShort(inventory[n3]);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            dataOutputStream.writeShort(inventoryCopy[n3]);
        }
        dataOutputStream.writeByte(numStatusEffects);
        if (numStatusEffects != 0) {
            for (n3 = 0; n3 < 18; ++n3) {
                dataOutputStream.writeShort(statusEffects[36 + n3]);
                dataOutputStream.writeShort(statusEffects[0 + n3]);
                dataOutputStream.writeShort(statusEffects[18 + n3]);
            }
        }
        if (isFamiliar) {
            dataOutputStream.writeByte(numStatusEffectsCopy);
            if (numStatusEffectsCopy != 0) {
                for (n3 = 0; n3 < 18; ++n3) {
                    dataOutputStream.writeShort(statusEffectsCopy[36 + n3]);
                    dataOutputStream.writeShort(statusEffectsCopy[0 + n3]);
                    dataOutputStream.writeShort(statusEffectsCopy[18 + n3]);
                }
            }
        }
        for (n3 = 0; n3 < 8; ++n3) {
            dataOutputStream.writeInt(counters[n3]);
        }
        dataOutputStream.writeBoolean(gameCompleted);
        return true;
    }

    public static final void unpause(int n) {
        if (n <= 0) {
            return;
        }
    }

    public static final void relink() {
        Player.unlink();
        Player.link();
    }

    public static final void unlink() {
        Entity entity = Player.getPlayerEnt();
        if ((entity.info & 0x100000) != 0) {
            Game.unlinkEntity(entity);
        }
    }

    public static final void link() {
        Entity entity = Player.getPlayerEnt();
        if (Canvas.destX >= 0 && Canvas.destX <= 2047 && Canvas.destY >= 0 && Canvas.destY <= 2047) {
            Game.linkEntity(entity, Canvas.destX >> 6, Canvas.destY >> 6);
        }
    }

    public static final void updateStats() {
        int n = baseCe.getStat(1) + buffs[25];
        ce.setStat(1, n);
        ce.setStat(0, ce.getStat(0));
        ce.setStat(4, baseCe.getStat(4) + buffs[20]);
        ce.setStat(5, baseCe.getStat(5) + buffs[22] - buffs[28]);
        ce.setStat(3, baseCe.getStat(3) + buffs[19]);
        ce.setStat(6, baseCe.getStat(6) + buffs[21]);
        ce.setStat(7, baseCe.getStat(7));
    }

    private static final void updateStatusEffects() {
        if (numStatusEffects == 0) {
            return;
        }
        for (int i = 0; i < 18; ++i) {
            if (statusEffects[0 + i] == 0) continue;
            if (statusEffects[0 + i] <= 5 && statusEffects[0 + i] == 1) {
                Player.removeStatusEffect(i);
                continue;
            }
            if (statusEffects[0 + i] == 0) continue;
            int n = 0 + i;
            statusEffects[n] = statusEffects[n] - 1;
        }
        Player.translateStatusEffects();
    }

    public static final void translateStatusEffects() {
        int n;
        for (n = 0; n < 15; ++n) {
            Player.buffs[15 + n] = 0;
            Player.buffs[0 + n] = 0;
        }
        numbuffs = 0;
        block6: for (n = 0; n < 18; ++n) {
            int n2 = statusEffects[0 + n];
            int n3 = statusEffects[18 + n];
            if (n2 == 0 || n2 <= 0) continue;
            switch (n) {
                case 14: {
                    int n4 = buffs[20] - n3;
                    Player.buffs[20] = (short)n4;
                    Player.buffs[5] = (short)n2;
                    n4 = buffs[19] - n3;
                    Player.buffs[19] = (short)n4;
                    Player.buffs[4] = (short)n2;
                    n4 = buffs[29] - statusEffects[36 + n] * 4;
                    Player.buffs[29] = (short)n4;
                    Player.buffs[14] = (short)n2;
                    continue block6;
                }
                case 15: 
                case 17: {
                    int n4 = buffs[20] + n3;
                    Player.buffs[20] = (short)n4;
                    Player.buffs[5] = (short)n2;
                    n4 = buffs[19] + n3;
                    Player.buffs[19] = (short)n4;
                    Player.buffs[4] = (short)n2;
                    n4 = buffs[22] - (n3 + n3 / 2);
                    Player.buffs[22] = (short)n4;
                    Player.buffs[7] = (short)n2;
                    continue block6;
                }
                case 16: {
                    int n4 = buffs[22] - n3;
                    Player.buffs[22] = (short)n4;
                    Player.buffs[7] = (short)n2;
                    continue block6;
                }
                default: {
                    int n4 = buffs[15 + n] + n3;
                    Player.buffs[15 + n] = (short)n4;
                    Player.buffs[0 + n] = (short)n2;
                }
            }
        }
        for (n = 0; n < 15; ++n) {
            if (buffs[0 + n] <= 0) continue;
            if ((0x1A07 & 1 << n) == 0 && buffs[15 + n] == 0) {
                Player.buffs[0 + n] = 0;
                continue;
            }
            ++numbuffs;
        }
        Player.updateStats();
    }

    public static final void removeStatusEffect(int n) {
        if (n == 18) {
            numStatusEffects = 0;
            for (int i = 0; i < 18; ++i) {
                Player.statusEffects[0 + i] = 0;
                Player.statusEffects[36 + i] = 0;
                Player.statusEffects[18 + i] = 0;
            }
        } else {
            if (statusEffects[36 + n] == 0) {
                return;
            }
            if (n == 17) {
                Render.startFogLerp(1, 0, 2000);
            }
            Player.statusEffects[18 + n] = 0;
            Player.statusEffects[36 + n] = 0;
            Player.statusEffects[0 + n] = 0;
            --numStatusEffects;
        }
        Player.translateStatusEffects();
    }

    public static final boolean addStatusEffect(int n, int n2, int n3) {
        if (isFamiliar) {
            return false;
        }
        if (n == 13 && buffs[9] > 0) {
            return false;
        }
        int n4 = statusEffects[36 + n] + 1;
        if (n4 > 3 || (n == 12 || n == 9) && n4 > 1) {
            if (n == 14) {
                Player.statusEffects[0 + n] = n3;
            }
            return false;
        }
        if (n4 == 1) {
            ++numStatusEffects;
            if (n == 17) {
                TinyGL.fogMin = 0;
                if (TinyGL.fogRange > 0) {
                    TinyGL.fogRange = -1;
                }
                Render.startFogLerp(1024, 0, 2000);
            }
        }
        int n5 = 18 + n;
        statusEffects[n5] = statusEffects[n5] + n2;
        Player.statusEffects[0 + n] = n3;
        Player.statusEffects[36 + n] = n4;
        return true;
    }

    private static final void drawStatusEffectIcon(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Text text = Text.getSmallBuffer();
        text.setLength(0);
        if (n == 8) {
            text.append('%');
            text.append(n2);
        } else if ((1 << n & 0x3A07) == 0) {
            if (n2 >= 0) {
                text.append('+');
                text.append(n2);
            } else {
                text.append(n2);
            }
        }
        graphics.drawString(text, n4, n5 + 2, 24);
        graphics.drawBuffIcon(n, n4 + 3, n5 + 1, 0);
        if (App.time - turnTime < 600) {
            text.setLength(0);
            text.append(n3);
            graphics.drawString(text, n4 + 8, n5 + 2, 17);
            Canvas.forcePump = true;
        }
        text.dispose();
    }

    private static final void resetCounters() {
        for (int i = 0; i < 8; ++i) {
            Player.counters[i] = 0;
        }
    }

    public static final Entity getPlayerEnt() {
        return Game.entities[1];
    }

    public static final void setPickUpWeapon(int n) {
        EntityDef entityDef = null;
        EntityDef entityDef2 = EntityDef.find(6, 1, 14);
        if (n != 15) {
            entityDef = EntityDef.lookup(n);
        }
        if (null != entityDef) {
            entityDef2.tileIndex = entityDef.tileIndex;
            entityDef2.name = entityDef.name;
            entityDef2.longName = entityDef.longName;
            entityDef2.description = entityDef.description;
        } else {
            entityDef2.tileIndex = (short)15;
            entityDef2.name = (short)159;
            entityDef2.longName = (short)159;
            entityDef2.description = (short)159;
        }
    }

    public static final void giveAll() {
        int n;
        if (!isFamiliar) {
            if (Player.hasASentryBot()) {
                for (n = 0; n <= 3; ++n) {
                    int n2 = 3 + n;
                    if ((weapons & 1 << n2) == 0) continue;
                    weapons &= ~(1 << n2);
                    weapons |= 1 << 3 + (n + 1) % 4;
                    break;
                }
            } else {
                weapons |= 8;
            }
            n = 16383;
            n &= 0xFFFFFFF7;
            n &= 0xFFFFFFEF;
            n &= 0xFFFFFFDF;
            weapons |= (n &= 0xFFFFFFBF);
            Player.selectPrevWeapon();
            Player.selectNextWeapon();
        }
        for (n = 0; n < 9; ++n) {
            if (n == 8) continue;
            Player.give(2, n, 100, true);
        }
        for (n = 0; n < 26; ++n) {
            if (n == 24) continue;
            Player.give(0, (byte)n, 999, true);
            Canvas.numHelpMessages = 0;
        }
        Player.give(0, 24, 9999, true);
        ce.setStat(0, ce.getStat(1));
    }

    public static void equipForLevel(int n) {
        if (isFamiliar) {
            Player.familiarReturnsToPlayer(false);
        }
        int n2 = Canvas.viewX;
        int n3 = Canvas.viewY;
        int n4 = Canvas.viewAngle;
        Player.reset();
        Canvas.saveX = Canvas.prevX = n2;
        Canvas.destX = Canvas.prevX;
        Canvas.viewX = Canvas.prevX;
        Canvas.saveY = Canvas.prevY = n3;
        Canvas.destY = Canvas.prevY;
        Canvas.viewY = Canvas.prevY;
        Canvas.viewZ = Canvas.destZ = Render.getHeight(Canvas.viewX, Canvas.viewY) + 36;
        Canvas.destAngle = Canvas.saveAngle = n4;
        Canvas.viewAngle = Canvas.saveAngle;
        Canvas.destPitch = 0;
        Canvas.viewPitch = 0;
        highestMap = n;
        boolean bl = enableHelp;
        enableHelp = false;
        weapons = 0;
        Game.numMallocsForVIOS = 0;
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                Player.give(1, 1, 1);
                Player.give(1, 0, 1);
                Player.addArmor(33);
                Player.give(0, 17, 23);
                Player.give(0, 11, 4);
                Player.give(0, 12, 3);
                Player.give(2, 1, 100);
                Player.give(0, 24, 4);
                Player.addXP(638);
                Player.modifyStat(3, 4);
                Player.modifyStat(4, 2);
                Player.modifyStat(5, 11);
                Player.modifyStat(7, 4);
                break;
            }
            case 3: {
                Player.give(1, 2, 1);
                Player.give(1, 1, 1);
                Player.give(1, 0, 1);
                Player.give(1, 3, 100);
                Player.addArmor(4);
                Player.give(0, 17, 34);
                Player.give(0, 11, 12);
                Player.give(0, 12, 6);
                Player.give(2, 1, 100);
                Player.give(2, 3, 90);
                Player.give(0, 24, 39);
                Player.addXP(1519);
                Player.modifyStat(3, 13);
                Player.modifyStat(4, 5);
                Player.modifyStat(5, 10);
                Player.modifyStat(6, 6);
                Player.modifyStat(7, 10);
                Game.numMallocsForVIOS = 1;
                break;
            }
            case 4: {
                Player.give(1, 7, 1);
                Player.give(1, 2, 1);
                Player.give(1, 1, 1);
                Player.give(1, 0, 1);
                Player.give(1, 4, 100);
                Player.addArmor(4);
                Player.give(0, 17, 44);
                Player.give(0, 11, 5);
                Player.give(0, 12, 26);
                Player.give(2, 1, 73);
                Player.give(2, 3, 30);
                Player.give(2, 2, 24);
                Player.give(0, 24, 59);
                Player.addXP(2622);
                Player.modifyStat(3, 14);
                Player.modifyStat(4, 10);
                Player.modifyStat(5, 9);
                Player.modifyStat(6, 14);
                Player.modifyStat(7, 20);
                Game.numMallocsForVIOS = 1;
                break;
            }
            case 5: {
                Player.give(1, 9, 1);
                Player.give(1, 8, 1);
                Player.give(1, 7, 1);
                Player.give(1, 2, 1);
                Player.give(1, 1, 1);
                Player.give(1, 0, 1);
                Player.give(1, 5, 100);
                Player.addArmor(34);
                Player.give(0, 17, 79);
                Player.give(0, 16, 31);
                Player.give(0, 11, 9);
                Player.give(0, 12, 40);
                Player.give(2, 1, 84);
                Player.give(2, 3, 85);
                Player.give(2, 2, 88);
                Player.give(2, 4, 55);
                Player.give(0, 24, 73);
                Player.addXP(3594);
                Player.modifyStat(3, 14);
                Player.modifyStat(4, 12);
                Player.modifyStat(5, 9);
                Player.modifyStat(6, 18);
                Player.modifyStat(7, 28);
                Game.numMallocsForVIOS = 2;
                break;
            }
            case 6: {
                Player.give(1, 10, 1);
                Player.give(1, 9, 1);
                Player.give(1, 8, 1);
                Player.give(1, 7, 1);
                Player.give(1, 2, 1);
                Player.give(1, 1, 1);
                Player.give(1, 0, 1);
                Player.give(1, 5, 100);
                Player.addArmor(24);
                Player.give(0, 17, 116);
                Player.give(0, 16, 54);
                Player.give(0, 11, 22);
                Player.give(0, 12, 2);
                Player.give(2, 1, 88);
                Player.give(2, 3, 60);
                Player.give(2, 2, 100);
                Player.give(2, 4, 100);
                Player.give(2, 5, 20);
                Player.give(0, 24, 101);
                Player.addXP(4749);
                Player.modifyStat(3, 24);
                Player.modifyStat(4, 13);
                Player.modifyStat(5, 9);
                Player.modifyStat(6, 18);
                Player.modifyStat(7, 34);
                Game.numMallocsForVIOS = 3;
                break;
            }
            case 7: {
                Player.give(1, 11, 1);
                Player.give(1, 10, 1);
                Player.give(1, 9, 1);
                Player.give(1, 8, 1);
                Player.give(1, 7, 1);
                Player.give(1, 2, 1);
                Player.give(1, 1, 1);
                Player.give(1, 0, 1);
                Player.give(1, 5, 100);
                Player.addArmor(44);
                Player.give(0, 17, 132);
                Player.give(0, 16, 72);
                Player.give(0, 11, 23);
                Player.give(0, 12, 12);
                Player.give(2, 1, 70);
                Player.give(2, 3, 40);
                Player.give(2, 2, 66);
                Player.give(2, 4, 60);
                Player.give(2, 5, 63);
                Player.give(0, 24, 168);
                Player.addXP(5971);
                Player.modifyStat(3, 25);
                Player.modifyStat(4, 14);
                Player.modifyStat(5, 8);
                Player.modifyStat(6, 18);
                Player.modifyStat(7, 40);
                Game.numMallocsForVIOS = 3;
                break;
            }
            case 8: {
                Player.give(1, 12, 1);
                Player.give(1, 11, 1);
                Player.give(1, 10, 1);
                Player.give(1, 9, 1);
                Player.give(1, 8, 1);
                Player.give(1, 7, 1);
                Player.give(1, 2, 1);
                Player.give(1, 1, 1);
                Player.give(1, 0, 1);
                Player.give(1, 5, 100);
                Player.addArmor(38);
                Player.give(0, 17, 146);
                Player.give(0, 16, 94);
                Player.give(0, 11, 27);
                Player.give(0, 12, 20);
                Player.give(2, 1, 89);
                Player.give(2, 3, 25);
                Player.give(2, 2, 94);
                Player.give(2, 4, 52);
                Player.give(2, 5, 100);
                Player.give(0, 24, 168);
                Player.addXP(7198);
                Player.modifyStat(3, 27);
                Player.modifyStat(4, 16);
                Player.modifyStat(5, 8);
                Player.modifyStat(6, 22);
                Player.modifyStat(7, 46);
                Game.numMallocsForVIOS = 4;
                break;
            }
            case 9: 
            case 10: {
                Player.give(1, 13, 1);
                Player.give(1, 12, 1);
                Player.give(1, 11, 1);
                Player.give(1, 10, 1);
                Player.give(1, 9, 1);
                Player.give(1, 8, 1);
                Player.give(1, 7, 1);
                Player.give(1, 2, 1);
                Player.give(1, 1, 1);
                Player.give(1, 0, 1);
                Player.give(1, 5, 100);
                Player.addArmor(27);
                Player.give(0, 17, 160);
                Player.give(0, 16, 90);
                Player.give(0, 11, 23);
                Player.give(0, 12, 28);
                Player.give(2, 1, 29);
                Player.give(2, 3, 8);
                Player.give(2, 2, 44);
                Player.give(2, 4, 55);
                Player.give(2, 5, 90);
                Player.give(2, 6, 5);
                Player.give(0, 24, 174);
                Player.addXP(8281);
                Player.modifyStat(3, 27);
                Player.modifyStat(4, 17);
                Player.modifyStat(5, 8);
                Player.modifyStat(6, 22);
                Player.modifyStat(7, 46);
                Game.numMallocsForVIOS = 4;
            }
        }
        Player.give(0, 18, 1);
        enableHelp = bl;
        Player.selectNextWeapon();
        Canvas.updateFacingEntity = true;
    }

    public static boolean addArmor(int n) {
        int n2 = ce.getStat(2);
        if (n2 >= 200 && n > 0) {
            return false;
        }
        if (n < 0 && god) {
            return false;
        }
        Hud.repaintFlags |= 4;
        ce.setStat(2, Math.max(0, Math.min(200, n2 + n)));
        return true;
    }

    public static int distFrom(Entity entity) {
        return entity.distFrom(Canvas.destX, Canvas.destY);
    }

    public static void showAchievementMessage(int n) {
        Text text = Text.getSmallBuffer();
        Text text2 = Text.getSmallBuffer();
        Text.resetTextArgs();
        switch (n) {
            case 0: {
                Text.composeText(136, text);
                break;
            }
            case 1: {
                Text.composeText(137, text);
                break;
            }
            case 2: {
                Text.composeText(138, text);
                break;
            }
            case 3: {
                Text.composeText(139, text);
            }
        }
        Text.addTextArg(text);
        text.dispose();
        Text.composeText((short)0, (short)135, text2);
        if (!Canvas.enqueueHelpDialog(text2, 3)) {
            text2.dispose();
        }
        int n2 = 10;
        if (n == 2) {
            n2 = Player.calcLevelXP(level) - Player.calcLevelXP(level - 1) >> 4;
        }
        Player.addXP(n2);
        Sound.playSound(14);
    }

    public static short gradeToString(int n) {
        short s = 44;
        switch (n) {
            case 6: {
                s = 38;
                break;
            }
            case 5: {
                s = 39;
                break;
            }
            case 4: {
                s = 40;
                break;
            }
            case 3: {
                s = 41;
                break;
            }
            case 2: {
                s = 42;
                break;
            }
            case 1: {
                s = 43;
            }
        }
        return s;
    }

    public static int levelGrade(boolean bl) {
        int n = Player.getCurrentGrade(Canvas.loadMapID);
        if (n != 0) {
            return n;
        }
        Player.fillMonsterStats();
        if (monsterStats[1] == 0 || Game.totalSecrets == 0) {
            return 0;
        }
        int n2 = (monsterStats[0] << 8) / monsterStats[1];
        int n3 = 6 * n2 >> 8;
        int n4 = (Game.mapSecretsFound << 8) / Game.totalSecrets;
        int n5 = 6 * n4 >> 8;
        int n6 = Math.max((n3 + n5 >> 1) - currentLevelDeaths, 1);
        if (bl) {
            int n7 = Player.getBestGrade(Canvas.loadMapID);
            if (n6 > n7) {
                Player.setBestGrade(Canvas.loadMapID, n6);
            }
            Player.setCurrentGrade(Canvas.loadMapID, n6);
        }
        return n6;
    }

    public static int finalCurrentGrade() {
        int n = 0;
        for (int i = 1; i <= 9; ++i) {
            n += Player.getCurrentGrade(i);
        }
        return n / 9;
    }

    public static int finalBestGrade() {
        int n = 0;
        for (int i = 1; i <= 9; ++i) {
            n += Player.getBestGrade(i);
        }
        return n / 9;
    }

    public static int getCurrentGrade(int n) {
        return currentGrades >> 3 * --n & 7;
    }

    public static void setCurrentGrade(int n, int n2) {
        currentGrades |= n2 << 3 * --n;
    }

    public static int getBestGrade(int n) {
        return bestGrades >> 3 * --n & 7;
    }

    public static void setBestGrade(int n, int n2) {
        bestGrades &= ~(7 << 3 * --n);
        bestGrades |= n2 << 3 * n;
    }

    public static boolean hasPurifyEffect() {
        return statusEffects[1] != 0;
    }

    public static void setFamiliar(short s) {
        int n;
        if (Canvas.state == 6) {
            return;
        }
        Game.scriptStateVars[16] = 1;
        Canvas.saveX = Canvas.viewX;
        Canvas.saveY = Canvas.viewY;
        Canvas.saveZ = Canvas.viewZ;
        Canvas.saveAngle = Canvas.viewAngle;
        Canvas.savePitch = Canvas.viewPitch;
        isFamiliar = true;
        Player.setFamiliarType(s);
        Game.updateScriptVars();
        if (!Canvas.attemptMove(Canvas.viewX + Canvas.viewStepX, Canvas.viewY + Canvas.viewStepY)) {
            Game.scriptStateVars[16] = 0;
            isFamiliar = false;
            Player.setFamiliarType((short)0);
            Game.updateScriptVars();
            Hud.addMessage((short)0, (short)190, 3);
            return;
        }
        Render.savePlayerFog();
        Render.startFade(400, 2);
        playerEntityCopyIndex = Game.spawnPlayerEntityCopy((short)Canvas.saveX, (short)Canvas.saveY).getIndex();
        weaponsCopy = 0;
        for (n = 0; n < ammoCopy.length; ++n) {
            Player.ammoCopy[n] = 0;
        }
        for (n = 0; n < inventoryCopy.length; ++n) {
            Player.inventoryCopy[n] = 0;
        }
        Player.clearOutFamiliarsStatusEffects();
        Player.swapStatusEffects();
        n = 0;
        n = familiarType == 1 || familiarType == 3 ? (int)(Player.showHelp((short)12, false) ? 1 : 0) : (int)(Player.showHelp((short)13, false) ? 1 : 0);
        if (n == 0) {
            Canvas.drawPlayingSoftKeys();
        }
    }

    public static short unsetFamiliar(boolean bl) {
        Hud.stopBrightenScreen();
        Hud.stopScreenSmack();
        int n = Canvas.saveAngle;
        if (bl) {
            if (Canvas.saveX > Canvas.viewX) {
                n = 512;
            } else if (Canvas.saveX < Canvas.viewX) {
                n = 0;
            } else if (Canvas.saveY > Canvas.viewY) {
                n = 256;
            } else if (Canvas.saveY < Canvas.viewY) {
                n = 768;
            }
        }
        Canvas.destAngle = Canvas.viewAngle = n;
        Canvas.destPitch = Canvas.viewPitch = Canvas.savePitch;
        if (!bl) {
            Canvas.destX = Canvas.saveX;
            Canvas.destY = Canvas.saveY;
            Canvas.destZ = Canvas.saveZ;
            Canvas.viewX = Canvas.destX;
            Canvas.viewY = Canvas.destY;
            Canvas.viewZ = Canvas.destZ;
        }
        Player.swapStatusEffects();
        if (!bl) {
            Render.loadPlayerFog();
        }
        Render.startFade(400, 2);
        Game.remove(Game.entities[playerEntityCopyIndex]);
        playerEntityCopyIndex = -1;
        Player.unlink();
        Canvas.finishRotation(true);
        Player.relink();
        isFamiliar = false;
        short s = familiarType;
        Player.setFamiliarType((short)0);
        Game.updateScriptVars();
        Canvas.drawPlayingSoftKeys();
        return s;
    }

    public static void clearOutFamiliarsStatusEffects() {
        int n = 0;
        numbuffsCopy = 0;
        for (n = 0; n < 15; ++n) {
            Player.buffsCopy[0 + n] = 0;
            Player.buffsCopy[15 + n] = 0;
        }
        numStatusEffectsCopy = 0;
        for (n = 0; n < 18; ++n) {
            Player.statusEffectsCopy[0 + n] = 0;
            Player.statusEffectsCopy[36 + n] = 0;
            Player.statusEffectsCopy[18 + n] = 0;
        }
    }

    public static void swapStatusEffects() {
        int n = numbuffs;
        numbuffs = numbuffsCopy;
        numbuffsCopy = n;
        short[] sArray = buffs;
        buffs = buffsCopy;
        buffsCopy = sArray;
        int n2 = numStatusEffects;
        numStatusEffects = numStatusEffectsCopy;
        numStatusEffectsCopy = n2;
        int[] nArray = statusEffects;
        statusEffects = statusEffectsCopy;
        statusEffectsCopy = nArray;
    }

    public static void familiarDied() {
        int n;
        int n2;
        if (Combat.curAttacker != null) {
            n2 = Combat.curAttacker.getSprite();
            if (Combat.curAttacker.def.eType == 2) {
                Render.mapSpriteInfo[n2] = Render.mapSpriteInfo[n2] & 0xFFFF00FF | 0;
            }
            Text.resetTextArgs();
            if (Combat.accumRoundDamage > 0) {
                Text.addTextArg((short)1, (short)(Combat.curAttacker.def.name & 0x3FF));
                Text.addTextArg(Combat.accumRoundDamage);
                Hud.addMessage((short)0, (short)112);
            }
            Canvas.shakeTime = 0;
            Hud.damageDir = 0;
            Hud.damageTime = 0;
            Combat.curAttacker.monster.flags = (short)(Combat.curAttacker.monster.flags | 0x400);
            Game.gsprite_clear(64);
            Canvas.invalidateRect();
        }
        n2 = Canvas.viewX;
        int n3 = Canvas.viewY;
        short s = Player.unsetFamiliar(false);
        Hud.addMessage((short)0, (short)192, 2);
        if (s == 2 || s == 4) {
            Player.explodeFamiliar(n2 >> 6, n3 >> 6, s);
        }
        switch (s) {
            case 2: {
                n = 4;
                break;
            }
            case 3: {
                n = 5;
                break;
            }
            case 4: {
                n = 6;
                break;
            }
            default: {
                n = 3;
            }
        }
        if (noFamiliarRemains) {
            noFamiliarRemains = false;
        } else {
            Player.handleBotRemains(n2, n3, n);
        }
        Player.give(1, n, -1, true);
    }

    public static void explodeFamiliar(int n, int n2, int n3) {
        int n4;
        int n5 = n3 == 2 ? 4 : 6;
        int n6 = n5 * 9;
        int n7 = Combat.weapons[n6 + 0] & 0xFF;
        if (n7 != (n4 = Combat.weapons[n6 + 1] & 0xFF)) {
            n7 += App.nextByte() % (n4 - n7);
        }
        Combat.radiusHurtEntities(n, n2, 0, n7, Player.getPlayerEnt(), null);
    }

    public static void familiarReturnsToPlayer(boolean bl) {
        Player.unsetFamiliar(bl);
        tookBotsInventory = Player.stealFamiliarsInventory();
    }

    public static boolean stealFamiliarsInventory() {
        int n;
        int n2 = weaponsCopy;
        short[] sArray = inventoryCopy;
        short[] sArray2 = ammoCopy;
        boolean bl = false;
        for (n = 0; n < 26; ++n) {
            if (sArray[n] == 0) continue;
            Player.give(0, n, sArray[n], true);
            bl = true;
        }
        for (n = 0; n < 9; ++n) {
            if (sArray2[n] == 0) continue;
            Player.give(2, n, sArray2[n], true);
            bl = true;
        }
        for (n = 0; n < 15; ++n) {
            int n3 = 1 << n;
            if ((n3 & n2) == 0) continue;
            Player.give(1, n, 1, true);
            bl = true;
        }
        return bl;
    }

    public static void handleBotRemains(int n, int n2, int n3) {
        Object object;
        int n4;
        int n5 = weaponsCopy;
        short[] sArray = inventoryCopy;
        short[] sArray2 = ammoCopy;
        short s = 0;
        short s2 = 0;
        block9: for (n4 = 0; n4 < 26; ++n4) {
            if (sArray[n4] == 0) continue;
            if (n4 == 24 || n4 >= 0 && n4 < 11) {
                short s3 = sArray[n4];
                Player.give(0, n4, s3, true, true);
                EntityDef entityDef = EntityDef.find(6, 0, n4);
                object = Hud.getMessageBuffer();
                Text.resetTextArgs();
                Text.addTextArg(s3);
                Text text = Text.getSmallBuffer();
                Text.composeText((short)1, entityDef.longName, text);
                Text.addTextArg(text);
                Text.composeText((short)0, (short)86, (Text)object);
                text.dispose();
                Hud.finishMessageBuffer();
                continue;
            }
            switch (n4) {
                case 13: {
                    s2 = (short)(s2 + sArray[n4]);
                    continue block9;
                }
                case 16: {
                    s = (short)(s + sArray[n4]);
                    continue block9;
                }
                case 11: 
                case 12: 
                case 17: 
                case 19: 
                case 20: {
                    EntityDef entityDef = EntityDef.find(6, 0, n4);
                    short s4 = entityDef.tileIndex;
                    Game.spawnDropItem(n, n2, s4, entityDef, sArray[n4], true);
                }
            }
        }
        block10: for (n4 = 1; n4 < 9; ++n4) {
            if (sArray2[n4] == 0) continue;
            switch (n4) {
                case 3: {
                    continue block10;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    EntityDef entityDef = EntityDef.find(6, 2, n4);
                    short s5 = entityDef.tileIndex;
                    Game.spawnDropItem(n, n2, s5, entityDef, sArray2[n4], true);
                }
            }
        }
        for (n4 = 0; n4 < 15; ++n4) {
            int n6 = 1 << n4;
            if ((n6 & n5) == 0) continue;
            int n7 = Combat.getWeaponTileNum(n4);
            object = EntityDef.lookup(n7);
            Game.spawnDropItem(n, n2, n7, (EntityDef)object, 1, true);
        }
        Game.spawnSentryBotCorpse(n, n2, n3, s, s2);
    }

    public static final void forceFamiliarReturnDueToMonster() {
        Player.familiarReturnsToPlayer(false);
        botReturnedDueToMonster = true;
    }

    public static final void attemptToDeploySentryBot() {
        short s;
        int n;
        int n2;
        if (Game.activeMonsters != null) {
            Entity entity;
            Entity entity2 = Game.activeMonsters;
            do {
                entity = entity2.monster.nextOnList;
                if (entity2.distFrom(Canvas.destX, Canvas.destY) > Combat.tileDistances[0] || !entity2.aiIsAttackValid()) continue;
                Hud.addMessage((short)0, (short)219, 3);
                return;
            } while ((entity2 = entity) != Game.activeMonsters && Game.activeMonsters != null);
        }
        if ((Render.mapFlags[(n2 = Canvas.viewY + Canvas.viewStepY >> 6) * 32 + (n = Canvas.viewX + Canvas.viewStepX >> 6)] & 0x10) != 0) {
            Hud.addMessage((short)0, (short)217, 3);
            return;
        }
        switch (Player.ce.weapon) {
            case 4: {
                s = 2;
                break;
            }
            case 5: {
                s = 3;
                break;
            }
            case 6: {
                s = 4;
                break;
            }
            default: {
                s = 1;
            }
        }
        Player.setFamiliar(s);
    }

    public static final void attemptToDiscardFamiliar(int n) {
        int n2 = Canvas.viewY >> 6;
        int n3 = Canvas.viewX >> 6;
        if ((Render.mapFlags[n2 * 32 + n3] & 0x20) != 0) {
            Hud.addMessage((short)0, (short)221, 3);
        } else {
            int n4 = Combat.getWeaponTileNum(n);
            Game.spawnDropItem(Canvas.viewX, Canvas.viewY, n4, 6, 1, n, ammo[7], false);
            Player.give(1, n, -1);
        }
    }

    public static final void startSelfDestructDialog() {
        if (Canvas.state != 6) {
            attemptingToSelfDestructFamiliar = true;
            Text text = Text.getSmallBuffer();
            Text.composeText((short)0, (short)194, text);
            Canvas.startDialog(null, text, 12, 1, false);
            text.dispose();
        }
    }

    public static final boolean vendingMachineIsHacked(int n) {
        return (hackedVendingMachines & 1 << n) == 1 << n;
    }

    public static final void setVendingMachineHack(int n) {
        hackedVendingMachines |= 1 << n;
    }

    public static final int getVendingMachineTriesLeft(int n) {
        int n2;
        if ((n = Math.max(Math.min(n, 18), 1)) > 9) {
            n2 = vendingMachineHackTriesLeft2;
            n -= 9;
        } else {
            n2 = vendingMachineHackTriesLeft1;
        }
        int n3 = 7;
        return n2 >> 3 * (n - 1) & n3;
    }

    public static final void removeOneVendingMachineTry(int n) {
        if (Player.getVendingMachineTriesLeft(n = Math.max(Math.min(n, 18), 1)) > 0) {
            if (n > 9) {
                vendingMachineHackTriesLeft2 -= 1 << 3 * ((n -= 9) - 1);
            } else {
                vendingMachineHackTriesLeft1 -= 1 << 3 * (n - 1);
            }
        }
    }

    public static final boolean weaponIsASentryBot(int n) {
        return (1 << n & 0x78) != 0;
    }

    public static final boolean hasASentryBot() {
        boolean bl = (weapons & 8) != 0 || (weapons & 0x20) != 0;
        boolean bl2 = (weapons & 0x10) != 0 || (weapons & 0x40) != 0;
        return bl || bl2;
    }

    private static final void setFamiliarType(short s) {
        familiarType = s;
        Player.calcViewMode();
    }

    private static final void calcViewMode() {
        switch (familiarType) {
            case 0: {
                Render.postProcessMode = 0;
                break;
            }
            case 1: 
            case 2: {
                Render.postProcessMode = 1;
                break;
            }
            case 3: 
            case 4: {
                Render.postProcessMode = 2;
            }
        }
    }

    public static final void enterTargetPractice(int n, int n2, int n3, ScriptThread scriptThread) {
        inTargetPractice = true;
        Canvas.targetPracticeThread = scriptThread;
        Canvas.saveX = Canvas.viewX;
        Canvas.saveY = Canvas.viewY;
        Canvas.saveZ = Canvas.viewZ;
        Canvas.saveAngle = Canvas.viewAngle;
        int n4 = n3 == 4 ? 512 : (n3 == 0 ? 0 : (n3 == 2 ? 256 : 768));
        Canvas.destAngle = Canvas.viewAngle = n4;
        Canvas.destX = Canvas.viewX = (n << 6) + 32;
        Canvas.destY = Canvas.viewY = (n2 << 6) + 32;
        Canvas.destZ = Canvas.viewZ = Render.getHeight(Canvas.viewX, Canvas.viewY) + 36;
        Player.showHelp((short)17, false);
        ScriptThread.stripInventoryForTargetPractice();
        targetPracticeScore = 0;
        Render.startFade(750, 2);
    }

    public static final void assessTargetPracticeShot(Entity entity) {
        int n = entity.getSprite();
        int n2 = Canvas.zoomCollisionX - Render.mapSprites[Render.S_X + n];
        int n3 = Canvas.zoomCollisionY - Render.mapSprites[Render.S_Y + n];
        int n4 = Canvas.zoomCollisionZ - Render.mapSprites[Render.S_Z + n];
        int n5 = Render.mapSpriteInfo[n] >> 8 & 0xF0;
        int[][] nArray = Render.getImageFrameBounds(entity.def.tileIndex, 3, 2, 0);
        int n6 = -1;
        for (int i = 0; i < 3; ++i) {
            if (n2 <= nArray[i][0] || n2 >= nArray[i][1] || n3 <= nArray[i][0] || n3 >= nArray[i][1] || n4 <= nArray[i][2] || n4 >= nArray[i][3]) continue;
            n6 = i;
            break;
        }
        if (n6 != -1) {
            if (n6 == 0 || n5 == 16) {
                Hud.addMessage((short)230, 4);
                targetPracticeScore += 30;
            } else if (n6 == 1) {
                Hud.addMessage((short)231, 4);
                targetPracticeScore += 20;
            } else {
                Hud.addMessage((short)232, 4);
                targetPracticeScore += 10;
            }
        } else {
            Hud.addMessage((short)68, 4);
        }
    }

    public static final void exitTargetPractice() {
        inTargetPractice = false;
        Canvas.destAngle = Canvas.viewAngle = Canvas.saveAngle;
        Canvas.destX = Canvas.viewX = Canvas.saveX;
        Canvas.destY = Canvas.viewY = Canvas.saveY;
        Canvas.destZ = Canvas.viewZ = Canvas.saveZ;
        ScriptThread.restoreInventory();
        Render.startFade(750, 2);
        int n = 0;
        int n2 = 240;
        Text.resetTextArgs();
        Text.addTextArg(targetPracticeScore);
        if (targetPracticeScore > n2 / 2) {
            n = 1;
            if ((n = Player.modifyStat(5, n)) > 0) {
                Text.addTextArg(n);
                Hud.addMessage((short)233, 3);
            } else {
                Hud.addMessage((short)235, 3);
            }
        } else {
            Hud.addMessage((short)234, 3);
        }
        if (Canvas.targetPracticeThread != null) {
            Canvas.setState(3);
            Canvas.targetPracticeThread.run();
            Canvas.targetPracticeThread = null;
        }
    }

    public static final void usedChainsaw(boolean bl) {
        ++chainsawStrengthBonusCount;
        if (bl && (Combat.crFlags & 2) != 0) {
            ++chainsawStrengthBonusCount;
        }
        if (chainsawStrengthBonusCount >= 30) {
            chainsawStrengthBonusCount %= 30;
            int n = 2;
            if ((n = Player.modifyStat(4, n)) != 0) {
                Text.resetTextArgs();
                Text.addTextArg(n);
                Hud.addMessage((short)241, 3);
            }
        }
        Canvas.startShake(666, 1, 0);
    }

    public static final boolean hasANanoDrink() {
        for (int i = 0; i < 11; ++i) {
            if (inventory[i] <= 0) continue;
            return true;
        }
        return false;
    }

    static {
        inventory = new short[26];
        ammo = new short[9];
        inventoryCopy = new short[26];
        ammoCopy = new short[9];
        baseCe = new CombatEntity();
        ce = new CombatEntity();
        characterChoice = (short)2;
        notebookIndexes = new short[8];
        notebookPositions = new short[8];
        noDeathFlag = false;
        noFamiliarRemains = false;
        statusEffects = new int[54];
        statusEffectsCopy = new int[54];
        buffs = new short[30];
        buffsCopy = new short[30];
        playerEntityCopyIndex = -1;
        counters = new int[8];
        monsterStats = new int[2];
    }
}

