/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;

final class Resource {
    public static int touchMe = 1;
    public static int cursor = 0;
    public static final int IO_SIZE = 40960;
    public static final byte[] ioBuffer = new byte[40960];
    private static int[] tableOffsets = new int[15];
    private static int prevOffset;
    private static InputStream prevIS;
    static int addRecordStoreError;

    Resource() {
    }

    public static void readByteArray(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        for (int i = n2; i > 0; i -= n3) {
            n3 = inputStream.read(byArray, n + n2 - i, i);
        }
    }

    public static void readUByteArray(InputStream inputStream, short[] sArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n2 > 0) {
            n3 = 40960 > n2 ? n2 : 40960;
            n2 -= n3;
            Resource.read(inputStream, n3);
            while (--n3 >= 0) {
                sArray[n++] = Resource.shiftUByte();
            }
        }
    }

    public static void readCoordArray(InputStream inputStream, short[] sArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n2 > 0) {
            n3 = 40960 > n2 ? n2 : 40960;
            n2 -= n3;
            Resource.read(inputStream, n3);
            while (--n3 >= 0) {
                sArray[n++] = Resource.shiftCoord();
            }
        }
    }

    public static void readShortArray(InputStream inputStream, short[] sArray, int n, int n2) throws IOException {
        int n3 = 0;
        int n4 = 20480;
        while (n2 > 0) {
            n3 = n4 > n2 ? n2 : n4;
            n2 -= n3;
            Resource.read(inputStream, n3 * 2);
            while (--n3 >= 0) {
                sArray[n++] = Resource.shiftShort();
            }
        }
    }

    public static void readUShortArray(InputStream inputStream, int[] nArray, int n, int n2) throws IOException {
        int n3 = 0;
        int n4 = 20480;
        while (n2 > 0) {
            n3 = n4 > n2 ? n2 : n4;
            n2 -= n3;
            Resource.read(inputStream, n3 * 2);
            while (--n3 >= 0) {
                nArray[n++] = Resource.shiftUShort();
            }
        }
    }

    public static void readIntArray(InputStream inputStream, int[] nArray, int n, int n2) throws IOException {
        int n3 = 0;
        int n4 = 10240;
        while (n2 > 0) {
            n3 = n4 > n2 ? n2 : n4;
            n2 -= n3;
            Resource.read(inputStream, n3 * 4);
            while (--n3 >= 0) {
                nArray[n++] = Resource.shiftInt();
            }
        }
    }

    public static final void readMarker(InputStream inputStream, int n) throws IOException {
        Resource.read(inputStream, 4);
    }

    public static final void readMarker(InputStream inputStream) throws IOException {
        Resource.readMarker(inputStream, -889275714);
    }

    public static final void writeMarker(OutputStream outputStream, int n) throws IOException {
        Resource.ioBuffer[0] = (byte)(n & 0xFF);
        Resource.ioBuffer[1] = (byte)(n >> 8 & 0xFF);
        Resource.ioBuffer[2] = (byte)(n >> 16 & 0xFF);
        Resource.ioBuffer[3] = (byte)(n >> 24 & 0xFF);
        outputStream.write(ioBuffer, 0, 4);
    }

    public static final void writeMarker(OutputStream outputStream) throws IOException {
        Resource.writeMarker(outputStream, -889275714);
    }

    public static final void read(InputStream inputStream, int n) throws IOException {
        cursor = 0;
        Resource.readByteArray(inputStream, ioBuffer, 0, n);
    }

    public static final void bufSkip(InputStream inputStream, int n, boolean bl) throws IOException {
        for (int i = 0; i < n; i += 40960) {
            int n2 = i + 40960 > n ? n - i : 40960;
            Resource.read(inputStream, n2);
            if (!bl) continue;
            Canvas.updateLoadingBar(false);
        }
    }

    public static final byte byteAt(int n) {
        return ioBuffer[n];
    }

    public static final byte shiftByte() {
        return ioBuffer[cursor++];
    }

    public static final short UByteAt(int n) {
        return (short)(ioBuffer[n] & 0xFF);
    }

    public static final short shiftUByte() {
        return (short)(ioBuffer[cursor++] & 0xFF);
    }

    public static final short shortAt(int n) {
        return (short)((ioBuffer[n] & 0xFF) + (ioBuffer[n + 1] << 8 & 0xFF00));
    }

    public static final short shiftShort() {
        short s = (short)((ioBuffer[cursor] & 0xFF) + (ioBuffer[cursor + 1] << 8 & 0xFF00));
        cursor += 2;
        return s;
    }

    public static final int shiftUShort() {
        int n = (ioBuffer[cursor] & 0xFF) + (ioBuffer[cursor + 1] << 8 & 0xFF00);
        cursor += 2;
        return n;
    }

    public static final int shiftInt() {
        int n = ioBuffer[cursor + 3] << 24 & 0xFF000000 | ioBuffer[cursor + 2] << 16 & 0xFF0000 | ioBuffer[cursor + 1] << 8 & 0xFF00 | ioBuffer[cursor + 0] & 0xFF;
        cursor += 4;
        return n;
    }

    public static final short shiftCoord() {
        short s = (short)((ioBuffer[cursor] & 0xFF) << 3);
        ++cursor;
        return s;
    }

    static final int[] readFileIndex(InputStream inputStream) throws IOException {
        Resource.read(inputStream, 4);
        int n = Resource.shiftInt();
        int[] nArray = new int[n];
        Resource.read(inputStream, n * 4);
        for (int i = 0; i < n; ++i) {
            nArray[i] = Resource.shiftInt();
        }
        return nArray;
    }

    public static final int[] loadFileIndex(String string) throws IOException {
        InputStream inputStream = App.getResourceAsStream(string);
        Resource.read(inputStream, 2);
        int n = Resource.shiftShort();
        int n2 = 5;
        int n3 = 3;
        int[] nArray = new int[n * n3];
        int n4 = n2 * (40960 / n2);
        int n5 = 0;
        do {
            int n6;
            n6 = (n6 = (n - n5) * n2) > n4 ? n4 : n6;
            Resource.read(inputStream, n6);
            for (int i = 0; i < n6; i += n2) {
                byte by = Resource.shiftByte();
                int n7 = Resource.shiftInt();
                if (n7 != 0) {
                    nArray[n5 * n3 - 1] = n7 - nArray[n5 * n3 - 2];
                }
                if (by == -1) continue;
                nArray[n5 * n3 + 0] = by;
                nArray[n5 * n3 + 1] = n7;
                ++n5;
            }
        } while (n5 != n);
        Resource.read(inputStream, n2);
        Resource.shiftByte();
        nArray[n5 * n3 - 1] = Resource.shiftInt() - nArray[n5 * n3 - 2];
        inputStream.close();
        return nArray;
    }

    public static void initTableLoading() {
        InputStream inputStream = App.getResourceAsStream("/tables.bin");
        try {
            Resource.read(inputStream, 60);
            for (int i = 0; i < 15; ++i) {
                Resource.tableOffsets[i] = Resource.shiftInt();
            }
            inputStream.close();
            inputStream = null;
            System.gc();
        }
        catch (IOException iOException) {
            App.Error(iOException, 77);
        }
    }

    public static void beginTableLoading() throws IOException {
        InputStream inputStream = App.getResourceAsStream("/tables.bin");
        Resource.bufSkip(inputStream, 60, false);
        prevOffset = 0;
        prevIS = inputStream;
    }

    public static void seekTable(int n) throws IOException {
        int n2 = 0;
        if (n > 0) {
            n2 = tableOffsets[n - 1];
        }
        if (n2 < prevOffset) {
            throw new IOException("seekTable seeking backwards");
        }
        Resource.bufSkip(prevIS, n2 - prevOffset, false);
        prevOffset = n2;
    }

    public static void finishTableLoading() throws IOException {
        prevIS.close();
        prevIS = null;
        System.gc();
    }

    public static int getNumTableBytes(int n) {
        int n2 = tableOffsets[n] - 4;
        if (n == 0) {
            return n2;
        }
        return n2 - tableOffsets[n - 1];
    }

    public static int getNumTableShorts(int n) {
        int n2 = tableOffsets[n] - 4;
        if (n == 0) {
            return n2 / 2;
        }
        return (n2 - tableOffsets[n - 1]) / 2;
    }

    public static int getNumTableInts(int n) {
        int n2 = tableOffsets[n] - 4;
        if (n == 0) {
            return n2 / 4;
        }
        return (n2 - tableOffsets[n - 1]) / 4;
    }

    public static void loadByteTable(byte[] byArray, int n) {
        try {
            Resource.seekTable(n);
            Resource.read(prevIS, 4);
            int n2 = Resource.shiftInt();
            prevIS.read(byArray);
            prevOffset += 4 + n2;
        }
        catch (Exception exception) {
            App.Error(exception, 77);
        }
    }

    public static void loadShortTable(short[] sArray, int n) {
        try {
            Resource.seekTable(n);
            Resource.read(prevIS, 4);
            int n2 = Resource.shiftInt();
            n2 *= 2;
            int n3 = 0;
            for (int i = 0; i < n2; i += 40960) {
                int n4 = i + 40960 > n2 ? n2 - i : 40960;
                Resource.read(prevIS, n4);
                for (int j = 0; j < n4; j += 2) {
                    sArray[n3++] = Resource.shiftShort();
                }
            }
            prevOffset += 4 + n2;
        }
        catch (Exception exception) {
            App.Error(exception, 77);
        }
    }

    public static void loadIntTable(int[] nArray, int n) {
        try {
            Resource.seekTable(n);
            Resource.read(prevIS, 4);
            int n2 = Resource.shiftInt();
            n2 *= 4;
            int n3 = 0;
            for (int i = 0; i < n2; i += 40960) {
                int n4 = i + 40960 > n2 ? n2 - i : 40960;
                Resource.read(prevIS, n4);
                for (int j = 0; j < n4; j += 4) {
                    nArray[n3++] = Resource.shiftInt();
                }
            }
            prevOffset += 4 + n2;
        }
        catch (Exception exception) {
            App.Error(exception, 77);
        }
    }

    public static DataInputStream loadRecord(String string) throws Exception {
        RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)false);
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            byteArrayInputStream = new ByteArrayInputStream(recordStore.getRecord(recordEnumeration.nextRecordId()));
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            recordStore.closeRecordStore();
            recordStore = null;
            System.gc();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return new DataInputStream(byteArrayInputStream);
    }

    public static RecordStore addRecordStore(String string) {
        addRecordStoreError = 0;
        RecordStore recordStore = null;
        while (recordStore == null && addRecordStoreError == 0) {
            recordStore = Resource.openRecord(string, true);
        }
        if (addRecordStoreError != 0) {
            if (addRecordStoreError == 1) {
                App.Error(new RecordStoreFullException("File System Full."), 83);
            } else if (addRecordStoreError == 2) {
                App.Error(new InvalidRecordIDException("Invalid Record ID."), 83);
            } else {
                App.Error(new RecordStoreException("File System Error."), 83);
            }
        }
        return recordStore;
    }

    public static RecordStore openRecord(String string, boolean bl) {
        try {
            return RecordStore.openRecordStore((String)string, (boolean)bl);
        }
        catch (RecordStoreFullException recordStoreFullException) {
            addRecordStoreError = 1;
            return null;
        }
        catch (InvalidRecordIDException invalidRecordIDException) {
            addRecordStoreError = 2;
            return null;
        }
        catch (Exception exception) {
            addRecordStoreError = 3;
            return null;
        }
    }

    public static void closeRecord(RecordStore recordStore) {
        try {
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            App.Error(exception, 82);
        }
        catch (Error error) {
            App.Error(82);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveRecord(String string, byte[] byArray) {
        Resource.deleteRecord(string);
        RecordStore recordStore = Resource.addRecordStore(string);
        if (recordStore != null) {
            try {
                recordStore.addRecord(byArray, 0, byArray.length);
            }
            catch (Throwable throwable) {
                App.Error(throwable, 83);
            }
            finally {
                Resource.closeRecord(recordStore);
                recordStore = null;
                System.gc();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            Text.addTextArg(83);
            Canvas.setLoadingBarText((short)0, (short)37);
            Canvas.updateLoadingBar(true);
            App.Error(new RecordStoreFullException("Cannot add RecordStore."), 83);
        }
        System.gc();
    }

    public static boolean recordExists(String string) {
        String[] stringArray = RecordStore.listRecordStores();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (!string2.equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static void deleteRecord(String string) {
        while (Resource.recordExists(string)) {
            try {
                RecordStore.deleteRecordStore((String)string);
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            }
            catch (RecordStoreException recordStoreException) {
                App.Error(recordStoreException, 81);
            }
        }
    }

    public static void touchRecord(String string) throws RecordStoreException {
        RecordStore recordStore = Resource.openRecord(string, true);
        if (recordStore != null) {
            Resource.closeRecord(recordStore);
            recordStore = null;
            System.gc();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static {
        addRecordStoreError = 0;
    }
}

