/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.EOFException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.rms.RecordStoreException;

class GameManager
extends GameCanvas
implements Runnable {
    static final int MILLIS_PER_TICK = 200;
    static final int MAX_INV = 16;
    static final int STAND_INV = 8;
    static final int NORTH = 0;
    static final int EAST = 1;
    static final int SOUTH = 2;
    static final int WEST = 3;
    static final int GM_UP = 1;
    static final int GM_DOWN = 2;
    static final int GM_LEFT = 3;
    static final int GM_RIGHT = 4;
    static final int GM_FIRE = 5;
    static final int GM_LSIDE = 6;
    static final int GM_RSIDE = 7;
    public final int GM_MENU;
    public final int GM_NEW_GAME;
    public final int GM_PLAY;
    public final int GM_INV;
    public final int GM_DEAD;
    public final int GM_NEW_LEVEL;
    public final int GM_EOL;
    public final int GM_MAP;
    public final int GM_CONT;
    private final DarkHorde_Midlet midlet;
    public final GameEffects gameEffects;
    public Dictionary dict;
    private Image splgfx;
    private Image invgfx;
    private Image inv2gfx;
    private Image bggfx;
    private Image menugfx;
    private Image MyImage;
    public View view;
    private int ticks = 0;
    public int status = 1;
    public int tempStatus;
    private int option;
    public boolean[] options;
    private int gameWidth;
    private int gameHeight;
    private boolean redrawBG;
    private boolean redrawAll = false;
    private boolean availBG;
    public byte[] invItem;
    private int[][] invSquareXY;
    private int invSquareSize;
    private int itemX;
    private int itemY;
    private int itemCurrent;
    private int itemSelect;
    private boolean isGameOver = false;
    private volatile boolean isPaused = false;
    private volatile Thread animationThread = null;
    private static final Font GAME_FONT = Font.getFont((int)0, (int)0, (int)8);
    private static final int fontHeight = GAME_FONT.getHeight();
    public byte[] gameAction;
    public int gameActionCount;
    public int gameActionCurrent;
    private boolean hasBeenShown = false;
    public int xEnd;
    public int yEnd;
    public int xMap;
    public int yMap;
    public int direction;
    public int HP;
    public int maxHP;
    public int iDex;
    public int iAtt;
    public int iDef;
    public byte gameLevel;
    public int showText;
    public int textTimer;
    public boolean clearText;
    public boolean showItem;
    public boolean clearItem;
    public boolean showHP;
    public boolean showHand;
    public int iHit;
    public int iRecovery;
    public int[][] showBlood;
    public int compassDirec;
    public int rowBorder;
    public int colBorder;
    public byte[] itemDsc = new byte[]{1, 2, 3, 0, 0, 0, 0, 0, 4, 5, 6, 7, 0, 0, 0, 0, 8, 9, 10, 0, 0, 0, 0, 0, 11, 12, 13, 0, 0, 0, 0, 0, 14, 15, 16, 17, 0, 0, 0, 0, 18, 19, 0, 0, 0, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 21, 22, 0, 0, 0, 0, 0, 0, 23, 24, 25, 26, 27, 28, 29, 0};
    public StringBuffer LevelText;
    public String LevelStr;
    public byte[] bStory;
    public String storyStr;
    public boolean bShowStory;
    public boolean bLoadQuik;
    public boolean bLoadGame;
    public boolean bEnd;
    public int c_startApp = 0;
    public int c_pauseApp = 0;
    public int c_hideNotify = 0;
    public int c_showNotify = 0;
    public int iLastKey = 0;
    public boolean bFireHeld = false;
    public boolean bLeftHeld;
    public boolean bRightHeld;
    public boolean bUpHeld;
    public boolean bDownHeld;
    public boolean bAHeld;
    public boolean bBHeld;
    public boolean bCHeld;

    GameManager(DarkHorde_Midlet darkHorde_Midlet, GameEffects gameEffects) {
        super(true);
        this.GM_MENU = 0;
        this.GM_NEW_GAME = 1;
        this.GM_PLAY = 2;
        this.GM_INV = 3;
        this.GM_DEAD = 4;
        this.GM_NEW_LEVEL = 5;
        this.GM_EOL = 6;
        this.GM_MAP = 7;
        this.GM_CONT = 8;
        this.options = new boolean[8];
        this.invItem = new byte[16];
        this.invSquareXY = new int[16][2];
        this.gameAction = new byte[32];
        this.showBlood = new int[4][2];
        this.midlet = darkHorde_Midlet;
        this.gameEffects = gameEffects;
        this.setFullScreenMode(true);
        this.MyImage = this.gameEffects.getGfx("/1.png");
        this.gameWidth = this.getWidth();
        this.gameHeight = this.getHeight();
        if (this.gameHeight <= 65) {
            this.rowBorder = 0;
            this.colBorder = 0;
            this.itemX = 0;
            this.itemY = this.gameHeight - 12;
            this.availBG = false;
        } else {
            this.rowBorder = this.gameHeight - 106 >> 1;
            this.colBorder = this.gameWidth - 120 >> 1;
            this.itemX = this.colBorder + 99;
            this.itemY = this.rowBorder + 88;
            this.availBG = true;
        }
        this.invSquareSize = 16;
        byte by = (byte)(this.availBG ? 2 : 0);
        byte by2 = (byte)(this.availBG ? 0 : 18);
        byte by3 = (byte)(this.availBG ? 0 : 12);
        int n = 0;
        while (n < 4) {
            this.invSquareXY[n << 1][0] = this.colBorder + 4;
            this.invSquareXY[n << 1][1] = this.rowBorder + by + by + (this.invSquareSize + by) * n;
            this.invSquareXY[(n << 1) + 1][0] = this.colBorder + 4 + (this.invSquareSize + by);
            this.invSquareXY[(n << 1) + 1][1] = this.rowBorder + by + by + (this.invSquareSize + by) * n;
            this.invSquareXY[(n << 1) + 8][0] = this.colBorder + 10 + (this.invSquareSize + by << 1);
            this.invSquareXY[(n << 1) + 8][1] = this.rowBorder + by + by + (this.invSquareSize + by) * n;
            this.invSquareXY[(n << 1) + 9][0] = this.availBG ? 68 : 62;
            int[] nArray = this.invSquareXY[(n << 1) + 9];
            nArray[0] = nArray[0] + (this.colBorder + (this.invSquareSize + by));
            this.invSquareXY[(n << 1) + 9][1] = this.rowBorder + by + by + (this.invSquareSize + by) * n;
            ++n;
        }
        if (!this.availBG) {
            this.rowBorder = -5;
        }
        this.init(true, false);
    }

    void init(boolean bl, boolean bl2) {
        GameEffects gameEffects = this.gameEffects;
        GameEffects.soundOn = this.midlet.soundOn;
        this.animationThread = null;
        this.isGameOver = false;
        this.isPaused = false;
        this.hasBeenShown = false;
        this.status = 1;
        this.ticks = 0;
        this.gameEffects.lightsOn();
        int n = 0;
        while (n < this.options.length) {
            this.options[n] = false;
            ++n;
        }
        this.options[1] = true;
        this.options[4] = true;
        this.options[7] = true;
        StringBuffer stringBuffer = new StringBuffer("DUNS");
        this.options[0] = Settings.getValue(Settings.GM_CONT, stringBuffer);
        this.options[2] = Settings.getValue(Settings.GM_LOAD, stringBuffer);
        GameEffects gameEffects2 = this.gameEffects;
        GameEffects.soundOn = Settings.getValue(Settings.GM_SOUND, stringBuffer);
        GameEffects gameEffects3 = this.gameEffects;
        this.options[5] = GameEffects.soundOn;
        GameEffects gameEffects4 = this.gameEffects;
        this.options[6] = !GameEffects.soundOn;
        this.option = this.options[0] ? 0 : 1;
        this.bLoadQuik = bl2;
        this.bLoadGame = !bl;
        this.gameActionCount = 0;
        this.gameActionCurrent = 0;
    }

    void setupView() {
        byte by = (byte)(this.gameLevel + 1 >> 1);
        if (this.view == null) {
            int n = 120;
            int n2 = 80;
            if (this.gameHeight == 65) {
                n = 96;
                n2 = 70;
            }
            this.view = new View(this, n, n2, this.colBorder, this.rowBorder);
            this.view.initTile();
            this.invgfx = this.gameEffects.getGfx("/i.png");
            this.inv2gfx = this.gameEffects.getGfx("/i2.png");
            this.bggfx = this.gameEffects.getGfx("/b.png");
            int n3 = 0;
            Image image = this.gameEffects.getGfx("/1.png");
            View view = this.view;
            View view2 = this.view;
            int[] nArray = new int[4096];
            View view3 = this.view;
            this.view.convertImage(0, image, nArray, 0);
            image = null;
            if (this.gameLevel <= 3) {
                image = this.gameEffects.getGfx("/1.png");
            } else {
                image = this.gameEffects.getGfx("/2.png");
                n3 = 1;
                this.view.bigMon = true;
            }
            int n4 = 1;
            while (n4 < 4) {
                View view4 = this.view;
                this.view.convertImage(n4, image, nArray, n4 - n3 << 6);
                ++n4;
            }
            this.view.setColorDepth();
            this.view.init();
        }
        this.view.initLevel(by);
    }

    public void changeCont(int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("DUNS");
        this.option = n;
        this.options[0] = bl;
        try {
            Settings.setValue(Settings.GM_CONT, bl, stringBuffer);
        }
        catch (RecordStoreException recordStoreException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Thread thread = Thread.currentThread();
        try {
            while (true) {
                Runnable runnable;
                long l;
                if (thread != this.animationThread) {
                    return;
                }
                long l2 = System.currentTimeMillis();
                if (this.isShown()) {
                    this.input();
                    if (!this.isPaused) {
                        this.tick();
                    }
                    this.draw();
                    this.flushGraphics();
                }
                if ((l = System.currentTimeMillis() - l2) < 200L) {
                    runnable = this;
                    synchronized (runnable) {
                        this.wait(200L - l);
                        continue;
                    }
                }
                runnable = thread;
                Thread.yield();
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public void input() {
        int n;
        int n2 = this.getKeyStates();
        if (!((n2 & 4) == 0 || this.isPaused && this.isShown())) {
            if (!this.bLeftHeld) {
                this.gameAction[++this.gameActionCount & 0x1F] = 3;
            }
            this.bLeftHeld = true;
        } else {
            this.bLeftHeld = false;
        }
        if (!((n2 & 0x20) == 0 || this.isPaused && this.isShown())) {
            if (!this.bRightHeld) {
                this.gameAction[++this.gameActionCount & 0x1F] = 4;
            }
            this.bRightHeld = true;
        } else {
            this.bRightHeld = false;
        }
        if ((n2 & 2) != 0) {
            if (this.isPaused && this.isShown()) {
                --this.option;
                n = 0;
                while (n < this.options.length) {
                    if (this.option < 0) {
                        this.option = this.options.length - 1;
                    }
                    if (this.option >= this.options.length) {
                        this.option = 0;
                    }
                    if (!this.options[this.option]) {
                        --this.option;
                        ++n;
                        continue;
                    }
                    break;
                }
            } else {
                if (!this.bUpHeld || this.status == 2) {
                    this.gameAction[++this.gameActionCount & 0x1F] = 1;
                }
                this.bUpHeld = true;
            }
        } else {
            this.bUpHeld = false;
        }
        if ((n2 & 0x40) != 0) {
            if (this.isPaused && this.isShown()) {
                ++this.option;
                n = 0;
                while (n < this.options.length) {
                    if (this.option < 0) {
                        this.option = this.options.length - 1;
                    }
                    if (this.option >= this.options.length) {
                        this.option = 0;
                    }
                    if (!this.options[this.option]) {
                        ++this.option;
                        ++n;
                        continue;
                    }
                    break;
                }
            } else {
                if (!this.bDownHeld || this.status == 2) {
                    this.gameAction[++this.gameActionCount & 0x1F] = 2;
                }
                this.bDownHeld = true;
            }
        } else {
            this.bDownHeld = false;
        }
        if ((n2 & 0x100) != 0) {
            if (!this.bFireHeld) {
                this.gameAction[++this.gameActionCount & 0x1F] = 5;
            }
            this.bFireHeld = true;
        } else {
            this.bFireHeld = false;
        }
        if (!((n2 & 0x200) == 0 || this.isPaused && this.isShown())) {
            if (!this.bAHeld) {
                this.gameAction[++this.gameActionCount & 0x1F] = 6;
            }
            this.bAHeld = true;
        } else {
            this.bAHeld = false;
        }
        if (!((n2 & 0x400) == 0 || this.isPaused && this.isShown())) {
            if (!this.bBHeld) {
                this.gameAction[++this.gameActionCount & 0x1F] = 7;
            }
            this.bBHeld = true;
        } else {
            this.bBHeld = false;
        }
        if (!((n2 & 0x800) == 0 || this.isPaused && this.isShown())) {
            if (!this.bCHeld) {
                if (this.status == 2) {
                    this.itemSelect = -1;
                    this.itemCurrent = 0;
                    this.status = 3;
                } else if (this.status == 3) {
                    this.status = 7;
                    this.ticks = 0;
                    this.gameActionCount = this.gameActionCurrent;
                } else if (this.status == 7) {
                    this.status = 2;
                    this.ticks = 0;
                    this.gameActionCount = this.gameActionCurrent;
                }
            }
            this.bCHeld = true;
        } else {
            this.bCHeld = false;
        }
        this.gameActionCount &= 0x1F;
    }

    public synchronized void start() {
        this.animationThread = new Thread(this);
        this.animationThread.start();
    }

    public synchronized void stop() {
        this.animationThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        GameManager gameManager = this;
        synchronized (gameManager) {
            this.isPaused = true;
        }
        this.gameEffects.resume();
    }

    public synchronized boolean isPaused() {
        return this.isPaused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        GameManager gameManager = this;
        synchronized (gameManager) {
            this.isPaused = false;
        }
        this.gameEffects.pause();
    }

    public void keyPressed(int n) {
        if (n < 0) {
            this.stop();
            this.midlet.hordeCanvasMenu(this.options[0], this.status != 0 && this.status != 1 && this.status != 4);
        }
    }

    public void manHit(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            n2 = this.calcHit(n2, n4, this.iDef, 10, false, true);
        }
        this.HP -= n2;
        this.showHP = true;
        if (this.HP < 0) {
            this.HP = 0;
            this.changeCont(1, false);
            this.options[3] = false;
            this.status = 4;
            this.ticks = 0;
        }
        n = n - this.direction & 3;
        switch (n) {
            case 0: {
                this.showBlood[2][0] = n2;
                this.showBlood[2][1] = n3;
                break;
            }
            case 1: {
                this.showBlood[3][0] = n2;
                this.showBlood[3][1] = n3;
                break;
            }
            case 2: {
                this.showBlood[0][0] = n2;
                this.showBlood[0][1] = n3;
                break;
            }
            case 3: {
                this.showBlood[1][0] = n2;
                this.showBlood[1][1] = n3;
            }
        }
        if (n2 > 0) {
            this.gameEffects.playHit();
        }
    }

    public int calcHit(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = !bl || this.view.scrolls[2] <= 0 ? 0 : n - n3 >> 1;
        n = Util.getRandomInt(n5, n - (n3 = !bl2 || this.view.scrolls[1] <= 0 ? n3 : n3 + (n3 >> 1)) + n5);
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    String fromUTF8(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            block5: {
                int n4;
                block3: {
                    block4: {
                        n4 = byArray[n3] & 0xFF;
                        if (n4 < 128) break block3;
                        if (n4 >= 224) break block4;
                        n4 = (n4 & 0x1F) << 6;
                        n4 |= byArray[++n3] & 0x3F;
                        break block3;
                    }
                    n4 = (n4 & 0xF) << 12;
                    n4 |= (byArray[++n3] & 0x3F) << 6;
                    if ((n4 |= byArray[++n3] & 0x3F) == 65279) break block5;
                }
                cArray[n2++] = (char)n4;
            }
            ++n3;
        }
        return new String(cArray, 0, n2);
    }

    private void tick() {
        switch (this.status) {
            default: {
                break;
            }
            case 0: {
                this.stop();
                this.options[0] = false;
                this.midlet.hordeCanvasMenu(false, false);
                break;
            }
            case 1: {
                this.view = null;
                this.menugfx = null;
                this.gameLevel = 1;
                int n = 0;
                while (n < 16) {
                    this.invItem[n] = 0;
                    ++n;
                }
                this.HP = 32;
                this.maxHP = 63;
                this.iDex = 10;
                this.iDef = 5;
                this.iAtt = 6;
                this.status = 5;
                this.gameActionCount = 0;
                this.gameActionCurrent = 0;
                this.ticks = 0;
                this.options[0] = true;
                break;
            }
            case 5: {
                if (!(this.ticks >= 50 && !this.bShowStory || this.bLoadQuik || this.bLoadGame)) {
                    if (this.ticks == 0) {
                        this.bStory = new byte[512];
                        this.bShowStory = true;
                        ++this.ticks;
                        try {
                            this.showItem = true;
                            DataInputStream dataInputStream = new DataInputStream(this.getClass().getResourceAsStream(String.valueOf(String.valueOf(new StringBuffer("/").append(this.gameLevel).append(".txt")))));
                            dataInputStream.readFully(this.bStory);
                            dataInputStream.close();
                        }
                        catch (EOFException eOFException) {
                        }
                        catch (Exception exception) {
                            this.ticks = this.gameHeight << 2;
                            this.bShowStory = false;
                            this.showItem = false;
                        }
                        this.storyStr = this.fromUTF8(this.bStory);
                        break;
                    }
                    if (this.gameActionCount == this.gameActionCurrent) break;
                    ++this.gameActionCurrent;
                    this.gameActionCurrent &= 0x1F;
                    if (this.gameAction[this.gameActionCurrent] == 1) {
                        --this.ticks;
                        if (this.ticks < 1) {
                            this.ticks = 1;
                        }
                        this.showItem = true;
                    }
                    if (this.gameAction[this.gameActionCurrent] == 2 && !this.bEnd) {
                        ++this.ticks;
                        this.showItem = true;
                    }
                    if (this.gameAction[this.gameActionCurrent] != 5) break;
                    this.ticks = 50;
                    this.bShowStory = false;
                    break;
                }
                if (this.gameLevel == 6) {
                    this.gameActionCurrent = this.gameActionCount;
                    this.LevelText = null;
                    this.status = 0;
                    this.ticks = 0;
                    break;
                }
                if (this.bLoadQuik || this.bLoadGame) {
                    Settings.getGame(this.bLoadQuik, this, null, false);
                }
                this.bStory = null;
                this.setupView();
                int n = 0;
                while (n < 4) {
                    this.showBlood[n][0] = 0;
                    this.showBlood[n][1] = 0;
                    ++n;
                }
                if ((this.bLoadQuik || this.bLoadGame) && this.status != 6) {
                    Settings.getGame(this.bLoadQuik, this, this.view, true);
                } else {
                    if (this.gameLevel != 1 || this.status == 6) {
                        int n2 = 0;
                        while (n2 < 16) {
                            if (this.invItem[n2] != 0) {
                                View view = this.view;
                                this.view.itemType[32 + n2] = this.invItem[n2];
                                View view2 = this.view;
                                this.view.itemX[32 + n2] = 65;
                                View view3 = this.view;
                                this.invItem[n2] = (byte)(32 + n2 + 1);
                            }
                            ++n2;
                        }
                    }
                    this.iHit = -1;
                    this.iRecovery = 0;
                }
                this.view.createMap((this.bLoadQuik || this.bLoadGame) && this.status != 6);
                this.bLoadQuik = false;
                this.bLoadGame = false;
                this.itemCurrent = 0;
                this.itemSelect = -1;
                this.gameActionCount = 0;
                this.gameActionCurrent = 0;
                this.redrawBG = this.availBG;
                this.showHP = true;
                this.showText = 0;
                this.textTimer = 0;
                this.showItem = false;
                this.compassDirec = this.direction + 1 & 3;
                this.options[3] = true;
                this.LevelText = null;
                this.status = 2;
                break;
            }
            case 6: {
                ++this.ticks;
                if (this.ticks > 30 || this.gameActionCurrent != this.gameActionCount && this.ticks > 20) {
                    this.gameLevel = (byte)(this.gameLevel + 1);
                    this.view = null;
                    this.status = 5;
                    this.gameActionCount = 0;
                    this.gameActionCurrent = 0;
                    this.ticks = 0;
                    break;
                }
                this.gameActionCurrent = this.gameActionCount;
                break;
            }
            case 2: {
                int n;
                int n3 = this.xMap;
                int n4 = this.yMap;
                int n5 = this.xMap;
                int n6 = this.yMap;
                if (this.iRecovery > 0) {
                    --this.iRecovery;
                }
                if (this.gameActionCurrent != this.gameActionCount) {
                    ++this.gameActionCurrent;
                    this.gameActionCurrent &= 0x1F;
                    if (this.gameAction[this.gameActionCurrent] == 1) {
                        if (this.direction == 0) {
                            --n6;
                        } else if (this.direction == 1) {
                            ++n5;
                        } else if (this.direction == 2) {
                            ++n6;
                        } else if (this.direction == 3) {
                            --n5;
                        }
                    }
                    if (this.gameAction[this.gameActionCurrent] == 2) {
                        if (this.direction == 0) {
                            ++n6;
                        } else if (this.direction == 1) {
                            --n5;
                        } else if (this.direction == 2) {
                            --n6;
                        } else if (this.direction == 3) {
                            ++n5;
                        }
                    }
                    if (this.gameAction[this.gameActionCurrent] == 6) {
                        if (this.direction == 0) {
                            --n5;
                        } else if (this.direction == 1) {
                            --n6;
                        } else if (this.direction == 2) {
                            ++n5;
                        } else if (this.direction == 3) {
                            ++n6;
                        }
                    }
                    if (this.gameAction[this.gameActionCurrent] == 7) {
                        if (this.direction == 0) {
                            ++n5;
                        } else if (this.direction == 1) {
                            ++n6;
                        } else if (this.direction == 2) {
                            --n5;
                        } else if (this.direction == 3) {
                            --n6;
                        }
                    }
                    if (!(this.xMap == n5 && this.yMap == n6 || this.view.moveCollision(n5, n6))) {
                        this.xMap = n5;
                        this.yMap = n6;
                        this.showText = 0;
                    }
                    if (this.gameAction[this.gameActionCurrent] == 3) {
                        --this.direction;
                        if (this.direction < 0) {
                            this.direction = 3;
                        }
                        this.showText = 0;
                    }
                    if (this.gameAction[this.gameActionCurrent] == 4) {
                        ++this.direction;
                        if (this.direction > 3) {
                            this.direction = 0;
                        }
                        this.showText = 0;
                    }
                    if (this.gameAction[this.gameActionCurrent] == 5) {
                        n = this.xMap;
                        int n7 = this.yMap;
                        if (this.direction == 0) {
                            --n7;
                        } else if (this.direction == 1) {
                            ++n;
                        } else if (this.direction == 2) {
                            ++n7;
                        } else if (this.direction == 3) {
                            --n;
                        }
                        int n8 = this.iRecovery != 0 ? 0 : this.view.attackMon(n, n7, this.iAtt, this.iDex);
                        if (n8 == -1) {
                            if (!this.view.doorOpenClose(n, n7)) {
                                this.showText = this.view.checkSpecial(this.xMap, this.yMap);
                                if (this.showText != 0) {
                                    this.textTimer = 30;
                                }
                                this.showItem = (this.view.mapItem[this.xMap][this.yMap] & 1) != 0;
                            }
                        } else if (this.iRecovery <= 0) {
                            this.iHit = n8;
                            this.iRecovery = this.iDex;
                            this.gameEffects.playSwoosh();
                        }
                    }
                }
                if (this.xMap == this.xEnd && this.yMap == this.yEnd) {
                    this.options[3] = false;
                    this.status = 6;
                    n = 0;
                    while (n < 16) {
                        if (this.invItem[n] != 0) {
                            this.invItem[n] = this.view.itemType[this.invItem[n] - 1];
                        }
                        if (this.invItem[n] == 49) {
                            this.invItem[n] = 0;
                        }
                        ++n;
                    }
                    Settings.storeGame(true, this, this.view);
                    this.ticks = 0;
                    break;
                }
                if (this.xMap != n3 | this.yMap != n4) {
                    this.view.checkMap(n3, n4, false);
                    this.showItem = this.view.checkMap(this.xMap, this.yMap, true);
                }
                this.view.doorUpdate();
                this.view.lineOfSite(this.xMap, this.yMap, this.direction);
                this.view.ai();
                break;
            }
            case 3: {
                if (this.gameActionCurrent == this.gameActionCount) break;
                ++this.gameActionCurrent;
                this.gameActionCurrent &= 0x1F;
                if (this.gameAction[this.gameActionCurrent] == 1) {
                    this.itemCurrent = this.itemCurrent == 0 || this.itemCurrent == 1 || this.itemCurrent == 8 || this.itemCurrent == 9 ? (this.itemCurrent += 6) : (this.itemCurrent -= 2);
                }
                if (this.gameAction[this.gameActionCurrent] == 2) {
                    this.itemCurrent = this.itemCurrent == 6 || this.itemCurrent == 7 || this.itemCurrent == 14 || this.itemCurrent == 15 ? (this.itemCurrent -= 6) : (this.itemCurrent += 2);
                }
                if (this.gameAction[this.gameActionCurrent] == 3) {
                    this.itemCurrent = (this.itemCurrent & 9) == 0 ? (this.itemCurrent += 9) : ((this.itemCurrent & 9) == 8 ? (this.itemCurrent -= 7) : --this.itemCurrent);
                }
                if (this.gameAction[this.gameActionCurrent] == 4) {
                    this.itemCurrent = (this.itemCurrent & 9) == 1 ? (this.itemCurrent += 7) : ((this.itemCurrent & 9) == 9 ? (this.itemCurrent -= 9) : ++this.itemCurrent);
                }
                if (this.gameAction[this.gameActionCurrent] != 5) break;
                if (this.itemSelect == -1) {
                    if (this.itemCurrent == 9) break;
                    this.itemSelect = this.itemCurrent;
                    break;
                }
                if (this.itemSelect == this.itemCurrent) {
                    if (this.itemCurrent == 12) {
                        this.showHand = true;
                    }
                    if (this.invItem[this.itemCurrent] == 0) {
                        this.itemSelect = -1;
                        break;
                    }
                    this.view.dropItem(this.xMap, this.yMap, this.invItem[this.itemCurrent] - 1, true);
                    this.showItem = true;
                    this.invItem[this.itemCurrent] = 0;
                    this.itemSelect = -1;
                    break;
                }
                if (this.itemCurrent == 12 || this.itemSelect == 12) {
                    this.showHand = true;
                }
                int n = this.invItem[this.itemSelect] != 0 ? this.view.itemType[this.invItem[this.itemSelect] - 1] - 1 >> 3 : -1;
                int n9 = this.invItem[this.itemCurrent] != 0 ? this.view.itemType[this.invItem[this.itemCurrent] - 1] - 1 >> 3 : -1;
                boolean bl = true;
                if (this.itemCurrent >= 8 || this.itemSelect >= 8) {
                    if (n == 0 && this.itemCurrent != 8 && this.itemCurrent >= 8 || n9 == 0 && this.itemSelect != 8 && this.itemSelect >= 8) {
                        bl = false;
                    }
                    if (n == 1 && this.itemCurrent != 12 && this.itemCurrent >= 8 || n9 == 1 && this.itemSelect != 12 && this.itemSelect >= 8) {
                        bl = false;
                    }
                    if (n == 2 && this.itemCurrent != 11 && this.itemCurrent >= 8 || n9 == 2 && this.itemSelect != 11 && this.itemSelect >= 8) {
                        bl = false;
                    }
                    if (n == 3 && this.itemCurrent != 10 && this.itemCurrent >= 8 || n9 == 3 && this.itemSelect != 10 && this.itemSelect >= 8) {
                        bl = false;
                    }
                    if (n == 4 && this.itemCurrent != 13 && this.itemCurrent != 14 && this.itemCurrent >= 8 || n9 == 4 && this.itemSelect != 13 && this.itemSelect != 14 && this.itemSelect >= 8) {
                        bl = false;
                    }
                    if (n == 5 && this.itemCurrent != 9 && this.itemCurrent >= 8 || n9 == 5 && this.itemSelect != 9 && this.itemSelect >= 8) {
                        bl = false;
                    }
                    if (n == 6 || n9 == 6) {
                        bl = false;
                    }
                    if (n == 7 && this.itemCurrent != 15 && this.itemCurrent >= 8 || n9 == 7 && this.itemSelect != 15 && this.itemSelect >= 8) {
                        bl = false;
                    }
                    if (n == 8 && this.itemCurrent != 12 && this.itemCurrent >= 8 || n9 == 8 && this.itemSelect != 12 && this.itemSelect >= 8) {
                        bl = false;
                    }
                }
                if (!bl) break;
                if (this.itemCurrent == 9 && n == 5) {
                    if (this.HP < this.maxHP) {
                        this.invItem[this.itemSelect] = 0;
                        this.HP += 10;
                        if (this.HP > this.maxHP) {
                            this.HP = this.maxHP;
                        }
                        this.showHP = true;
                    }
                } else {
                    int n10;
                    int n11;
                    if (n >= 0 && this.itemCurrent >= 8 && this.itemSelect < 8 || n9 >= 0 && this.itemSelect >= 8 && this.itemCurrent < 8) {
                        n11 = this.itemCurrent < 8 ? this.view.itemType[this.invItem[this.itemCurrent] - 1] - 1 & 7 : this.view.itemType[this.invItem[this.itemSelect] - 1] - 1 & 7;
                        int n12 = n10 = this.itemCurrent < 8 ? n9 : n;
                        if (n10 == 0 || n10 == 7) {
                            this.iDef += this.view.helmet[n11 + n11];
                            this.iDex -= this.view.helmet[n11 + n11 + 1];
                        } else if (n10 == 1) {
                            this.iAtt += this.view.sword[n11 + n11];
                            this.iDex -= this.view.sword[n11 + n11 + 1];
                        } else if (n10 == 2 || n10 == 3) {
                            this.iDef += this.view.sword[n11 + n11];
                            this.iDex -= this.view.sword[n11 + n11 + 1];
                        } else if (n10 == 4) {
                            this.iAtt += this.view.ring[n11 + n11 + n11];
                            this.iDef += this.view.ring[n11 + n11 + n11 + 1];
                            this.iDex -= this.view.ring[n11 + n11 + n11 + 2];
                        }
                    }
                    if (n >= 0 && this.itemSelect >= 8 && this.itemCurrent < 8 || n9 >= 0 && this.itemCurrent >= 8 && this.itemSelect < 8) {
                        n11 = this.itemSelect < 8 ? this.view.itemType[this.invItem[this.itemCurrent] - 1] - 1 & 7 : this.view.itemType[this.invItem[this.itemSelect] - 1] - 1 & 7;
                        int n13 = n10 = this.itemSelect < 8 ? n9 : n;
                        if (n10 == 0 || n10 == 7) {
                            this.iDef -= this.view.helmet[n11 + n11];
                            this.iDex += this.view.helmet[n11 + n11 + 1];
                        } else if (n10 == 1) {
                            this.iAtt -= this.view.sword[n11 + n11];
                            this.iDex += this.view.sword[n11 + n11 + 1];
                        } else if (n10 == 2 || n10 == 3) {
                            this.iDef -= this.view.sword[n11 + n11];
                            this.iDex += this.view.sword[n11 + n11 + 1];
                        } else if (n10 == 4) {
                            this.iAtt -= this.view.ring[n11 + n11 + n11];
                            this.iDef -= this.view.ring[n11 + n11 + n11 + 1];
                            this.iDex += this.view.ring[n11 + n11 + n11 + 2];
                        }
                    }
                    n11 = this.invItem[this.itemCurrent];
                    this.invItem[this.itemCurrent] = this.invItem[this.itemSelect];
                    this.invItem[this.itemSelect] = (byte)n11;
                }
                this.itemSelect = -1;
                break;
            }
            case 7: {
                ++this.ticks;
                if (this.ticks != 258) break;
                this.ticks = 2;
                break;
            }
            case 4: {
                int n = 0;
                while (n < this.view.xSize / 5) {
                    this.view.itemType[n] = this.ticks >= 8 ? (byte)(this.view.itemType[n] + Util.getRandomInt(0, 2)) : (byte)0;
                    ++n;
                }
                ++this.ticks;
                if (this.ticks < 60) break;
                this.gameActionCurrent = this.gameActionCount;
                this.status = 0;
                this.ticks = 0;
            }
        }
    }

    public void draw() {
        Object object;
        int n;
        Graphics graphics;
        block96: {
            block97: {
                int n2;
                block98: {
                    View view;
                    Object object2;
                    int n3;
                    graphics = this.getGraphics();
                    graphics.setFont(GAME_FONT);
                    if (this.status == 1 || this.status == 0) {
                        graphics.setClip(0, 0, this.gameWidth, this.gameHeight);
                        graphics.setColor(0, 0, 0);
                    }
                    if (this.isPaused && !this.redrawAll) break block96;
                    if (this.status == 6) {
                        graphics.setClip(0, 0, this.gameWidth, this.gameHeight);
                        graphics.setColor(0, 0, 0);
                        if (this.ticks <= 8) {
                            n3 = 0;
                            while (n3 < this.view.xSize >> 3) {
                                if (this.ticks + (n3 << 3) < this.view.xSize) {
                                    graphics.drawLine(this.colBorder + this.ticks + (n3 << 3), this.rowBorder, this.colBorder + this.ticks + (n3 << 3), this.rowBorder + this.view.ySize - 1);
                                }
                                ++n3;
                            }
                        } else {
                            n3 = 0;
                            n = 0;
                            while (n < this.view.totSecret) {
                                if (this.view.secretFound[n] == 1) {
                                    ++n3;
                                }
                                ++n;
                            }
                            StringBuffer stringBuffer = new StringBuffer("");
                            stringBuffer.append(n3);
                            Dictionary dictionary = this.dict;
                            stringBuffer.append(this.dict.getString(Dictionary.OF));
                            stringBuffer.append(this.view.totSecret);
                            this.drawSmallText(graphics, this.gameWidth >> 1, this.rowBorder + (this.view.ySize >> 1) - (fontHeight << 1), stringBuffer, 0);
                            stringBuffer = null;
                            object2 = this.dict;
                            stringBuffer = new StringBuffer(this.dict.getString(Dictionary.SECRETS_FOUND));
                            this.drawSmallText(graphics, this.gameWidth >> 1, this.rowBorder + (this.view.ySize >> 1) - fontHeight, stringBuffer, 0);
                            stringBuffer = null;
                            object = this.dict;
                            stringBuffer = new StringBuffer(this.dict.getString(Dictionary.LEVEL_COMPLETE));
                            this.drawSmallText(graphics, this.gameWidth >> 1, this.rowBorder + (this.view.ySize >> 1) + fontHeight, stringBuffer, 0);
                        }
                    } else if (this.status == 5 && this.ticks != 0) {
                        if (this.showItem) {
                            graphics.setClip(0, 0, this.gameWidth, this.gameHeight);
                            graphics.setColor(0, 0, 0);
                            graphics.fillRect(0, 0, this.gameWidth, this.gameHeight);
                            graphics.setColor(255, 255, 255);
                        }
                        if (!this.isPaused && this.showItem) {
                            if (this.bStory == null) {
                                return;
                            }
                            n3 = 2;
                            n = fontHeight - fontHeight * this.ticks;
                            int n4 = n3;
                            int n5 = n;
                            int n6 = 0;
                            int n7 = 0;
                            while (n6 < this.storyStr.length()) {
                                if (this.storyStr.charAt(n6) == ' ' || this.storyStr.charAt(n6) == '\n') {
                                    if (n4 + GAME_FONT.stringWidth(this.storyStr.substring(n7, n6)) > this.gameWidth - 4) {
                                        n4 = n3;
                                        if ((n5 += fontHeight) > this.gameHeight) break;
                                        if (this.storyStr.charAt(n7) == ' ' && n7 < n6) {
                                            ++n7;
                                        }
                                    }
                                    graphics.drawString(this.storyStr.substring(n7, n6), n4, n5, 20);
                                    if (this.storyStr.charAt(n6) == ' ' && (n4 += GAME_FONT.stringWidth(this.storyStr.substring(n7, n6))) == n3) {
                                        ++n6;
                                    }
                                    if (this.storyStr.charAt(n6) == '\n') {
                                        n4 = n3;
                                        if ((n5 += fontHeight) > this.gameHeight) break;
                                    }
                                    n7 = ++n6;
                                }
                                ++n6;
                            }
                            this.bEnd = false;
                            if (n5 <= this.gameHeight - fontHeight) {
                                this.bEnd = true;
                            }
                            this.showItem = false;
                        }
                    } else if (this.status == 2 || this.status == 4 && this.ticks == 0 || this.status == 7 && this.ticks == 1) {
                        int n8;
                        if (this.redrawBG) {
                            this.drawBackground(graphics);
                        }
                        this.view.getMap(this.direction, this.xMap, this.yMap);
                        graphics.setClip(0, 0, this.gameWidth, this.gameHeight);
                        this.view.floorToView();
                        this.view.getRayCast();
                        this.view.doRayCast();
                        this.view.getObjectMap(this.direction);
                        this.view.showView(graphics);
                        if (this.showItem) {
                            graphics.setClip(this.itemX, this.itemY, 16, 11);
                            graphics.drawImage(this.invgfx, this.itemX - 16, this.itemY - 85, 20);
                            this.clearItem = true;
                        } else if (this.clearItem) {
                            if (this.availBG) {
                                graphics.setClip(this.itemX, this.itemY, 16, 11);
                                graphics.drawImage(this.bggfx, this.colBorder, this.view.ySize + this.rowBorder + 2, 20);
                            }
                            this.clearItem = false;
                        }
                        if (this.iRecovery > 0) {
                            n3 = this.gameWidth - 16 >> 1;
                            n8 = (this.view.ySize - 16 >> 1) + this.view.yLoc;
                            graphics.setClip(n3, n8, 16, 16);
                            graphics.drawImage(this.invgfx, n3 - 32, n8 - 80, 20);
                            StringBuffer stringBuffer = new StringBuffer("");
                            stringBuffer.append(this.iHit);
                            graphics.setClip(n3 - 8, n8 - 9, 32, 32);
                            graphics.setColor(255, 255, 255);
                            graphics.drawString(stringBuffer.toString(), n3 + 8, n8 + 9 - (fontHeight >> 1), 17);
                        }
                        if (this.compassDirec != this.direction) {
                            this.compassDirec = this.direction;
                            n3 = this.view.xLoc + 62;
                            n8 = this.view.yLoc + this.view.ySize + 11;
                            graphics.setClip(n3, n8, 11, 11);
                            graphics.drawImage(this.bggfx, n3 -= this.compassDirec * 11, n8 - 24, 20);
                        }
                        if (this.showText != 0) {
                            n3 = this.availBG ? this.view.yLoc + this.view.ySize - (fontHeight + 2) : this.gameHeight - 5;
                            StringBuffer stringBuffer = new StringBuffer("");
                            stringBuffer.append(this.dict.getString(this.showText));
                            this.drawSmallText(graphics, this.gameWidth >> 1, n3, stringBuffer, 0);
                            if (this.textTimer == 0) {
                                this.showText = 0;
                            } else {
                                --this.textTimer;
                            }
                        }
                        n3 = this.view.xLoc + this.view.xSize - 12;
                        n = this.colBorder + 2;
                        int n9 = 0;
                        while (n9 < this.view.scrolls.length) {
                            graphics.setClip(n3, n, 12, 12);
                            if (this.view.scrolls[n9] > 16 || (this.view.scrolls[n9] & 2) != 0) {
                                graphics.drawImage(this.invgfx, n3 - (n9 & 1) * 12, n - (72 + (n9 >> 1) * 12), 20);
                            }
                            if (this.view.scrolls[n9] != 0) {
                                int n10 = n9;
                                this.view.scrolls[n10] = (byte)(this.view.scrolls[n10] - 1);
                                n += 12;
                            }
                            ++n9;
                        }
                    } else if (this.status == 3) {
                        if (this.redrawBG) {
                            this.drawBackground(graphics);
                        }
                        this.view.showView(graphics);
                        this.drawInv(graphics);
                    } else if (this.status == 4 && this.ticks != 0) {
                        n3 = 0;
                        while (n3 <= this.view.xSize / 5) {
                            n = n3 * 5 + this.colBorder;
                            int n11 = n + 5;
                            int n12 = this.availBG ? this.view.itemType[n3] + this.rowBorder : this.view.itemType[n3];
                            int n13 = n12 - 5;
                            if (n13 < this.rowBorder) {
                                graphics.setClip(n, this.rowBorder, 5, n12 - this.rowBorder);
                            } else {
                                graphics.setClip(n, n13, 5, 5);
                            }
                            graphics.drawImage(this.invgfx, n - 36, n13 - 73, 20);
                            ++n3;
                        }
                    }
                    if (this.status == 3 || this.status == 2 || this.status == 4 && this.ticks == 0 || this.status == 7 && this.ticks == 1) {
                        if (this.showHand && this.availBG) {
                            this.drawHand(graphics);
                            this.showHand = false;
                        }
                        if (this.showHP || !this.availBG) {
                            if (this.availBG) {
                                n3 = this.view.xLoc + 2;
                                n = this.view.yLoc + this.view.ySize + 20;
                                graphics.setClip(n3, n, 32, 4);
                                if (this.HP > 0) {
                                    if (this.HP > 32) {
                                        graphics.setColor(0, 255, 0);
                                    } else if (this.HP > 16) {
                                        graphics.setColor(255, 255, 0);
                                    } else {
                                        graphics.setColor(255, 0, 0);
                                    }
                                    graphics.fillRect(n3, n, this.HP >> 2, 4);
                                }
                                if (this.HP < 64) {
                                    graphics.setColor(0, 0, 0);
                                    graphics.fillRect(n3 + (this.HP >> 2), n, 16 - (this.HP >> 2), 4);
                                }
                            } else if (this.status != 3) {
                                graphics.setClip(0, 16, 16, 2);
                                graphics.setColor(0, 0, 0);
                                graphics.fillRect(0, 16, 16, 2);
                                if (this.HP > 32) {
                                    graphics.setColor(0, 255, 0);
                                } else if (this.HP > 16) {
                                    graphics.setColor(255, 255, 0);
                                } else {
                                    graphics.setColor(255, 0, 0);
                                }
                                graphics.fillRect(0, 16, this.HP >> 2, 4);
                            }
                            this.showHP = false;
                        }
                        if (this.status != 3) {
                            n3 = 1;
                            n = 0;
                            while (n < 4) {
                                if (this.showBlood[n][1] > 0) {
                                    int n14 = this.availBG ? this.view.xLoc + 1 : 0;
                                    int n15 = this.availBG ? this.view.yLoc + this.view.ySize + 3 : 0;
                                    switch (n) {
                                        case 0: {
                                            n15 -= n3;
                                            break;
                                        }
                                        case 1: {
                                            n14 += n3;
                                            break;
                                        }
                                        case 2: {
                                            n15 += n3;
                                            break;
                                        }
                                        case 3: {
                                            n14 -= n3;
                                        }
                                    }
                                    graphics.setClip(n14, n15, 16, 16);
                                    if (this.showBlood[n][1] == 1) {
                                        if (this.availBG) {
                                            graphics.drawImage(this.bggfx, this.colBorder, this.view.ySize + this.rowBorder + 2, 20);
                                        }
                                    } else {
                                        graphics.drawImage(this.invgfx, n14 - 32, n15 - 80, 20);
                                        object2 = new StringBuffer("");
                                        ((StringBuffer)object2).append(this.showBlood[n][0]);
                                        graphics.setClip(n14 - 8, n15 - 9, 32, 32);
                                        graphics.setColor(255, 255, 255);
                                        graphics.drawString(((StringBuffer)object2).toString(), n14 + 8, n15 + 9 - (fontHeight >> 1), 17);
                                    }
                                    int[] nArray = this.showBlood[n];
                                    nArray[1] = nArray[1] - 1;
                                    if (n == 2 && this.showBlood[n][1] == 0) {
                                        this.showHP = true;
                                    }
                                }
                                ++n;
                            }
                        }
                    }
                    if (this.status != 7) break block97;
                    View view2 = this.view;
                    n = this.view.xLoc + (this.view.xSize - 64 >> 2) * 3;
                    View view3 = this.view;
                    n2 = this.view.yLoc + (this.view.ySize - 64 >> 1);
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    graphics.setClip(0, 0, this.gameWidth, this.gameHeight);
                    if (this.ticks != 1 && !this.redrawBG) break block98;
                    if (this.redrawBG) {
                        this.drawBackground(graphics);
                    }
                    graphics.setColor(0, 128, 54);
                    object2 = this.view;
                    object = this.view;
                    graphics.fillRect(n, n2, 64, 64);
                    int n16 = 0;
                    while (true) {
                        View view4 = this.view;
                        if (n16 > 8) break;
                        graphics.setColor(0, 160, 54);
                        view = this.view;
                        graphics.drawLine(n, n2 + (n16 << 3), n + 64, n2 + (n16 << 3));
                        View view5 = this.view;
                        graphics.drawLine(n + (n16 << 3), n2, n + (n16 << 3), n2 + 64);
                        ++n16;
                    }
                    int n17 = 0;
                    while (true) {
                        view = this.view;
                        if (n17 >= 32) break;
                        int n18 = 0;
                        while (true) {
                            block99: {
                                block102: {
                                    View view6;
                                    View view7;
                                    block104: {
                                        block103: {
                                            View view8;
                                            block101: {
                                                block100: {
                                                    View view9 = this.view;
                                                    if (n18 >= 32) break;
                                                    if ((this.view.mapItem[n18][n17] & 4) == 0) break block99;
                                                    View view10 = this.view;
                                                    byte by = this.view.mapOne[n18 + (n17 << 5)];
                                                    if ((by & 0x11) == 0) break block100;
                                                    if ((by & 0x11) == 17) {
                                                        graphics.setColor(255, 255, 255);
                                                    } else {
                                                        graphics.setColor(172, 211, 115);
                                                    }
                                                    graphics.fillRect(n18 + n18 + n, n17 + n17 + n2, 2, 2);
                                                    break block99;
                                                }
                                                if (n18 == 0) break block101;
                                                view8 = this.view;
                                                if (this.view.mapOne[n18 + (n17 << 5) - 1] != 0) break block102;
                                            }
                                            view8 = this.view;
                                            if (n18 == 31) break block103;
                                            view7 = this.view;
                                            if (this.view.mapOne[n18 + (n17 << 5) + 1] != 0) break block102;
                                        }
                                        if (n17 == 0) break block104;
                                        view7 = this.view;
                                        view6 = this.view;
                                        if (this.view.mapOne[n18 + (n17 << 5) - 32] != 0) break block102;
                                    }
                                    view7 = this.view;
                                    if (n17 == 31) break block99;
                                    view6 = this.view;
                                    View view11 = this.view;
                                    if (this.view.mapOne[n18 + (n17 << 5) + 32] == 0) break block99;
                                }
                                graphics.setColor(0, 0, 0);
                                graphics.fillRect(n18 + n18 + n, n17 + n17 + n2, 2, 2);
                            }
                            ++n18;
                        }
                        ++n17;
                    }
                }
                if ((this.ticks & 8) == 0) {
                    graphics.setColor(0, 0, 255);
                } else {
                    graphics.setColor(172, 211, 115);
                }
                graphics.fillRect(this.xMap + this.xMap + n, this.yMap + this.yMap + n2, 2, 2);
            }
            this.redrawAll = false;
        }
        if (this.isPaused) {
            int n19;
            int n20 = 0;
            n = 0;
            while (n < this.options.length) {
                if (this.options[n]) {
                    ++n20;
                }
                ++n;
            }
            int n21 = this.gameWidth >> 1;
            int n22 = n19 = this.view == null ? (this.gameHeight >> 1) - ((n20 - 2) * (fontHeight + 1) >> 1) : (this.view.ySize >> 1) - (n20 * (fontHeight + 1) >> 1);
            if (this.view != null && this.view.yLoc > 0) {
                n19 += this.view.yLoc;
            }
            graphics.setClip(0, 0, this.gameWidth, this.gameHeight);
            graphics.setColor(0, 0, 0);
            graphics.fillRect(n21 - 35, n19 - 3, 70, n20 * (fontHeight + 1) + 4);
            graphics.setColor(255, 255, 0);
            graphics.drawRect(n21 - 35, n19 - 3, 70, n20 * (fontHeight + 1) + 4);
            int n23 = 0;
            while (n23 < this.options.length) {
                object = this.dict;
                StringBuffer stringBuffer = new StringBuffer(this.dict.getString(Dictionary.MENU_0 + n23));
                if (this.options[n23]) {
                    if (this.option == n23) {
                        this.drawSmallText(graphics, n21, n19, stringBuffer, 1);
                        n19 += fontHeight + 1;
                    } else {
                        this.drawSmallText(graphics, n21, n19, stringBuffer, 0);
                        n19 += fontHeight + 1;
                    }
                }
                ++n23;
            }
        }
        graphics.setClip(0, 0, this.gameWidth, this.gameHeight);
    }

    void showOption(Graphics graphics, int n, int n2, StringBuffer stringBuffer) {
        graphics.setClip(0, 0, this.gameWidth, this.gameHeight);
        graphics.setColor(0, 0, 0);
        graphics.drawString(stringBuffer.toString(), n + 1, (n2 -= 2) + 1, 17);
        graphics.setColor(255, 255, 0);
        graphics.drawString(stringBuffer.toString(), n, n2, 17);
    }

    int drawSmallText(Graphics graphics, int n, int n2, StringBuffer stringBuffer, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (GAME_FONT.stringWidth(stringBuffer.toString()) > this.gameWidth - (this.colBorder << 1)) {
            n6 = 1;
            while (n5 < stringBuffer.length()) {
                if (stringBuffer.charAt(n5) != ' ') {
                    ++n5;
                    continue;
                }
                break;
            }
        } else {
            n5 = stringBuffer.length();
        }
        graphics.setClip(0, 0, this.gameWidth, this.gameHeight);
        int n7 = 0;
        while (n7 <= n6) {
            graphics.setColor(0, 0, 0);
            if (n7 == 0) {
                graphics.drawString(stringBuffer.toString().substring(n4, n5), n + 1, n2 + 1, 17);
            } else {
                graphics.drawString(stringBuffer.toString().substring(n5, stringBuffer.length()), n + 1, n2 + 1, 17);
            }
            switch (n3) {
                case 0: {
                    graphics.setColor(255, 255, 255);
                    break;
                }
                case 1: {
                    graphics.setColor(255, 255, 0);
                    break;
                }
                case 2: {
                    graphics.setColor(0, 255, 255);
                }
            }
            if (n7 == 0) {
                graphics.drawString(stringBuffer.toString().substring(n4, n5), n, n2, 17);
            } else {
                graphics.drawString(stringBuffer.toString().substring(n5, stringBuffer.length()), n, n2, 17);
            }
            n2 += fontHeight + 1;
            ++n7;
        }
        return n6 * (fontHeight + 1);
    }

    void drawBackground(Graphics graphics) {
        graphics.setClip(0, 0, this.gameWidth, this.gameHeight);
        graphics.setColor(0, 0, 0);
        graphics.fillRect(0, 0, this.gameWidth, this.gameHeight);
        graphics.setClip(0, this.view.ySize + this.rowBorder + 2, this.gameWidth, 24);
        if (this.availBG) {
            graphics.drawImage(this.bggfx, this.colBorder, this.view.ySize + this.rowBorder + 2, 20);
            this.drawHand(graphics);
        }
        this.redrawBG = false;
    }

    void drawHand(Graphics graphics) {
        if (this.view == null) {
            return;
        }
        int n = this.colBorder + 19;
        int n2 = this.view.ySize + this.rowBorder + 4;
        graphics.setClip(n, n2, this.invSquareSize, this.invSquareSize);
        graphics.drawImage(this.bggfx, this.colBorder, this.view.ySize + this.rowBorder + 2, 20);
        if (this.invItem[12] != 0) {
            int n3 = this.view.itemType[this.invItem[12] - 1] - 1 >> 3;
            graphics.drawImage(this.invgfx, n - this.invSquareSize - (n3 & 1) * this.invSquareSize, n2 - (n3 >> 1) * this.invSquareSize, 20);
        } else {
            graphics.drawImage(this.invgfx, n, n2 - 2 * this.invSquareSize, 20);
        }
    }

    void drawInv(Graphics graphics) {
        int n;
        int n2;
        int n3 = 0;
        while (n3 < 16) {
            n2 = this.invSquareXY[n3][0];
            n = this.invSquareXY[n3][1];
            graphics.setClip(n2, n, this.invSquareSize, this.invSquareSize);
            if (this.itemSelect == n3) {
                graphics.drawImage(this.invgfx, n2, n - this.invSquareSize, 20);
            } else {
                graphics.drawImage(this.invgfx, n2, n, 20);
            }
            ++n3;
        }
        n2 = this.availBG ? 46 + this.view.xLoc : 60 + this.view.xLoc;
        n = this.availBG ? this.view.yLoc + 3 : 8;
        graphics.setClip(n2, n, 56, 72);
        graphics.drawImage(this.inv2gfx, n2, n, 20);
        int n4 = 0;
        while (n4 < 16) {
            if (this.invItem[n4] != 0) {
                int n5 = this.view.itemType[this.invItem[n4] - 1] - 1 >> 3;
                n2 = this.invSquareXY[n4][0];
                n = this.invSquareXY[n4][1];
                graphics.setClip(n2, n, this.invSquareSize, this.invSquareSize);
                graphics.drawImage(this.invgfx, n2 - this.invSquareSize - (n5 & 1) * this.invSquareSize, n - (n5 >> 1) * this.invSquareSize, 20);
            }
            ++n4;
        }
        graphics.setClip(0, 0, this.gameWidth, this.gameHeight);
        n2 = this.invSquareXY[this.itemCurrent][0];
        n = this.invSquareXY[this.itemCurrent][1];
        graphics.setColor(255, 0, 0);
        graphics.drawRect(n2, n, this.invSquareSize - 1, this.invSquareSize - 1);
        n2 = this.gameWidth >> 1;
        int n6 = n = this.availBG ? this.view.yLoc + this.view.ySize - (fontHeight << 1) : this.gameHeight - 14;
        if (this.invItem[this.itemCurrent] != 0) {
            Dictionary dictionary;
            StringBuffer stringBuffer = new StringBuffer("");
            StringBuffer stringBuffer2 = new StringBuffer("");
            int n7 = this.view.itemType[this.invItem[this.itemCurrent] - 1] - 1;
            int n8 = n7 >> 3;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            Dictionary dictionary2 = this.dict;
            stringBuffer.append(this.dict.getString(this.itemDsc[n7] + Dictionary.TEXT_DEX));
            this.drawSmallText(graphics, n2, n, stringBuffer, 0);
            n7 &= 7;
            if (n8 == 0 || n8 == 7) {
                n10 += this.view.helmet[n7 + n7];
                n11 -= this.view.helmet[n7 + n7 + 1];
            } else if (n8 == 1) {
                n9 += this.view.sword[n7 + n7];
                n11 -= this.view.sword[n7 + n7 + 1];
            } else if (n8 == 2 || n8 == 3) {
                n10 += this.view.sword[n7 + n7];
                n11 -= this.view.sword[n7 + n7 + 1];
            } else if (n8 == 4) {
                n9 += this.view.ring[n7 + n7 + n7];
                n10 += this.view.ring[n7 + n7 + n7 + 1];
                n11 -= this.view.ring[n7 + n7 + n7 + 2];
            }
            n11 = -n11;
            if (n9 != 0) {
                dictionary = this.dict;
                stringBuffer2.append(this.dict.getString(Dictionary.TEXT_ATT));
                if (n9 > 0) {
                    stringBuffer2.append("+");
                }
                stringBuffer2.append(n9);
                stringBuffer2.append(" ");
            }
            if (n10 != 0) {
                dictionary = this.dict;
                stringBuffer2.append(this.dict.getString(Dictionary.TEXT_DEF));
                if (n10 > 0) {
                    stringBuffer2.append("+");
                }
                stringBuffer2.append(n10);
                stringBuffer2.append(" ");
            }
            if (n11 != 0) {
                dictionary = this.dict;
                stringBuffer2.append(this.dict.getString(Dictionary.TEXT_DEX));
                if (n11 > 0) {
                    stringBuffer2.append("+");
                }
                stringBuffer2.append(n11);
            }
            this.drawSmallText(graphics, n2, n += fontHeight, stringBuffer2, 0);
        }
    }
}

