/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class View {
    static final int PERSPECTIVE = 64;
    static final int PERSP_OFFSET = 672;
    static final int BLOCK_SIZE = 64;
    static final int BLOCK_SHIFT = 6;
    static final long ACCURACY = 14L;
    static final int TILES_WIDE = 7;
    static final int HALF_WIDE = 3;
    static final int MAX_DEPTH = 4;
    static final int MAP_WIDTH = 32;
    static final int MAP_WIDTH_SHIFT = 5;
    static final int NORTH = 0;
    static final int EAST = 1;
    static final int SOUTH = 2;
    static final int WEST = 3;
    static final byte DOOR_LOCKED = 9;
    static final byte DOOR_CLOSED = 8;
    static final byte DOOR_OPEN = 16;
    static final byte CLOSE_LOCK = 40;
    static final byte MAX_DOORS = 32;
    static final byte MAX_MONSTERS = 16;
    static final byte MON_AND = 15;
    static final byte MAX_PADS = 16;
    static final byte PAD_AND = -16;
    static final byte PAD_SHIFT = 4;
    static final byte MAX_SPECIAL = 16;
    static final byte MAX_ITEMS = 48;
    static final byte MAX_SECRET = 5;
    public int[][] showBlocks = new int[7][6];
    public int[][] mapBlocks = new int[32][32];
    public byte[][] showDoors = new byte[7][6];
    public byte[][] mapDoors = new byte[32][32];
    public byte[][] showMonster = new byte[7][6];
    public byte[][] mapMonster = new byte[32][32];
    public byte[][] showItem = new byte[7][6];
    public byte[][] mapItem = new byte[32][32];
    public byte doorCount;
    public byte[] doorDirection = new byte[32];
    public byte[] doorStatus = new byte[32];
    public byte[] doorCode = new byte[32];
    public int[] doorOffset = new int[]{56, 48, 40, 32, 24, 16, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public byte[] monsterDirec = new byte[16];
    public byte[] monsterAction = new byte[16];
    public byte[] monsterX = new byte[16];
    public byte[] monsterY = new byte[16];
    public byte[] monsterHP = new byte[16];
    public byte[] monsterRec = new byte[16];
    public byte[] monsterItem = new byte[16];
    public byte monsterSpeed;
    public byte monStartHP;
    public byte monStartRec;
    public byte monAttack;
    public byte[] specType = new byte[16];
    public byte[] specText = new byte[16];
    public byte[] specX = new byte[16];
    public byte[] specY = new byte[16];
    public byte[] specDirec = new byte[16];
    public byte[] specUnlock = new byte[16];
    public byte[] specWallX = new byte[16];
    public byte[] specWallY = new byte[16];
    public byte[] specCode = new byte[16];
    public int[] specOffset = new int[]{8, -24, 16, 0, 8, -8, 16, 0, 8, 8, 16, 0, 8, 24, 16, 0, 22, -11, 46, 16, 5, -4, 8, 16, 15, 13, 8, 16, 22, -11, 46, 16};
    public byte[] padType = new byte[16];
    public byte[] padX = new byte[16];
    public byte[] padY = new byte[16];
    public byte[] itemType = new byte[48];
    public byte[] itemX = new byte[48];
    public byte[] itemY = new byte[48];
    public byte totSecret = 0;
    public byte[] secretFound = new byte[5];
    public byte[] secretX = new byte[5];
    public byte[] secretY = new byte[5];
    public byte[] helmet = new byte[]{1, -1, 1, 1, 2, 0, 0, 0};
    public byte[] sword = new byte[]{4, -2, 6, 1, 8, 0, 12, 0};
    public byte[] ring = new byte[]{3, 3, 0, 4, 0, 0, 0, 4, 0, 0, 0, 4};
    public byte aiCount;
    public byte[] scrolls = new byte[6];
    public byte[] mapOne = new byte[1024];
    public byte[] rightCol = new byte[64];
    public byte[] leftCol = new byte[64];
    public byte[] frontCol = new byte[64];
    public byte[] halfWall = new byte[64];
    public byte[] halfDoor = new byte[64];
    public short[][] startEndZ;
    public short[] halfColRowSize;
    public int iMaxHeight = 0;
    public byte[][] pixelYData;
    public int xLoc;
    public int yLoc;
    public int xSize;
    public int ySize;
    public int size;
    public GameManager gameManager;
    public int[] view;
    public int[] floor;
    static final int MAX_COLORS = 256;
    static final int COLOR_DEPTH = 16;
    public int[][] color;
    public short colorCount = 0;
    public short[][] gfx;
    public boolean bigMon;

    View(GameManager gameManager, int n, int n2, int n3, int n4) {
        this.gameManager = gameManager;
        this.xLoc = n3;
        this.yLoc = n4;
        this.xSize = n;
        this.ySize = n2;
        this.size = n * n2;
        int n5 = 0;
        while (n5 < 64) {
            this.rightCol[n5] = (byte)(n5 < 16 || n5 > 47 ? -1 : (byte)(16 + n5));
            this.leftCol[n5] = (byte)(n5 < 16 || n5 > 47 ? -1 : (byte)(79 - n5));
            this.frontCol[n5] = (byte)(n5 < 16 || n5 > 47 ? -1 : (byte)(-16 + n5));
            this.halfWall[n5] = (byte)(n5 < 32 ? n5 : (byte)(63 - n5));
            this.halfDoor[n5] = n5 < 32 ? (byte)(32 + n5) : (byte)(95 - n5);
            n5 = (byte)(n5 + 1);
        }
        this.tempFloorSetup();
        this.bigMon = false;
    }

    void init() {
        this.view = new int[this.size];
        this.startEndZ = new short[this.xSize][5];
        this.halfColRowSize = new short[321];
        int n = 2048 / (this.xSize >> 1);
        while (n < 320) {
            this.halfColRowSize[n] = (short)(4096 / n >> 1);
            if (this.halfColRowSize[n] > this.iMaxHeight) {
                this.iMaxHeight = this.halfColRowSize[n];
            }
            ++n;
        }
        this.iMaxHeight *= 2;
        this.pixelYData = new byte[this.iMaxHeight][this.iMaxHeight];
        int n2 = 0;
        while (n2 < this.iMaxHeight) {
            int n3 = 0;
            while (n3 < n2) {
                this.pixelYData[n2][n3] = (byte)(64 * n3 / n2);
                ++n3;
            }
            ++n2;
        }
    }

    void initLevel(byte by) {
        this.clear();
        try {
            this.loadMap(by);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        this.aiCount = 0;
        int n = 0;
        while (n < this.scrolls.length) {
            this.scrolls[n] = 0;
            ++n;
        }
    }

    void initTile() {
        this.color = new int[256][16];
        this.gfx = new short[4][4096];
    }

    private void loadMap(byte by) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(this.getClass().getResourceAsStream(String.valueOf(String.valueOf(new StringBuffer("/").append(by).append(".a")))));
        int n = 0;
        while (n < 1024) {
            this.mapOne[n] = dataInputStream.readByte();
            ++n;
        }
        n = 0;
        while (n < 16) {
            this.specType[n] = dataInputStream.readByte();
            ++n;
        }
        n = 0;
        while (n < 16) {
            this.specText[n] = dataInputStream.readByte();
            ++n;
        }
        n = 0;
        while (n < 16) {
            this.specX[n] = dataInputStream.readByte();
            ++n;
        }
        n = 0;
        while (n < 16) {
            this.specY[n] = dataInputStream.readByte();
            ++n;
        }
        n = 0;
        while (n < 16) {
            this.specDirec[n] = dataInputStream.readByte();
            ++n;
        }
        n = 0;
        while (n < 16) {
            this.specUnlock[n] = dataInputStream.readByte();
            ++n;
        }
        n = 0;
        while (n < 16) {
            this.specWallX[n] = dataInputStream.readByte();
            ++n;
        }
        n = 0;
        while (n < 16) {
            this.specWallY[n] = dataInputStream.readByte();
            ++n;
        }
        n = 0;
        while (n < 16) {
            this.specCode[n] = dataInputStream.readByte();
            ++n;
        }
        n = 0;
        while (n < 32) {
            this.doorCode[n] = dataInputStream.readByte();
            ++n;
        }
        n = 0;
        while (n < 32) {
            this.itemType[n] = dataInputStream.readByte();
            ++n;
        }
        n = 0;
        while (n < 32) {
            this.itemX[n] = dataInputStream.readByte();
            ++n;
        }
        n = 0;
        while (n < 32) {
            this.itemY[n] = dataInputStream.readByte();
            ++n;
        }
        n = 32;
        while (n < 48) {
            this.itemType[n] = 0;
            this.itemX[n] = 0;
            this.itemY[n] = 0;
            ++n;
        }
        n = 0;
        while (n < 16) {
            this.monsterItem[n] = dataInputStream.readByte();
            ++n;
        }
        n = 0;
        while (n < 16) {
            this.padType[n] = dataInputStream.readByte();
            ++n;
        }
        n = 0;
        while (n < 16) {
            this.padX[n] = dataInputStream.readByte();
            ++n;
        }
        n = 0;
        while (n < 16) {
            this.padY[n] = dataInputStream.readByte();
            ++n;
        }
        this.monsterSpeed = dataInputStream.readByte();
        this.monStartHP = dataInputStream.readByte();
        this.monStartRec = dataInputStream.readByte();
        this.monAttack = dataInputStream.readByte();
        this.gameManager.xMap = dataInputStream.readByte();
        this.gameManager.yMap = dataInputStream.readByte();
        this.gameManager.direction = dataInputStream.readByte();
        this.gameManager.xEnd = dataInputStream.readByte();
        this.gameManager.yEnd = dataInputStream.readByte();
        n = 0;
        while (n < 5) {
            this.secretX[n] = dataInputStream.readByte();
            ++n;
        }
        n = 0;
        while (n < 5) {
            this.secretY[n] = dataInputStream.readByte();
            ++n;
        }
        this.totSecret = dataInputStream.readByte();
        byte[] byArray = new byte[20];
        n = 0;
        while (n < byArray.length) {
            byArray[n] = dataInputStream.readByte();
            ++n;
        }
        if (this.gameManager.gameLevel < 5 && (this.gameManager.gameLevel & 1) == 0) {
            this.monsterSpeed = byArray[0];
            this.monStartHP = byArray[1];
            this.monStartRec = byArray[2];
            this.monAttack = byArray[3];
            this.gameManager.xMap = byArray[4];
            this.gameManager.yMap = byArray[5];
            this.gameManager.direction = byArray[6];
            this.gameManager.xEnd = byArray[7];
            this.gameManager.yEnd = byArray[8];
            n = 0;
            while (n < 5) {
                this.secretX[n] = byArray[9 + n];
                ++n;
            }
            n = 0;
            while (n < 5) {
                this.secretY[n] = byArray[14 + n];
                ++n;
            }
            this.totSecret = byArray[19];
        }
        dataInputStream.close();
    }

    void createMap(boolean bl) {
        int n;
        this.doorCount = 0;
        int n2 = 0;
        int n3 = 1;
        if (!bl) {
            n = 0;
            while (n < 32) {
                this.doorStatus[n] = 8;
                ++n;
            }
        }
        if (!bl) {
            n = 0;
            while (n < 5) {
                this.secretFound[n] = 0;
                ++n;
            }
        }
        int n4 = 0;
        while (n4 < 32) {
            int n5 = 0;
            while (n5 < 32) {
                this.mapBlocks[n5][n4] = 0;
                if (n4 == 0 && (this.mapOne[(n4 << 5) + n5] & 7) != 0) {
                    this.mapBlocks[n5][n4] = (this.mapOne[(n4 << 5) + n5] & 7) << 4;
                } else if (n4 > 0 && (this.mapOne[(n4 << 5) + n5] & 7) != 0 && (this.mapOne[(n4 - 1 << 5) + n5] & 7) == 0) {
                    this.mapBlocks[n5][n4] = (this.mapOne[(n4 << 5) + n5] & 7) << 4;
                } else if (n4 > 0 && (this.mapOne[(n4 << 5) + n5] & 7) == 0 && (this.mapOne[(n4 - 1 << 5) + n5] & 7) != 0) {
                    this.mapBlocks[n5][n4] = (this.mapOne[(n4 - 1 << 5) + n5] & 7) << 4;
                }
                if (n5 == 0 && (this.mapOne[(n4 << 5) + n5] & 7) != 0) {
                    int[] nArray = this.mapBlocks[n5];
                    int n6 = n4;
                    nArray[n6] = nArray[n6] + (this.mapOne[(n4 << 5) + n5] & 7);
                } else if (n5 > 0 && (this.mapOne[(n4 << 5) + n5] & 7) != 0 && (this.mapOne[(n4 << 5) + (n5 - 1)] & 7) == 0) {
                    int[] nArray = this.mapBlocks[n5];
                    int n7 = n4;
                    nArray[n7] = nArray[n7] + (this.mapOne[(n4 << 5) + n5] & 7);
                } else if (n5 > 0 && (this.mapOne[(n4 << 5) + n5] & 7) == 0 && (this.mapOne[(n4 << 5) + (n5 - 1)] & 7) != 0) {
                    int[] nArray = this.mapBlocks[n5];
                    int n8 = n4;
                    nArray[n8] = nArray[n8] + (this.mapOne[(n4 << 5) + (n5 - 1)] & 7);
                }
                this.mapDoors[n5][n4] = (byte)(this.mapOne[(n4 << 5) + n5] >> 4 & 3);
                if (this.mapDoors[n5][n4] != 0) {
                    this.doorDirection[this.doorCount] = n4 > 0 && (this.mapOne[(n4 - 1 << 5) + n5] & 7) != 0 && (this.mapOne[(n4 + 1 << 5) + n5] & 7) != 0 ? 0 : 3;
                    this.mapDoors[n5][n4] = this.doorCount = (byte)(this.doorCount + 1);
                }
                if (!bl) {
                    this.mapMonster[n5][n4] = (byte)(this.mapOne[(n4 << 5) + n5] >> 6 & 1);
                    if (this.mapMonster[n5][n4] != 0) {
                        this.monsterX[n2] = (byte)n5;
                        this.monsterY[n2] = (byte)n4;
                        this.monsterHP[n2] = this.monStartHP;
                        this.monsterAction[n2] = 1;
                        this.mapMonster[n5][n4] = n2 = (int)((byte)(n2 + 1));
                    }
                }
                if ((this.mapOne[(n4 << 5) + n5] & 0x80) != 0) {
                    byte[] byArray = this.mapMonster[n5];
                    int n9 = n4;
                    byArray[n9] = (byte)(byArray[n9] + (byte)(n3 << 4));
                    if (!(this.padType[n3 - 1] != 0 && this.padType[n3 - 1] != 1 || bl)) {
                        this.doorStatus[this.padX[n3 - 1]] = 9;
                    }
                    n3 = (byte)(n3 + 1);
                }
                ++n5;
            }
            ++n4;
        }
        n = 0;
        while (n < 16) {
            if (this.specType[n] != 0) {
                if (this.specDirec[n] == 0) {
                    int[] nArray = this.mapBlocks[this.specX[n]];
                    byte by = this.specY[n];
                    nArray[by] = nArray[by] + (n + 1 << 12);
                } else {
                    int[] nArray = this.mapBlocks[this.specX[n]];
                    byte by = this.specY[n];
                    nArray[by] = nArray[by] + (n + 1 << 8);
                }
            }
            if (this.specUnlock[n] != 0 && !bl) {
                this.doorStatus[this.specUnlock[n] - 1] = 9;
            }
            if (this.specType[n] == 7) {
                if (this.specDirec[n] == 0) {
                    int[] nArray = this.mapBlocks[this.specX[n]];
                    byte by = this.specY[n];
                    nArray[by] = nArray[by] | 0x10;
                } else {
                    int[] nArray = this.mapBlocks[this.specX[n]];
                    byte by = this.specY[n];
                    nArray[by] = nArray[by] | 1;
                }
            }
            ++n;
        }
        n = 0;
        while (n < 32) {
            if (this.doorCode[n] != 0 && !bl) {
                this.doorStatus[n] = 9;
            }
            ++n;
        }
        n = 0;
        while (n < 48) {
            if (this.itemType[n] != 0 && this.itemX[n] < 32 && this.itemY[n] < 32) {
                byte[] byArray = this.mapItem[this.itemX[n]];
                byte by = this.itemY[n];
                byArray[by] = (byte)(byArray[by] | 1);
            }
            ++n;
        }
    }

    void clear() {
        int n = 0;
        while (n < this.size) {
            this.view[n] = 0;
            ++n;
        }
    }

    void showView(Graphics graphics) {
        graphics.drawRGB(this.view, 0, this.xSize, this.xLoc, this.yLoc, this.xSize, this.ySize, false);
    }

    void tempFloorSetup() {
        this.floor = this.ySize == 80 ? new int[this.xSize * 30] : new int[this.xSize * 26];
        Image image = this.gameManager.gameEffects.getGfx("/f.png");
        Image image2 = Image.createImage((int)this.xSize, (int)(this.floor.length / this.xSize));
        Graphics graphics = image2.getGraphics();
        graphics.setClip(0, 0, this.xSize, this.ySize);
        graphics.drawImage(image, -(120 - this.xSize >> 1), 0, 20);
        image2.getRGB(this.floor, 0, this.xSize, 0, 0, this.xSize, this.floor.length / this.xSize);
    }

    void floorToView() {
        int n = this.floor.length / this.xSize;
        int n2 = (this.ySize - n) * this.xSize;
        int n3 = this.floor.length;
        int n4 = 0;
        while (n4 < this.floor.length) {
            this.view[n2++] = this.floor[n4];
            this.view[n4] = this.floor[--n3];
            ++n4;
        }
        n4 = this.floor.length;
        while (n4 < (this.ySize - n) * this.xSize) {
            this.view[n4] = 0;
            ++n4;
        }
        long l = 96L;
        int n5 = 1;
        while (n5 <= 2) {
            long l2 = -192L;
            int n6 = 0;
            while (n6 < 7) {
                byte by = (byte)((this.showMonster[n6][4 - n5] & 0xFFFFFFF0) >> 4);
                if (by != 0) {
                    short s;
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    long l3 = (long)(32 << 14) / l;
                    long l4 = l3 * 64L >> 14;
                    l3 = (l2 << 14) / l;
                    long l5 = l3 * 64L >> 14;
                    if (n5 == 1) {
                        l5 += (long)((this.xSize >> 1) - 16);
                        n10 = (int)((l4 += (long)((this.ySize >> 1) - 5)) * (long)this.xSize);
                        n9 = 52;
                        n8 = (int)l4;
                        while ((long)n8 < l4 + 11L) {
                            n7 = (int)l5;
                            while ((long)n7 < l5 + 32L) {
                                if (n7 >= 0 && n7 < this.xSize && (s = this.gfx[0][n9]) > 0) {
                                    this.view[n10 + n7] = this.color[s][0];
                                }
                                n9 += 64;
                                ++n7;
                            }
                            n9 += -2047;
                            n10 += this.xSize;
                            ++n8;
                        }
                    } else {
                        l5 += (long)((this.xSize >> 1) - 10);
                        n10 = (int)((l4 += (long)((this.ySize >> 1) - 2)) * (long)this.xSize);
                        n9 = 2235;
                        n8 = (int)l4;
                        while ((long)n8 < l4 + 5L) {
                            n7 = (int)l5;
                            while ((long)n7 < l5 + 22L) {
                                if (n7 >= 0 && n7 < this.xSize && (s = this.gfx[0][n9]) > 0) {
                                    this.view[n10 + n7] = this.color[s][0];
                                }
                                n9 += 64;
                                ++n7;
                            }
                            n9 += -1407;
                            n10 += this.xSize;
                            ++n8;
                        }
                    }
                }
                l2 += 64L;
                ++n6;
            }
            l += 64L;
            ++n5;
        }
    }

    public void getMap(int n, int n2, int n3) {
        int n4;
        int n5 = 0;
        while (n5 <= 4) {
            n4 = 0;
            while (n4 < 7) {
                this.showBlocks[n4][n5] = 0;
                this.showDoors[n4][n5] = 0;
                this.showMonster[n4][n5] = 0;
                this.showItem[n4][n5] = 0;
                ++n4;
            }
            ++n5;
        }
        switch (n) {
            case 0: {
                int n6 = n2 - 3;
                int n7 = n3 - 4;
                n5 = 0;
                while (n5 <= 4) {
                    n4 = 0;
                    while (n4 < 7) {
                        if (n6 + n4 >= 0 && n6 + n4 < 32 && n7 >= 0 && n7 < 32) {
                            this.showBlocks[n4][n5] = this.mapBlocks[n6 + n4][n7];
                            this.showDoors[n4][n5] = this.mapDoors[n6 + n4][n7];
                            this.showMonster[n4][n5] = this.mapMonster[n6 + n4][n7];
                            this.showItem[n4][n5] = this.mapItem[n6 + n4][n7];
                        }
                        ++n4;
                    }
                    ++n7;
                    ++n5;
                }
                break;
            }
            case 1: {
                int n8 = n2 + 4;
                int n9 = n3 - 3;
                n5 = 0;
                while (n5 <= 4) {
                    n4 = 0;
                    while (n4 < 7) {
                        if (n9 + n4 >= 0 && n9 + n4 < 32 && n8 >= 0 && n8 < 32) {
                            this.showBlocks[n4][n5] = (this.mapBlocks[n8][n9 + n4] & 0xF0F0) >> 4;
                            this.showDoors[n4][n5] = this.mapDoors[n8][n9 + n4];
                            this.showMonster[n4][n5] = this.mapMonster[n8][n9 + n4];
                            this.showItem[n4][n5] = this.mapItem[n8][n9 + n4];
                        }
                        if (n8 + 1 >= 0 && n8 + 1 < 32 && n9 + n4 >= 0 && n9 + n4 < 32) {
                            this.showBlocks[n4][n5] = this.showBlocks[n4][n5] + ((this.mapBlocks[n8 + 1][n9 + n4] & 0xF0F) << 4);
                        }
                        ++n4;
                    }
                    --n8;
                    ++n5;
                }
                break;
            }
            case 2: {
                int n10 = n2 + 3;
                int n11 = n3 + 4;
                n5 = 0;
                while (n5 <= 4) {
                    n4 = 0;
                    while (n4 < 7) {
                        if (n10 - n4 >= 0 && n10 - n4 < 32 && n11 >= 0 && n11 < 32) {
                            this.showBlocks[n4][n5] = 0;
                            this.showDoors[n4][n5] = this.mapDoors[n10 - n4][n11];
                            this.showMonster[n4][n5] = this.mapMonster[n10 - n4][n11];
                            this.showItem[n4][n5] = this.mapItem[n10 - n4][n11];
                        }
                        if (n10 - (n4 - 1) >= 0 && n10 - (n4 - 1) < 32 && n11 >= 0 && n11 < 32) {
                            this.showBlocks[n4][n5] = this.showBlocks[n4][n5] + (this.mapBlocks[n10 - (n4 - 1)][n11] & 0xF0F);
                        }
                        if (n10 - n4 >= 0 && n10 - n4 < 32 && n11 + 1 >= 0 && n11 + 1 < 32) {
                            this.showBlocks[n4][n5] = this.showBlocks[n4][n5] + (this.mapBlocks[n10 - n4][n11 + 1] & 0xF0F0);
                        }
                        ++n4;
                    }
                    --n11;
                    ++n5;
                }
                break;
            }
            case 3: {
                int n12 = n2 - 4;
                int n13 = n3 + 3;
                n5 = 0;
                while (n5 <= 4) {
                    n4 = 0;
                    while (n4 < 7) {
                        if (n13 - n4 >= 0 && n13 - n4 < 32 && n12 >= 0 && n12 < 32) {
                            this.showBlocks[n4][n5] = (this.mapBlocks[n12][n13 - n4] & 0xF0F) << 4;
                            this.showDoors[n4][n5] = this.mapDoors[n12][n13 - n4];
                            this.showMonster[n4][n5] = this.mapMonster[n12][n13 - n4];
                            this.showItem[n4][n5] = this.mapItem[n12][n13 - n4];
                        }
                        if (n13 - (n4 - 1) >= 0 && n13 - (n4 - 1) < 32 && n12 >= 0 && n12 < 32) {
                            this.showBlocks[n4][n5] = this.showBlocks[n4][n5] + ((this.mapBlocks[n12][n13 - (n4 - 1)] & 0xF0F0) >> 4);
                        }
                        ++n4;
                    }
                    ++n12;
                    ++n5;
                }
                break;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void getRayCast() {
        var1_1 = this.ySize >> 1;
        var2_2 = 192L;
        var4_3 = 256L;
        var6_4 = 0L;
        while (var6_4 < (long)this.xSize) {
            block19: {
                this.startEndZ[(int)var6_4][3] = 0;
                var8_5 = var6_4 == (long)(this.xSize >> 1) ? 0L : (long)(64 << 14) / ((long)(this.xSize >> 1) - var6_4);
                var10_6 = 32L;
                var12_7 = 64L;
                var14_8 = 3;
                var15_9 = 4;
                v0 = var8_5 = var8_5 < 0L ? -var8_5 : var8_5;
                if (var6_4 > (long)(this.xSize >> 1)) ** GOTO lbl145
                while (var10_6 <= var2_2 && var12_7 <= var4_3) {
                    if (var8_5 == 0L) {
                        var16_10 = (this.showBlocks[var14_8][var15_9] & 240) >> 4;
                        if (var16_10 != 0) {
                            this.startEndZ[(int)var6_4][0] = (short)(var1_1 - this.halfColRowSize[(int)var12_7]);
                            this.startEndZ[(int)var6_4][1] = (short)(var1_1 + this.halfColRowSize[(int)var12_7]);
                            this.startEndZ[(int)var6_4][2] = 31;
                            this.startEndZ[(int)var6_4][3] = (short)var16_10;
                            this.startEndZ[(int)var6_4][4] = (short)(var12_7 >> 5);
                            break block19;
                        }
                        var12_7 += 64L;
                        --var15_9;
                        continue;
                    }
                    var17_11 = var10_6 * var8_5 >> 14;
                    if (var17_11 == var12_7) {
                        var16_10 = this.showBlocks[var14_8][var15_9] & 15;
                        if (var16_10 != 0) {
                            this.startEndZ[(int)var6_4][0] = (short)(var1_1 - this.halfColRowSize[(int)var17_11]);
                            this.startEndZ[(int)var6_4][1] = (short)(var1_1 + this.halfColRowSize[(int)var17_11]);
                            this.startEndZ[(int)var6_4][2] = this.halfWall[(byte)((var17_11 % 64L << 6) / 64L)];
                            this.startEndZ[(int)var6_4][3] = (short)var16_10;
                            this.startEndZ[(int)var6_4][4] = (short)(var12_7 >> 5);
                            break block19;
                        }
                        var16_10 = (this.showBlocks[var14_8][var15_9] & 240) >> 4;
                        if (var16_10 != 0) {
                            var19_12 = var12_7 * var8_5 >> 14;
                            this.startEndZ[(int)var6_4][0] = (short)(var1_1 - this.halfColRowSize[(int)var12_7]);
                            this.startEndZ[(int)var6_4][1] = (short)(var1_1 + this.halfColRowSize[(int)var12_7]);
                            this.startEndZ[(int)var6_4][2] = this.halfWall[(byte)(((256L - var19_12) % 64L << 6) / 64L)];
                            this.startEndZ[(int)var6_4][3] = (short)var16_10;
                            this.startEndZ[(int)var6_4][4] = (short)(var12_7 >> 5);
                            break block19;
                        }
                        if (var15_9 > 0 && (var16_10 = this.showBlocks[var14_8][var15_9 - 1] & 15) != 0) {
                            var19_12 = var12_7 * var8_5 >> 14;
                            this.startEndZ[(int)var6_4][0] = (short)(var1_1 - this.halfColRowSize[(int)var12_7]);
                            this.startEndZ[(int)var6_4][1] = (short)(var1_1 + this.halfColRowSize[(int)var12_7]);
                            this.startEndZ[(int)var6_4][2] = this.halfWall[(byte)(((256L - var19_12) % 64L << 6) / 64L)];
                            this.startEndZ[(int)var6_4][3] = (short)var16_10;
                            this.startEndZ[(int)var6_4][4] = (short)(var12_7 >> 5);
                            break block19;
                        }
                        var10_6 += 64L;
                        var12_7 += 64L;
                        --var14_8;
                        --var15_9;
                        continue;
                    }
                    if (var17_11 < var12_7) {
                        var16_10 = this.showBlocks[var14_8][var15_9] & 15;
                        if (var16_10 != 0) {
                            this.startEndZ[(int)var6_4][0] = (short)(var1_1 - this.halfColRowSize[(int)var17_11]);
                            this.startEndZ[(int)var6_4][1] = (short)(var1_1 + this.halfColRowSize[(int)var17_11]);
                            this.startEndZ[(int)var6_4][2] = this.halfWall[(byte)((var17_11 % 64L << 6) / 64L)];
                            this.startEndZ[(int)var6_4][3] = (short)var16_10;
                            this.startEndZ[(int)var6_4][4] = (short)(var17_11 >> 5);
                            break block19;
                        }
                        var10_6 += 64L;
                        --var14_8;
                        continue;
                    }
                    var16_10 = (this.showBlocks[var14_8][var15_9] & 240) >> 4;
                    if (var16_10 != 0) {
                        var19_12 = (var12_7 << 14) / var8_5;
                        this.startEndZ[(int)var6_4][0] = (short)(var1_1 - this.halfColRowSize[(int)var12_7]);
                        this.startEndZ[(int)var6_4][1] = (short)(var1_1 + this.halfColRowSize[(int)var12_7]);
                        this.startEndZ[(int)var6_4][2] = this.halfWall[(byte)(((672L - var19_12) % 64L << 6) / 64L)];
                        this.startEndZ[(int)var6_4][3] = (short)var16_10;
                        this.startEndZ[(int)var6_4][4] = (short)(var12_7 >> 5);
                        break block19;
                    }
                    var12_7 += 64L;
                    --var15_9;
                }
                break block19;
lbl-1000:
                // 1 sources

                {
                    var17_11 = var10_6 * var8_5 >> 14;
                    if (var17_11 == var12_7) {
                        var16_10 = this.showBlocks[var14_8 + 1][var15_9] & 15;
                        if (var16_10 != 0) {
                            this.startEndZ[(int)var6_4][0] = (short)(var1_1 - this.halfColRowSize[(int)var17_11]);
                            this.startEndZ[(int)var6_4][1] = (short)(var1_1 + this.halfColRowSize[(int)var17_11]);
                            this.startEndZ[(int)var6_4][2] = this.halfWall[(byte)((var17_11 % 64L << 6) / 64L)];
                            this.startEndZ[(int)var6_4][3] = (short)var16_10;
                            this.startEndZ[(int)var6_4][4] = (short)(var17_11 >> 5);
                            break;
                        }
                        var16_10 = (this.showBlocks[var14_8][var15_9] & 240) >> 4;
                        if (var16_10 != 0) {
                            var19_12 = (var12_7 << 14) / var8_5;
                            this.startEndZ[(int)var6_4][0] = (short)(var1_1 - this.halfColRowSize[(int)var12_7]);
                            this.startEndZ[(int)var6_4][1] = (short)(var1_1 + this.halfColRowSize[(int)var12_7]);
                            this.startEndZ[(int)var6_4][2] = this.halfWall[(byte)(((32L + var19_12) % 64L << 6) / 64L)];
                            this.startEndZ[(int)var6_4][3] = (short)var16_10;
                            this.startEndZ[(int)var6_4][4] = (short)(var17_11 >> 5);
                            break;
                        }
                        if (var15_9 > 0 && (var16_10 = this.showBlocks[var14_8 + 1][var15_9 - 1] & 15) != 0) {
                            var19_12 = var12_7 * var8_5 >> 14;
                            this.startEndZ[(int)var6_4][0] = (short)(var1_1 - this.halfColRowSize[(int)var12_7]);
                            this.startEndZ[(int)var6_4][1] = (short)(var1_1 + this.halfColRowSize[(int)var12_7]);
                            this.startEndZ[(int)var6_4][2] = this.halfWall[(byte)(((256L - var19_12) % 64L << 6) / 64L)];
                            this.startEndZ[(int)var6_4][3] = (short)var16_10;
                            this.startEndZ[(int)var6_4][4] = (short)(var12_7 >> 5);
                            break;
                        }
                        var10_6 += 64L;
                        var12_7 += 64L;
                        ++var14_8;
                        --var15_9;
                        continue;
                    }
                    if (var17_11 < var12_7) {
                        var16_10 = this.showBlocks[var14_8 + 1][var15_9] & 15;
                        if (var16_10 != 0) {
                            this.startEndZ[(int)var6_4][0] = (short)(var1_1 - this.halfColRowSize[(int)var17_11]);
                            this.startEndZ[(int)var6_4][1] = (short)(var1_1 + this.halfColRowSize[(int)var17_11]);
                            this.startEndZ[(int)var6_4][2] = this.halfWall[(byte)((var17_11 % 64L << 6) / 64L)];
                            this.startEndZ[(int)var6_4][3] = (short)var16_10;
                            this.startEndZ[(int)var6_4][4] = (short)(var17_11 >> 5);
                            break;
                        }
                        var10_6 += 64L;
                        ++var14_8;
                        continue;
                    }
                    var16_10 = (this.showBlocks[var14_8][var15_9] & 240) >> 4;
                    if (var16_10 != 0) {
                        var19_12 = (var12_7 << 14) / var8_5;
                        this.startEndZ[(int)var6_4][0] = (short)(var1_1 - this.halfColRowSize[(int)var12_7]);
                        this.startEndZ[(int)var6_4][1] = (short)(var1_1 + this.halfColRowSize[(int)var12_7]);
                        this.startEndZ[(int)var6_4][2] = this.halfWall[(byte)(((32L + var19_12) % 64L << 6) / 64L)];
                        this.startEndZ[(int)var6_4][3] = (short)var16_10;
                        this.startEndZ[(int)var6_4][4] = (short)(var12_7 >> 5);
                        break;
                    }
                    var12_7 += 64L;
                    --var15_9;
lbl145:
                    // 4 sources

                    ** while (var10_6 <= var2_2 && var12_7 <= var4_3)
                }
            }
            ++var6_4;
        }
    }

    public void doRayCast() {
        int n = 0;
        while (n < this.xSize) {
            if (this.startEndZ[n][3] != 0) {
                this.doRayCast(this.startEndZ[n][3], n);
            }
            ++n;
        }
    }

    public void getObjectMap(int n) {
        int n2 = 192;
        int n3 = 1;
        while (n3 < 5) {
            int n4 = -192;
            int n5 = 0;
            while (n5 < 7) {
                int n6;
                if (n3 != 4 || n5 != 3) {
                    byte by = (byte)(this.showItem[n5][n3] & 1);
                    byte by2 = (byte)(this.showItem[n5][n3] & 2);
                    byte by3 = (byte)(this.showMonster[n5][n3] & 0xF);
                    byte by4 = this.showDoors[n5][n3];
                    if (by2 != 0) {
                        this.getDoorCast(n4 - 15, n4 + 15, n2 + 16, n2 + 16, 32, 0, 14, 24, null);
                    }
                    if (by != 0) {
                        this.getDoorCast(n4 - 15, n4 + 15, n2 + 16, n2 + 16, 32, 0, -16, 24, null);
                    }
                    if (by4 != 0) {
                        if (this.doorDirection[by4 = (byte)(by4 - 1)] == 0 && (n == 0 || n == 2) || this.doorDirection[by4] == 3 && (n == 1 || n == 3)) {
                            this.getDoorCast(n4 - 32, n4 + 32, n2 + 32, n2 + 32, this.doorOffset[this.doorStatus[by4] & 0xF], 1, 0, 0, this.halfDoor);
                        } else if (n4 < 0) {
                            this.getDoorCast(n4, n4, n2, n2 + 64, this.doorOffset[this.doorStatus[by4] & 0xF], 1, 0, 0, this.halfDoor);
                        } else {
                            this.getDoorCast(n4, n4, n2, n2 + 64, this.doorOffset[this.doorStatus[by4] & 0xF], 1, 0, 0, this.halfDoor);
                        }
                    }
                    if (by3 != 0 && this.monsterAction[by3 = (byte)(by3 - 1)] != 0) {
                        int n7;
                        byte[] byArray = null;
                        int n8 = this.monsterDirec[by3] - n;
                        if (n8 == 0) {
                            byArray = this.bigMon ? this.halfWall : this.frontCol;
                            n7 = 2;
                        } else if (n8 == -2 || n8 == 2) {
                            if (this.monsterRec[by3] != 0) {
                                byArray = this.bigMon ? this.halfDoor : this.rightCol;
                                n7 = 2;
                            } else {
                                byArray = this.bigMon ? this.halfWall : this.frontCol;
                                n7 = 3;
                            }
                        } else if (n8 == 1 || n8 == -3) {
                            byArray = this.rightCol;
                            n7 = 3;
                        } else {
                            byArray = this.leftCol;
                            n7 = 3;
                        }
                        this.getDoorCast(n4 - 32, n4 + 32, n2 + 32, n2 + 32, 0, n7, 0, 0, byArray);
                    }
                }
                if ((n6 = (this.showBlocks[n5][n3] & 0xF000) >> 12) != 0) {
                    n6 = this.specType[n6 - 1] - 1 << 2;
                    this.getDoorCast(n4 - this.specOffset[n6], n4 + this.specOffset[n6] - 1, n2 + 64, n2 + 64, this.specOffset[n6 + 3], 0, this.specOffset[n6 + 1], this.specOffset[n6 + 2], null);
                }
                if ((n6 = (this.showBlocks[n5][n3] & 0xF00) >> 8) != 0) {
                    n6 = this.specType[n6 - 1] - 1 << 2;
                    this.getDoorCast(n4 - 32, n4 - 32, n2 + (32 - this.specOffset[n6]), n2 + 32 + this.specOffset[n6] - 1, this.specOffset[n6 + 3], 0, this.specOffset[n6 + 1], this.specOffset[n6 + 2], null);
                }
                n4 += 64;
                ++n5;
            }
            n2 -= 64;
            ++n3;
        }
    }

    public void getDoorCast(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, byte[] byArray) {
        int n9;
        int n10;
        if (n == 0 && n2 == 0) {
            return;
        }
        int n11 = this.ySize >> 1;
        if (n > n2) {
            n10 = n;
            n = n2;
            n2 = n10;
        }
        if (n3 > n4) {
            n10 = n3;
            n3 = n4;
            n4 = n10;
        }
        if (n3 == 0) {
            n3 = 1;
        }
        n10 = (64 << 14) / ((n3 << 14) / n);
        int n12 = (64 << 14) / ((n4 << 14) / n2);
        if (n10 > n12) {
            n9 = n10;
            n10 = n12;
            n12 = n9;
        }
        n9 = n10 + (this.xSize >> 1);
        int n13 = n10;
        while (n13 <= n12) {
            if (n9 >= 0 && n9 < this.xSize) {
                int n14;
                long l;
                long l2;
                if (n3 == n4) {
                    long l3 = n13 == 0 ? 0L : (l2 = (long)((64 << 14) / n13));
                    long l4 = l2 == 0L ? 0L : (l = (long)(n3 << 14) / l2);
                    if (this.startEndZ[n9][4] >= n3 >> 5 || this.startEndZ[n9][3] == 0) {
                        this.startEndZ[n9][0] = (short)(n11 - this.halfColRowSize[n3]);
                        this.startEndZ[n9][1] = (short)(n11 + this.halfColRowSize[n3]);
                        this.startEndZ[n9][2] = (short)(((672L + l + (long)n7) % 64L << 6) / 64L);
                        this.startEndZ[n9][3] = (short)n6;
                        this.startEndZ[n9][4] = (short)(n3 >> 5);
                        if (byArray != null) {
                            this.startEndZ[n9][2] = byArray[this.startEndZ[n9][2]];
                        }
                        if (this.startEndZ[n9][2] != -1) {
                            n14 = this.startEndZ[n9][2] >= 41 && n6 == 1 || n6 != 1 ? (this.startEndZ[n9][1] - this.startEndZ[n9][0]) * n5 >> 6 : 0;
                            switch (n8) {
                                case 0: {
                                    this.doRayCast(this.startEndZ[n9][3], n9, n14, this.startEndZ[n9][0], this.startEndZ[n9][1]);
                                    break;
                                }
                                case 16: {
                                    this.doRayCast(this.startEndZ[n9][3], n9, n14, n11 - this.halfColRowSize[n3] / 2, n11 + n14 + 1);
                                    break;
                                }
                                case 24: {
                                    this.doRayCast(this.startEndZ[n9][3], n9, n14, n11 + this.halfColRowSize[n3] / 2, n11 + this.halfColRowSize[n3] + n14 + 1);
                                    break;
                                }
                                case 8: {
                                    this.doRayCast(this.startEndZ[n9][3], n9, n14, n11 - this.halfColRowSize[n3] / 2, n11 + n14 + 1);
                                }
                            }
                        }
                    }
                } else {
                    long l5 = n13 == 0 ? 0L : (l2 = (long)((64 << 14) / n13));
                    long l6 = l2 == 0L ? 0L : (l = (long)n * l2 >> 14);
                    if ((long)this.startEndZ[n9][4] >= l >> 5 || this.startEndZ[n9][3] == 0) {
                        this.startEndZ[n9][0] = (short)(n11 - this.halfColRowSize[(int)l]);
                        this.startEndZ[n9][1] = (short)(n11 + this.halfColRowSize[(int)l]);
                        this.startEndZ[n9][2] = (short)(((l + (long)n7) % 64L << 6) / 64L);
                        this.startEndZ[n9][3] = (short)n6;
                        this.startEndZ[n9][4] = (short)(l >> 5);
                        if (byArray != null) {
                            this.startEndZ[n9][2] = byArray[this.startEndZ[n9][2]];
                        }
                        n14 = this.startEndZ[n9][2] >= 41 && n6 == 1 || n6 != 1 ? (this.startEndZ[n9][1] - this.startEndZ[n9][0]) * n5 >> 6 : 0;
                        switch (n8) {
                            case 0: {
                                this.doRayCast(this.startEndZ[n9][3], n9, n14, this.startEndZ[n9][0], this.startEndZ[n9][1]);
                                break;
                            }
                            case 16: {
                                this.doRayCast(this.startEndZ[n9][3], n9, n14, n11 - this.halfColRowSize[(int)l] / 2, n11 + n14 + 1);
                                break;
                            }
                            case 24: {
                                this.doRayCast(this.startEndZ[n9][3], n9, n14, n11 + this.halfColRowSize[(int)l] / 4, n11 + this.halfColRowSize[(int)l] / 1 + n14 + 1);
                                break;
                            }
                            case 8: {
                                this.doRayCast(this.startEndZ[n9][3], n9, n14, n11 - this.halfColRowSize[(int)l] / 2, n11 + n14 + 1);
                            }
                        }
                    }
                }
            }
            ++n9;
            ++n13;
        }
    }

    public void doorUpdate() {
        int n = 0;
        while (n < 32) {
            if ((this.doorStatus[n] & 0x2F) == 40) {
                this.doorStatus[n] = 9;
            } else if (this.doorStatus[n] != 8 && this.doorStatus[n] != 16 && this.doorStatus[n] != 9) {
                if ((this.doorStatus[n] & 0x10) == 16) {
                    if ((this.doorStatus[n] & 0xF) == 8 || (this.doorStatus[n] & 0xF) == 4) {
                        this.gameManager.gameEffects.playDoor();
                    }
                    this.doorStatus[n] = (byte)((this.doorStatus[n] & 0xF0) + ((this.doorStatus[n] & 0xF) - 1));
                } else if ((this.doorStatus[n] & 0x10) == 0) {
                    if ((this.doorStatus[n] & 0xF) == 0 || (this.doorStatus[n] & 0xF) == 4) {
                        this.gameManager.gameEffects.playDoor();
                    }
                    this.doorStatus[n] = (byte)((this.doorStatus[n] & 0xF0) + ((this.doorStatus[n] & 0xF) + 1));
                }
            }
            ++n;
        }
    }

    public boolean doorOpenClose(int n, int n2) {
        int n3 = this.mapDoors[n][n2];
        if (n3 == 0) {
            return false;
        }
        if ((this.mapMonster[n][n2] & 0xF) != 0) {
            return false;
        }
        if (this.doorStatus[--n3] == 9) {
            this.gameManager.showText = 1;
            this.gameManager.textTimer = 30;
        } else if (this.doorStatus[n3] != 9 && (this.doorStatus[n3] & 0x20) != 32) {
            int n4 = n3;
            this.doorStatus[n4] = (byte)(this.doorStatus[n4] ^ 0x10);
            this.gameManager.gameEffects.playDoor();
        }
        return true;
    }

    public int attackMon(int n, int n2, int n3, int n4) {
        byte by;
        byte by2 = (byte)(this.mapMonster[n][n2] & 0xF);
        if (by2 == 0) {
            return -1;
        }
        if (this.monsterAction[by2 = (byte)(by2 - 1)] == 0) {
            return -1;
        }
        if (this.gameManager.invItem[12] != 0 && (by = this.itemType[this.gameManager.invItem[12] - 1]) > 64 && by <= 72) {
            return -1;
        }
        n3 = this.gameManager.calcHit(n3, n4, 0, 10, true, false);
        byte by3 = by2;
        this.monsterHP[by3] = (byte)(this.monsterHP[by3] - n3);
        if (this.scrolls[3] != 0) {
            this.gameManager.HP += n3;
            if (this.gameManager.HP > this.gameManager.maxHP) {
                this.gameManager.HP = this.gameManager.maxHP;
            }
            this.gameManager.showHP = true;
        }
        if (this.monsterHP[by2] <= 0) {
            this.monsterAction[by2] = 0;
            this.monsterHP[by2] = 0;
            byte[] byArray = this.mapMonster[n];
            int n5 = n2;
            byArray[n5] = (byte)(byArray[n5] & 0xFFFFFFF0);
            byte[] byArray2 = this.mapItem[n];
            int n6 = n2;
            byArray2[n6] = (byte)(byArray2[n6] | 2);
            by = this.monsterItem[by2];
            if (by != -1) {
                this.dropItem(n, n2, by, false);
            }
        }
        return n3;
    }

    /*
     * Unable to fully structure code
     */
    public int checkSpecial(int var1_1, int var2_2) {
        block38: {
            var3_3 = (this.showBlocks[3][4] & 61440) >> 12;
            var4_4 = 0;
            if (var3_3 != 0) break block38;
            var5_5 = this.showItem[3][4] & 1;
            if (var5_5 == 0) ** GOTO lbl42
            var6_7 = 0;
            var7_9 = 0;
            if (true) ** GOTO lbl14
            do {
                if (this.gameManager.invItem[var7_9] == 0) {
                    ++var6_7;
                }
                ++var7_9;
lbl14:
                // 2 sources

            } while (var7_9 < 8);
            var7_9 = 0;
            while (var7_9 < 48) {
                block39: {
                    block40: {
                        if (this.itemX[var7_9] != var1_1 || this.itemY[var7_9] != var2_2 || this.itemType[var7_9] == 0) break block39;
                        if (var6_7 <= 0) break block40;
                        this.itemX[var7_9] = 65;
                        var8_12 = 0;
                        if (true) ** GOTO lbl28
                        do {
                            if (this.gameManager.invItem[var8_12] == 0) {
                                this.gameManager.invItem[var8_12] = (byte)(var7_9 + 1);
                                break;
                            }
                            ++var8_12;
lbl28:
                            // 2 sources

                        } while (var8_12 < 8);
                    }
                    --var6_7;
                }
                ++var7_9;
            }
            if (var6_7 >= 0) {
                v0 = this.showItem[3];
                v0[4] = (byte)(v0[4] & 254);
                v1 = this.mapItem[var1_1];
                v2 = var2_2;
                v1[v2] = (byte)(v1[v2] & 254);
            } else {
                return 2;
lbl42:
                // 1 sources

                if (this.gameManager.invItem[12] != 0 && (var5_5 = this.itemType[this.gameManager.invItem[12] - 1]) > 64 && var5_5 <= 72) {
                    this.itemType[this.gameManager.invItem[12] - 1] = 0;
                    this.gameManager.invItem[12] = 0;
                    this.gameManager.showHand = true;
                    this.gameManager.gameEffects.playScroll();
                    switch (var5_5) {
                        case 65: {
                            this.gameManager.HP += 30;
                            if (this.gameManager.HP > this.gameManager.maxHP) {
                                this.gameManager.HP = this.gameManager.maxHP;
                            }
                            this.gameManager.showHP = true;
                            break;
                        }
                        case 66: {
                            this.scrolls[2] = 127;
                            break;
                        }
                        case 67: {
                            this.scrolls[1] = 127;
                            break;
                        }
                        case 68: {
                            this.scrolls[0] = 127;
                            break;
                        }
                        case 69: {
                            this.scrolls[3] = 127;
                            break;
                        }
                        case 70: {
                            this.scrolls[4] = 127;
                            break;
                        }
                        case 71: {
                            this.scrolls[5] = 127;
                        }
                    }
                }
            }
            return 0;
        }
        var5_6 = false;
        block9 : switch (this.specType[--var3_3]) {
            case 1: {
                var6_8 = 0;
                if (true) ** GOTO lbl86
                do {
                    if (this.gameManager.invItem[var6_8] != 0 && this.itemType[this.gameManager.invItem[var6_8] - 1] >> 3 == 6) {
                        this.specText[var3_3] = this.gameManager.invItem[var6_8];
                        this.gameManager.invItem[var6_8] = 0;
                        var5_6 = true;
                        break;
                    }
                    ++var6_8;
lbl86:
                    // 2 sources

                } while (var6_8 < 8);
                if (!var5_6) break;
                this.gameManager.gameEffects.playCrys();
                this.specType[var3_3] = this.specCode[var3_3] == 1 ? 2 : (this.specCode[var3_3] == 2 ? 3 : 4);
                var7_10 = 0;
                var8_13 = 0;
                while (var8_13 < 16) {
                    if (this.specWallX[var8_13] == this.specWallX[var3_3] && this.specType[var8_13] != 1) {
                        var7_10 += this.specCode[var8_13];
                    }
                    ++var8_13;
                }
                if (var7_10 == 0) break;
                var9_15 = 0;
                while (var9_15 < 32) {
                    if (this.doorCode[var9_15] == var7_10 && this.doorStatus[var9_15] == 9) {
                        this.doorStatus[var9_15] = 8;
                        v3 = var9_15;
                        this.doorStatus[v3] = (byte)(this.doorStatus[v3] ^ 16);
                        break block9;
                    }
                    ++var9_15;
                }
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                var7_11 = 0;
                if (true) ** GOTO lbl119
                do {
                    if (this.gameManager.invItem[var7_11] == 0) {
                        this.gameManager.invItem[var7_11] = this.specText[var3_3];
                        this.specText[var3_3] = 0;
                        var5_6 = true;
                        break;
                    }
                    ++var7_11;
lbl119:
                    // 2 sources

                } while (var7_11 < 8);
                if (!var5_6) {
                    var4_4 = 2;
                    break;
                }
                this.gameManager.gameEffects.playCrys();
                this.specType[var3_3] = 1;
                var8_14 = 0;
                var9_16 = 0;
                while (var9_16 < 16) {
                    if (this.specWallX[var9_16] == this.specWallX[var3_3] && this.specType[var9_16] != 1) {
                        var8_14 += this.specCode[var9_16];
                    }
                    ++var9_16;
                }
                if (var8_14 == 0) break;
                var10_17 = 0;
                while (var10_17 < 32) {
                    if (this.doorCode[var10_17] == var8_14 && this.doorStatus[var10_17] == 9) {
                        this.doorStatus[var10_17] = 8;
                        v4 = var10_17;
                        this.doorStatus[v4] = (byte)(this.doorStatus[v4] ^ 16);
                        break block9;
                    }
                    ++var10_17;
                }
                break;
            }
            case 6: {
                this.gameManager.gameEffects.playCrys();
                if (this.specUnlock[var3_3] != 0 && this.doorStatus[this.specUnlock[var3_3] - 1] == 9) {
                    this.doorStatus[this.specUnlock[var3_3] - 1] = 8;
                    v5 = this.specUnlock[var3_3] - 1;
                    this.doorStatus[v5] = (byte)(this.doorStatus[v5] ^ 16);
                    var4_4 = 3;
                    break;
                }
                if (this.specWallX[var3_3] == 0 || this.specWallY[var3_3] == 0) break;
                this.changeWall(this.specWallX[var3_3], this.specWallY[var3_3], 0);
                var4_4 = 3;
                break;
            }
            case 7: {
                var4_4 = 5;
                break;
            }
        }
        return var4_4;
    }

    boolean changeWall(int n, int n2, int n3) {
        int n4 = n2;
        byte by = this.mapOne[n + (n2 <<= 5)];
        switch (n3) {
            case 1: {
                int n5 = n + n2;
                this.mapOne[n5] = (byte)(this.mapOne[n5] & 0xFE);
                break;
            }
            case 2: {
                int n6 = n + n2;
                this.mapOne[n6] = (byte)(this.mapOne[n6] | 1);
                break;
            }
            default: {
                int n7 = n + n2;
                this.mapOne[n7] = (byte)(this.mapOne[n7] ^ 1);
            }
        }
        if ((this.mapOne[n + n2] & 0xF) == 0) {
            if ((this.mapOne[n + n2 - 32] & 0xF) != 0) {
                int[] nArray = this.mapBlocks[n];
                int n8 = n4;
                nArray[n8] = nArray[n8] | 0x10;
            }
            if ((this.mapOne[n + n2 + 32] & 0xF) != 0) {
                int[] nArray = this.mapBlocks[n];
                int n9 = n4 + 1;
                nArray[n9] = nArray[n9] | 0x10;
            }
            if ((this.mapOne[n - 1 + n2] & 0xF) != 0) {
                int[] nArray = this.mapBlocks[n];
                int n10 = n4;
                nArray[n10] = nArray[n10] | 1;
            }
            if ((this.mapOne[n + 1 + n2] & 0xF) != 0) {
                int[] nArray = this.mapBlocks[n + 1];
                int n11 = n4;
                nArray[n11] = nArray[n11] | 1;
            }
        } else {
            if ((this.mapOne[n + n2 - 32] & 0xF) != 0) {
                int[] nArray = this.mapBlocks[n];
                int n12 = n4;
                nArray[n12] = nArray[n12] & 0xFF0F;
            } else {
                int[] nArray = this.mapBlocks[n];
                int n13 = n4;
                nArray[n13] = nArray[n13] | 0x10;
            }
            if ((this.mapOne[n + n2 + 32] & 0xF) != 0) {
                int[] nArray = this.mapBlocks[n];
                int n14 = n4 + 1;
                nArray[n14] = nArray[n14] & 0xFF0F;
            } else {
                int[] nArray = this.mapBlocks[n];
                int n15 = n4 + 1;
                nArray[n15] = nArray[n15] | 0x10;
            }
            if ((this.mapOne[n - 1 + n2] & 0xF) != 0) {
                int[] nArray = this.mapBlocks[n];
                int n16 = n4;
                nArray[n16] = nArray[n16] & 0xFFF0;
            } else {
                int[] nArray = this.mapBlocks[n];
                int n17 = n4;
                nArray[n17] = nArray[n17] | 1;
            }
            if ((this.mapOne[n + 1 + n2] & 0xF) != 0) {
                int[] nArray = this.mapBlocks[n + 1];
                int n18 = n4;
                nArray[n18] = nArray[n18] & 0xFFF0;
            } else {
                int[] nArray = this.mapBlocks[n + 1];
                int n19 = n4;
                nArray[n19] = nArray[n19] | 1;
            }
        }
        if (by != this.mapOne[n + n2]) {
            this.gameManager.gameEffects.playDoor();
        }
        return by != this.mapOne[n + n2];
    }

    public void dropItem(int n, int n2, int n3, boolean bl) {
        if (bl) {
            byte[] byArray = this.showItem[3];
            byArray[4] = (byte)(byArray[4] | 1);
        }
        byte[] byArray = this.mapItem[n];
        int n4 = n2;
        byArray[n4] = (byte)(byArray[n4] | 1);
        this.itemX[n3] = (byte)n;
        this.itemY[n3] = (byte)n2;
    }

    public boolean moveCollision(int n, int n2) {
        if (n >= 0 && n2 >= 0 && (this.mapOne[(n2 << 5) + n] & 0xF) != 0) {
            byte by = (byte)(this.mapMonster[n][n2] & 0xF);
            if (by != 0 && this.monsterAction[by - 1] != 0) {
                return true;
            }
            return this.mapDoors[n][n2] != 0 && this.doorStatus[this.mapDoors[n][n2] - 1] != 16;
        }
        return true;
    }

    public boolean checkMap(int n, int n2, boolean bl) {
        byte by = (byte)(this.mapMonster[n][n2] >> 4 & 0xF);
        if (bl) {
            int n3 = 0;
            while (n3 < this.totSecret) {
                if (this.secretFound[n3] == 0 && this.secretX[n3] == n && this.secretY[n3] == n2) {
                    this.secretFound[n3] = 1;
                    this.gameManager.showText = 6;
                    this.gameManager.textTimer = 10;
                    break;
                }
                ++n3;
            }
            if ((this.mapItem[n][n2] & 1) == 0) {
                if (by != 0) {
                    this.gameManager.gameEffects.playCrys();
                    by = (byte)(by - 1);
                    switch (this.padType[by]) {
                        case 0: 
                        case 1: {
                            byte by2 = this.padX[by];
                            if (this.doorStatus[by2] == 9) {
                                this.doorStatus[by2] = 24;
                                this.gameManager.showText = 3;
                                this.gameManager.textTimer = 10;
                                break;
                            }
                            if (this.doorStatus[by2] == 16) break;
                            this.doorStatus[by2] = (byte)(this.doorStatus[by2] & 0x1F | 0x10);
                            this.gameManager.showText = 3;
                            this.gameManager.textTimer = 10;
                            break;
                        }
                        case 2: 
                        case 3: {
                            if (!this.changeWall(this.padX[by], this.padY[by], 0)) break;
                            this.gameManager.showText = 3;
                            this.gameManager.textTimer = 10;
                            break;
                        }
                        case 4: {
                            --this.gameManager.direction;
                            this.gameManager.direction &= 3;
                            this.gameManager.showText = 4;
                            this.gameManager.textTimer = 10;
                            break;
                        }
                        case 5: {
                            if (!this.changeWall(this.padX[by], this.padY[by], 1)) break;
                            this.gameManager.showText = 3;
                            this.gameManager.textTimer = 10;
                            break;
                        }
                        case 6: {
                            if (!this.changeWall(this.padX[by], this.padY[by], 2)) break;
                            this.gameManager.showText = 3;
                            this.gameManager.textTimer = 10;
                        }
                    }
                }
                return false;
            }
            return true;
        }
        if ((this.mapItem[n][n2] & 1) == 0 && by != 0) {
            by = (byte)(by - 1);
            this.gameManager.gameEffects.playCrys();
            switch (this.padType[by]) {
                case 1: {
                    byte by3 = this.padX[by];
                    if (this.doorStatus[by3] == 9) break;
                    this.doorStatus[by3] = (byte)((this.doorStatus[by3] & 0xF) + 32);
                    this.gameManager.showText = 3;
                    this.gameManager.textTimer = 10;
                    break;
                }
                case 3: {
                    if (!this.changeWall(this.padX[by], this.padY[by], 0)) break;
                    this.gameManager.showText = 3;
                    this.gameManager.textTimer = 10;
                }
            }
        }
        return false;
    }

    void lineOfSite(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        switch (n3) {
            case 0: {
                n4 = 0;
                n5 = -1;
                break;
            }
            case 1: {
                n4 = 1;
                n5 = 0;
                break;
            }
            case 2: {
                n4 = 0;
                n5 = 1;
                break;
            }
            case 3: {
                n4 = -1;
                n5 = 0;
            }
        }
        boolean bl = false;
        int n6 = 0;
        while (n6 < 3) {
            byte[] byArray = this.mapItem[n];
            int n7 = n2;
            byArray[n7] = (byte)(byArray[n7] | 4);
            if (this.mapOne[n + (n2 << 5)] == 0) {
                bl = true;
            } else if (this.mapDoors[n][n2] != 0 && this.doorStatus[this.mapDoors[n][n2] - 1] != 16) {
                bl = true;
            }
            if (n > 0 && (!bl || bl && n3 != 3 && this.mapOne[n - 1 + (n2 - n5 << 5) - n4] != 0)) {
                byte[] byArray2 = this.mapItem[n - 1];
                int n8 = n2;
                byArray2[n8] = (byte)(byArray2[n8] | 4);
            }
            if (n < 31 && (!bl || bl && n3 != 1 && this.mapOne[n + 1 + (n2 - n5 << 5) - n4] != 0)) {
                byte[] byArray3 = this.mapItem[n + 1];
                int n9 = n2;
                byArray3[n9] = (byte)(byArray3[n9] | 4);
            }
            if (n2 > 0 && (!bl || bl && n3 != 0 && this.mapOne[n + (n2 - 1 - n5 << 5) - n4] != 0)) {
                byte[] byArray4 = this.mapItem[n];
                int n10 = n2 - 1;
                byArray4[n10] = (byte)(byArray4[n10] | 4);
            }
            if (n2 < 31 && (!bl || bl && n3 != 2 && this.mapOne[n + (n2 + 1 - n5 << 5) - n4] != 0)) {
                byte[] byArray5 = this.mapItem[n];
                int n11 = n2 + 1;
                byArray5[n11] = (byte)(byArray5[n11] | 4);
            }
            if (bl || (n += n4) < 0 || n >= 32 || (n2 += n5) < 0 || n2 >= 32) break;
            ++n6;
        }
    }

    public void ai() {
        byte by = 0;
        byte by2 = 64;
        byte by3 = (byte)this.gameManager.xMap;
        byte by4 = (byte)this.gameManager.yMap;
        if (this.scrolls[0] == 0 && (this.scrolls[5] & 3) == 0) {
            int n = this.aiCount;
            while (n < this.aiCount + this.monsterSpeed) {
                if (this.monsterRec[n] > 0) {
                    int n2 = n;
                    this.monsterRec[n2] = (byte)(this.monsterRec[n2] - 1);
                } else {
                    byte by5 = this.monsterX[n];
                    byte by6 = this.monsterY[n];
                    if (this.monsterAction[n] == 1) {
                        this.monWander(n, true);
                    } else if (this.monsterAction[n] == 2) {
                        if (this.checkInSite(this.monsterX[n], this.monsterY[n], this.monsterDirec[n])) {
                            this.monAttack(n);
                        } else {
                            this.monsterAction[n] = 1;
                            this.monWander(n, false);
                        }
                    }
                    if (by5 != this.monsterX[n] || by6 != this.monsterY[n]) {
                        byte by7 = (byte)(this.monsterX[n] - by3);
                        byte by8 = (byte)(this.monsterY[n] - by4);
                        by7 = by7 < 0 ? (byte)(-by7) : by7;
                        by8 = by8 < 0 ? (byte)(-by8) : by8;
                        by = by7 > by8 ? by7 : by8;
                        by2 = by < by2 ? by : by2;
                    }
                }
                ++n;
            }
            this.aiCount = (byte)(this.aiCount + this.monsterSpeed);
            if (this.aiCount >= 16) {
                this.aiCount = 0;
            }
        }
        if (by2 < 4) {
            this.gameManager.gameEffects.playFoot(by2);
        }
    }

    public void monWander(int n, boolean bl) {
        byte by = this.monsterX[n];
        byte by2 = this.monsterY[n];
        byte by3 = by;
        byte by4 = by2;
        int n2 = Util.getRandomInt(0, 100);
        int n3 = this.monsterDirec[n];
        boolean bl2 = false;
        if (bl) {
            bl2 = this.checkInSite(by, by2, this.monsterDirec[n]);
        }
        if (bl2) {
            this.monsterAction[n] = 2;
            this.monAttack(n);
            return;
        }
        switch (this.monsterDirec[n]) {
            case 0: {
                by2 = (byte)(by2 - 1);
                break;
            }
            case 1: {
                by = (byte)(by + 1);
                break;
            }
            case 2: {
                by2 = (byte)(by2 + 1);
                break;
            }
            case 3: {
                by = (byte)(by - 1);
            }
        }
        boolean bl3 = by < 0 || by >= 32 || by2 < 0 || by2 >= 32 ? true : this.moveCollision(by, by2);
        if (bl3) {
            int n4 = n;
            this.monsterDirec[n4] = (byte)(this.monsterDirec[n4] + 1);
            int n5 = n;
            this.monsterDirec[n5] = (byte)(this.monsterDirec[n5] & 3);
            by = this.monsterX[n];
            by2 = this.monsterY[n];
            switch (this.monsterDirec[n]) {
                case 0: {
                    by2 = (byte)(by2 - 1);
                    break;
                }
                case 1: {
                    by = (byte)(by + 1);
                    break;
                }
                case 2: {
                    by2 = (byte)(by2 + 1);
                    break;
                }
                case 3: {
                    by = (byte)(by - 1);
                }
            }
            bl3 = by < 0 || by >= 32 || by2 < 0 || by2 >= 32 ? true : this.moveCollision(by, by2);
            if (bl3) {
                int n6 = n;
                this.monsterDirec[n6] = (byte)(this.monsterDirec[n6] + 2);
                int n7 = n;
                this.monsterDirec[n7] = (byte)(this.monsterDirec[n7] & 3);
            } else {
                byte[] byArray = this.mapMonster[this.monsterX[n]];
                byte by5 = this.monsterY[n];
                byArray[by5] = (byte)(byArray[by5] & 0xFFFFFFF0);
                byte[] byArray2 = this.mapMonster[by];
                byte by6 = by2;
                byArray2[by6] = (byte)(byArray2[by6] | (byte)(n + 1));
                this.monsterX[n] = by;
                this.monsterY[n] = by2;
            }
        } else {
            if (n2 < 5) {
                --n3;
            } else if (n2 < 10) {
                ++n3;
            }
            switch (n3 &= 3) {
                case 0: {
                    by4 = (byte)(by4 - 1);
                    break;
                }
                case 1: {
                    by3 = (byte)(by3 + 1);
                    break;
                }
                case 2: {
                    by4 = (byte)(by4 + 1);
                    break;
                }
                case 3: {
                    by3 = (byte)(by3 - 1);
                }
            }
            bl3 = by3 < 0 || by3 >= 32 || by4 < 0 || by4 >= 32 ? true : this.moveCollision(by3, by4);
            if (bl3) {
                byte[] byArray = this.mapMonster[this.monsterX[n]];
                byte by7 = this.monsterY[n];
                byArray[by7] = (byte)(byArray[by7] & 0xFFFFFFF0);
                byte[] byArray3 = this.mapMonster[by];
                byte by8 = by2;
                byArray3[by8] = (byte)(byArray3[by8] | (byte)(n + 1));
                this.monsterX[n] = by;
                this.monsterY[n] = by2;
            } else {
                byte[] byArray = this.mapMonster[this.monsterX[n]];
                byte by9 = this.monsterY[n];
                byArray[by9] = (byte)(byArray[by9] & 0xFFFFFFF0);
                byte[] byArray4 = this.mapMonster[by3];
                byte by10 = by4;
                byArray4[by10] = (byte)(byArray4[by10] | (byte)(n + 1));
                this.monsterX[n] = by3;
                this.monsterY[n] = by4;
                this.monsterDirec[n] = (byte)n3;
            }
        }
    }

    public void monAttack(int n) {
        byte by = this.monsterX[n];
        byte by2 = this.monsterY[n];
        byte by3 = (byte)this.gameManager.xMap;
        byte by4 = (byte)this.gameManager.yMap;
        by3 = (byte)(by3 - by);
        by4 = (byte)(by4 - by2);
        if (!(by3 != 0 && by4 != 0 || by3 != -1 && by3 != 1 && by4 != -1 && by4 != 1)) {
            if (by3 == 1 && this.monsterDirec[n] != 1) {
                this.monsterDirec[n] = 1;
            } else if (by3 == -1 && this.monsterDirec[n] != 3) {
                this.monsterDirec[n] = 3;
            } else if (by4 == 1 && this.monsterDirec[n] != 2) {
                this.monsterDirec[n] = 2;
            } else if (by4 == -1 && this.monsterDirec[n] != 0) {
                this.monsterDirec[n] = 0;
            } else {
                int n2;
                int n3 = n2 = this.scrolls[1] != 0 ? this.monAttack >> 1 : this.monAttack;
                if (this.scrolls[4] != 0) {
                    n2 = 0;
                }
                this.gameManager.manHit(this.monsterDirec[n], n2, 7, this.monStartRec * (16 / this.monsterSpeed));
                this.monsterRec[n] = this.monStartRec;
            }
            return;
        }
        if (by3 == 0) {
            this.monsterDirec[n] = by4 < 0 ? 0 : 2;
        } else if (by4 == 0) {
            this.monsterDirec[n] = by3 < 0 ? 3 : 1;
        }
        switch (this.monsterDirec[n]) {
            case 0: {
                by2 = (byte)(by2 - 1);
                break;
            }
            case 1: {
                by = (byte)(by + 1);
                break;
            }
            case 2: {
                by2 = (byte)(by2 + 1);
                break;
            }
            case 3: {
                by = (byte)(by - 1);
            }
        }
        boolean bl = by < 0 || by >= 32 || by2 < 0 || by2 >= 32 ? true : this.moveCollision(by, by2);
        if (bl) {
            this.monsterAction[n] = 1;
            this.monWander(n, false);
        } else {
            byte[] byArray = this.mapMonster[this.monsterX[n]];
            byte by5 = this.monsterY[n];
            byArray[by5] = (byte)(byArray[by5] & 0xFFFFFFF0);
            byte[] byArray2 = this.mapMonster[by];
            byte by6 = by2;
            byArray2[by6] = (byte)(byArray2[by6] | (byte)(n + 1));
            this.monsterX[n] = by;
            this.monsterY[n] = by2;
        }
    }

    public boolean checkInSite(byte by, byte by2, byte by3) {
        byte by4 = (byte)this.gameManager.xMap;
        byte by5 = (byte)this.gameManager.yMap;
        by4 = (byte)(by4 - by);
        by5 = (byte)(by5 - by2);
        if (!(by4 != 0 && by5 != 0 || by4 != -1 && by4 != 1 && by5 != -1 && by5 != 1)) {
            return true;
        }
        if (by4 < -3 || by4 > 3 || by5 < -3 || by5 > 3) {
            return false;
        }
        return !(by3 == 0 && by5 >= 0 || by3 == 1 && by4 <= 0 || by3 == 2 && by5 <= 0) && (by3 != 3 || by4 < 0);
    }

    public void setColor(int n, int[] nArray) {
        int n2 = 0;
        if (this.colorCount == 0) {
            this.color[0][0] = 0xFFFFFF;
            this.colorCount = (short)(this.colorCount + 1);
        }
        int n3 = n2;
        while (n3 < 4096) {
            nArray[n3] = nArray[n3] & 0xFFFFFF;
            boolean bl = false;
            short s = 0;
            while (s < this.colorCount) {
                if (this.color[s][0] == nArray[n3]) {
                    this.gfx[n][n3] = s;
                    bl = true;
                    break;
                }
                s = (short)(s + 1);
            }
            if (!bl) {
                if (this.colorCount < 256) {
                    this.color[this.colorCount][0] = nArray[n3];
                    this.gfx[n][n3] = this.colorCount;
                    this.colorCount = (short)(this.colorCount + 1);
                } else {
                    this.gfx[n][n3] = 1;
                }
            }
            if (this.colorCount >= 256) break;
            n3 = (short)(n3 + 1);
        }
    }

    public void convertImage(int n, Image image, int[] nArray, int n2) {
        Image image2 = Image.createImage((int)64, (int)64);
        Graphics graphics = image2.getGraphics();
        graphics.setClip(0, 0, 64, 64);
        graphics.drawRegion(image, 0, n2, 64, 64, 4, 0, 0, 20);
        image2.getRGB(nArray, 0, 64, 0, 0, 64, 64);
        this.setColor(n, nArray);
    }

    public void setColorDepth() {
        int n = 1;
        while (n < 16) {
            int n2 = 0;
            while (n2 < 256) {
                this.color[n2][16 - n] = (this.color[n2][0] & 0xFF0000) * (n + 1) >> 4 & 0xFF0000;
                int[] nArray = this.color[n2];
                int n3 = 16 - n;
                nArray[n3] = nArray[n3] + ((this.color[n2][0] & 0xFF00) * (n + 1) >> 4 & 0xFF00);
                int[] nArray2 = this.color[n2];
                int n4 = 16 - n;
                nArray2[n4] = nArray2[n4] + ((this.color[n2][0] & 0xFF) * (n + 1) >> 4 & 0xFF);
                n2 = (short)(n2 + 1);
            }
            n = (short)(n + 1);
        }
    }

    public void doRayCast(int n, int n2) {
        int n3;
        int n4;
        int n5 = this.startEndZ[n2][1] - this.startEndZ[n2][0] - 1;
        int n6 = this.startEndZ[n2][2] << 6;
        int n7 = 0;
        int n8 = n4 = this.startEndZ[n2][4] > 0 ? this.startEndZ[n2][4] - 1 : 0;
        if (this.startEndZ[n2][0] < 0) {
            n7 = 0 - this.startEndZ[n2][0];
            n3 = n2;
            this.startEndZ[n2][0] = 0;
        } else {
            n3 = this.startEndZ[n2][0] * this.xSize + n2;
        }
        if (this.startEndZ[n2][1] > this.ySize) {
            this.startEndZ[n2][1] = (short)this.ySize;
        }
        int n9 = this.startEndZ[n2][0];
        while (n9 < this.startEndZ[n2][1]) {
            this.view[n3] = this.color[this.gfx[n][n6 + this.pixelYData[n5][n7++]]][n4];
            n3 += this.xSize;
            ++n9;
        }
    }

    public void doRayCast(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8 = this.startEndZ[n2][1] - this.startEndZ[n2][0] - 1;
        int n9 = this.startEndZ[n2][2] << 6;
        int n10 = 0;
        int n11 = n7 = this.startEndZ[n2][4] > 0 ? this.startEndZ[n2][4] - 1 : 0;
        if (n4 < 0) {
            n10 = 0 - n4;
            n6 = n2;
            this.startEndZ[n2][0] = 0;
        } else {
            n6 = n4 * this.xSize + n2;
        }
        if ((n5 -= n3 + 1) > this.ySize) {
            n5 = this.ySize;
        }
        n10 += n3;
        int n12 = n4;
        while (n12 < n5) {
            int n13;
            if ((n13 = this.gfx[n][n9 + this.pixelYData[n8][n10++]] & 0xFF) > 0) {
                this.view[n6] = this.color[n13][n7];
            }
            n6 += this.xSize;
            ++n12;
        }
    }
}

