/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.EOFException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStoreException;

class GameManager
implements Runnable {
    static final int MILLIS_PER_TICK = 100;
    static final int MAX_INV = 16;
    static final int STAND_INV = 8;
    static final int NORTH = 0;
    static final int EAST = 1;
    static final int SOUTH = 2;
    static final int WEST = 3;
    static final int GM_UP = 1;
    static final int GM_DOWN = 2;
    static final int GM_LEFT = 3;
    static final int GM_RIGHT = 4;
    static final int GM_FIRE = 5;
    static final int GM_LSIDE = 6;
    static final int GM_RSIDE = 7;
    private final DarkHorde_Midlet midlet;
    private final Dictionary dict;
    public final GameEffects gameEffects;
    private final Canvas canvas;
    private Image splgfx;
    private Image invgfx;
    private Image inv2gfx;
    private Image bggfx;
    private Image menugfx;
    public View view;
    private int ticks = 0;
    public int status;
    public int tempStatus;
    private int option;
    public boolean[] options = new boolean[8];
    private int gameWidth;
    private int gameHeight;
    private boolean redrawBG;
    private boolean redrawAll = false;
    private boolean availBG;
    public byte[] invItem = new byte[16];
    private int[][] invSquareXY = new int[16][2];
    private int invSquareSize;
    private int itemX;
    private int itemY;
    private int itemCurrent;
    private int itemSelect;
    private boolean isGameOver = false;
    private volatile boolean isPaused = false;
    private volatile Thread animationThread = null;
    private static final Font GAME_FONT = Font.getFont((int)0, (int)0, (int)8);
    private static final int fontHeight = GAME_FONT.getHeight();
    public byte[] gameAction = new byte[32];
    public int gameActionCount;
    public int gameActionCurrent;
    public final int GM_SPLASH;
    public final int GM_MENU;
    public final int GM_NEW_GAME;
    public final int GM_PLAY;
    public final int GM_INV;
    public final int GM_DEAD;
    public final int GM_NEW_LEVEL;
    public final int GM_EOL;
    public final int GM_MAP;
    public final int GM_CONT;
    private boolean hasBeenShown = false;
    public int xEnd;
    public int yEnd;
    public int xMap;
    public int yMap;
    public int direction;
    public int HP;
    public int maxHP;
    public int iDex;
    public int iAtt;
    public int iDef;
    public byte gameLevel;
    public int showText;
    public int textTimer;
    public boolean clearText;
    public boolean showItem;
    public boolean clearItem;
    public boolean clrInvTxt;
    public boolean showHP;
    public boolean showHand;
    public int iHit;
    public int iRecovery;
    public int[][] showBlood = new int[4][2];
    public int compassDirec;
    public int rowBorder;
    public int colBorder;
    public byte[] itemDsc = new byte[]{1, 2, 3, 0, 0, 0, 0, 0, 4, 5, 6, 7, 0, 0, 0, 0, 8, 9, 10, 0, 0, 0, 0, 0, 11, 12, 13, 0, 0, 0, 0, 0, 14, 15, 16, 17, 0, 0, 0, 0, 18, 19, 0, 0, 0, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 21, 22, 0, 0, 0, 0, 0, 0, 23, 24, 25, 26, 27, 28, 29, 0};
    public byte[] bStory;
    public boolean bShowStory;
    public boolean bLoadQuik;
    public boolean bLoadGame;
    public boolean bEnd;
    public int c_startApp = 0;
    public int c_pauseApp = 0;
    public int c_hideNotify = 0;
    public int c_showNotify = 0;
    public int iLastKey = 0;
    public int[] bgColor = new int[]{0, 0, 0};
    public int iLeft = 0;
    public int iRight = 0;
    public boolean newHelp = false;
    public int colorCycle = 0;
    public int colorInc = 1;
    public int[] itemHold = new int[]{8, 12, 11, 10, 13, 9, 64, 15, 12};

    GameManager(DarkHorde_Midlet darkHorde_Midlet, Dictionary dictionary, GameEffects gameEffects, Canvas canvas) {
        this.GM_SPLASH = 10;
        this.GM_MENU = 0;
        this.GM_NEW_GAME = 1;
        this.GM_PLAY = 2;
        this.GM_INV = 3;
        this.GM_DEAD = 4;
        this.GM_NEW_LEVEL = 5;
        this.GM_EOL = 6;
        this.GM_MAP = 7;
        this.GM_CONT = 8;
        this.midlet = darkHorde_Midlet;
        this.dict = dictionary;
        this.canvas = canvas;
        this.gameEffects = gameEffects;
        try {
            DataInputStream dataInputStream = new DataInputStream(this.getClass().getResourceAsStream("/sw.wav"));
            dataInputStream.readFully(GameEffects.SWOOSH_SOUND_BYTES);
            dataInputStream = new DataInputStream(this.getClass().getResourceAsStream("/h.wav"));
            dataInputStream.readFully(GameEffects.HIT_SOUND_BYTES);
            dataInputStream = new DataInputStream(this.getClass().getResourceAsStream("/c.wav"));
            dataInputStream.readFully(GameEffects.CRYS_SOUND_BYTES);
            dataInputStream = new DataInputStream(this.getClass().getResourceAsStream("/f.wav"));
            dataInputStream.readFully(GameEffects.FOOT1_SOUND_BYTES);
            dataInputStream = new DataInputStream(this.getClass().getResourceAsStream("/f2.wav"));
            dataInputStream.readFully(GameEffects.FOOT2_SOUND_BYTES);
            dataInputStream = new DataInputStream(this.getClass().getResourceAsStream("/f3.wav"));
            dataInputStream.readFully(GameEffects.FOOT3_SOUND_BYTES);
            dataInputStream = new DataInputStream(this.getClass().getResourceAsStream("/sc.wav"));
            dataInputStream.readFully(GameEffects.SCRO_SOUND_BYTES);
            dataInputStream = new DataInputStream(this.getClass().getResourceAsStream("/w.wav"));
            dataInputStream.readFully(GameEffects.WALL_SOUND_BYTES);
        }
        catch (EOFException eOFException) {
        }
        catch (Exception exception) {
            System.out.println("SFX Error");
        }
        this.gameWidth = this.canvas.getWidth();
        this.gameHeight = this.canvas.getHeight();
        if (this.gameHeight == 65) {
            this.rowBorder = 0;
            this.colBorder = 0;
            this.itemX = 0;
            this.itemY = this.gameHeight - 12;
            this.availBG = false;
        } else {
            this.rowBorder = 12;
            this.colBorder = 8;
            this.itemX = 139;
            this.itemY = this.rowBorder + 5 + 144;
            this.availBG = true;
        }
        this.invSquareSize = 24;
        int n = this.availBG ? 4 : 0;
        int n2 = this.availBG ? 0 : 18;
        int n3 = this.availBG ? 0 : 12;
        int n4 = 0;
        while (n4 < 4) {
            this.invSquareXY[n4 << 1][0] = this.colBorder + 4;
            this.invSquareXY[n4 << 1][1] = this.rowBorder + n + n + (this.invSquareSize + n) * n4;
            this.invSquareXY[(n4 << 1) + 1][0] = this.colBorder + 4 + (this.invSquareSize + n);
            this.invSquareXY[(n4 << 1) + 1][1] = this.rowBorder + n + n + (this.invSquareSize + n) * n4;
            this.invSquareXY[(n4 << 1) + 8][0] = this.colBorder + 10 + (this.invSquareSize + n << 1);
            this.invSquareXY[(n4 << 1) + 8][1] = this.rowBorder + n + n + (this.invSquareSize + n) * n4;
            this.invSquareXY[(n4 << 1) + 9][0] = this.availBG ? 98 : 62;
            int[] nArray = this.invSquareXY[(n4 << 1) + 9];
            nArray[0] = nArray[0] + (this.colBorder + (this.invSquareSize + n));
            this.invSquareXY[(n4 << 1) + 9][1] = this.rowBorder + n + n + (this.invSquareSize + n) * n4;
            ++n4;
        }
        if (!this.availBG) {
            this.rowBorder = -5;
        }
        this.init();
    }

    void init() {
        this.animationThread = null;
        this.isGameOver = false;
        this.isPaused = false;
        this.hasBeenShown = false;
        this.status = 10;
        this.ticks = 0;
        this.gameEffects.lightsOn();
        int n = 0;
        while (n < this.options.length) {
            this.options[n] = false;
            ++n;
        }
        this.options[1] = true;
        this.options[4] = true;
        this.options[7] = true;
        try {
            StringBuffer stringBuffer = new StringBuffer("DUNS");
            this.options[0] = Settings.getValue(Settings.GM_CONT, stringBuffer);
            this.options[2] = Settings.getValue(Settings.GM_LOAD, stringBuffer);
            GameEffects.soundOn = Settings.getValue(Settings.GM_SOUND, stringBuffer);
        }
        catch (RecordStoreException recordStoreException) {
            throw new IllegalArgumentException("EC:0x04");
        }
        this.options[5] = GameEffects.soundOn;
        this.options[6] = !GameEffects.soundOn;
        this.option = this.options[0] ? 0 : 1;
        this.bLoadQuik = false;
        this.bLoadGame = false;
        this.gameActionCount = 0;
        this.gameActionCurrent = 0;
    }

    void setupView() {
        byte by = (byte)(this.gameLevel + 1 >> 1);
        if (this.view == null) {
            int n = 160;
            int n2 = 140;
            if (this.gameHeight == 65) {
                n = 96;
                n2 = 70;
            }
            this.view = new View(this, n, n2, this.colBorder, this.rowBorder);
            this.view.initTile();
            this.invgfx = this.gameEffects.getGfx("/i.png");
            this.inv2gfx = this.gameEffects.getGfx("/i2.png");
            this.bggfx = this.gameEffects.getGfx("/b.png");
            int n3 = 0;
            Image image = this.gameEffects.getGfx("/1.png");
            short[] sArray = new short[64 * 64];
            this.view.convertImage(0, image, sArray, 0 << 6);
            image = null;
            if (this.gameLevel <= 3) {
                image = this.gameEffects.getGfx("/1.png");
            } else {
                image = this.gameEffects.getGfx("/2.png");
                n3 = 1;
                this.view.bigMon = true;
            }
            int n4 = 1;
            while (n4 < 4) {
                this.view.convertImage(n4, image, sArray, n4 - n3 << 6);
                ++n4;
            }
            this.view.setColorDepth();
            this.view.init();
        }
        this.view.initLevel(by);
    }

    public void changeCont(int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("DUNS");
        this.option = n;
        this.options[0] = bl;
        try {
            Settings.setValue(Settings.GM_CONT, bl, stringBuffer);
        }
        catch (RecordStoreException recordStoreException) {}
    }

    public void changeSound() {
        StringBuffer stringBuffer = new StringBuffer("DUNS");
        try {
            Settings.setValue(Settings.GM_SOUND, this.options[5], stringBuffer);
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        GameEffects.soundOn = this.options[5];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Thread thread = Thread.currentThread();
        try {
            while (true) {
                long l;
                if (thread != this.animationThread) {
                    return;
                }
                long l2 = System.currentTimeMillis();
                if (!this.isPaused) {
                    if (this.canvas.isShown()) {
                        if (!this.hasBeenShown) {
                            this.hasBeenShown = true;
                        }
                        this.tick();
                    } else if (this.hasBeenShown) {
                        this.pause();
                    }
                }
                if (this.canvas.isShown()) {
                    this.canvas.repaint(0, 0, this.gameWidth, this.gameHeight);
                    this.canvas.serviceRepaints();
                }
                if ((l = System.currentTimeMillis() - l2) < 100L) {
                    GameManager gameManager = this;
                    synchronized (gameManager) {
                        this.wait(100L - l);
                        continue;
                    }
                }
                thread.yield();
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public synchronized void start() {
        this.animationThread = new Thread(this);
        this.animationThread.start();
    }

    public synchronized void stop() {
        this.animationThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        GameManager gameManager = this;
        synchronized (gameManager) {
            this.isPaused = true;
        }
        if (this.status == 10) {
            this.status = 0;
            this.ticks = 0;
        }
        if (this.status != 0) {
            this.options[0] = true;
            this.option = 0;
        }
    }

    public synchronized boolean isPaused() {
        return this.isPaused;
    }

    void closePressed() {
        if (this.status != 6 && this.status != 5 && this.status != 4 && this.status != 10 && (this.status != 8 || this.tempStatus != 0)) {
            if (!this.isPaused) {
                this.pause();
            } else {
                if (this.option == 0 && this.status == 0) {
                    this.bLoadQuik = true;
                } else if (this.option == 0 && this.status == 7) {
                    this.ticks = 0;
                } else if (this.option == 1) {
                    this.status = 1;
                    this.options[3] = false;
                } else if (this.option == 2) {
                    this.bLoadGame = true;
                    this.gameActionCurrent = this.gameActionCount;
                    this.status = 0;
                } else if (this.option == 3) {
                    Settings.storeGame(false, this, this.view);
                }
                this.resume();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        GameManager gameManager = this;
        synchronized (gameManager) {
            this.isPaused = false;
        }
        this.gameEffects.resume();
        if (this.status == 10) {
            this.status = 0;
            this.ticks = 0;
        }
    }

    public void keyPressed(int n) {
        block55: {
            int n2;
            block56: {
                n2 = n == 49 || n == 51 || n == 55 || n == 57 || n == 42 || n == 35 ? n : this.canvas.getGameAction(n);
                this.iLastKey = n;
                if (!this.isPaused || !this.canvas.isShown()) break block56;
                if (n == -6) {
                    n2 = 8;
                }
                switch (n2) {
                    case 6: {
                        ++this.option;
                        int n3 = 0;
                        while (n3 < this.options.length) {
                            if (this.option < 0) {
                                this.option = this.options.length - 1;
                            }
                            if (this.option >= this.options.length) {
                                this.option = 0;
                            }
                            if (!this.options[this.option]) {
                                ++this.option;
                                ++n3;
                                continue;
                            }
                            break block55;
                        }
                        break block55;
                    }
                    case 1: {
                        --this.option;
                        int n4 = 0;
                        while (n4 < this.options.length) {
                            if (this.option < 0) {
                                this.option = this.options.length - 1;
                            }
                            if (this.option >= this.options.length) {
                                this.option = 0;
                            }
                            if (!this.options[this.option]) {
                                --this.option;
                                ++n4;
                                continue;
                            }
                            break block55;
                        }
                        break block55;
                    }
                    case -5: 
                    case 8: {
                        if (this.option == 0) {
                            if (this.status == 7) {
                                this.ticks = 0;
                                this.setLeft(Dictionary.OPTIONS);
                                this.setRight(Dictionary.MENU_0);
                                this.gameActionCurrent = this.gameActionCount;
                            } else if (this.status == 0) {
                                this.bLoadQuik = true;
                            }
                        } else if (this.option == 1) {
                            this.status = 1;
                            this.options[3] = false;
                        } else if (this.option == 2) {
                            this.bLoadGame = true;
                            this.bLoadQuik = false;
                            this.gameActionCurrent = this.gameActionCount;
                            this.status = 0;
                        } else if (this.option == 3) {
                            Settings.storeGame(false, this, this.view);
                            if (this.status == 7) {
                                this.ticks = 0;
                                this.setLeft(Dictionary.OPTIONS);
                                this.setRight(Dictionary.MENU_0);
                                this.gameActionCurrent = this.gameActionCount;
                            }
                        } else if (this.option == 4) {
                            if (this.status == 8) {
                                this.status = this.tempStatus;
                                this.redrawBG = true;
                                this.showHP = true;
                                this.ticks = 0;
                                this.gameActionCurrent = this.gameActionCount;
                                this.compassDirec = this.direction + 1 & 3;
                                if (this.status == 7) {
                                    this.setLeft(Dictionary.OPTIONS);
                                    this.setRight(Dictionary.MENU_0);
                                    break;
                                }
                            } else {
                                this.tempStatus = this.status;
                                this.status = 8;
                                this.ticks = 0;
                                this.gameActionCurrent = this.gameActionCount;
                            }
                        } else if (this.option == 5) {
                            this.options[5] = false;
                            this.options[6] = true;
                            this.option = 6;
                            this.changeSound();
                        } else if (this.option == 6) {
                            this.options[5] = true;
                            this.options[6] = false;
                            this.option = 5;
                            this.changeSound();
                        } else if (this.option == 7) {
                            this.midlet.exitRequested();
                        }
                        if (this.option != 5 && this.option != 6) {
                            this.resume();
                        }
                        break block55;
                    }
                }
                break block55;
            }
            if (n == -6) {
                if (this.status == 7) {
                    this.pause();
                    return;
                }
                n2 = 8;
            }
            if (n == -7) {
                if (this.status == 3 && this.view != null && this.itemSelect >= 0 && this.itemSelect == this.itemCurrent && this.invItem[this.itemSelect] != 0) {
                    this.itemCurrent = 9;
                    this.setStats();
                    this.view.dropItem(this.xMap, this.yMap, this.invItem[this.itemSelect] - 1, true);
                    this.showItem = true;
                    this.invItem[this.itemSelect] = 0;
                    this.itemCurrent = this.itemSelect;
                    this.itemSelect = -1;
                    return;
                }
                n2 = 42;
            }
            switch (n2) {
                case 1: {
                    ++this.gameActionCount;
                    this.gameActionCount &= 0x1F;
                    this.gameAction[this.gameActionCount] = 1;
                    break;
                }
                case 6: {
                    ++this.gameActionCount;
                    this.gameActionCount &= 0x1F;
                    this.gameAction[this.gameActionCount] = 2;
                    break;
                }
                case 2: {
                    ++this.gameActionCount;
                    this.gameActionCount &= 0x1F;
                    this.gameAction[this.gameActionCount] = 3;
                    break;
                }
                case 5: {
                    ++this.gameActionCount;
                    this.gameActionCount &= 0x1F;
                    this.gameAction[this.gameActionCount] = 4;
                    break;
                }
                case -5: 
                case 8: {
                    ++this.gameActionCount;
                    this.gameActionCount &= 0x1F;
                    this.gameAction[this.gameActionCount] = 5;
                    break;
                }
                case 49: 
                case 55: {
                    ++this.gameActionCount;
                    this.gameActionCount &= 0x1F;
                    this.gameAction[this.gameActionCount] = 6;
                    break;
                }
                case 51: 
                case 57: {
                    ++this.gameActionCount;
                    this.gameActionCount &= 0x1F;
                    this.gameAction[this.gameActionCount] = 7;
                    break;
                }
                case 42: {
                    if (this.status == 2) {
                        this.itemSelect = -1;
                        this.itemCurrent = 0;
                        this.status = 3;
                        this.setRight(Dictionary.BACK);
                        break;
                    }
                    if (this.status == 3) {
                        this.status = 2;
                        this.setRight(Dictionary.INV);
                        this.ticks = 0;
                        this.gameActionCount = this.gameActionCurrent;
                        break;
                    }
                    if (this.status != 7) break;
                    this.status = 2;
                    this.setRight(Dictionary.INV);
                    this.ticks = 0;
                    this.gameActionCount = this.gameActionCurrent;
                    break;
                }
                case 35: {
                    if (this.status == 7) {
                        this.status = 2;
                        this.setRight(Dictionary.INV);
                        this.ticks = 0;
                        this.gameActionCount = this.gameActionCurrent;
                        break;
                    }
                    this.status = 7;
                    this.setLeft(Dictionary.OPTIONS);
                    this.setRight(Dictionary.MENU_0);
                    this.ticks = 0;
                    this.gameActionCount = this.gameActionCurrent;
                }
            }
        }
    }

    public void manHit(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            n2 = this.calcHit(n2, n4, this.iDef, 10, false, true);
        }
        this.HP -= n2;
        this.showHP = true;
        if (this.HP < 0) {
            this.HP = 0;
            this.changeCont(1, false);
            this.options[3] = false;
            this.status = 4;
            this.ticks = 0;
        }
        n = n - this.direction & 3;
        switch (n) {
            case 0: {
                this.showBlood[2][0] = n2;
                this.showBlood[2][1] = n3;
                break;
            }
            case 1: {
                this.showBlood[3][0] = n2;
                this.showBlood[3][1] = n3;
                break;
            }
            case 2: {
                this.showBlood[0][0] = n2;
                this.showBlood[0][1] = n3;
                break;
            }
            case 3: {
                this.showBlood[1][0] = n2;
                this.showBlood[1][1] = n3;
            }
        }
        if (n2 > 0) {
            this.gameEffects.playHit();
        }
    }

    public int calcHit(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = bl && this.view.scrolls[2] > 0 ? n - n3 >> 1 : 0;
        n = Util.getRandomInt(n5, n - (n3 = bl2 && this.view.scrolls[1] > 0 ? n3 + (n3 >> 1) : n3) + n5);
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    private void tick() {
        switch (this.status) {
            case 10: {
                if (this.splgfx == null && this.ticks == 0) {
                    this.splgfx = this.gameEffects.getGfx("/p.png");
                }
                ++this.ticks;
                if (this.ticks < 20 && this.gameActionCount == this.gameActionCurrent) break;
                this.status = 0;
                break;
            }
            case 0: {
                this.splgfx = null;
                if (this.view != null) {
                    this.view.floor = null;
                    this.view.view = null;
                    this.view.color = null;
                    this.view.gfx = null;
                    this.view = null;
                }
                this.invgfx = null;
                this.inv2gfx = null;
                this.bggfx = null;
                this.options[4] = true;
                if (this.menugfx == null && !this.bLoadQuik && !this.bLoadGame) {
                    this.menugfx = this.gameEffects.getGfx("/s.png");
                    ++this.ticks;
                    this.setRight(Dictionary.OPTIONS);
                    this.pause();
                    break;
                }
                this.status = 1;
                this.options[3] = false;
                break;
            }
            case 1: {
                if (this.view != null) {
                    this.view.floor = null;
                    this.view.view = null;
                    this.view.color = null;
                    this.view.gfx = null;
                    this.view = null;
                }
                this.menugfx = null;
                this.gameLevel = 1;
                int n = 0;
                while (n < 16) {
                    this.invItem[n] = 0;
                    ++n;
                }
                this.HP = 32;
                this.maxHP = 63;
                this.iDex = 10;
                this.iDef = 5;
                this.iAtt = 6;
                this.status = 5;
                this.gameActionCount = 0;
                this.gameActionCurrent = 0;
                this.ticks = 0;
                break;
            }
            case 5: {
                if (this.gameActionCount != this.gameActionCurrent) {
                    ++this.gameActionCurrent;
                    this.gameActionCurrent &= 0x1F;
                    if (this.gameAction[this.gameActionCurrent] == 5) {
                        this.ticks = 10;
                        this.bShowStory = false;
                    }
                }
                if (!(this.ticks >= 10 && !this.bShowStory || this.bLoadQuik || this.bLoadGame)) {
                    if (this.ticks != 0) break;
                    int n = 0;
                    try {
                        DataInputStream dataInputStream = new DataInputStream(this.getClass().getResourceAsStream(String.valueOf(String.valueOf(new StringBuffer("/").append(this.gameLevel).append(".txt")))));
                        n = 370;
                        this.bStory = new byte[n];
                        dataInputStream.readFully(this.bStory);
                        this.bShowStory = true;
                    }
                    catch (EOFException eOFException) {
                    }
                    catch (Exception exception) {
                        this.bStory = new byte[n];
                        this.ticks = this.gameHeight << 2;
                        this.bShowStory = false;
                    }
                    ++this.ticks;
                    break;
                }
                if (this.gameLevel == 6) {
                    this.gameActionCurrent = this.gameActionCount;
                    this.status = 0;
                    this.ticks = 0;
                    break;
                }
                if (this.bLoadQuik || this.bLoadGame) {
                    Settings.getGame(this.bLoadQuik, this, null, false);
                }
                if (this.gameLevel == 6) {
                    this.bLoadQuik = false;
                    this.bLoadGame = false;
                    this.status = 5;
                    this.ticks = 0;
                    break;
                }
                this.bStory = null;
                this.setupView();
                int n = 0;
                while (n < 4) {
                    this.showBlood[n][0] = 0;
                    this.showBlood[n][1] = 0;
                    ++n;
                }
                if ((this.bLoadQuik || this.bLoadGame) && this.status != 6) {
                    Settings.getGame(this.bLoadQuik, this, this.view, true);
                } else {
                    if (this.gameLevel != 1 || this.status == 6) {
                        n = 0;
                        while (n < 16) {
                            if (this.invItem[n] != 0) {
                                this.view.itemType[48 - 16 + n] = this.invItem[n];
                                this.view.itemX[48 - 16 + n] = 65;
                                this.invItem[n] = (byte)(48 - 16 + n + 1);
                            }
                            ++n;
                        }
                    }
                    this.iHit = -1;
                    this.iRecovery = 0;
                }
                this.view.createMap((this.bLoadQuik || this.bLoadGame) && this.status != 6);
                this.bLoadQuik = false;
                this.bLoadGame = false;
                this.itemCurrent = 0;
                this.itemSelect = -1;
                this.gameActionCount = 0;
                this.gameActionCurrent = 0;
                this.redrawBG = this.availBG;
                this.showHP = true;
                this.showText = 0;
                this.textTimer = 0;
                this.showItem = false;
                this.compassDirec = this.direction + 1 & 3;
                this.options[3] = true;
                this.status = 2;
                this.setRight(Dictionary.INV);
                break;
            }
            case 6: {
                ++this.ticks;
                if (this.ticks > 30 || this.gameActionCurrent != this.gameActionCount && this.ticks > 20) {
                    this.gameLevel = (byte)(this.gameLevel + 1);
                    if (this.view != null) {
                        this.view.floor = null;
                        this.view.view = null;
                        this.view.color = null;
                        this.view.gfx = null;
                        this.view = null;
                    }
                    this.status = 5;
                    this.gameActionCount = 0;
                    this.gameActionCurrent = 0;
                    this.ticks = 0;
                    break;
                }
                this.gameActionCurrent = this.gameActionCount;
                break;
            }
            case 2: {
                int n;
                int n2 = this.xMap;
                int n3 = this.yMap;
                int n4 = this.xMap;
                int n5 = this.yMap;
                if (this.iRecovery > 0) {
                    --this.iRecovery;
                }
                if (this.gameActionCurrent != this.gameActionCount) {
                    ++this.gameActionCurrent;
                    this.gameActionCurrent &= 0x1F;
                    if (this.gameAction[this.gameActionCurrent] == 1) {
                        if (this.direction == 0) {
                            --n5;
                        } else if (this.direction == 1) {
                            ++n4;
                        } else if (this.direction == 2) {
                            ++n5;
                        } else if (this.direction == 3) {
                            --n4;
                        }
                    }
                    if (this.gameAction[this.gameActionCurrent] == 2) {
                        if (this.direction == 0) {
                            ++n5;
                        } else if (this.direction == 1) {
                            --n4;
                        } else if (this.direction == 2) {
                            --n5;
                        } else if (this.direction == 3) {
                            ++n4;
                        }
                    }
                    if (this.gameAction[this.gameActionCurrent] == 6) {
                        if (this.direction == 0) {
                            --n4;
                        } else if (this.direction == 1) {
                            --n5;
                        } else if (this.direction == 2) {
                            ++n4;
                        } else if (this.direction == 3) {
                            ++n5;
                        }
                    }
                    if (this.gameAction[this.gameActionCurrent] == 7) {
                        if (this.direction == 0) {
                            ++n4;
                        } else if (this.direction == 1) {
                            ++n5;
                        } else if (this.direction == 2) {
                            --n4;
                        } else if (this.direction == 3) {
                            --n5;
                        }
                    }
                    if (!(this.xMap == n4 && this.yMap == n5 || this.view.moveCollision(n4, n5))) {
                        this.xMap = n4;
                        this.yMap = n5;
                        this.showText = 0;
                    }
                    if (this.gameAction[this.gameActionCurrent] == 3) {
                        --this.direction;
                        if (this.direction < 0) {
                            this.direction = 3;
                        }
                        this.showText = 0;
                    }
                    if (this.gameAction[this.gameActionCurrent] == 4) {
                        ++this.direction;
                        if (this.direction > 3) {
                            this.direction = 0;
                        }
                        this.showText = 0;
                    }
                    if (this.gameAction[this.gameActionCurrent] == 5) {
                        int n6 = this.iRecovery != 0 ? 0 : this.view.attackMon(this.xMap, this.yMap, this.iAtt, this.iDex, false);
                        if (n6 == -1) {
                            if (this.view.doorOpenClose(this.xMap, this.yMap, false) == 0) {
                                this.showText = this.view.checkSpecial(this.xMap, this.yMap, false);
                                if (this.showText != 0) {
                                    this.textTimer = 30;
                                }
                                this.showItem = (this.view.mapItem[this.xMap][this.yMap] & 1) != 0;
                            }
                        } else if (this.iRecovery <= 0) {
                            this.iHit = n6;
                            this.iRecovery = this.iDex;
                            this.gameEffects.playSwoosh();
                        }
                    }
                }
                if (this.xMap == this.xEnd && this.yMap == this.yEnd) {
                    this.options[3] = false;
                    this.status = 6;
                    n = 0;
                    while (n < 16) {
                        if (this.invItem[n] != 0) {
                            this.invItem[n] = this.view.itemType[this.invItem[n] - 1];
                        }
                        if (this.invItem[n] == 49) {
                            this.invItem[n] = 0;
                        }
                        ++n;
                    }
                    Settings.storeGame(true, this, this.view);
                    this.ticks = 0;
                } else {
                    if (this.xMap != n2 | this.yMap != n3) {
                        this.view.checkMap(n2, n3, false);
                        this.showItem = this.view.checkMap(this.xMap, this.yMap, true);
                    }
                    this.view.doorUpdate();
                    this.view.lineOfSite(this.xMap, this.yMap, this.direction);
                    this.view.ai();
                }
                if (this.view.attackMon(this.xMap, this.yMap, this.iAtt, this.iDex, true) == 1) {
                    this.setLeft(Dictionary.ATTACK);
                    break;
                }
                n = this.view.doorOpenClose(this.xMap, this.yMap, true);
                if (n != 0) {
                    this.setLeft(n += Dictionary.OPTIONS);
                    break;
                }
                n = this.view.checkSpecial(this.xMap, this.yMap, true);
                if (n != 0) {
                    n += Dictionary.ATTACK;
                }
                this.setLeft(n);
                break;
            }
            case 3: {
                if (this.gameActionCurrent != this.gameActionCount) {
                    ++this.gameActionCurrent;
                    this.gameActionCurrent &= 0x1F;
                    if (this.gameAction[this.gameActionCurrent] == 1) {
                        this.itemCurrent = this.itemCurrent == 0 || this.itemCurrent == 1 || this.itemCurrent == 8 || this.itemCurrent == 9 ? (this.itemCurrent += 6) : (this.itemCurrent -= 2);
                    }
                    if (this.gameAction[this.gameActionCurrent] == 2) {
                        this.itemCurrent = this.itemCurrent == 6 || this.itemCurrent == 7 || this.itemCurrent == 14 || this.itemCurrent == 15 ? (this.itemCurrent -= 6) : (this.itemCurrent += 2);
                    }
                    if (this.gameAction[this.gameActionCurrent] == 3) {
                        this.itemCurrent = (this.itemCurrent & 9) == 0 ? (this.itemCurrent += 9) : ((this.itemCurrent & 9) == 8 ? (this.itemCurrent -= 7) : --this.itemCurrent);
                    }
                    if (this.gameAction[this.gameActionCurrent] == 4) {
                        this.itemCurrent = (this.itemCurrent & 9) == 1 ? (this.itemCurrent += 7) : ((this.itemCurrent & 9) == 9 ? (this.itemCurrent -= 9) : ++this.itemCurrent);
                    }
                    if (this.gameAction[this.gameActionCurrent] == 5) {
                        if (this.itemCurrent == 9) {
                            this.status = 7;
                            this.setLeft(Dictionary.OPTIONS);
                            this.setRight(Dictionary.MENU_0);
                            this.ticks = 0;
                            this.gameActionCount = this.gameActionCurrent;
                            break;
                        }
                        int n = -1;
                        int n7 = -1;
                        int n8 = this.itemCurrent;
                        boolean bl = false;
                        if (this.itemSelect == -1) {
                            if (this.itemCurrent != 9) {
                                this.itemSelect = this.itemCurrent;
                            }
                        } else if (this.itemSelect == this.itemCurrent) {
                            if (this.itemCurrent == 12) {
                                this.showHand = true;
                            }
                            if (this.invItem[this.itemCurrent] == 0) {
                                this.itemSelect = -1;
                            } else if (this.itemSelect < 8) {
                                int n9 = n = this.invItem[this.itemSelect] == 0 ? -1 : this.view.itemType[this.invItem[this.itemSelect] - 1] - 1 >> 3;
                                if (n == 4) {
                                    this.itemCurrent = this.invItem[13] == 0 ? 13 : 14;
                                } else {
                                    int n10 = this.itemCurrent = n == 5 ? this.itemSelect : this.itemHold[n];
                                }
                                if (this.itemCurrent > 15) {
                                    this.itemCurrent = this.itemSelect;
                                } else {
                                    n7 = this.invItem[this.itemCurrent] == 0 ? -1 : this.view.itemType[this.invItem[this.itemCurrent] - 1] - 1 >> 3;
                                    bl = true;
                                }
                            } else {
                                this.itemCurrent = 9;
                                bl = true;
                            }
                        } else {
                            n = this.invItem[this.itemSelect] == 0 ? -1 : this.view.itemType[this.invItem[this.itemSelect] - 1] - 1 >> 3;
                            n7 = this.invItem[this.itemCurrent] == 0 ? -1 : this.view.itemType[this.invItem[this.itemCurrent] - 1] - 1 >> 3;
                            bl = true;
                            if ((this.itemCurrent >= 8 || this.itemSelect >= 8) && this.itemCurrent != 9) {
                                if (n == 4 && this.itemCurrent != 13 && this.itemCurrent != 14) {
                                    bl = false;
                                } else if (n != -1 && this.itemCurrent >= 8 && this.itemCurrent != this.itemHold[n]) {
                                    bl = false;
                                }
                                if (n7 == 4 && this.itemSelect != 13 && this.itemSelect != 14) {
                                    bl = false;
                                } else if (n7 != -1 && this.itemSelect >= 8 && this.itemSelect != this.itemHold[n7]) {
                                    bl = false;
                                }
                            }
                        }
                        if (bl) {
                            if (this.itemCurrent == 12 || this.itemSelect == 12) {
                                this.showHand = true;
                            }
                            if (n == 5 && this.itemCurrent == this.itemSelect) {
                                if (this.HP < this.maxHP) {
                                    this.invItem[this.itemSelect] = 0;
                                    this.HP += 10;
                                    if (this.HP > this.maxHP) {
                                        this.HP = this.maxHP;
                                    }
                                    this.showHP = true;
                                }
                            } else if (this.itemCurrent == 9) {
                                this.setStats();
                                this.view.dropItem(this.xMap, this.yMap, this.invItem[this.itemSelect] - 1, true);
                                this.showItem = true;
                                this.invItem[this.itemSelect] = 0;
                                this.itemSelect = -1;
                            } else {
                                this.setStats();
                                byte by = this.invItem[this.itemCurrent];
                                this.invItem[this.itemCurrent] = this.invItem[this.itemSelect];
                                this.invItem[this.itemSelect] = by;
                            }
                            this.itemSelect = -1;
                            this.itemCurrent = n8;
                        }
                    }
                }
                if (this.itemCurrent == 9) {
                    this.setLeft(Dictionary.MAP);
                    this.setRight(Dictionary.BACK);
                    break;
                }
                if (this.itemSelect == -1) {
                    this.setLeft(Dictionary.SELECT);
                    this.setRight(Dictionary.BACK);
                    break;
                }
                if (this.itemSelect == this.itemCurrent) {
                    if (this.itemSelect < 8) {
                        this.setLeft(Dictionary.USE);
                    } else {
                        this.setLeft(Dictionary.DROP);
                    }
                    if (this.invItem[this.itemSelect] != 0) {
                        this.setRight(Dictionary.DROP);
                        break;
                    }
                    this.setRight(Dictionary.BACK);
                    break;
                }
                this.setLeft(Dictionary.MOVE);
                if (this.invItem[this.itemSelect] != 0) {
                    this.setRight(Dictionary.DROP);
                    break;
                }
                this.setRight(Dictionary.BACK);
                break;
            }
            case 7: {
                ++this.ticks;
                if (this.ticks != 258) break;
                this.ticks = 2;
                break;
            }
            case 4: {
                int n = 0;
                while (n < this.view.xSize / 5) {
                    this.view.itemType[n] = this.ticks < 8 ? (byte)0 : (byte)(this.view.itemType[n] + Util.getRandomInt(0, 2));
                    ++n;
                }
                ++this.ticks;
                if (this.ticks < 60) break;
                this.gameActionCurrent = this.gameActionCount;
                this.status = 0;
                this.ticks = 0;
                break;
            }
            case 8: {
                if (this.gameActionCurrent != this.gameActionCount) {
                    ++this.gameActionCurrent;
                    this.gameActionCurrent &= 0x1F;
                    if (this.gameAction[this.gameActionCurrent] == 1) {
                        --this.ticks;
                    }
                    if (this.gameAction[this.gameActionCurrent] == 2 & !this.bEnd) {
                        ++this.ticks;
                    }
                    if (this.gameAction[this.gameActionCurrent] == 5) {
                        this.status = this.tempStatus;
                        if (this.status == 0) {
                            this.pause();
                        }
                        if (this.status == 7) {
                            this.setLeft(Dictionary.OPTIONS);
                            this.setRight(Dictionary.MENU_0);
                        }
                        this.gameActionCount = this.gameActionCurrent;
                        this.ticks = 0;
                    }
                    this.redrawBG = true;
                    this.showHP = true;
                }
                if (this.ticks >= 0) break;
                this.ticks = 0;
            }
        }
    }

    public void setStats() {
        int n;
        int n2;
        int n3;
        int n4 = this.invItem[this.itemSelect] == 0 ? -1 : this.view.itemType[this.invItem[this.itemSelect] - 1] - 1 >> 3;
        int n5 = n3 = this.invItem[this.itemCurrent] == 0 ? -1 : this.view.itemType[this.invItem[this.itemCurrent] - 1] - 1 >> 3;
        if (n4 >= 0 && this.itemCurrent >= 8 && this.itemCurrent != 9 && this.itemSelect < 8 || n3 >= 0 && this.itemSelect >= 8 && this.itemCurrent < 8) {
            n2 = this.itemCurrent >= 8 ? this.view.itemType[this.invItem[this.itemSelect] - 1] - 1 & 7 : this.view.itemType[this.invItem[this.itemCurrent] - 1] - 1 & 7;
            int n6 = n = this.itemCurrent >= 8 ? n4 : n3;
            if (n == 0 || n == 7) {
                this.iDef += this.view.helmet[n2 + n2];
                this.iDex -= this.view.helmet[n2 + n2 + 1];
            } else if (n == 1) {
                this.iAtt += this.view.sword[n2 + n2];
                this.iDex -= this.view.sword[n2 + n2 + 1];
            } else if (n == 2 || n == 3) {
                this.iDef += this.view.sword[n2 + n2];
                this.iDex -= this.view.sword[n2 + n2 + 1];
            } else if (n == 4) {
                this.iAtt += this.view.ring[n2 + n2 + n2];
                this.iDef += this.view.ring[n2 + n2 + n2 + 1];
                this.iDex -= this.view.ring[n2 + n2 + n2 + 2];
            }
        }
        if (n4 >= 0 && this.itemSelect >= 8 && (this.itemCurrent < 8 || this.itemCurrent == 9) || n3 >= 0 && this.itemCurrent >= 8 && this.itemSelect < 8) {
            n2 = this.itemSelect >= 8 ? this.view.itemType[this.invItem[this.itemSelect] - 1] - 1 & 7 : this.view.itemType[this.invItem[this.itemCurrent] - 1] - 1 & 7;
            int n7 = n = this.itemSelect >= 8 ? n4 : n3;
            if (n == 0 || n == 7) {
                this.iDef -= this.view.helmet[n2 + n2];
                this.iDex += this.view.helmet[n2 + n2 + 1];
            } else if (n == 1) {
                this.iAtt -= this.view.sword[n2 + n2];
                this.iDex += this.view.sword[n2 + n2 + 1];
            } else if (n == 2 || n == 3) {
                this.iDef -= this.view.sword[n2 + n2];
                this.iDex += this.view.sword[n2 + n2 + 1];
            } else if (n == 4) {
                this.iAtt -= this.view.ring[n2 + n2 + n2];
                this.iDef -= this.view.ring[n2 + n2 + n2 + 1];
                this.iDex += this.view.ring[n2 + n2 + n2 + 2];
            }
        }
    }

    public void setLeft(int n) {
        if (this.iLeft != n) {
            this.iLeft = n;
            this.newHelp = true;
        }
    }

    public void setRight(int n) {
        if (this.iRight != n) {
            this.iRight = n;
            this.newHelp = true;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void paint(Graphics var1_1) {
        block109: {
            block110: {
                block111: {
                    var1_1.setFont(GameManager.GAME_FONT);
                    if (this.status == 10 && this.splgfx != null && this.ticks <= 1) {
                        var1_1.setClip(0, 0, this.gameWidth, this.gameHeight);
                        var1_1.setColor(255, 255, 255);
                        var1_1.fillRect(0, 0, this.gameWidth, this.gameHeight);
                        var1_1.drawImage(this.splgfx, this.gameWidth >> 1, this.gameHeight >> 1, 3);
                    }
                    if (this.status == 0) {
                        var1_1.setClip(0, 0, this.gameWidth, this.gameHeight);
                        this.bgColor[0] = 0;
                        this.bgColor[1] = 0;
                        this.bgColor[2] = 0;
                        var1_1.setColor(this.bgColor[0], this.bgColor[1], this.bgColor[2]);
                        var1_1.fillRect(0, 0, this.gameWidth, this.gameHeight);
                        if (this.menugfx != null) {
                            var1_1.drawImage(this.menugfx, this.gameWidth >> 1, 0, 17);
                        }
                    }
                    if (this.isPaused && !this.redrawAll) break block109;
                    if (this.status == 6) {
                        var1_1.setClip(0, 0, this.gameWidth, this.gameHeight);
                        var1_1.setColor(0, 0, 0);
                        if (this.ticks <= 8) {
                            var2_2 = 0;
                            while (var2_2 < this.view.xSize >> 3) {
                                if (this.ticks + (var2_2 << 3) < this.view.xSize) {
                                    var1_1.drawLine(this.colBorder + this.ticks + (var2_2 << 3), this.rowBorder, this.colBorder + this.ticks + (var2_2 << 3), this.rowBorder + this.view.ySize - 1);
                                }
                                ++var2_2;
                            }
                        } else {
                            var2_2 = 0;
                            var3_3 = 0;
                            while (var3_3 < this.view.totSecret) {
                                if (this.view.secretFound[var3_3] == 1) {
                                    ++var2_2;
                                }
                                ++var3_3;
                            }
                            var4_6 = new StringBuffer("");
                            var4_6.append(var2_2);
                            var4_6.append(this.dict.getString(Dictionary.OF));
                            var4_6.append(this.view.totSecret);
                            this.drawSmallText(var1_1, this.gameWidth >> 1, this.rowBorder + (this.view.ySize >> 1) - (GameManager.fontHeight << 1), var4_6, 0);
                            var4_6 = null;
                            var4_6 = new StringBuffer(this.dict.getString(Dictionary.SECRETS_FOUND));
                            this.drawSmallText(var1_1, this.gameWidth >> 1, this.rowBorder + (this.view.ySize >> 1) - GameManager.fontHeight, var4_6, 0);
                            var4_6 = null;
                            var4_6 = new StringBuffer(this.dict.getString(Dictionary.LEVEL_COMPLETE));
                            this.drawSmallText(var1_1, this.gameWidth >> 1, this.rowBorder + (this.view.ySize >> 1) + GameManager.fontHeight, var4_6, 0);
                        }
                    } else if (this.status == 5 && this.ticks != 0) {
                        var1_1.setClip(0, 0, this.gameWidth, this.gameHeight);
                        this.bgColor[0] = 0;
                        this.bgColor[1] = 0;
                        this.bgColor[2] = 0;
                        var1_1.setColor(this.bgColor[0], this.bgColor[1], this.bgColor[2]);
                        var1_1.fillRect(0, 0, this.gameWidth, this.gameHeight);
                        var1_1.setColor(255, 255, 255);
                        if (!this.isPaused) {
                            if (this.bStory == null) {
                                return;
                            }
                            var2_2 = 2;
                            var3_3 = 2;
                            var4_7 = var2_2;
                            var5_15 = var3_3;
                            var6_16 = this.bStory.length;
                            var9_20 = 3;
                            var10_22 = new StringBuffer("");
                            while (var9_20 < var6_16) {
                                if ((var7_24 = this.bStory[var9_20++]) == 32 || var7_24 == 13 || var7_24 == 44 || var7_24 == 10) {
                                    var1_1.drawString(var10_22.toString(), var4_7, var5_15, 20);
                                    if (var7_24 == 32) {
                                        var4_7 += GameManager.GAME_FONT.stringWidth(var10_22.toString()) + 4;
                                    }
                                    if (var7_24 == 13) {
                                        var4_7 = var2_2;
                                        var5_15 += GameManager.fontHeight << 1;
                                    }
                                    if (var7_24 == 44) {
                                        var4_7 = var2_2;
                                        var5_15 += GameManager.fontHeight;
                                    }
                                    var10_22 = null;
                                    var10_22 = new StringBuffer("");
                                    continue;
                                }
                                var10_22.append((char)var7_24);
                                if (var4_7 + GameManager.GAME_FONT.stringWidth(var10_22.toString()) <= this.gameWidth - 4) continue;
                                var4_7 = var2_2;
                                var5_15 += GameManager.fontHeight;
                            }
                        }
                        this.setLeft(Dictionary.MENU_0);
                        this.newHelp = true;
                    } else if (this.status == 2 || this.status == 4 && this.ticks == 0 || this.status == 7 && this.ticks == 1) {
                        if (this.redrawBG) {
                            this.drawBackground(var1_1);
                        }
                        if (this.clrInvTxt) {
                            if (this.availBG) {
                                var1_1.setColor(0, 0, 0);
                                var1_1.fillRect(this.colBorder, 90, this.gameWidth - (this.colBorder << 1), 14);
                            }
                            this.clrInvTxt = false;
                        }
                        this.view.getMap(this.direction, this.xMap, this.yMap);
                        var1_1.setClip(0, 0, this.gameWidth, this.gameHeight);
                        this.view.floorToView();
                        this.view.getRayCast();
                        this.view.doRayCast();
                        this.view.getObjectMap(this.direction);
                        this.view.showView(var1_1);
                        if (this.showItem) {
                            var1_1.setClip(this.itemX, this.itemY, 24, 20);
                            var1_1.drawImage(this.invgfx, this.itemX - 24, this.itemY - 124, 20);
                            this.clearItem = true;
                        } else if (this.clearItem) {
                            if (this.availBG) {
                                var1_1.setClip(this.itemX, this.itemY, 24, 20);
                                var1_1.drawImage(this.bggfx, this.colBorder, this.view.ySize + this.rowBorder + 2, 20);
                            }
                            this.clearItem = false;
                        }
                        if (this.iRecovery > 0) {
                            var2_2 = this.gameWidth - 16 >> 1;
                            var3_4 = (this.view.ySize - 16 >> 1) + this.view.yLoc;
                            var1_1.setClip(var2_2, var3_4, 16, 16);
                            var1_1.drawImage(this.invgfx, var2_2 - 48, var3_4 - 120, 20);
                            var4_8 = new StringBuffer("");
                            var4_8.append(this.iHit);
                            var1_1.setClip(var2_2 - 8, var3_4 - 9, 32, 32);
                            var1_1.setColor(255, 255, 255);
                            var1_1.drawString(var4_8.toString(), var2_2 + 8, var3_4 + 9 - (GameManager.fontHeight >> 1), 17);
                        }
                        if (this.compassDirec != this.direction || this.gameHeight == 65) {
                            this.compassDirec = this.direction;
                            var2_2 = this.view.xLoc + 83;
                            var3_4 = this.view.yLoc + this.view.ySize + 15;
                            var1_1.setClip(var2_2, var3_4, 13, 13);
                            var1_1.drawImage(this.bggfx, var2_2 -= this.compassDirec * 13, var3_4 - 32, 20);
                        }
                        if (this.showText != 0) {
                            var2_2 = this.availBG != false ? this.view.yLoc + this.view.ySize - (GameManager.fontHeight + 2) : this.gameHeight - 5;
                            var3_5 = new StringBuffer("");
                            var3_5.append(this.dict.getString(this.showText));
                            this.drawSmallText(var1_1, this.gameWidth >> 1, var2_2, var3_5, 0);
                            this.clrInvTxt = true;
                            if (this.textTimer == 0) {
                                this.showText = 0;
                            } else {
                                --this.textTimer;
                            }
                        }
                        var2_2 = this.view.xLoc + this.view.xSize - 12;
                        var3_3 = this.colBorder + 2;
                        var4_9 = 0;
                        while (var4_9 < this.view.scrolls.length) {
                            var1_1.setClip(var2_2, var3_3, 12, 12);
                            if (this.view.scrolls[var4_9] > 16 || (this.view.scrolls[var4_9] & 2) != 0) {
                                var1_1.drawImage(this.invgfx, var2_2 - (var4_9 & 1) * 12, var3_3 - (72 + (var4_9 >> 1) * 12), 20);
                            }
                            if (this.view.scrolls[var4_9] != 0) {
                                v0 = var4_9;
                                this.view.scrolls[v0] = (byte)(this.view.scrolls[v0] - 1);
                                var3_3 += 12;
                            }
                            ++var4_9;
                        }
                    } else if (this.status == 3) {
                        if (this.redrawBG) {
                            this.drawBackground(var1_1);
                        }
                        this.view.showView(var1_1);
                        this.drawInv(var1_1);
                    } else if (this.status == 4 && this.ticks != 0) {
                        var2_2 = 0;
                        while (var2_2 <= this.view.xSize / 5) {
                            var3_3 = var2_2 * 5 + this.colBorder;
                            var4_10 = var3_3 + 5;
                            var5_15 = this.availBG != false ? this.view.itemType[var2_2] + this.rowBorder : this.view.itemType[var2_2];
                            var6_16 = var5_15 - 5;
                            if (var6_16 < this.rowBorder) {
                                var1_1.setClip(var3_3, this.rowBorder, 5, var5_15 - this.rowBorder);
                            } else {
                                var1_1.setClip(var3_3, var6_16, 5, 5);
                            }
                            var1_1.drawImage(this.invgfx, var3_3 - 54, var6_16 - 110, 20);
                            ++var2_2;
                        }
                    }
                    if (this.status == 3 || this.status == 2 || this.status == 4 && this.ticks == 0 || this.status == 7 && this.ticks == 1) {
                        if (this.showHand && this.availBG) {
                            this.drawHand(var1_1);
                            this.showHand = false;
                        }
                        if (this.showHP || !this.availBG) {
                            if (this.availBG) {
                                var2_2 = this.view.yLoc + 4;
                                var3_3 = this.view.yLoc + this.view.ySize + 26;
                                var1_1.setClip(var2_2, var3_3, 32, 4);
                                if (this.HP > 0) {
                                    if (this.HP > 32) {
                                        var1_1.setColor(0, 255, 0);
                                    } else if (this.HP > 16) {
                                        var1_1.setColor(255, 255, 0);
                                    } else {
                                        var1_1.setColor(255, 0, 0);
                                    }
                                    var1_1.fillRect(var2_2, var3_3, this.HP >> 2, 4);
                                }
                                if (this.HP < 64) {
                                    var1_1.setColor(0, 0, 0);
                                    var1_1.fillRect(var2_2 + (this.HP >> 2), var3_3, 16 - (this.HP >> 2), 4);
                                }
                            } else if (this.status != 3) {
                                var1_1.setClip(0, 16, 16, 2);
                                var1_1.setColor(0, 0, 0);
                                var1_1.fillRect(0, 16, 16, 2);
                                if (this.HP > 32) {
                                    var1_1.setColor(0, 255, 0);
                                } else if (this.HP > 16) {
                                    var1_1.setColor(255, 255, 0);
                                } else {
                                    var1_1.setColor(255, 0, 0);
                                }
                                var1_1.fillRect(0, 16, this.HP >> 2, 4);
                            }
                            this.showHP = false;
                        }
                        if (this.status != 3) {
                            var2_2 = 4;
                            var3_3 = 0;
                            while (var3_3 < 4) {
                                if (this.showBlood[var3_3][1] > 0) {
                                    var4_11 = this.availBG != false ? this.view.xLoc + 4 : 0;
                                    var5_15 = this.availBG != false ? this.view.yLoc + this.view.ySize + 6 : 0;
                                    switch (var3_3) {
                                        case 0: {
                                            var5_15 -= var2_2;
                                            break;
                                        }
                                        case 1: {
                                            var4_11 += var2_2;
                                            break;
                                        }
                                        case 2: {
                                            var5_15 += var2_2;
                                            break;
                                        }
                                        case 3: {
                                            var4_11 -= var2_2;
                                        }
                                    }
                                    var1_1.setClip(var4_11, var5_15, 16, 16);
                                    if (this.showBlood[var3_3][1] == 1) {
                                        if (this.availBG) {
                                            var1_1.drawImage(this.bggfx, this.colBorder, this.view.ySize + this.rowBorder + 2, 20);
                                        }
                                    } else {
                                        var1_1.drawImage(this.invgfx, var4_11 - 48, var5_15 - 120, 20);
                                        var6_17 = new StringBuffer("");
                                        var6_17.append(this.showBlood[var3_3][0]);
                                        var1_1.setClip(var4_11 - 8, var5_15 - 9, 32, 32);
                                        var1_1.setColor(255, 255, 255);
                                        var1_1.drawString(var6_17.toString(), var4_11 + 8, var5_15 + 9 - (GameManager.fontHeight >> 1), 17);
                                    }
                                    v1 = this.showBlood[var3_3];
                                    v1[1] = v1[1] - 1;
                                    if (var3_3 == 2 && this.showBlood[var3_3][1] == 0) {
                                        this.showHP = true;
                                    }
                                }
                                ++var3_3;
                            }
                        }
                    }
                    if (this.status != 7) break block110;
                    var2_2 = 3;
                    var3_3 = this.view.xLoc + (this.view.xSize - 32 * var2_2 >> 2) * 3;
                    var4_12 = this.view.yLoc + (this.view.ySize - 32 * var2_2 >> 1);
                    if (var4_12 < 0) {
                        var4_12 = 0;
                    }
                    var1_1.setClip(0, 0, this.gameWidth, this.gameHeight);
                    if (this.ticks != 1) break block111;
                    var1_1.setColor(0, 128, 54);
                    var1_1.fillRect(var3_3, var4_12, 32 * 3, 32 * 3);
                    var5_15 = 0;
                    while (var5_15 <= 12) {
                        var1_1.setColor(0, 160, 54);
                        var1_1.drawLine(var3_3, var4_12 + (var5_15 << 3), var3_3 + 32 * 3, var4_12 + (var5_15 << 3));
                        var1_1.drawLine(var3_3 + (var5_15 << 3), var4_12, var3_3 + (var5_15 << 3), var4_12 + 32 * 3);
                        ++var5_15;
                    }
                    var6_18 = 0;
                    if (true) ** GOTO lbl321
                    do {
                        var7_24 = 0;
                        if (true) ** GOTO lbl318
                        do {
                            block112: {
                                block115: {
                                    block117: {
                                        block116: {
                                            block114: {
                                                block113: {
                                                    if ((this.view.mapItem[var7_24][var6_18] & 4) == 0) break block112;
                                                    var8_25 = this.view.mapOne[var7_24 + (var6_18 << 5)];
                                                    if ((var8_25 & 17) == 0) break block113;
                                                    if ((var8_25 & 17) == 17) {
                                                        var1_1.setColor(255, 255, 255);
                                                    } else {
                                                        var1_1.setColor(172, 211, 115);
                                                    }
                                                    var1_1.fillRect(var7_24 + var7_24 + var7_24 + var3_3, var6_18 + var6_18 + var6_18 + var4_12, var2_2, var2_2);
                                                    break block112;
                                                }
                                                if (var7_24 == 0) break block114;
                                                if (this.view.mapOne[var7_24 + (var6_18 << 5) - 1] != 0) break block115;
                                            }
                                            if (var7_24 == 32 - 1) break block116;
                                            if (this.view.mapOne[var7_24 + (var6_18 << 5) + 1] != 0) break block115;
                                        }
                                        if (var6_18 == 0) break block117;
                                        if (this.view.mapOne[var7_24 + (var6_18 << 5) - 32] != 0) break block115;
                                    }
                                    if (var6_18 == 32 - 1) break block112;
                                    if (this.view.mapOne[var7_24 + (var6_18 << 5) + 32] == 0) break block112;
                                }
                                var1_1.setColor(0, 0, 0);
                                var1_1.fillRect(var7_24 + var7_24 + var7_24 + var3_3, var6_18 + var6_18 + var6_18 + var4_12, var2_2, var2_2);
                            }
                            ++var7_24;
lbl318:
                            // 2 sources

                        } while (var7_24 < 32);
                        ++var6_18;
lbl321:
                        // 2 sources

                    } while (var6_18 < 32);
                }
                if ((this.ticks & 8) == 0) {
                    var1_1.setColor(0, 0, 255);
                } else {
                    var1_1.setColor(172, 211, 115);
                }
                var1_1.fillRect(this.xMap * var2_2 + var3_3, this.yMap * var2_2 + var4_12, var2_2, var2_2);
            }
            if (this.status == 8) {
                this.bgColor[0] = 32;
                this.bgColor[1] = 128;
                this.bgColor[2] = 160;
                var1_1.setColor(this.bgColor[0], this.bgColor[1], this.bgColor[2]);
                var1_1.fillRect(0, 0, this.gameWidth, this.gameHeight);
                var1_1.setColor(255, 255, 255);
                var2_2 = 2;
                var5_15 = var3_3 = -(GameManager.fontHeight * this.ticks);
                var8_25 = this.availBG != false ? this.gameHeight - (GameManager.fontHeight << 1) : this.gameHeight;
                var1_1.setClip(0, 0, this.gameWidth, var8_25);
                this.bEnd = false;
                var10_23 = 0;
                while (var10_23 <= 11) {
                    if (this.view == null || var10_23 > 0) {
                        var11_26 = 0;
                        var12_27 = 0;
                        var4_13 = var2_2;
                        var9_21 = new StringBuffer(this.dict.getString(Dictionary.I0 + var10_23));
                        while (var11_26 < var9_21.length()) {
                            if (var9_21.charAt(var11_26) == ' ' || var9_21.charAt(var11_26) == '\n' || var11_26 + 1 >= var9_21.length()) {
                                if (var4_13 + GameManager.GAME_FONT.stringWidth(var9_21.toString().substring(var12_27, var11_26)) > this.gameWidth - 4) {
                                    var4_13 = var2_2;
                                    if ((var5_15 += GameManager.fontHeight) > var8_25) break;
                                    if (var9_21.charAt(var11_26) == ' ' && var12_27 < var11_26) {
                                        ++var12_27;
                                    }
                                }
                                if (var9_21.charAt(var11_26) == '\n') {
                                    if (var12_27 < var11_26) {
                                        var1_1.drawString(var9_21.toString().substring(var12_27, var11_26 - 1), var4_13, var5_15, 20);
                                    }
                                    var4_13 = var2_2;
                                    if ((var5_15 += GameManager.fontHeight) > var8_25) break;
                                    ++var11_26;
                                }
                                if (var9_21.charAt(var11_26) == ' ' || var11_26 + 1 >= var9_21.length()) {
                                    var1_1.drawString(var9_21.toString().substring(var12_27, var11_26 + 1), var4_13, var5_15, 20);
                                    if ((var4_13 += GameManager.GAME_FONT.stringWidth(var9_21.toString().substring(var12_27, var11_26))) == var2_2) {
                                        // empty if block
                                    }
                                }
                                var12_27 = ++var11_26;
                            }
                            ++var11_26;
                        }
                        var5_15 += GameManager.fontHeight;
                    }
                    if (var5_15 > var8_25) break;
                    ++var10_23;
                }
                if (var5_15 <= var8_25 - GameManager.fontHeight) {
                    this.bEnd = true;
                }
                this.setLeft(Dictionary.BACK);
                this.newHelp = true;
                var1_1.setClip(0, 0, this.gameWidth, this.gameHeight);
            }
            this.redrawAll = false;
        }
        if (this.isPaused) {
            var2_2 = 0;
            var3_3 = 0;
            while (var3_3 < this.options.length) {
                if (this.options[var3_3]) {
                    ++var2_2;
                }
                ++var3_3;
            }
            var4_14 = this.gameWidth >> 1;
            v2 = var5_15 = this.view != null ? (this.view.ySize >> 1) - (var2_2 * (GameManager.fontHeight + 1) >> 1) : (this.gameHeight >> 1) - ((var2_2 - 2) * (GameManager.fontHeight + 1) >> 1);
            if (this.view != null && this.view.yLoc > 0) {
                var5_15 += this.view.yLoc;
            }
            var1_1.setClip(0, 0, this.gameWidth, this.gameHeight);
            var1_1.setColor(0, 0, 0);
            var1_1.fillRect(var4_14 - 35, var5_15 - 3, 70, var2_2 * (GameManager.fontHeight + 1) + 4);
            var1_1.setColor(255, 255, 0);
            var1_1.drawRect(var4_14 - 35, var5_15 - 3, 70, var2_2 * (GameManager.fontHeight + 1) + 4);
            var3_3 = 0;
            while (var3_3 < this.options.length) {
                var6_19 = new StringBuffer(this.dict.getString(Dictionary.MENU_0 + var3_3));
                if (this.options[var3_3]) {
                    if (this.option == var3_3) {
                        this.drawSmallText(var1_1, var4_14, var5_15, var6_19, 1);
                        var5_15 += GameManager.fontHeight + 1;
                    } else {
                        this.drawSmallText(var1_1, var4_14, var5_15, var6_19, 0);
                        var5_15 += GameManager.fontHeight + 1;
                    }
                }
                ++var3_3;
            }
            this.iLeft = Dictionary.SELECT;
            this.newHelp = true;
        }
        if (this.availBG && this.newHelp) {
            var2_2 = this.gameHeight - GameManager.fontHeight;
            var1_1.setClip(0, var2_2, this.gameWidth, this.gameHeight);
            var1_1.setColor(this.bgColor[0], this.bgColor[1], this.bgColor[2]);
            var1_1.fillRect(0, var2_2, this.gameWidth, this.gameHeight);
            var1_1.setColor(255, 255, 255);
            if (this.iLeft != 0) {
                var1_1.drawString(this.dict.getString(this.iLeft), 0, var2_2, 20);
            }
            if (!this.isPaused && this.status != 5 && this.iRight != 0 && this.status != 8) {
                var1_1.drawString(this.dict.getString(this.iRight), this.gameWidth - 1, var2_2, 24);
            }
            this.newHelp = false;
        }
    }

    void showOption(Graphics graphics, int n, int n2, StringBuffer stringBuffer) {
        graphics.setClip(0, 0, this.gameWidth, this.gameHeight);
        graphics.setColor(0, 0, 0);
        graphics.drawString(stringBuffer.toString(), n + 1, (n2 -= 2) + 1, 17);
        graphics.setColor(255, 255, 0);
        graphics.drawString(stringBuffer.toString(), n, n2, 17);
    }

    void drawSmallText(Graphics graphics, int n, int n2, StringBuffer stringBuffer, int n3) {
        graphics.setClip(0, 0, this.gameWidth, this.gameHeight);
        graphics.setColor(0, 0, 0);
        graphics.drawString(stringBuffer.toString(), n + 1, n2 + 1, 17);
        switch (n3) {
            case 0: {
                graphics.setColor(255, 255, 255);
                break;
            }
            case 1: {
                this.colorCycle += this.colorInc;
                if (this.colorCycle == 15) {
                    this.colorInc = -1;
                }
                if (this.colorCycle == 0) {
                    this.colorInc = 1;
                }
                graphics.setColor(255, this.colorCycle << 4, 0);
                break;
            }
            case 2: {
                graphics.setColor(0, 255, 255);
            }
        }
        graphics.drawString(stringBuffer.toString(), n, n2, 17);
    }

    void drawBackground(Graphics graphics) {
        graphics.setClip(0, 0, this.gameWidth, this.gameHeight);
        this.bgColor[0] = 0;
        this.bgColor[1] = 0;
        this.bgColor[2] = 0;
        graphics.setColor(this.bgColor[0], this.bgColor[1], this.bgColor[2]);
        graphics.fillRect(0, 0, this.gameWidth, this.gameHeight);
        graphics.setClip(0, this.view.ySize + this.rowBorder + 2, this.gameWidth, 32);
        if (this.availBG) {
            graphics.drawImage(this.bggfx, this.colBorder, this.view.ySize + this.rowBorder + 2, 20);
            this.drawHand(graphics);
        }
        this.redrawBG = false;
    }

    void drawHand(Graphics graphics) {
        if (this.view == null) {
            return;
        }
        int n = this.colBorder + 25;
        int n2 = this.view.ySize + this.rowBorder + 6;
        graphics.setClip(n, n2, this.invSquareSize, this.invSquareSize);
        graphics.drawImage(this.bggfx, this.colBorder, this.view.ySize + this.rowBorder + 2, 20);
        if (this.invItem[12] != 0) {
            int n3 = this.view.itemType[this.invItem[12] - 1] - 1 >> 3;
            graphics.drawImage(this.invgfx, n - this.invSquareSize - (n3 & 1) * this.invSquareSize, n2 - (n3 >> 1) * this.invSquareSize, 20);
        } else {
            graphics.drawImage(this.invgfx, n, n2 - 2 * this.invSquareSize, 20);
        }
    }

    void drawInv(Graphics graphics) {
        int n;
        int n2;
        int n3 = 0;
        while (n3 < 16) {
            n2 = this.invSquareXY[n3][0];
            n = this.invSquareXY[n3][1];
            graphics.setClip(n2, n, this.invSquareSize, this.invSquareSize);
            if (this.itemSelect == n3) {
                graphics.drawImage(this.invgfx, n2, n - this.invSquareSize, 20);
            } else {
                graphics.drawImage(this.invgfx, n2, n, 20);
            }
            ++n3;
        }
        n2 = this.availBG ? 66 + this.view.xLoc : 60 + this.view.xLoc;
        n = this.availBG ? this.view.yLoc + 8 : 8;
        graphics.setClip(n2, n, 84, 108);
        graphics.drawImage(this.inv2gfx, n2, n, 20);
        n3 = 0;
        while (n3 < 16) {
            if (this.invItem[n3] != 0) {
                int n4 = this.view.itemType[this.invItem[n3] - 1] - 1 >> 3;
                n2 = this.invSquareXY[n3][0];
                n = this.invSquareXY[n3][1];
                graphics.setClip(n2, n, this.invSquareSize, this.invSquareSize);
                graphics.drawImage(this.invgfx, n2 - this.invSquareSize - (n4 & 1) * this.invSquareSize, n - (n4 >> 1) * this.invSquareSize, 20);
            }
            ++n3;
        }
        graphics.setClip(0, 0, this.gameWidth, this.gameHeight);
        n2 = this.invSquareXY[this.itemCurrent][0];
        n = this.invSquareXY[this.itemCurrent][1];
        graphics.setColor(255, 0, 0);
        graphics.drawRect(n2, n, this.invSquareSize - 1, this.invSquareSize - 1);
        n2 = this.gameWidth >> 1;
        int n5 = n = this.availBG ? this.view.yLoc + this.view.ySize - (fontHeight << 1) : this.gameHeight - 14;
        if (this.invItem[this.itemCurrent] != 0) {
            StringBuffer stringBuffer = new StringBuffer("");
            StringBuffer stringBuffer2 = new StringBuffer("");
            int n6 = this.view.itemType[this.invItem[this.itemCurrent] - 1] - 1;
            int n7 = n6 >> 3;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            stringBuffer.append(this.dict.getString(this.itemDsc[n6] + Dictionary.TEXT_DEX));
            this.drawSmallText(graphics, n2, n, stringBuffer, 0);
            n6 &= 7;
            if (n7 == 0 || n7 == 7) {
                n9 += this.view.helmet[n6 + n6];
                n10 -= this.view.helmet[n6 + n6 + 1];
            } else if (n7 == 1) {
                n8 += this.view.sword[n6 + n6];
                n10 -= this.view.sword[n6 + n6 + 1];
            } else if (n7 == 2 || n7 == 3) {
                n9 += this.view.sword[n6 + n6];
                n10 -= this.view.sword[n6 + n6 + 1];
            } else if (n7 == 4) {
                n8 += this.view.ring[n6 + n6 + n6];
                n9 += this.view.ring[n6 + n6 + n6 + 1];
                n10 -= this.view.ring[n6 + n6 + n6 + 2];
            }
            n10 = -n10;
            if (n8 != 0) {
                stringBuffer2.append(this.dict.getString(Dictionary.TEXT_ATT));
                if (n8 > 0) {
                    stringBuffer2.append("+");
                }
                stringBuffer2.append(n8);
                stringBuffer2.append(" ");
            }
            if (n9 != 0) {
                stringBuffer2.append(this.dict.getString(Dictionary.TEXT_DEF));
                if (n9 > 0) {
                    stringBuffer2.append("+");
                }
                stringBuffer2.append(n9);
                stringBuffer2.append(" ");
            }
            if (n10 != 0) {
                stringBuffer2.append(this.dict.getString(Dictionary.TEXT_DEX));
                if (n10 > 0) {
                    stringBuffer2.append("+");
                }
                stringBuffer2.append(n10);
            }
            this.drawSmallText(graphics, n2, n += fontHeight, stringBuffer2, 0);
            this.clrInvTxt = true;
        }
    }
}

