/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import com.nokia.mid.ui.DeviceControl;
import java.io.IOException;
import javax.microedition.lcdui.Image;

class GameEffects {
    private volatile boolean isPaused = true;
    private Sound sound = null;
    private volatile int currentPriority = 0;
    public static boolean soundOn = false;
    public static byte[] SWOOSH_SOUND_BYTES = new byte[5430];
    public static byte[] HIT_SOUND_BYTES = new byte[2926];
    public static byte[] CRYS_SOUND_BYTES = new byte[1138];
    public static byte[] FOOT1_SOUND_BYTES = new byte[2354];
    public static byte[] FOOT2_SOUND_BYTES = new byte[2356];
    public static byte[] FOOT3_SOUND_BYTES = new byte[2358];
    public static byte[] WALL_SOUND_BYTES = new byte[4812];
    public static byte[] SCRO_SOUND_BYTES = new byte[3776];

    GameEffects() {
    }

    private synchronized void setIsPaused(boolean bl) {
        this.isPaused = bl;
    }

    void pause() {
        this.setIsPaused(true);
        if (this.sound != null) {
            this.sound.stop();
        }
        DeviceControl.stopVibra();
    }

    void resume() {
        this.setIsPaused(false);
    }

    private void playSound(int n, byte[] byArray) {
        block5: {
            if (this.isPaused || !soundOn) break block5;
            try {
                if (this.sound == null || this.sound.getState() != 0) {
                    this.sound = new Sound(byArray, 5);
                    this.sound.play(1);
                    this.currentPriority = n;
                } else if (n >= this.currentPriority) {
                    this.sound.stop();
                    this.sound.init(byArray, 5);
                    this.sound.play(1);
                    this.currentPriority = n;
                }
            }
            catch (Exception exception) {
                this.currentPriority = 0;
            }
        }
    }

    void playHit() {
        this.playSound(2, HIT_SOUND_BYTES);
    }

    void playSwoosh() {
        this.playSound(6, SWOOSH_SOUND_BYTES);
    }

    void playDoor() {
        this.playSound(4, WALL_SOUND_BYTES);
    }

    void playCrys() {
        this.playSound(1, CRYS_SOUND_BYTES);
    }

    void playScroll() {
        this.playSound(5, SCRO_SOUND_BYTES);
    }

    void playFoot(int n) {
        switch (n) {
            case 1: {
                this.playSound(3, FOOT1_SOUND_BYTES);
                break;
            }
            case 2: {
                this.playSound(2, FOOT2_SOUND_BYTES);
                break;
            }
            case 3: {
                this.playSound(1, FOOT3_SOUND_BYTES);
                break;
            }
        }
    }

    Image getGfx(String string) {
        Image image;
        try {
            image = Image.createImage((String)string);
        }
        catch (IOException iOException) {
            image = null;
        }
        return image;
    }

    void lightsOn() {
        DeviceControl.setLights((int)0, (int)100);
    }
}

