/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.GameScreen;
import game.itemsClass;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class inventoryClass {
    private itemsClass[] items;
    private Image image;
    private Image arrowImage;
    private Sprite sprite;
    private Sprite leftArrow;
    private Sprite rightArrow;
    private int selectedItem;
    private int selX;
    private int bookX;
    private int selY;
    private int bookY;
    public int inventoryMode = 0;

    public inventoryClass() {
        System.out.println("creating inventory");
        this.image = null;
        this.arrowImage = null;
        try {
            this.image = Image.createImage((String)"/images/inv_back.png");
            this.arrowImage = Image.createImage((String)"/images/inv_arrow.png");
        }
        catch (IOException io) {
            System.out.println("error " + io.getMessage());
        }
        this.sprite = new Sprite(this.image);
        this.leftArrow = new Sprite(this.arrowImage);
        this.rightArrow = new Sprite(this.arrowImage);
        this.leftArrow.setPosition(3, 72);
        this.rightArrow.setPosition(125, 72);
        this.rightArrow.setTransform(2);
        this.items = new itemsClass[GameScreen.data.invCount];
        int i = 0;
        while (i < GameScreen.data.invCount) {
            this.items[i] = GameScreen.data.getItemNew(GameScreen.data.invItems[i]);
            this.items[i].init();
            ++i;
        }
        this.selectedItem = 0;
        this.selX = 0;
        this.bookY = 0;
    }

    public int getMode() {
        return this.inventoryMode;
    }

    public void callPhone(int userID) {
        System.out.println("goto phone menu");
        this.inventoryMode = 1;
    }

    public int getItemID() {
        return this.items[this.selX].getID();
    }

    public int getPhoneID() {
        return GameScreen.data.phoneBook[this.bookY];
    }

    public void move(int dirX, int dirY) {
        if (this.inventoryMode == 0) {
            this.selX += dirX;
            if (this.selX >= this.items.length) {
                this.selX = this.items.length - 1;
            } else if (this.selX < 0) {
                this.selX = 0;
            }
        } else {
            this.bookY += dirY;
            if (this.bookY >= GameScreen.data.phoneLength) {
                this.bookY = GameScreen.data.phoneLength - 1;
            } else if (this.bookY < 0) {
                this.bookY = 0;
            }
        }
    }

    public void render(Graphics g) {
        System.gc();
        this.sprite.paint(g);
        if (GameScreen.data.invCount > 0) {
            int i = -1;
            while (i < 2) {
                if (this.selX + i < GameScreen.data.invCount && this.selX + i > -1) {
                    this.items[this.selX + i].getSprite().setPosition(48 + i * 34, 62);
                    this.items[this.selX + i].render(g);
                }
                ++i;
            }
        }
        if (this.inventoryMode == 0) {
            if (this.selX > 0) {
                this.leftArrow.paint(g);
            }
            if (this.selX < GameScreen.data.invCount - 1) {
                this.rightArrow.paint(g);
            }
            if (GameScreen.data.invCount == 0) {
                GameScreen.data.showText(g, "\u041f\u043e\u043a\u0430 \u043d\u0435\u0442 \u043d\u0438 \u043e\u0434\u043d\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u0430", 8, 8, 22);
            } else {
                GameScreen.data.showText(g, this.items[this.selX].getLabel(), 8, 8, 22);
            }
        } else {
            g.setColor(0x808080);
            g.fillRect(6 + this.bookY / 4 * 60, 7 + 11 * (this.bookY % 4), GameScreen.data.phoneTalks[GameScreen.data.phoneBook[this.bookY]].length() * 5 + 15, 10);
            int line = 0;
            while (line < GameScreen.data.phoneLength) {
                int sx = 8 + line / 4 * 60;
                int sy = 8 + 11 * (line % 4);
                GameScreen.data.showText(g, "-" + GameScreen.data.phoneTalks[GameScreen.data.phoneBook[line]], sx, sy, 22);
                ++line;
            }
        }
    }
}

