/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.GameScreen;
import game.roomClass;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class boySprite {
    private Image image;
    private Image dotImage;
    public Sprite sprite;
    public Sprite dotSprite;
    private int positionX;
    private int positionY;
    private int frameWidth;
    private int frameHeight;
    private int numFrames;
    private int currentFrame;
    private boolean visible = false;
    private int dirX;
    private int dirY = 0;
    private int oldDirection;
    private int stepBit = 0;
    private int hSpeed = 3;
    private int vSpeed = 2;
    private int backColor;
    private int[][] moves;
    private int[][] pos;
    private int tailLen = 4;
    private int[][][] dirIndex = new int[][][]{new int[][]{{6, 6, 14, 14}, {1, 1, 9, 9}, {5, 5, 13, 13}}, new int[][]{{2, 2, 10, 10}, {0, 0, 8, 8}, {3, 3, 11, 11}}, new int[][]{{7, 7, 15, 15}, {0, 0, 8, 8}, {4, 4, 12, 12}}};
    private int[] pixInfo = new int[10];

    public boySprite(String image, int frameWidth, int frameHeight) throws Exception {
        this.image = Image.createImage((String)image);
        this.dotImage = Image.createImage((String)"/images/sprites/peoples/dot.png");
        this.frameWidth = frameWidth;
        this.frameHeight = frameHeight;
        this.numFrames = this.numFrames;
        this.sprite = new Sprite(this.image, this.frameWidth, this.frameHeight);
        this.dotSprite = new Sprite(this.dotImage);
        this.sprite.setFrameSequence(this.dirIndex[2][1]);
        this.positionX = 190;
        this.positionY = 60;
        this.moves = new int[10][2];
        this.pos = new int[10][2];
    }

    public int[][] getLastMoves() {
        int[][] ar = new int[2][2];
        ar[0] = this.pos[0];
        ar[1] = this.moves[0];
        return ar;
    }

    public void move(roomClass gameMap, int maxX, int maxY) {
        if (maxX == 0 && maxY == 0) {
            this.sprite.setFrameSequence(this.dirIndex[1 + this.dirX][1 + this.dirY]);
            this.sprite.setFrame(0);
            this.stepBit = 0;
            System.gc();
        } else {
            if (this.dirX != maxX || this.dirY != maxY) {
                this.sprite.setFrameSequence(this.dirIndex[1 + maxX][1 + maxY]);
            } else {
                this.sprite.nextFrame();
            }
            this.dirX = maxX;
            this.dirY = maxY;
            int newX = this.positionX + maxX * this.hSpeed;
            int newY = this.positionY + maxY * this.vSpeed;
            if (newX > 0 && newY > 0 && newX < gameMap.terrain.getWidth() && newY < gameMap.terrain.getHeight()) {
                gameMap.moveTerrain(newX, newY);
                if (this.dotSprite.collidesWith(gameMap.getAlphaTerrain(), true)) {
                    if (GameScreen.currentRoom == 16) {
                        if (newX <= 215 || GameScreen.data.roomStates[16] != 0) {
                            this.positionX = newX;
                            this.positionY = newY;
                        }
                    } else {
                        this.positionX = newX;
                        this.positionY = newY;
                    }
                    GameScreen.dan.setPosition(64 - this.positionX + this.pos[1][0] - 12, 64 - this.positionY + this.pos[1][1] - 23);
                    GameScreen.dan.move(this.moves[0][0], this.moves[0][1]);
                    int r = 0;
                    while (r < this.tailLen) {
                        this.moves[r][0] = this.moves[r + 1][0];
                        this.moves[r][1] = this.moves[r + 1][1];
                        ++r;
                    }
                    this.moves[this.tailLen][0] = maxX;
                    this.moves[this.tailLen][1] = maxY;
                    int r2 = 0;
                    while (r2 < this.tailLen) {
                        this.pos[r2][0] = this.pos[r2 + 1][0];
                        this.pos[r2][1] = this.pos[r2 + 1][1];
                        ++r2;
                    }
                    this.pos[this.tailLen][0] = this.positionX;
                    this.pos[this.tailLen][1] = this.positionY;
                } else {
                    gameMap.moveTerrain(this.positionX, this.positionY);
                }
            }
        }
    }

    public int getX() {
        return this.positionX;
    }

    public int getY() {
        return this.positionY;
    }

    public void setVisible(boolean val) {
        this.visible = val;
    }

    public int getVisible() {
        if (this.visible) {
            return 1;
        }
        return 0;
    }

    public void setPosition(roomClass gameMap, int positionX, int positionY) {
        this.positionX = positionX;
        this.positionY = positionY;
        gameMap.moveTerrain(positionX, positionY);
        int r = 0;
        while (r < this.tailLen) {
            this.moves[r][0] = 0;
            this.moves[r][1] = 0;
            ++r;
        }
        int r2 = 0;
        while (r2 < this.tailLen) {
            this.pos[r2][0] = positionX;
            this.pos[r2][1] = positionY;
            ++r2;
        }
    }

    public void render(Graphics g) {
        if (this.visible) {
            this.sprite.paint(g);
            this.dotSprite.paint(g);
        }
    }
}

