/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.DanAndMax;
import game.Settings;
import game.boySprite;
import game.danSprite;
import game.gameData;
import game.inventoryClass;
import game.itemAction;
import game.mapClass;
import game.roomClass;
import game.textMessage;
import java.util.Random;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.TiledLayer;

public class GameScreen
extends GameCanvas
implements Runnable,
CommandListener {
    private dialogClass dialog;
    public int itemOver;
    public int oldItemOver;
    private itemAction[] itemOverActions;
    public static gameData data;
    public long code;
    public static int currentRoom;
    private static final int MILLIS_PER_TICK = 50;
    private DanAndMax midlet;
    private Command backCommand = new Command("\u043d\u0430\u0437\u0430\u0434", 2, 1);
    private Command useCommand = new Command("\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c", 8, 1);
    private Command noCommand = new Command("\u043d\u0435\u0442", 2, 1);
    private Command yesCommand = new Command("\u0434\u0430", 4, 1);
    private Command nextCommand = new Command("\u0434\u0430\u043b\u0435\u0435", 4, 1);
    public roomClass gameMap;
    private boolean isPlay;
    public static int width;
    public static int height;
    private int scnViewWidth;
    private int scnViewHeight;
    public static boySprite maxSprite;
    public static danSprite dan;
    public inventoryClass inventory;
    public mapClass map;
    public textMessage displayText;
    public boolean textDelay = false;
    private long startTextDelay;
    private LayerManager layerManager;
    public TiledLayer terrain;
    public TiledLayer alphaTerrain;
    private Settings settings;
    private Thread gameThread = null;
    private int gameMode;
    private StringBuffer debInfo;

    public GameScreen(DanAndMax midlet, Settings settings) throws Exception {
        super(true);
        this.midlet = midlet;
        this.settings = settings;
        width = this.getWidth();
        height = this.getHeight();
        this.scnViewWidth = width;
        this.scnViewHeight = height;
        data = new gameData();
        this.displayText = new textMessage();
        this.dialog = new dialogClass();
        maxSprite = new boySprite("/images/sprites/peoples/boymax.png", 24, 24);
        dan = new danSprite("/images/sprites/peoples/boydan.png", 24, 24);
        this.addCommand(this.backCommand);
        this.addCommand(this.useCommand);
        this.setCommandListener(this);
        this.gameMode = 1;
    }

    public void loadGame() throws Exception {
        System.gc();
        this.settings.loadSettings();
        currentRoom = this.settings._currentRoom;
        System.arraycopy(this.settings._itemStates, 0, GameScreen.data.itemStates, 0, GameScreen.data.itemStates.length);
        System.arraycopy(this.settings._itemVisible, 0, GameScreen.data.itemVisible, 0, GameScreen.data.itemVisible.length);
        System.arraycopy(this.settings._invItems, 0, GameScreen.data.invItems, 0, GameScreen.data.invItems.length);
        System.arraycopy(this.settings._roomStates, 0, GameScreen.data.roomStates, 0, GameScreen.data.roomStates.length);
        System.arraycopy(this.settings._mapAllow, 0, GameScreen.data.mapAllow, 0, GameScreen.data.mapAllow.length);
        System.arraycopy(this.settings._phoneStates, 0, GameScreen.data.phoneStates, 0, GameScreen.data.phoneStates.length);
        System.arraycopy(this.settings._phoneBook, 0, GameScreen.data.phoneBook, 0, GameScreen.data.phoneBook.length);
        GameScreen.data.phoneLength = this.settings._phoneLength;
        GameScreen.data.invCount = this.settings._invCount;
        dan.setVisible(this.settings._danVisible == 1);
        maxSprite.setVisible(this.settings._maxVisible == 1);
        this.code = this.settings._code;
        System.out.println("loaded room " + currentRoom);
        System.out.println("loaded x " + this.settings._playerX);
        System.out.println("loaded y " + this.settings._playerY);
        this.gameMap = new roomClass(currentRoom);
        System.gc();
        this.gameMap.roomInit();
        System.out.println("rooms done");
        this.layerManager = new LayerManager();
        this.terrain = this.gameMap.getTerrain();
        this.alphaTerrain = this.gameMap.getAlphaTerrain();
        this.layerManager.append((Layer)this.terrain);
        this.layerManager.append((Layer)this.alphaTerrain);
        maxSprite.setPosition(this.gameMap, this.settings._playerX, this.settings._playerY);
        this.gameMap.moveTerrain(maxSprite.getX(), maxSprite.getY());
        System.out.println("all seems ok done");
        System.gc();
        String[] actions = gameData.split(GameScreen.data.roomActions[currentRoom], "#");
        int st = GameScreen.data.roomStates[currentRoom];
        String[] actionsTmp = gameData.split(actions[st], "$");
        int act = 0;
        while (act < actionsTmp.length) {
            String[] actCur = gameData.split(actionsTmp[act], "=");
            itemAction actionsPar = new itemAction(actCur[0], actCur[1]);
            this.processAction(actionsPar);
            ++act;
        }
        this.isPlay = true;
        System.out.println("all seems ok done1");
        System.out.println("start loadedGame");
        this.gameThread = new Thread(this);
        this.gameThread.start();
    }

    public void start() throws Exception {
        System.gc();
        currentRoom = 1;
        this.gameMap = new roomClass(currentRoom);
        System.gc();
        this.gameMap.roomInit();
        System.out.println("rooms done");
        this.layerManager = new LayerManager();
        this.terrain = this.gameMap.getTerrain();
        this.alphaTerrain = this.gameMap.getAlphaTerrain();
        this.layerManager.append((Layer)this.terrain);
        this.layerManager.append((Layer)this.alphaTerrain);
        this.gameMap.moveTerrain(maxSprite.getX(), maxSprite.getY());
        System.out.println("all seems ok done");
        System.gc();
        String[] actions = gameData.split(GameScreen.data.roomActions[currentRoom], "#");
        int st = GameScreen.data.roomStates[currentRoom];
        String[] actionsTmp = gameData.split(actions[st], "$");
        int act = 0;
        while (act < actionsTmp.length) {
            String[] actCur = gameData.split(actionsTmp[act], "=");
            itemAction actionsPar = new itemAction(actCur[0], actCur[1]);
            this.processAction(actionsPar);
            ++act;
        }
        this.isPlay = true;
        GameScreen.data.itemVisible[164] = 0;
        System.out.println("all seems ok done1");
        System.out.println("start newGame");
        this.gameThread = new Thread(this);
        this.gameThread.start();
    }

    public void saveAndExit() {
        try {
            this.settings.updateSettings();
            this.midlet.mainMenuScreenShow();
        }
        catch (Exception ex) {
            System.out.println("error saving info");
        }
    }

    public void saveOnly() {
        try {
            this.settings.updateSettings();
        }
        catch (Exception ex) {
            System.out.println("error saving info");
        }
    }

    public void stop() {
        this.gameThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Graphics g = this.getGraphics();
        Thread currentThread = Thread.currentThread();
        try {
            while (true) {
                long timeTake;
                if (currentThread != this.gameThread) {
                    return;
                }
                long startTime = System.currentTimeMillis();
                if (this.isShown() && this.isPlay) {
                    this.tick();
                    this.render(g);
                }
                if ((timeTake = System.currentTimeMillis() - startTime) < 50L) {
                    GameScreen gameScreen = this;
                    synchronized (gameScreen) {
                        this.wait(50L - timeTake);
                        continue;
                    }
                }
                Thread.yield();
            }
        }
        catch (InterruptedException ex) {
            System.out.println("errorrr" + ex);
        }
    }

    public void tick() {
        int keyStates = this.getKeyStates();
        int maxX = 0;
        int maxY = 0;
        switch (this.gameMode) {
            case 1: {
                if ((keyStates & 4) != 0) {
                    --maxX;
                }
                if ((keyStates & 0x20) != 0) {
                    ++maxX;
                }
                if ((keyStates & 2) != 0) {
                    --maxY;
                }
                if ((keyStates & 0x40) != 0) {
                    ++maxY;
                }
                maxSprite.move(this.gameMap, maxX, maxY);
                if (maxX == 0 && maxY == 0) break;
                this.checkPlace();
                break;
            }
            case 2: {
                if ((keyStates & 4) != 0) {
                    --maxX;
                }
                if ((keyStates & 0x20) != 0) {
                    ++maxX;
                }
                this.map.move(maxX);
                break;
            }
            case 3: {
                if ((keyStates & 4) != 0) {
                    --maxX;
                }
                if ((keyStates & 0x20) != 0) {
                    ++maxX;
                }
                if ((keyStates & 2) != 0) {
                    --maxY;
                }
                if ((keyStates & 0x40) != 0) {
                    ++maxY;
                }
                this.inventory.move(maxX, maxY);
            }
        }
    }

    public void checkPlace() {
        this.itemOver = this.gameMap.checkItems(maxSprite.getX(), maxSprite.getY());
        if (this.itemOver != -1) {
            if (this.itemOver != this.oldItemOver) {
                this.oldItemOver = this.itemOver;
                String itemType = this.gameMap.roomItemsNew[this.itemOver].getType();
                this.itemOverActions = this.gameMap.roomItemsNew[this.itemOver].getAction();
                if (itemType.equals("door")) {
                    int ac = 0;
                    while (ac < this.itemOverActions.length) {
                        this.processAction(this.itemOverActions[ac]);
                        ++ac;
                    }
                    if (this.itemOverActions[0].getType().equals("none")) {
                        this.displayText.setText(this.gameMap.roomItemsNew[this.itemOver].getLabel(), 0);
                    }
                } else if (itemType.equals("item")) {
                    this.displayText.setText(this.gameMap.roomItemsNew[this.itemOver].getLabel(), 0);
                    if (this.itemOverActions[0].getType().equals("state") || this.itemOverActions[0].getType().equals("get") || this.itemOverActions[0].getType().equals("message") || this.itemOverActions[0].getType().equals("dialog")) {
                        this.removeCommand(this.useCommand);
                        this.addCommand(this.yesCommand);
                    }
                } else {
                    this.displayText.hide();
                }
            }
        } else {
            this.displayText.hide();
            if (this.oldItemOver != this.itemOver) {
                this.oldItemOver = this.itemOver;
                this.removeCommand(this.yesCommand);
                this.addCommand(this.useCommand);
            }
        }
    }

    public void gotoRoom(int roomNum) {
        if (currentRoom != roomNum) {
            this.isPlay = false;
            this.gameMap.resetSprites();
            currentRoom = roomNum;
            if (this.terrain != null) {
                this.layerManager.remove((Layer)this.terrain);
                this.layerManager.remove((Layer)this.alphaTerrain);
            }
            this.gameMap.setMap(currentRoom);
            this.gameMap.roomInit();
            this.terrain = this.gameMap.getTerrain();
            this.alphaTerrain = this.gameMap.getAlphaTerrain();
            this.layerManager.append((Layer)this.terrain);
            this.layerManager.append((Layer)this.alphaTerrain);
            this.setGameMode(1);
            String[] actions = gameData.split(GameScreen.data.roomActions[currentRoom], "#");
            int st = GameScreen.data.roomStates[currentRoom];
            String[] actionsTmp = gameData.split(actions[st], "$");
            int act = 0;
            while (act < actionsTmp.length) {
                String[] actCur = gameData.split(actionsTmp[act], "=");
                itemAction actionsPar = new itemAction(actCur[0], actCur[1]);
                this.processAction(actionsPar);
                ++act;
            }
            System.gc();
            this.isPlay = true;
        }
    }

    public void processAction(itemAction _use) {
        String _what = _use.getType();
        int[] attr = _use.getAttr();
        if (_what.equals("goto")) {
            this.gotoRoom(attr[0]);
            maxSprite.setPosition(this.gameMap, attr[1], attr[2]);
        } else if (_what.equals("state")) {
            System.out.println("changin item " + attr[0] + " to state " + attr[1]);
            GameScreen.data.itemStates[attr[0]] = attr[1];
            int textID = this.gameMap.setState(attr[0], attr[1]);
            if (textID != -1) {
                this.displayText.setText(this.gameMap.roomItemsNew[textID].getLabel(), 0);
            }
        } else if (_what.equals("message")) {
            System.out.println("displayMessage " + attr[0]);
            this.displayText.setText(GameScreen.data.gameMessages[attr[0]], 0);
            this.startTextDelay = System.currentTimeMillis();
            this.textDelay = true;
        } else if (_what.equals("get")) {
            System.out.println("put to inventory " + attr[0]);
            data.addInvItem(attr[0]);
        } else if (_what.equals("remove")) {
            System.out.println("remove from inventory " + attr[0]);
            data.removeInvItem(attr[0]);
        } else if (_what.equals("hide")) {
            GameScreen.data.itemVisible[attr[0]] = 0;
        } else if (_what.equals("show")) {
            GameScreen.data.itemVisible[attr[0]] = 1;
        } else if (_what.equals("roomstate")) {
            GameScreen.data.roomStates[attr[0]] = attr[1];
        } else if (_what.equals("map")) {
            this.setGameMode(2);
        } else if (_what.equals("danhide")) {
            dan.setVisible(false);
        } else if (_what.equals("danshow")) {
            dan.setVisible(true);
        } else if (_what.equals("maxhide")) {
            maxSprite.setVisible(false);
        } else if (_what.equals("maxshow")) {
            maxSprite.setVisible(true);
        } else if (_what.equals("dialog")) {
            this.setGameMode(4);
            this.removeCommand(this.yesCommand);
            this.removeCommand(this.useCommand);
            this.addCommand(this.nextCommand);
            this.dialog.init(GameScreen.data.dialogs[attr[0]]);
            this.dialog.showNext();
        } else if (_what.equals("close")) {
            this.removeCommand(this.yesCommand);
            this.removeCommand(this.useCommand);
            this.gameMode = 1;
            this.displayText.hide();
            this.removeCommand(this.nextCommand);
            this.addCommand(this.useCommand);
        } else if (_what.equals("phoneadd")) {
            System.out.println("adding to phonebook item " + GameScreen.data.phoneTalks[attr[0]]);
            GameScreen.data.phoneBook[GameScreen.data.phoneLength] = attr[0];
            ++GameScreen.data.phoneLength;
        } else if (_what.equals("callphone")) {
            System.out.println("calling with phone ID " + attr[0]);
            this.inventory.callPhone(attr[0]);
            this.removeCommand(this.nextCommand);
        } else if (_what.equals("phonestate")) {
            System.out.println("changin phone " + attr[0] + " to state " + attr[1]);
            GameScreen.data.phoneStates[attr[0]] = attr[1];
        } else if (_what.equals("mapallow")) {
            System.out.println("open map " + attr[0]);
            GameScreen.data.mapAllow[attr[0]] = 1;
        } else if (_what.equals("final")) {
            this.finalCode();
        }
    }

    public void finalCode() {
        System.out.println(this.code);
        if (this.code == 0L) {
            this.code = System.currentTimeMillis();
        }
        this.gameMode = 5;
        this.removeCommand(this.yesCommand);
        this.removeCommand(this.useCommand);
        this.removeCommand(this.backCommand);
        this.removeCommand(this.nextCommand);
    }

    public void useInventoryItem() {
        boolean found = false;
        int _item = this.inventory.getItemID();
        System.out.println("using item with ID " + _item);
        int it = 0;
        block0: while (it < GameScreen.data.invActions.length) {
            String[] _tmpAction = gameData.split(GameScreen.data.invActions[it], "|");
            if (_item == Integer.parseInt(_tmpAction[0])) {
                System.out.println("check actions for ID " + _item);
                String[] _checks = gameData.split(_tmpAction[1], "#");
                int ch = 0;
                while (ch < _checks.length) {
                    itemAction actionsPar;
                    String[] actCur;
                    int act;
                    String[] actionsTmp;
                    String[] _itemAct = gameData.split(_checks[ch], "$");
                    int _itemID = Integer.parseInt(_itemAct[0]);
                    System.out.println("check actions for item " + _itemID);
                    if (this.itemOver == -1) {
                        if (_itemID == -1) {
                            System.out.println("making action " + _itemAct[1]);
                            actionsTmp = gameData.split(_itemAct[1], "%");
                            act = 0;
                            while (act < actionsTmp.length) {
                                actCur = gameData.split(actionsTmp[act], "=");
                                actionsPar = new itemAction(actCur[0], actCur[1]);
                                this.processAction(actionsPar);
                                ++act;
                            }
                        }
                    } else {
                        if (_itemID == this.gameMap.roomItemsNew[this.itemOver].getID()) {
                            System.out.println("making action " + _itemAct[1] + " with item " + this.gameMap.roomItemsNew[this.itemOver].getID());
                            actionsTmp = gameData.split(_itemAct[1], "%");
                            act = 0;
                            while (act < actionsTmp.length) {
                                actCur = gameData.split(actionsTmp[act], "=");
                                actionsPar = new itemAction(actCur[0], actCur[1]);
                                this.processAction(actionsPar);
                                ++act;
                            }
                            found = true;
                            break block0;
                        }
                        if (_itemID == -1 && !found) {
                            System.out.println("making action " + _itemAct[1]);
                            actionsTmp = gameData.split(_itemAct[1], "%");
                            act = 0;
                            while (act < actionsTmp.length) {
                                actCur = gameData.split(actionsTmp[act], "=");
                                actionsPar = new itemAction(actCur[0], actCur[1]);
                                this.processAction(actionsPar);
                                ++act;
                            }
                        }
                    }
                    ++ch;
                }
                break;
            }
            ++it;
        }
        if (_item != 85 && _item != 86) {
            this.gameMode = 1;
        }
    }

    public void commandAction(Command c, Displayable d) {
        block18: {
            block19: {
                block17: {
                    if (c != this.backCommand) break block17;
                    switch (this.gameMode) {
                        case 1: {
                            this.saveAndExit();
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            this.setGameMode(1);
                            break;
                        }
                        case 4: {
                            this.setGameMode(1);
                        }
                    }
                    break block18;
                }
                if (c != this.useCommand) break block19;
                switch (this.gameMode) {
                    case 1: {
                        this.setGameMode(3);
                        break;
                    }
                    case 2: {
                        if (GameScreen.data.mapAllow[this.map.getSelected()] != 1) break;
                        itemAction mapJump = new itemAction("goto", GameScreen.data.mapLoc[this.map.getSelected()]);
                        this.processAction(mapJump);
                        break;
                    }
                    case 3: {
                        if (this.inventory.getMode() == 0) {
                            this.useInventoryItem();
                            break;
                        }
                        String[] actions = gameData.split(GameScreen.data.phonesInfo[this.inventory.getPhoneID()], "#");
                        int st = GameScreen.data.phoneStates[this.inventory.getPhoneID()];
                        String[] actionsTmp = gameData.split(actions[st], "$");
                        int act = 0;
                        while (act < actionsTmp.length) {
                            String[] actCur = gameData.split(actionsTmp[act], "=");
                            itemAction actionsPar = new itemAction(actCur[0], actCur[1]);
                            this.processAction(actionsPar);
                            ++act;
                        }
                        break block6;
                    }
                }
                break block18;
            }
            if (c == this.yesCommand) {
                int ac = 0;
                while (ac < this.itemOverActions.length) {
                    this.processAction(this.itemOverActions[ac]);
                    ++ac;
                }
            } else if (c == this.nextCommand) {
                this.dialog.showNext();
            }
        }
    }

    public void setGameMode(int newMode) {
        this.map = null;
        this.inventory = null;
        if (newMode == 2) {
            this.map = new mapClass();
        } else if (newMode == 3) {
            this.inventory = new inventoryClass();
        }
        this.gameMode = newMode;
    }

    private void render(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, width, height);
        this.layerManager.paint(g, 0, 0);
        switch (this.gameMode) {
            case 1: 
            case 4: {
                int item = 0;
                while (item < this.gameMap.roomItemsNew.length) {
                    if (this.gameMap.roomItemsNew[item].isBackGround()) {
                        this.gameMap.roomItemsNew[item].render(g);
                    } else if (this.gameMap.roomItemsNew[item].getBottom() <= maxSprite.getY() + 4) {
                        this.gameMap.roomItemsNew[item].render(g);
                    }
                    ++item;
                }
                GameScreen.maxSprite.sprite.setPosition(52, 41);
                GameScreen.maxSprite.dotSprite.setPosition(64, 64);
                if (dan.getY() > maxSprite.getY()) {
                    maxSprite.render(g);
                    dan.render(g);
                } else {
                    dan.render(g);
                    maxSprite.render(g);
                }
                int item2 = 0;
                while (item2 < this.gameMap.roomItemsNew.length) {
                    if (!this.gameMap.roomItemsNew[item2].isBackGround() && this.gameMap.roomItemsNew[item2].getBottom() > maxSprite.getY() + 4) {
                        this.gameMap.roomItemsNew[item2].render(g);
                    }
                    ++item2;
                }
                this.displayText.render(g);
                break;
            }
            case 2: {
                this.map.render(g);
                break;
            }
            case 3: {
                this.inventory.render(g);
                break;
            }
            case 5: {
                String a = String.valueOf(this.code);
                int suma = 0;
                int l = 0;
                while (l < a.length() - 1) {
                    suma += Integer.parseInt(a.substring(l, l + 1));
                    ++l;
                }
                String strCode = "C650" + suma + "28" + a;
                g.setColor(0);
                g.fillRect(0, 0, width, height);
                data.showText(g, "\u041f\u043e\u0437\u0434\u0440\u0430\u0432\u043b\u044f\u0435\u043c. \u0412\u0432\u0435\u0434\u0438\u0442\u0435   \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u043a\u043e\u0434 \u043d\u0430 \u0441\u0430\u0439\u0442\u0435 www.danandmax.ru.      " + strCode, 8, 8, 22);
            }
        }
        this.flushGraphics();
    }

    static {
        MILLIS_PER_TICK = 50;
    }

    private class dialogClass {
        private String[] labels;
        private String action;
        private int cur;

        private dialogClass() {
        }

        private void init(String _in) {
            this.cur = -1;
            String[] tmpStr = gameData.split(_in, "|");
            this.action = tmpStr[1];
            this.labels = gameData.split(tmpStr[0], "#");
        }

        public void showNext() {
            ++this.cur;
            if (this.cur == this.labels.length) {
                String[] dActions = gameData.split(this.action, "$");
                int ac = 0;
                while (ac < dActions.length) {
                    String[] actCur = gameData.split(dActions[ac], "=");
                    itemAction actionsPar = new itemAction(actCur[0], actCur[1]);
                    GameScreen.this.processAction(actionsPar);
                    ++ac;
                }
            } else {
                String[] showLabel = gameData.split(this.labels[this.cur], "$");
                Random r = new Random();
                GameScreen.this.displayText.setText(showLabel[Math.abs(r.nextInt() % showLabel.length)], 0);
            }
        }
    }
}

