/*
 * Decompiled with CFR 0.152.
 */
package Calc4M;

import Calc4M.CalcStack;
import Calc4M.Settings;
import Calc4M.StackElement;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import ral.Real;

public class CalcTextBox {
    private Font textFont;
    private int top;
    private int width;
    private int height;
    private static Real.NumberFormat format = new Real.NumberFormat();
    private String text = "";

    public CalcTextBox() {
        this.setNumberFormat(Settings.getNFSE());
        this.updateSize(0, 0);
    }

    public int getHeight() {
        return this.height;
    }

    public void setNumberFormat(int numberFormat) {
        CalcTextBox.format.fse = this.internalFormatToRealFormat(numberFormat);
        CalcTextBox.format.precision = numberFormat < 0 ? -numberFormat : 16;
    }

    public static int getNumberBase() {
        return CalcTextBox.format.base;
    }

    public static void setNumberBase(int base) {
        CalcTextBox.format.base = base;
    }

    public void updateSize(int top, int width) {
        Real mw = new Real();
        this.top = top;
        this.width = width;
        this.textFont = Settings.getFont(32);
        this.height = this.textFont.getHeight() + 2;
        CalcTextBox.format.maxwidth = mw.assign(width - 2).div(this.textFont.charWidth('0')).floor().toInteger();
    }

    private int internalFormatToRealFormat(int internalFormat) {
        switch (internalFormat) {
            case 1: {
                return 0;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        if (internalFormat <= 0) {
            return 1;
        }
        return 0;
    }

    protected void paint(Graphics g) {
        g.setClip(0, this.top, this.width, this.height);
        g.setColor(0xFFFFFF);
        g.fillRect(0, this.top, this.width, this.height);
        g.setColor(0);
        g.drawRect(-1, this.top, this.width + 1, this.height - 1);
        g.setFont(this.textFont);
        if (this.text != null) {
            g.drawString(this.text, this.width - 1, this.top + 2, 24);
        }
    }

    public void setContent(StackElement top, boolean displayAsArc) {
        this.text = top == null ? "" : top.toString(format, displayAsArc);
    }

    public void setContent(CalcStack calcStack, boolean displayAsArc) {
        this.text = calcStack == null ? "" : calcStack.toString(format, displayAsArc);
    }
}

