/*
 * Decompiled with CFR 0.152.
 */
package cityKnights;

import cityKnights.Constants;
import cityKnights.Game;
import cityKnights.MenuCanvas;
import cityKnights.SplashScreen;
import cityKnights.common.DataItem;
import cityKnights.common.SFStatus;
import cityKnights.common.SFStatuses;
import cityKnights.common.Scores;
import cityKnights.common.SoundItem;
import cityKnights.common.Storage;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public final class Starter
extends MIDlet
implements Constants {
    public static Display display = null;
    public static Scores scores = new Scores();
    private static MenuCanvas menu;
    private Game game = null;

    public Starter() {
        Object object;
        try {
            object = RecordStore.openRecordStore((String)"SFdb", (boolean)false);
            object.getRecord(3);
            object.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            try {
                Storage.store(scores, 1);
                Storage.store(new SFStatuses(), 2);
                Storage.store(new SoundItem(true), 3);
                scores.addDefaultScores();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            Storage.restore(scores, 1);
            object = new SoundItem(true);
            Storage.restore((DataItem)object, 3);
            Game.soundOn = object.soundOn;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        menu = new MenuCanvas(this);
    }

    public void pauseApp() {
        if (this.game != null) {
            this.game.gamePaused();
        }
    }

    public void destroyApp(boolean bl) {
        if (this.game != null) {
            this.game.stop();
        }
    }

    public void startApp() {
        Displayable displayable;
        if (display == null) {
            display = Display.getDisplay((MIDlet)this);
        }
        if ((displayable = display.getCurrent()) == null) {
            SplashScreen splashScreen = new SplashScreen();
            display.setCurrent((Displayable)splashScreen);
            splashScreen.start();
        } else {
            display.setCurrent(displayable);
            if (this.game != null && displayable == this.game) {
                this.game.resume();
            }
        }
        System.gc();
    }

    public static void setDisplayable(Displayable displayable) {
        display.setCurrent(displayable);
    }

    public static void setDisplayable(Alert alert, Displayable displayable) {
        display.setCurrent(alert, displayable);
    }

    void splashScreenDone(Displayable displayable) {
        display.setCurrent(displayable);
    }

    public void newGame(SFStatus sFStatus) {
        System.gc();
        Runtime runtime = Runtime.getRuntime();
        System.out.println("1 " + runtime.freeMemory());
        this.game = new Game(this);
        System.out.println("2 " + runtime.freeMemory());
        this.game.startGame(sFStatus);
        System.out.println("3 " + runtime.freeMemory());
    }

    public void exitMidlet() {
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public static void showMenu(Game game) {
        menu.setGame(game);
        menu.repaint();
        display.setCurrent((Displayable)menu);
    }
}

