/*
 * Decompiled with CFR 0.152.
 */
package math;

import math.DoubleBits;
import math.MathEx;

public class Frexp
implements DoubleBits {
    public final int sign;
    public final double mantissa;
    public final int exponent;

    public Frexp(double d) {
        if (d == 0.0) {
            this.sign = 0;
            this.mantissa = 0.0;
            this.exponent = 0;
            return;
        }
        int n = this.sign = d > 0.0 ? 1 : -1;
        if (MathEx.isInfOrNaN(d *= (double)this.sign)) {
            this.mantissa = d;
            this.exponent = 0;
            return;
        }
        long l = Double.doubleToLongBits(d);
        int n2 = 1;
        if ((l & 0x7FF0000000000000L) == 0L) {
            n2 -= 52;
            l = Double.doubleToLongBits(d *= TWO_POW_D_MANTISSA_BITS);
        }
        this.mantissa = Double.longBitsToDouble(l & 0xFFFFFFFFFFFFFL | 0x3FE0000000000000L);
        this.exponent = n2 + (int)((l & 0x7FF0000000000000L) >> 52) - 1023;
    }
}

