/*
 * Decompiled with CFR 0.152.
 */
package parse;

import java.util.Random;
import math.Complex;

public class Expression {
    private int error;
    private int nTokens;
    private int[] tokens;
    private Complex[] tokenData;
    private Random rgen = new Random();
    private static final double TANGENT_EPSILON = 1.0E-6;
    private static final double INTEGRAL_RES = 1000.0;
    private static final double INTERVAL_EPSILON = 1.0E-12;
    private static final double MINMAX_RES = 10.0;
    private static final double ZERO_RES = 50.0;
    private static final String[] funcNames = new String[]{"abs", "arg", "conj", "sgn", "sqr", "sqrt", "exp", "ln", "sin", "cos", "tan", "asin", "acos", "atan", "sinh", "cosh", "tanh", "asinh", "acosh", "atanh", "floor", "ceil", "frac", "round", "re", "im"};
    private static final int precedUnary = 10;
    private static final int[] preced = new int[]{0, 0, 0, 0, 0, 0, 3, 2, 2, 10, 1, 1, 1, 1, 1, 1, 4, 4, 10, 5, 5, 5, 6, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10};
    private static final int[] spConstDiff = new int[]{1, 1, 1, 1, 0, 0, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int spConst;
    private int spConstMin;
    private int spConstMax;
    private int spOp;
    private int[] stOp;

    public static boolean isIdChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_';
    }

    public static boolean isWhitespace(char c) {
        return c == '\t' || c == '\n' || c == '\r' || c == ' ';
    }

    private void pushOp(int n) {
        if (n != 4) {
            int n2;
            int n3 = preced[n];
            while (this.spOp > 0 && ((n2 = preced[this.stOp[this.spOp - 1]]) > n3 || n3 != 10 && n2 == n3)) {
                this.popOp();
            }
        }
        this.stOp[this.spOp++] = n;
    }

    private void popOp() {
        --this.spOp;
        if (this.stOp[this.spOp] != 4) {
            this.writeToken(this.stOp[this.spOp], null);
        }
    }

    private void writeToken(int n, Complex complex) {
        this.tokens[this.nTokens] = n;
        this.tokenData[this.nTokens] = complex;
        ++this.nTokens;
        this.spConst += spConstDiff[n];
        if (this.spConst < this.spConstMin) {
            this.spConstMin = this.spConst;
        }
        if (this.spConst > this.spConstMax) {
            this.spConstMax = this.spConst;
        }
    }

    public Expression(String string, String string2, String string3) {
        try {
            int n = string.length();
            this.nTokens = 0;
            this.tokens = new int[2 * n];
            this.tokenData = new Complex[2 * n];
            this.spConst = 0;
            this.spConstMin = 0;
            this.spConstMax = 0;
            this.spOp = 0;
            this.stOp = new int[2 * n];
            string = string + ' ';
            string2 = string2.toLowerCase();
            string3 = string3.toLowerCase();
            int n2 = 0;
            boolean bl = false;
            while (n2 < n) {
                while (Expression.isWhitespace(string.charAt(n2))) {
                    ++n2;
                }
                char c = string.charAt(n2);
                char c2 = string.charAt(n2 + 1);
                int n3 = n2 + 1;
                boolean bl2 = false;
                if (c >= '0' && c <= '9') {
                    char c3 = string.charAt(n3);
                    bl2 = true;
                    if (bl) {
                        this.pushOp(19);
                    }
                    while (c3 >= '0' && c3 <= '9' || c3 == '.') {
                        c3 = string.charAt(++n3);
                    }
                    if (c3 == 'e' || c3 == 'E') {
                        if ((c3 = string.charAt(++n3)) == '+' || c3 == '-') {
                            c3 = string.charAt(++n3);
                        }
                        while (c3 >= '0' && c3 <= '9') {
                            c3 = string.charAt(++n3);
                        }
                    }
                    try {
                        double d = Double.parseDouble(string.substring(n2, n3));
                        this.writeToken(2, new Complex(d));
                    }
                    catch (Exception exception) {
                        this.error = 2;
                        return;
                    }
                } else if (Expression.isIdChar(c)) {
                    if (bl) {
                        this.pushOp(19);
                    }
                    while (Expression.isIdChar(string.charAt(n3))) {
                        ++n3;
                    }
                    String string4 = string.substring(n2, n3).toLowerCase();
                    boolean bl3 = true;
                    bl2 = true;
                    if (string4.equals(string2)) {
                        this.writeToken(0, null);
                    } else if (string4.equals(string3)) {
                        this.writeToken(1, null);
                    } else if (string4.equals("random")) {
                        this.writeToken(3, null);
                    } else if (string4.equals("i")) {
                        this.writeToken(2, Complex.CX_I);
                    } else if (string4.equals("e")) {
                        this.writeToken(2, Complex.CX_E);
                    } else if (string4.equals("pi")) {
                        this.writeToken(2, Complex.CX_PI);
                    } else if (string4.equals("inf")) {
                        this.writeToken(2, Complex.CX_INF);
                    } else if (string4.equals("nan")) {
                        this.writeToken(2, Complex.CX_NAN);
                    } else {
                        bl3 = false;
                        bl2 = false;
                    }
                    if (!bl3) {
                        for (int i = 24; i <= 49; ++i) {
                            if (!string4.equals(funcNames[i - 24])) continue;
                            this.pushOp(i);
                            bl3 = true;
                            break;
                        }
                        if (!bl3) {
                            this.error = 7;
                            return;
                        }
                    }
                } else {
                    block2 : switch (c) {
                        case '(': 
                        case '[': 
                        case '{': {
                            if (bl) {
                                this.pushOp(19);
                            }
                            this.pushOp(4);
                            break;
                        }
                        case ')': 
                        case ']': 
                        case '}': {
                            bl2 = true;
                            while (this.spOp > 0 && this.stOp[this.spOp - 1] != 4) {
                                this.popOp();
                            }
                            if (this.spOp == 0) {
                                this.error = 3;
                                return;
                            }
                            this.popOp();
                            break;
                        }
                        case '&': {
                            this.pushOp(6);
                            break;
                        }
                        case '|': {
                            this.pushOp(7);
                            break;
                        }
                        case '#': {
                            this.pushOp(8);
                            break;
                        }
                        case '~': {
                            this.pushOp(9);
                            break;
                        }
                        case '=': {
                            this.pushOp(10);
                            break;
                        }
                        case '<': {
                            switch (c2) {
                                case '>': {
                                    this.pushOp(11);
                                    break block2;
                                }
                                case '=': {
                                    this.pushOp(15);
                                    ++n3;
                                    break block2;
                                }
                            }
                            this.pushOp(12);
                            break;
                        }
                        case '>': {
                            if (c2 == '=') {
                                this.pushOp(14);
                                ++n3;
                                break;
                            }
                            this.pushOp(13);
                            break;
                        }
                        case '+': {
                            if (!bl) break;
                            this.pushOp(16);
                            break;
                        }
                        case '-': {
                            if (bl) {
                                this.pushOp(17);
                                break;
                            }
                            this.pushOp(18);
                            break;
                        }
                        case '*': {
                            this.pushOp(19);
                            break;
                        }
                        case '/': {
                            this.pushOp(20);
                            break;
                        }
                        case '%': {
                            this.pushOp(21);
                            break;
                        }
                        case '^': {
                            this.pushOp(22);
                            break;
                        }
                        case '!': {
                            this.writeToken(23, null);
                            break;
                        }
                        default: {
                            this.error = 1;
                            return;
                        }
                    }
                }
                n2 = ++n3;
                bl = bl2;
            }
            while (this.spOp > 0 && this.stOp[this.spOp - 1] != 4) {
                this.popOp();
            }
            this.stOp = null;
            if (this.spOp > 0) {
                this.error = 4;
                return;
            }
            if (this.spConst < 1 || this.spConstMin < 0) {
                this.error = 6;
                return;
            }
            if (this.spConst > 1) {
                this.error = 5;
                return;
            }
            this.error = 0;
        }
        catch (Exception exception) {
            this.error = 8;
        }
    }

    public int getError() {
        return this.error;
    }

    public Complex calculate(Complex complex, Complex complex2) {
        if (this.error != 0) {
            return null;
        }
        int n = 0;
        Complex[] complexArray = new Complex[this.spConstMax];
        for (int i = 0; i < this.nTokens; ++i) {
            Complex complex3 = n >= 2 ? complexArray[n - 2] : null;
            Complex complex4 = n >= 1 ? complexArray[n - 1] : null;
            Complex complex5 = null;
            switch (this.tokens[i]) {
                case 0: {
                    complex5 = complex;
                    break;
                }
                case 1: {
                    complex5 = complex2;
                    break;
                }
                case 2: {
                    complex5 = this.tokenData[i];
                    break;
                }
                case 3: {
                    complex5 = new Complex(this.rgen.nextDouble());
                    break;
                }
                case 6: {
                    complex5 = new Complex(complex3.isZero() || complex4.isZero() ? 0.0 : 1.0);
                    break;
                }
                case 7: {
                    complex5 = new Complex(complex3.isZero() && complex4.isZero() ? 0.0 : 1.0);
                    break;
                }
                case 8: {
                    complex5 = new Complex(complex3.isZero() ^ complex4.isZero() ? 1.0 : 0.0);
                    break;
                }
                case 9: {
                    complex5 = new Complex(complex4.isZero() ? 1.0 : 0.0);
                    break;
                }
                case 10: {
                    complex5 = new Complex(complex3.equals(complex4) ? 1.0 : 0.0);
                    break;
                }
                case 11: {
                    complex5 = new Complex(complex3.equals(complex4) ? 0.0 : 1.0);
                    break;
                }
                case 12: {
                    complex5 = new Complex(complex3.compareTo(complex4) == -1 ? 1.0 : 0.0);
                    break;
                }
                case 13: {
                    complex5 = new Complex(complex3.compareTo(complex4) == 1 ? 1.0 : 0.0);
                    break;
                }
                case 14: {
                    complex5 = new Complex(complex3.compareTo(complex4) == -1 ? 0.0 : 1.0);
                    break;
                }
                case 15: {
                    complex5 = new Complex(complex3.compareTo(complex4) == 1 ? 0.0 : 1.0);
                    break;
                }
                case 16: {
                    complex5 = complex3.add(complex4);
                    break;
                }
                case 17: {
                    complex5 = complex3.sub(complex4);
                    break;
                }
                case 18: {
                    complex5 = complex4.neg();
                    break;
                }
                case 19: {
                    complex5 = complex3.mul(complex4);
                    break;
                }
                case 20: {
                    complex5 = complex3.div(complex4);
                    break;
                }
                case 21: {
                    complex5 = complex3.mod(complex4);
                    break;
                }
                case 22: {
                    complex5 = complex3.power(complex4);
                    break;
                }
                case 23: {
                    break;
                }
                case 24: {
                    complex5 = new Complex(complex4.abs());
                    break;
                }
                case 25: {
                    complex5 = new Complex(complex4.arg());
                    break;
                }
                case 26: {
                    complex5 = complex4.conj();
                    break;
                }
                case 27: {
                    complex5 = complex4.sign();
                    break;
                }
                case 28: {
                    complex5 = complex4.sqr();
                    break;
                }
                case 29: {
                    complex5 = complex4.sqrt();
                    break;
                }
                case 30: {
                    complex5 = complex4.exp();
                    break;
                }
                case 31: {
                    complex5 = complex4.log();
                    break;
                }
                case 32: {
                    complex5 = complex4.sin();
                    break;
                }
                case 33: {
                    complex5 = complex4.cos();
                    break;
                }
                case 34: {
                    complex5 = complex4.tan();
                    break;
                }
                case 35: {
                    complex5 = complex4.asin();
                    break;
                }
                case 36: {
                    complex5 = complex4.acos();
                    break;
                }
                case 37: {
                    complex5 = complex4.atan();
                    break;
                }
                case 38: {
                    complex5 = complex4.sinh();
                    break;
                }
                case 39: {
                    complex5 = complex4.cosh();
                    break;
                }
                case 40: {
                    complex5 = complex4.tanh();
                    break;
                }
                case 41: {
                    complex5 = complex4.asinh();
                    break;
                }
                case 42: {
                    complex5 = complex4.acosh();
                    break;
                }
                case 43: {
                    complex5 = complex4.atanh();
                    break;
                }
                case 44: {
                    complex5 = complex4.floor();
                    break;
                }
                case 45: {
                    complex5 = complex4.ceil();
                    break;
                }
                case 46: {
                    complex5 = complex4.frac();
                    break;
                }
                case 47: {
                    complex5 = complex4.round();
                    break;
                }
                case 48: {
                    complex5 = new Complex(complex4.r);
                    break;
                }
                case 49: {
                    complex5 = new Complex(complex4.i);
                }
            }
            complexArray[(n += Expression.spConstDiff[this.tokens[i]]) - 1] = complex5;
        }
        return complexArray[0];
    }

    public static Complex parseComplex(String string) {
        Expression expression = new Expression(string, "", "");
        if (expression.error == 0) {
            return expression.calculate(Complex.CX_0, Complex.CX_0);
        }
        return Complex.CX_0;
    }

    public double calcTangent(double d) {
        Complex complex = this.calculate(new Complex(d - 1.0E-6), Complex.CX_0);
        Complex complex2 = this.calculate(new Complex(d + 1.0E-6), Complex.CX_0);
        if (complex == null || !complex.isReal() || complex2 == null || !complex2.isReal()) {
            return Double.NaN;
        }
        return (complex2.r - complex.r) / 2.0E-6;
    }

    public double calcIntegral(double d, double d2) {
        double d3 = (d2 - d) / 1000.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n = 0;
        while ((double)n <= 1000.0) {
            Complex complex = this.calculate(new Complex(d + (double)n * d3), Complex.CX_0);
            if (complex != null && complex.isReal()) {
                double d6 = n == 0 || (double)n == 1000.0 ? 1.0 : ((n & 1) != 0 ? 4.0 : 2.0);
                d4 += d6 * complex.r;
                d5 += d6;
            }
            ++n;
        }
        if (d5 == 0.0) {
            return Double.NaN;
        }
        return (d2 - d) * d4 / d5;
    }

    public double calcZero(double d, double d2) {
        Complex complex;
        double d3;
        int n = -1;
        int n2 = -1;
        double d4 = (d2 - d) / 50.0;
        int n3 = 0;
        while ((double)n3 <= 50.0) {
            d3 = d + (double)n3 * d4;
            complex = this.calculate(new Complex(d3), Complex.CX_0);
            if (complex != null && complex.isReal()) {
                if (complex.r == 0.0) {
                    return d3;
                }
                if (complex.r > 0.0) {
                    n = n3;
                } else {
                    n2 = n3;
                }
                if (n >= 0 && n2 >= 0) break;
            }
            ++n3;
        }
        if (n < 0 || n2 < 0) {
            return Double.NaN;
        }
        d2 = d + (double)n * d4;
        d += (double)n2 * d4;
        while (Math.abs(d2 - d) >= 1.0E-12) {
            d3 = (d + d2) * 0.5;
            complex = this.calculate(new Complex(d3), Complex.CX_0);
            if (complex == null || !complex.isReal()) {
                return Double.NaN;
            }
            if (complex.r == 0.0) {
                return d3;
            }
            if (complex.r > 0.0) {
                d2 = d3;
                continue;
            }
            d = d3;
        }
        return (d + d2) * 0.5;
    }

    public double calcMinMax(double d, double d2, boolean bl) {
        while (Math.abs(d2 - d) >= 1.0E-12) {
            int n = -1;
            double d3 = 0.0;
            double d4 = (d2 - d) / 10.0;
            int n2 = 0;
            while ((double)n2 <= 10.0) {
                Complex complex = this.calculate(new Complex(d + (double)n2 * d4), Complex.CX_0);
                if (complex != null && complex.isReal() && (n < 0 || bl == complex.r < d3)) {
                    n = n2;
                    d3 = complex.r;
                }
                ++n2;
            }
            if (n < 0) {
                d = (d + d2) * 0.5;
                continue;
            }
            d = Math.max(d, d + (double)(n - 1) * d4);
            d2 = Math.min(d2, d + (double)(n + 1) * d4);
        }
        return (d + d2) * 0.5;
    }
}

