/*
 * Decompiled with CFR 0.152.
 */
package win;

import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import win.ColorItem;
import win.Colors;
import win.RGBScrollBar;
import win.StringTable;
import win.WindowProc;

public class ColorDialog
implements CommandListener,
ItemStateListener {
    private final Display display;
    private final WindowProc callback;
    private final Object userData;
    private int color;
    private Form form;
    private final Command CMD_OK;
    private final Command CMD_CANCEL;
    private ChoiceGroup itemSwatches;
    private RGBScrollBar[] itemScrollBar;
    private ColorItem itemPreview;

    public ColorDialog(Display display, StringTable stringTable, WindowProc windowProc, Object object, int n) {
        int n2;
        this.display = display;
        this.callback = windowProc;
        this.userData = object;
        this.CMD_OK = new Command(stringTable.get("OK"), 4, 1);
        this.CMD_CANCEL = new Command(stringTable.get("CANCEL"), 2, 2);
        this.itemSwatches = new ChoiceGroup(stringTable.get("SWATCHES") + ":", 4);
        this.itemSwatches.append("(" + stringTable.get("NONE") + ")", null);
        String[] stringArray = stringTable.getArray("COLORS");
        for (n2 = 0; n2 < 16; ++n2) {
            this.itemSwatches.append(stringArray[n2], Colors.createSwatch(Colors.COLOR16[n2], 15));
        }
        this.itemScrollBar = new RGBScrollBar[3];
        for (n2 = 0; n2 < 3; ++n2) {
            this.itemScrollBar[n2] = new RGBScrollBar(this, null, n2, n);
        }
        this.itemPreview = new ColorItem(stringTable.get("PREVIEW") + ":", this.color, this.display, stringTable);
        this.itemPreview.dialogEnabled = false;
        this.form = new Form(stringTable.get("SELECT_COLOR"));
        this.form.append((Item)this.itemSwatches);
        for (n2 = 0; n2 < 3; ++n2) {
            this.form.append((Item)this.itemScrollBar[n2]);
        }
        this.form.append((Item)this.itemPreview);
        this.form.addCommand(this.CMD_OK);
        this.form.addCommand(this.CMD_CANCEL);
        this.form.setCommandListener((CommandListener)this);
        this.form.setItemStateListener((ItemStateListener)this);
        this.setColor(n);
        this.show();
    }

    private void show() {
        this.display.setCurrent((Displayable)this.form);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.CMD_OK) {
            this.close(true);
        } else if (command == this.CMD_CANCEL) {
            this.close(false);
        }
    }

    public void itemStateChanged(Item item) {
        if (item == this.itemSwatches) {
            int n = this.itemSwatches.getSelectedIndex() - 1;
            if (n >= 0) {
                this.setColor(Colors.COLOR16[n]);
            }
            return;
        }
        for (int i = 0; i < 3; ++i) {
            if (item != this.itemScrollBar[i]) continue;
            this.setColor(this.itemScrollBar[i].getColor());
            return;
        }
    }

    private void setColor(int n) {
        if (this.color != n) {
            this.color = n;
            this.updateForm();
        }
    }

    private void updateForm() {
        int n;
        int n2 = 0;
        for (n = 0; n < 16; ++n) {
            if (this.color != Colors.COLOR16[n]) continue;
            n2 = n + 1;
            break;
        }
        this.itemSwatches.setSelectedIndex(n2, true);
        for (n = 0; n < 3; ++n) {
            this.itemScrollBar[n].setColor(this.color);
        }
        this.itemPreview.setColor(this.color);
    }

    private void close(boolean bl) {
        if (!bl) {
            this.color = -1;
        }
        if (this.callback != null) {
            this.callback.windowProc(this, 1, this.color, this.userData);
        }
    }
}

