/*
 * Decompiled with CFR 0.152.
 */
package ui;

import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.TextField;
import math.Complex;
import math.MathEx;
import parse.Expression;
import ui.App;

public class FrmCalculus
implements CommandListener,
ItemStateListener {
    public App app;
    private Form form;
    private final Command CMD_CALC;
    private final Command CMD_BACK;
    public int index;
    private static final int MAX_NUMERIC = 100;
    private ChoiceGroup itemMenu;
    private TextField itemA;
    private TextField itemB;
    private TextField itemResult;

    public FrmCalculus(App app) {
        this.app = app;
        this.CMD_CALC = new Command(this.app.langPack.get("CALCULATE"), 4, 1);
        this.CMD_BACK = new Command(this.app.langPack.get("BACK"), 2, 2);
        this.itemMenu = new ChoiceGroup(this.app.langPack.get("CALCULATE") + ":", 4, this.app.langPack.getArray("CALCULUS_MENU"), null);
        this.itemA = new TextField("", "0", 100, 5);
        this.itemB = new TextField("", "0", 100, 5);
        this.itemResult = new TextField(this.app.langPack.get("RESULT") + ":", "", 100, 131072);
        this.form = new Form(this.app.langPack.get("CALCULUS"));
        this.form.append((Item)this.itemMenu);
        this.form.append((Item)this.itemA);
        this.form.append((Item)this.itemB);
        this.form.append((Item)this.itemResult);
        this.form.addCommand(this.CMD_CALC);
        this.form.addCommand(this.CMD_BACK);
        this.form.setCommandListener((CommandListener)this);
        this.form.setItemStateListener((ItemStateListener)this);
        this.updateLabels();
    }

    public void show() {
        this.app.display.setCurrent((Displayable)this.form);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.CMD_CALC) {
            this.onCalculate();
        } else if (command == this.CMD_BACK) {
            this.app.frmFunctions.show();
        }
    }

    public void itemStateChanged(Item item) {
        if (item == this.itemMenu) {
            this.updateLabels();
        }
    }

    private void onCalculate() {
        String string;
        Expression expression = this.app.doc.getEntry((int)this.index).expr[0];
        double d = MathEx.safeParseDouble(this.itemA.getString());
        double d2 = MathEx.safeParseDouble(this.itemB.getString());
        switch (this.itemMenu.getSelectedIndex()) {
            case 0: {
                string = expression.calculate(new Complex(d), Complex.CX_0).toString();
                break;
            }
            case 1: {
                string = String.valueOf(expression.calcTangent(d));
                break;
            }
            case 2: {
                string = String.valueOf(expression.calcIntegral(d, d2));
                break;
            }
            case 3: {
                string = String.valueOf(expression.calcZero(d, d2));
                break;
            }
            case 4: {
                string = String.valueOf(expression.calcMinMax(d, d2, true));
                break;
            }
            case 5: {
                string = String.valueOf(expression.calcMinMax(d, d2, false));
                break;
            }
            default: {
                string = "";
            }
        }
        this.itemResult.setString(string);
    }

    private void updateLabels() {
        switch (this.itemMenu.getSelectedIndex()) {
            case 0: 
            case 1: {
                this.itemA.setLabel(this.app.langPack.get("AT") + ":");
                this.itemB.setLabel(this.app.langPack.get("UNUSED"));
                break;
            }
            default: {
                this.itemA.setLabel(this.app.langPack.get("LEFT_BOUND") + ":");
                this.itemB.setLabel(this.app.langPack.get("RIGHT_BOUND") + ":");
            }
        }
    }
}

